#ifndef _DB_H_ 
#define _DB_H_ 

#ifndef GDBM_COMPT 
#include <ndbm.h>
#else
#include <gdbm-ndbm.h>
#endif


#define LOG_DB_NAME "log_db"
#define INDEX_DB_NAME "index_db"

#define DB_KEY_SIZE_MAX ((SHA_DIGEST_LENGTH)*2+2) 

typedef struct tag_nt_db_log_rec_t *nt_db_log_rec_tp;
typedef struct tag_nt_db_log_rec_t{
	int content_length;
	char last_modified[128];
} nt_db_log_rec_t;

typedef struct tag_nt_db_idx_rec_t *nt_db_idx_rec_tp;
typedef struct tag_nt_db_idx_rec_t{
} nt_db_idx_rec_t;

extern BOOL nt_db_cpy_key(const char *src, char *dst);
extern const char *nt_db_get_log_path();
extern const char *nt_db_get_idx_path();
#endif /* _DB_H_ */
