#ifndef _NT_HTTP_H_
#define _NT_HTTP_H_

#include "net/nt_cookie.h"

#define SSL_FLAG 1
#define GZIP_FLAG 2
#define CHUNKED_FLAG 4
#define RANGE_FLAG 8
#define SET_FLAG(a,b) ((a)->flags  |= (b))
#define CLR_FLAG(a,b) ((a)->flags  &= ~(b))
#define IS_SET_FLAG(a,b) ((a)->flags & (b))

#define HTTP_RESPONCE_HEADER_BUFFER_LEN  256

#define USER_AGENT "Monazilla/1.00 (monaweb/1.00) ntch for GUN/Linux"

#define CONTENT_TYPE_ZIP 1
#define CONTENT_TYPE_TEXT 2 

typedef struct tag_nt_http_header_t *nt_http_header_tp;
typedef struct tag_nt_http_header_t {
	int port;
	char *host;
	char *param;
	char *last_modified;
	size_t fsize;
	unsigned int flags;
}nt_http_header_t;


typedef struct tag_nt_http_response_header_t 
	*nt_http_response_header_tp;
typedef struct tag_nt_http_response_header_t {
	char	*status_text;
	int		status_code;
	char	*last_modified;
	int 	content_length;
	int 	flags;
}nt_http_response_header_t;

extern BOOL nt_http_post(const char *url, 
		const char *post_data,
		char *out_buf, size_t out_buf_len,
		const char *referer, const char *user_agent, 
		nt_link_tp headers, nt_cookie_tp cookiep);
extern BOOL nt_http_get(const char *url, const char *out_path,
		const char *referer, const char *user_agent, 
		nt_link_tp headers, BOOL range);
extern int nt_http_parse_response_header(int readfd,
		nt_http_response_header_tp responsep,
		nt_cookie_tp cookeip, const char *host);
extern int nt_http_parse_response_header2(
			const char *data, size_t data_len,
			nt_http_response_header_tp responsep);
extern nt_http_response_header_tp nt_http_alloc_response_header();
extern void nt_http_free_response_header(
		nt_http_response_header_tp responsep);
extern BOOL nt_http_save_response_header(const char *out_path,
		nt_http_response_header_tp responsep);
extern BOOL nt_parse_server_name_and_board_name(const wchar_t *url,
	wchar_t *buf, size_t buf_size, wchar_t **server_name,
	wchar_t **board_name);
extern wchar_t* nt_rid_sufix(const wchar_t *file_name);
extern BOOL url_encode(const char *src, char *out_buf, size_t out_buf_len);
extern BOOL url_decode(const char *src, char *out_buf, size_t out_buf_len);
#endif /* _NT_HTTP_H_ */
