#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <wchar.h>
#include <ncursesw/ncurses.h>

#include	"env.h"
#include	"utils/nt_std_t.h"
#include	"utils/text.h"
#include	"_2ch/_2ch.h"
#include	"_2ch/model_2ch.h"
#include	"ui/disp.h"
#include	"ui/disp_string.h"

typedef struct tag_ctx_reslist_t *ctx_reslist_tp;
typedef struct tag_ctx_reslist_t
{
	int res_num;
	int cur_res;
	int cur_res_offset;
	nt_stack_tp	selected_num_stackp;

} ctx_reslist_t;


static ctx_reslist_tp init_context(nt_2ch_model_tp modelp);
static void int_ptr_free(void *ptr);
static BOOL parse_cmd1(const char *param, int *statep);

int disp_reslist(nt_window_tp wp, nt_2ch_model_tp modelp)
{
	ctx_reslist_tp ctxp;
	nt_res_tp resp;
	nt_thread_tp threadp;
	nt_link_tp clistp;
	int i, rows;
	int wlines;
	int len, ch;
	int num;
	int res_offset;
	int *nptr;
	void *ptr;
	wchar_t buf[1024*3+1];
	wchar_t *cptr;
	nt_link_tp link_curp;
	BOOL bottom_chk = FALSE;
	int state;

	ctxp = (ctx_reslist_tp)wp->data;
	if(!ctxp){
		ctxp = init_context(modelp);
		if(!ctxp)
			return DISP_STATE_ERROR;
		wp->data = ctxp;
	}
	ch = wp->key;

	threadp = modelp->selected_threadp;

	switch(ch){
	case NT_KEY_CLOSE:
		return DISP_STATE_THREADTITLE; 
	case NT_KEY_BOTTOM:
		if(ctxp->cur_res == ctxp->res_num - 1)
			break;
		if(!threadp->reslistp)
			break;
		clistp = threadp->reslistp->prev;
		ctxp->cur_res = ctxp->res_num - 1;
		ctxp->cur_res_offset = 0;
		bottom_chk = TRUE;
		break;
	case NT_KEY_LEFT:
		if(!ctxp->selected_num_stackp)
			break;
		nptr = malloc(sizeof(int));
		*nptr = ctxp->cur_res;
		ptr = nt_stack_add_last(ctxp->selected_num_stackp, nptr);
		if(!ptr){
			free(nptr);
		}
		nptr = nt_stack_pop(ctxp->selected_num_stackp);
		if(!nptr)
			break;
		num = *nptr;
		if(ctxp->cur_res == num)
			break;
		if(num >= ctxp->res_num)
			break;
		ctxp->cur_res = num;
		ctxp->cur_res_offset = 0;
		if(!threadp->reslistp)
			break;
		clistp = threadp->reslistp;
		for(i = 0; i < num; i++)
			clistp = clistp->next;
		bottom_chk = TRUE;
		break;
	case NT_KEY_RIGHT:
		if(!ctxp->selected_num_stackp)
			break;
		nptr = nt_stack_cursor_next(ctxp->selected_num_stackp);
		if(!nptr)
			break;
		num = *nptr;
		if(ctxp->cur_res == num)
			break;
		if(num >= ctxp->res_num)
			break;
		ctxp->cur_res = num;
		ctxp->cur_res_offset = 0;
		if(!threadp->reslistp)
			break;
		clistp = threadp->reslistp;
		for(i = 0; i < num; i++)
			clistp = clistp->next;
		bottom_chk = TRUE;
		break;
	case NT_KEY_COMMAND1:
		assert(wp->cmd_param);
				if(parse_cmd1(wp->cmd_param, &state)){
					return state;
				}
				num = atoi(wp->cmd_param);
				if(0 == num)
					break;
				num--;
				if(ctxp->cur_res == num)
					break;
				if(num >= ctxp->res_num)
					break;
				nptr = malloc(sizeof(int));
				*nptr = ctxp->cur_res;
				ctxp->cur_res = num;
				ctxp->cur_res_offset = 0;
				if(!threadp->reslistp){
					free(nptr);
					break;
				}
				clistp = threadp->reslistp;
				for(i = 0; i < num; i++)
					clistp = clistp->next;
				nt_stack_push(ctxp->selected_num_stackp, nptr);
				bottom_chk = TRUE;
				break;
			case NT_KEY_UP:
				ctxp->cur_res_offset--;
				if(0 > ctxp->cur_res_offset){
					if(ctxp->cur_res > 0){
						ctxp->cur_res--;
						ctxp->cur_res_offset = -1;
					}else{
						ctxp->cur_res_offset = 0;
					}
				}
				break;
			case NT_KEY_DOWN:
				ctxp->cur_res_offset++;
				clistp = threadp->reslistp;
				for(i = 0; i < ctxp->res_num; i++){
					if(i == ctxp->cur_res)
						break;
					clistp = clistp->next;
				}
				if(i == ctxp->res_num)
					break;
				bottom_chk = TRUE;
				break;
			case NT_KEY_PAGEUP:
				if(ctxp->cur_res_offset > wp->lines){
					ctxp->cur_res_offset -= wp->lines;
					break;
				}
				clistp = threadp->reslistp;
				for(i = 0; i < ctxp->res_num; i++){
					if(i == ctxp->cur_res)
						break;
					clistp = clistp->next;
				}
				if(i == ctxp->res_num)
					break;
				if(i == 0){
					ctxp->cur_res_offset = 0;
					ctxp->cur_res = 0;
					break;
				}
				wlines = wp->lines - ctxp->cur_res_offset;
				for( ; i > 0; i--){
					resp = (nt_res_tp)clistp->data;
					if(!resp->msg_line_linkp){
						parse_res_msg(resp, wp->cols-5);
					}
					num = resp->msg_line_num + 2;
					if(num > wlines){
						ctxp->cur_res = i;
						ctxp->cur_res_offset = num - wlines;
						break;
					}
					wlines -= num;
					clistp = clistp->prev;
				}
				if(i == 0){
					ctxp->cur_res = 0;
					ctxp->cur_res_offset = 0;
				}
				break;
			case NT_KEY_PAGEDOWN:
				clistp = threadp->reslistp;
				for(i = 0; i < ctxp->res_num; i++){
					if(i == ctxp->cur_res)
						break;
					clistp = clistp->next;
				}
				if(i == ctxp->res_num)
					break;
				
				ctxp->cur_res_offset += wp->lines;
				for( ; i < ctxp->res_num; i++){
					resp = (nt_res_tp)clistp->data;
					if(!resp->msg_line_linkp){
						parse_res_msg(resp, wp->cols-5);
					}
					num = resp->msg_line_num + 2;
					if(num > ctxp->cur_res_offset)
						break;

					ctxp->cur_res++;
					ctxp->cur_res_offset -= num;

					clistp = clistp->next;
				}
				bottom_chk = TRUE;
				break;
			}
			if(bottom_chk){
				/* Check the botton line. */
				wlines = wp->lines + ctxp->cur_res_offset;
				i = ctxp->cur_res;
				for( ; i < ctxp->res_num; i++){
					resp = (nt_res_tp)clistp->data;
					if(!resp->msg_line_linkp){
						parse_res_msg(resp, wp->cols-5);
					}
					num = resp->msg_line_num + 2;
					wlines -= num;
					if(wlines <= 0)
						break;
					clistp = clistp->next;
				}
				/* Adjust the bottom line. */
				if(i == ctxp->res_num){
					ctxp->cur_res_offset = wp->lines;
					ctxp->cur_res = ctxp->res_num - 1;
					for( ; i > 0; i--){
						resp = (nt_res_tp)clistp->data;
						if(!resp->msg_line_linkp){
							parse_res_msg(resp, wp->cols-5);
				}
				num = resp->msg_line_num + 2;
				if(num > ctxp->cur_res_offset)
					break;

				ctxp->cur_res--;
				ctxp->cur_res_offset -= num;
				clistp = clistp->prev;
			}
		}
	}

	clistp = threadp->reslistp;
	res_offset = 0;
	rows = 0;
	for(i = 0; i < ctxp->res_num; i++){
		if(i < ctxp->cur_res){
			clistp = clistp->next;
			continue;
		}

		if(rows == wp->lines)
			break;

		resp = (nt_res_tp)clistp->data;
		
		if(-1 == swprintf(buf, sizeof(buf)-1, 
				L"%5d. %ls %ls %ls", 
				resp->seq_no, resp->name,
				resp->mail, resp->misc)){
			continue;
		}
		len = wcslen(buf);
		num = nt_get_wc_count_within_colmns(buf, wp->cols);

		if(num < len){
			if(!nt_w_str_move(buf, sizeof(buf), num, 1))
				break;
			if(res_offset >= ctxp->cur_res_offset){
				wmove(wp->wp, rows, 0);
				nt_add_wstr(wp->wp, buf, 0);
				rows++;
			}else{
				res_offset++;
			}
			if(rows == wp->lines)
				break;
			if(res_offset >= ctxp->cur_res_offset){
				wmove(wp->wp, rows, 0);
				nt_add_wnch(wp->wp, L' ', WA_UNDERLINE, 5);
				nt_add_wnstr(wp->wp, buf + num + 1, WA_UNDERLINE,
				wp->cols - 5);
				rows++;
			}else{
				res_offset++;
			}
		}else{
			if(res_offset >= ctxp->cur_res_offset){
				wmove(wp->wp, rows, 0);
				nt_add_wstr(wp->wp, buf, WA_UNDERLINE);
				rows++;
			}else{
				res_offset++;
			}
		}
		if(rows == wp->lines)
			break;
		if(!resp->msg_line_linkp){
			parse_res_msg(resp, wp->cols-5);
		}
		if(0 == resp->msg_line_num)
			continue;
		if(ctxp->cur_res == i){
			if(ctxp->cur_res_offset > resp->msg_line_num){
				ctxp->cur_res++;
				ctxp->cur_res_offset = 0;
				rows = 0;
				res_offset = 0;
				i--;
				continue;
			}
		}
		if(ctxp->cur_res_offset == -1){
			ctxp->cur_res_offset = resp->msg_line_num;
			rows = 0;
			res_offset = 0;
			i = -1;
			clistp = threadp->reslistp;
			continue;
		}

		link_curp = resp->msg_line_linkp;
		do{
			cptr = (wchar_t*)link_curp->data;
			if(res_offset >= ctxp->cur_res_offset){
				wmove(wp->wp, rows, 5);
				nt_add_wstr(wp->wp, cptr, 0);
				rows++;
				if(rows == wp->lines)
					goto END_FOR;
			}else{
				res_offset++;
			}
			link_curp = link_curp->next;
		}while(resp->msg_line_linkp != link_curp);

		if(rows == wp->lines)
			goto END_FOR;
		if(res_offset >= ctxp->cur_res_offset){
			wmove(wp->wp, rows, 0);
			nt_add_wnch(wp->wp, L' ', 0, wp->cols);
			rows++;
		}else{
			res_offset++;
		}
		clistp = clistp->next;
	}/* end for */
END_FOR:
	
	return DISP_STATE_RESLIST; 
}

static BOOL parse_cmd1(const char *param, int *statep)
{
	assert(param);

	if(0 == strcmp(NT_COMMAND1_WRITE_MSG_1, param) ||
		0 == strcmp(NT_COMMAND1_WRITE_MSG_2, param)){
		*statep = DISP_STATE_EDITOR;
		return TRUE;

	}
	return FALSE;
}



static ctx_reslist_tp init_context(nt_2ch_model_tp modelp)
{
	ctx_reslist_tp ctxp;
	nt_thread_tp threadp;
	ctxp = (ctx_reslist_tp)calloc(1,sizeof(nt_2ch_model_t));

	if(!ctxp)
		return NULL;

	threadp = modelp->selected_threadp;
	ctxp->res_num = nt_link_num(threadp->reslistp);
	ctxp->cur_res = 0;
	ctxp->cur_res_offset = 0;
	ctxp->selected_num_stackp = nt_stack_alloc();

	return ctxp;
}

void free_reslist_ctx(void *ptr)
{
	ctx_reslist_tp ctxp;
	if(!ptr)
		return;
	 ctxp = (ctx_reslist_tp)ptr;
	 nt_stack_free(ctxp->selected_num_stackp, &int_ptr_free);
	 free(ptr);
}

static void int_ptr_free(void *ptr)
{
	free(ptr);
}


