/*
 * Decompiled with CFR 0.152.
 */
package nor.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.core.Nor;
import nor.core.plugin.PluginAdapter;
import nor.core.proxy.filter.FilterRegister;
import nor.core.proxy.filter.ReadonlyByteFilter;
import nor.core.proxy.filter.ReadonlyPatternMatchingFilter;
import nor.core.proxy.filter.ReadonlyStringFilter;
import nor.core.proxy.filter.RequestFilter;
import nor.core.proxy.filter.RequestFilterAdapter;
import nor.core.proxy.filter.ResponseFilter;
import nor.core.proxy.filter.ResponseFilterAdapter;
import nor.core.proxy.filter.StoringToFileFilter;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.util.FixedSizeMap;
import nor.util.io.Stream;
import nor.util.log.Logger;

public class ManagementArticles
extends PluginAdapter {
    private static final Pattern CiteSeerX = Pattern.compile("http://citeseerx\\.ist\\.psu\\.edu/viewdoc/download?.*doi=([^&]+)");
    private static final Pattern SpringerSite = Pattern.compile("springerlink\\.com/content/(\\w+)/");
    private static final Pattern Springer = Pattern.compile("springerlink\\.com/content/(\\w+)/fulltext\\.pdf");
    private static final Pattern ACMSite = Pattern.compile("portal\\.acm\\.org.*citation\\.cfm\\?id=(\\d+)(?:\\.(\\d+))?");
    private static final Pattern ACM = Pattern.compile("delivery\\.acm\\.org/[0-9\\.]+/\\d+/(\\d+)/(.+)\\.pdf");
    private static final Pattern PDF = Pattern.compile("pdf");
    private static final Pattern HTML = Pattern.compile("html");
    private final Properties properties = new Properties();
    private File dir;
    private final Map<String, String> springerTitle = new FixedSizeMap(20);
    private final Map<String, String> acmTitle = new FixedSizeMap(20);
    private static final Logger LOGGER = Logger.getLogger(ManagementArticles.class);

    public void init(File common, File local) throws IOException {
        LOGGER.entering("init", new Object[]{common, local});
        if (!common.exists()) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("default.conf");
            FileOutputStream out = new FileOutputStream(common);
            Stream.copy((InputStream)in, (OutputStream)out);
            ((OutputStream)out).close();
            in.close();
        }
        FileReader r = new FileReader(common);
        this.properties.load(r);
        ((Reader)r).close();
        if (local.exists()) {
            Properties localProp = new Properties();
            FileReader localIn = new FileReader(local);
            localProp.load(localIn);
            ((Reader)localIn).close();
            this.properties.putAll((Map<?, ?>)localProp);
        }
        this.dir = new File(this.properties.getProperty("folder"));
        this.dir.mkdirs();
        StoringToFileFilter.deleteTemplaryFiles((File)this.dir);
        LOGGER.exiting("init");
    }

    public RequestFilter[] requestFilters() {
        return new RequestFilter[]{new RequestFilterAdapter(Springer, PDF){

            public void update(HttpRequest msg, MatchResult url, MatchResult cType, FilterRegister register) {
                LOGGER.entering(((Object)((Object)this)).getClass(), "update", new Object[]{msg, url, cType, register});
                HttpHeader header = msg.getHeader();
                header.remove(HeaderName.Range);
                header.remove(HeaderName.IfRange);
                LOGGER.exiting(((Object)((Object)this)).getClass(), "update");
            }
        }};
    }

    public ResponseFilter[] responseFilters() {
        return new ResponseFilter[]{new ResponseFilterAdapter(CiteSeerX, PDF){

            public void update(HttpResponse msg, MatchResult url, MatchResult cType, FilterRegister register) {
                LOGGER.entering(((Object)((Object)this)).getClass(), "update", new Object[]{msg, url, cType, register});
                if (msg.getStatus() == Status.OK) {
                    try {
                        URL summary = new URL("http://citeseerx.ist.psu.edu/viewdoc/summary?doi=" + url.group(1));
                        Pattern pat = Pattern.compile("<title>CiteSeerX &#8212; (.*)</title>");
                        String title = this.getTitle(summary, pat);
                        if (title != null) {
                            File dest = new File(ManagementArticles.this.dir, title + ".pdf");
                            register.add((ReadonlyByteFilter)new StoringToFileFilter(dest));
                        }
                    }
                    catch (IOException e) {
                        LOGGER.catched(Level.WARNING, ((Object)((Object)this)).getClass(), "update", (Throwable)e);
                    }
                }
                LOGGER.exiting(((Object)((Object)this)).getClass(), "update");
            }

            private String getTitle(URL url, Pattern pat) throws IOException {
                HttpRequest req = new HttpRequest(Method.GET, url);
                HttpResponse res = Nor.getRequestHandler().doRequest(req);
                if (res.getStatus() == Status.OK) {
                    InputStream in = res.getBody();
                    BufferedReader rin = new BufferedReader(new InputStreamReader(in));
                    String buf = rin.readLine();
                    while (buf != null) {
                        Matcher m = pat.matcher(buf);
                        if (m.find()) {
                            return m.group(1);
                        }
                        buf = rin.readLine();
                    }
                }
                return null;
            }
        }, new ResponseFilterAdapter(SpringerSite, HTML){

            public void update(HttpResponse msg, final MatchResult url, MatchResult cType, FilterRegister register) {
                LOGGER.entering(((Object)((Object)this)).getClass(), "update", new Object[]{msg, url, cType, register});
                if (msg.getStatus() == Status.OK) {
                    ReadonlyPatternMatchingFilter f = new ReadonlyPatternMatchingFilter();
                    f.addEventListener("\"ktitle=([^\"]+)\"", new ReadonlyPatternMatchingFilter.MatchingEventListener(){

                        public void update(MatchResult result) {
                            ManagementArticles.this.springerTitle.put(url.group(1), result.group(1));
                        }
                    });
                    register.add((ReadonlyStringFilter)f);
                }
                LOGGER.exiting(((Object)((Object)this)).getClass(), "update");
            }
        }, new ResponseFilterAdapter(Springer, PDF){

            public void update(HttpResponse msg, MatchResult url, MatchResult cType, FilterRegister register) {
                LOGGER.entering(((Object)((Object)this)).getClass(), "update", new Object[]{msg, url, cType, register});
                if (msg.getStatus() == Status.OK) {
                    try {
                        String id = url.group(1);
                        String title = ManagementArticles.this.springerTitle.containsKey(id) ? (String)ManagementArticles.this.springerTitle.get(id) : id;
                        File dest = new File(ManagementArticles.this.dir, title + ".pdf");
                        register.add((ReadonlyByteFilter)new StoringToFileFilter(dest));
                    }
                    catch (IOException e) {
                        LOGGER.catched(Level.WARNING, ((Object)((Object)this)).getClass(), "update", (Throwable)e);
                    }
                }
                LOGGER.exiting(((Object)((Object)this)).getClass(), "update");
            }
        }, new ResponseFilterAdapter(ACMSite, HTML){

            public void update(HttpResponse msg, final MatchResult url, MatchResult cType, FilterRegister register) {
                LOGGER.entering(((Object)((Object)this)).getClass(), "update", new Object[]{msg, url, cType, register});
                if (msg.getStatus() == Status.OK) {
                    ReadonlyPatternMatchingFilter f = new ReadonlyPatternMatchingFilter();
                    f.addEventListener("<title>(.*)</title>", new ReadonlyPatternMatchingFilter.MatchingEventListener(){

                        public void update(MatchResult result) {
                            String title = result.group(1);
                            ManagementArticles.this.acmTitle.put(url.group(1), title);
                            String next = url.group(2);
                            if (next != null) {
                                ManagementArticles.this.acmTitle.put(next, title);
                            }
                        }
                    });
                    register.add((ReadonlyStringFilter)f);
                }
                LOGGER.exiting(((Object)((Object)this)).getClass(), "update");
            }
        }, new ResponseFilterAdapter(ACM, PDF){

            public void update(HttpResponse msg, MatchResult url, MatchResult cType, FilterRegister register) {
                LOGGER.entering(((Object)((Object)this)).getClass(), "update", new Object[]{"update", msg, url, cType, register});
                if (msg.getStatus() == Status.OK) {
                    try {
                        String id = url.group(1);
                        String title = ManagementArticles.this.acmTitle.containsKey(id) ? (String)ManagementArticles.this.acmTitle.get(id) : url.group(2);
                        File dest = new File(ManagementArticles.this.dir, title + ".pdf");
                        register.add((ReadonlyByteFilter)new StoringToFileFilter(dest));
                    }
                    catch (IOException e) {
                        LOGGER.catched(Level.WARNING, "update", (Throwable)e);
                    }
                }
                LOGGER.exiting(((Object)((Object)this)).getClass(), "update");
            }
        }};
    }
}

