/*
 * Decompiled with CFR 0.152.
 */
package nor.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import nor.util.log.Logger;

public class Stream {
    public static final int DefaultBufferSize = 65536;
    private static final Logger LOGGER = Logger.getLogger(Stream.class);

    public static void copy(InputStream in, OutputStream out) throws IOException {
        Stream.copy(in, out, 65536);
        out.flush();
    }

    public static void copy(InputStream in, OutputStream out, int bufSize) throws IOException {
        try {
            ReadableByteChannel cin = Channels.newChannel(in);
            WritableByteChannel cout = Channels.newChannel(out);
            Stream.copy(cin, cout, bufSize);
        }
        catch (ClosedByInterruptException e) {
            throw new IOException(e);
        }
    }

    public static void copy(ReadableByteChannel in, WritableByteChannel out) throws IOException {
        Stream.copy(in, out, 65536);
    }

    public static void copy(ReadableByteChannel in, WritableByteChannel out, int bufSize) throws IOException {
        LOGGER.entering("copy", in, out, bufSize);
        assert (in != null);
        assert (out != null);
        assert (bufSize > 0);
        long c = 0L;
        ByteBuffer buf = ByteBuffer.allocate(bufSize);
        while (!Thread.currentThread().isInterrupted()) {
            int len;
            buf.clear();
            if (in.read(buf) < 0) break;
            buf.flip();
            c += (long)len;
            for (len = buf.limit() - buf.position(); len != 0 && !Thread.currentThread().isInterrupted(); len -= out.write(buf)) {
            }
        }
        LOGGER.exiting("copy");
    }
}

