/*
 * Decompiled with CFR 0.152.
 */
package nor.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import nor.util.log.Logger;

public class NoExceptionOutputStreamFilter
extends FilterOutputStream {
    private boolean alive = true;
    private static final Logger LOGGER = Logger.getLogger(NoExceptionOutputStreamFilter.class);

    public NoExceptionOutputStreamFilter(OutputStream out) {
        super(out);
    }

    @Override
    public void flush() throws IOException {
        LOGGER.entering("flush", new Object[0]);
        if (this.alive) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "flush", e);
                this.alive = false;
                this.out.close();
            }
        }
        LOGGER.exiting("flush");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        LOGGER.entering("write", b, off, len);
        if (this.alive) {
            try {
                this.out.write(b, off, len);
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "write", e);
                this.alive = false;
                this.out.close();
            }
        }
        LOGGER.exiting("write");
    }

    @Override
    public void write(byte[] b) throws IOException {
        LOGGER.entering("write", new Object[]{b});
        if (this.alive) {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "write", e);
                this.alive = false;
                this.out.close();
            }
        }
        LOGGER.exiting("write");
    }

    @Override
    public void write(int b) throws IOException {
        LOGGER.entering("write", b);
        if (this.alive) {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "write", e);
                this.alive = false;
                this.close();
            }
        }
        LOGGER.exiting("write");
    }

    public boolean alive() {
        LOGGER.entering("alive", new Object[0]);
        LOGGER.exiting("alive", this.alive);
        return this.alive;
    }
}

