/*
 * Decompiled with CFR 0.152.
 */
package nor.util.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class CopyingStreamWriter
extends FilterWriter {
    private final StringBuilder copy = new StringBuilder();

    public CopyingStreamWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        super.write(cbuf, off, len);
        this.copy.append(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        this.copy.append(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
        this.copy.append(str, off, len);
    }

    @Override
    public Writer append(char c) throws IOException {
        this.append(c);
        return super.append(c);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.copy.append(csq, start, end);
        return super.append(csq, start, end);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.copy.append(csq);
        return super.append(csq);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        super.write(cbuf);
        this.copy.append(cbuf);
    }

    @Override
    public void write(String str) throws IOException {
        super.write(str);
        this.append(str);
    }

    public String copy() {
        return this.copy.toString();
    }
}

