/*
 * Decompiled with CFR 0.152.
 */
package nor.util;

import java.util.logging.Logger;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.codec.net.URLCodec;

public final class Codec {
    private static final Logger LOGGER = Logger.getLogger(Codec.class.getName());
    public static final String DEFAULT_ENCODE = "utf-8";
    private static final URLCodec URLCodec = new URLCodec();
    private static final BCodec BCodec = new BCodec();

    public static String urlEncode(String str) {
        String ret = str;
        try {
            ret = URLCodec.encode(str);
        }
        catch (EncoderException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
        return ret;
    }

    public static String urlDecode(String str) {
        String ret = str;
        try {
            ret = URLCodec.decode(str);
        }
        catch (DecoderException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
        return ret;
    }

    public static String base64Encode(String str) {
        return Codec.base64Encode(str, DEFAULT_ENCODE);
    }

    public static String base64Encode(String str, String enc) {
        String ret = str;
        try {
            ret = BCodec.encode(str, enc);
        }
        catch (EncoderException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
        return ret;
    }

    public static String base64Decode(String str) {
        String ret = str;
        try {
            ret = BCodec.decode(str);
        }
        catch (DecoderException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
        return ret;
    }
}

