/*
 * Decompiled with CFR 0.152.
 */
package nor.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import nor.network.Network;
import nor.network.PortListener;
import nor.network.SelectionEventHandler;
import nor.util.log.Logger;

public class SelectionWorker
implements Runnable {
    private final Selector selector;
    private static final Logger LOGGER = Logger.getLogger(SelectionWorker.class);

    public SelectionWorker() throws IOException {
        LOGGER.entering("<init>", new Object[0]);
        this.selector = Selector.open();
        LOGGER.exiting("<init>");
    }

    @Override
    public void run() {
        LOGGER.entering("run", new Object[0]);
        Thread.currentThread().setName("Selection Thread");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                int nc = this.selector.select(Network.Timeout);
                LOGGER.finest("run", "Begin a selection ({0} selected keys, {1} registrated keys)", nc, this.selector.keys().size());
                if (nc == 0) {
                    this.onIdle();
                    continue;
                }
                for (SelectionKey key : this.selector.selectedKeys()) {
                    Channel ch;
                    LOGGER.finer("run", "Selected key is {0}", key);
                    SelectionEventHandler handler = (SelectionEventHandler)key.attachment();
                    if (!key.isValid()) continue;
                    if (key.isAcceptable()) {
                        ch = (ServerSocketChannel)key.channel();
                        handler.onAccept((ServerSocketChannel)ch);
                        continue;
                    }
                    if (key.isConnectable()) {
                        ch = (SocketChannel)key.channel();
                        handler.onConnect((SocketChannel)ch);
                        continue;
                    }
                    if (key.isReadable()) {
                        ch = (ReadableByteChannel)((Object)key.channel());
                        handler.onRead((ReadableByteChannel)ch);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    ch = (WritableByteChannel)((Object)key.channel());
                    handler.onWrite((WritableByteChannel)ch);
                }
                this.selector.selectedKeys().clear();
                LOGGER.finest("run", "Ends the selection", new Object[0]);
            }
            catch (ClosedSelectorException e) {
                LOGGER.severe("run", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "run", e);
            }
            catch (CancelledKeyException e) {
                LOGGER.severe("run", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "run", e);
            }
            catch (IOException e) {
                LOGGER.severe("run", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "run", e);
            }
        }
        try {
            this.selector.close();
        }
        catch (IOException e) {
            LOGGER.catched(Level.WARNING, "run", e);
        }
        LOGGER.exiting("run");
    }

    public SelectionKey register(SelectableChannel channel, int ops, SelectionEventHandler handler) throws IOException {
        LOGGER.entering("register", channel, ops, handler);
        assert (channel != null);
        assert (ops >= 0);
        assert (handler != null);
        channel.configureBlocking(false);
        SelectionKey key = channel.register(this.selector, ops, handler);
        LOGGER.exiting("register", key);
        return key;
    }

    public PortListener createPortListener(String host, int port) throws IOException {
        return this.createPortListener(new InetSocketAddress(host, port));
    }

    public PortListener createPortListener(SocketAddress addr) throws IOException {
        LOGGER.entering("createPortListener", addr);
        assert (addr != null);
        PortListener res = new PortListener(addr, this);
        LOGGER.exiting("createPortListener", res);
        return res;
    }

    protected void onIdle() {
    }
}

