/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.tserver;

import java.io.IOException;
import java.util.Properties;
import nor.util.log.Logger;

final class TServer {
    public static final int Timeout;
    public static final int MaxThreads;

    private TServer() {
    }

    static {
        Logger LOGGER = Logger.getLogger(TServer.class);
        String classname = TServer.class.getName();
        Properties defaults = new Properties();
        try {
            defaults.load(TServer.class.getResourceAsStream("default.conf"));
        }
        catch (IOException e) {
            LOGGER.severe("<class init>", "Cannot load default configs ({0})", e);
        }
        String timeout = String.format("%s.Timeout", classname);
        Timeout = Integer.valueOf(System.getProperty(timeout, defaults.getProperty(timeout)));
        String mthreads = String.format("%s.MaxThreads", classname);
        MaxThreads = Integer.valueOf(System.getProperty(mthreads, defaults.getProperty(mthreads)));
        LOGGER.config("<class init>", "Load a constant: Timeout = {0}", Timeout);
        LOGGER.config("<class init>", "Load a constant: MaxThreads = {0}", MaxThreads);
    }
}

