/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.tserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import nor.http.HeaderName;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.server.HttpRequestHandler;
import nor.http.server.tserver.TServer;
import nor.util.io.NoCloseInputStream;
import nor.util.io.NoCloseOutputStream;
import nor.util.log.Logger;

final class ServiceWorker
implements Runnable {
    private final Socket socket;
    private final HttpRequestHandler handler;
    private static final Logger LOGGER = Logger.getLogger(ServiceWorker.class);

    ServiceWorker(Socket socket, HttpRequestHandler handler) {
        LOGGER.entering("<init>", socket, handler);
        assert (socket != null);
        assert (handler != null);
        this.socket = socket;
        this.handler = handler;
        LOGGER.exiting("<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.entering("run", new Object[0]);
        try {
            HttpResponse response;
            this.socket.setKeepAlive(true);
            this.socket.setSoTimeout(0);
            BufferedInputStream input = new BufferedInputStream(new NoCloseInputStream(this.socket.getInputStream()), this.socket.getReceiveBufferSize());
            BufferedOutputStream output = new BufferedOutputStream(new NoCloseOutputStream(this.socket.getOutputStream()), this.socket.getSendBufferSize());
            for (boolean keepAlive = true; keepAlive && !Thread.currentThread().isInterrupted(); keepAlive &= this.isKeepingAlive(response)) {
                this.socket.setSoTimeout(TServer.Timeout);
                HttpRequest request = HttpRequest.create(input);
                if (request == null) {
                    break;
                }
                this.socket.setSoTimeout(0);
                Thread.currentThread().setName(request.getHeadLine());
                keepAlive &= this.isKeepingAlive(request);
                response = this.handler.doRequest(request);
                response.writeTo(output);
                ((OutputStream)output).flush();
                this.socket.setSoTimeout(0);
                this.socket.getOutputStream().flush();
            }
        }
        catch (SocketTimeoutException e) {
            LOGGER.fine("run", e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            LOGGER.warning("run", e.getMessage(), new Object[0]);
        }
        finally {
            if (!this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    LOGGER.warning("run", "Cannot close the socket.", new Object[0]);
                }
            }
            Thread.currentThread().setName("Sleep");
        }
        LOGGER.exiting("run");
    }

    private boolean isKeepingAlive(HttpRequest request) {
        return !request.getHeader().containsValue(HeaderName.Connection, "close");
    }

    private boolean isKeepingAlive(HttpResponse response) {
        return !response.getHeader().containsValue(HeaderName.Connection, "close");
    }
}

