/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.tserver;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import nor.http.server.HttpRequestHandler;
import nor.http.server.HttpServer;
import nor.http.server.tserver.ListenWorker;
import nor.http.server.tserver.TServer;
import nor.util.log.Logger;

public class HttpTServer
implements HttpServer {
    private final HttpRequestHandler handler;
    private Thread listeningThread;
    private static final Logger LOGGER = Logger.getLogger(HttpTServer.class);

    public HttpTServer(HttpRequestHandler handler) {
        LOGGER.entering("<init>", handler);
        assert (handler != null);
        this.handler = handler;
        LOGGER.exiting("<init>");
    }

    @Override
    public void start(String hostname, int port) throws IOException {
        LOGGER.entering("start", hostname, port);
        ServerSocket socket = new ServerSocket();
        socket.setReuseAddress(true);
        LOGGER.info("start", "Create new socket.", new Object[0]);
        socket.bind(new InetSocketAddress(hostname, port));
        LOGGER.info("start", "Bind the socket to port {0}", port);
        LOGGER.info("start", "Start listening.", new Object[0]);
        this.listeningThread = new Thread(new ListenWorker(socket, this.handler, TServer.MaxThreads));
        this.listeningThread.setName("ListenWorker");
        this.listeningThread.start();
        LOGGER.exiting("service");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        if (this.listeningThread != null) {
            this.listeningThread.interrupt();
            try {
                this.listeningThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOGGER.info("close", "Closes.", new Object[0]);
        }
        LOGGER.exiting("close");
    }
}

