/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.proxyserver;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.util.Querable;
import nor.util.log.Logger;

public class Router
implements Map<Pattern, Proxy>,
Querable<Proxy> {
    private final Map<Pattern, Proxy> routs = new HashMap<Pattern, Proxy>();
    private static final Pattern AddressPat = Pattern.compile("([^:]+):(\\d+)");
    private static final Logger LOGGER = Logger.getLogger(Router.class);

    @Override
    public Proxy query(String url) {
        LOGGER.entering("query", url);
        assert (url != null);
        Proxy res = Proxy.NO_PROXY;
        for (Pattern p : this.routs.keySet()) {
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            res = this.routs.get(p);
        }
        LOGGER.exiting("query", res);
        return res;
    }

    @Override
    public void put(Pattern pat, InetSocketAddress addr) {
        LOGGER.entering("put", pat, addr);
        assert (pat != null);
        assert (addr != null);
        this.put(pat, new Proxy(Proxy.Type.HTTP, addr));
        LOGGER.exiting("put");
    }

    @Override
    public void put(String regex, InetSocketAddress addr) {
        this.put(Pattern.compile(regex), addr);
    }

    @Override
    public void put(Pattern pat, String url) {
        LOGGER.entering("pur", pat, url);
        Matcher m = AddressPat.matcher(url);
        if (m.matches()) {
            String host = m.group(1);
            int port = Integer.valueOf(m.group(2));
            this.put(pat, host, port);
        } else {
            LOGGER.warning("put", "Invalid parameter: {0}", url);
        }
        LOGGER.exiting("put");
    }

    @Override
    public void put(String regex, String url) {
        this.put(Pattern.compile(regex), url);
    }

    public void put(String regex, String host, int port) {
        this.put(Pattern.compile(regex), host, port);
    }

    public void put(Pattern pat, String host, int port) {
        LOGGER.entering("pur", pat, host, port);
        this.put(pat, new InetSocketAddress(host, port));
        LOGGER.exiting("put");
    }

    @Override
    public void clear() {
        this.routs.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.routs.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.routs.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Pattern, Proxy>> entrySet() {
        return this.routs.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.routs).equals(o);
    }

    @Override
    public Proxy get(Object key) {
        return this.routs.get(key);
    }

    @Override
    public int hashCode() {
        return ((Object)this.routs).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.routs.isEmpty();
    }

    @Override
    public Set<Pattern> keySet() {
        return this.routs.keySet();
    }

    @Override
    public Proxy put(Pattern key, Proxy value) {
        return this.routs.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Pattern, ? extends Proxy> m) {
        this.routs.putAll(m);
    }

    @Override
    public Proxy remove(Object key) {
        return this.routs.remove(key);
    }

    @Override
    public int size() {
        return this.routs.size();
    }

    @Override
    public Collection<Proxy> values() {
        return this.routs.values();
    }
}

