/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.proxyserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.error.InternalServerErrorException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.proxyserver.Router;
import nor.util.io.LimitedInputStream;
import nor.util.io.NoCloseInputStream;
import nor.util.io.NoCloseOutputStream;
import nor.util.log.Logger;

public class ProxyRequestHandler
implements HttpRequestHandler {
    private final String name;
    private final Router router;
    private static final int Timeout;
    private static final String Close = "close";
    private static final String VIA_FORMAT = "%s %s";
    private static final Logger LOGGER;

    public ProxyRequestHandler(String name, Router router) {
        LOGGER.entering("<init>", name, router);
        assert (name != null && name.length() != 0);
        assert (router != null);
        this.name = name;
        this.router = router;
        HttpURLConnection.setFollowRedirects(false);
        LOGGER.exiting("<init>");
    }

    @Override
    public HttpResponse doRequest(HttpRequest request) {
        LOGGER.entering("doRequest", request);
        assert (request != null);
        LOGGER.finest("doRequest", "{0}", request);
        HttpResponse response = null;
        try {
            if (Method.CONNECT.equals(request.getMethodString())) {
                throw new HttpException(Status.NotImplemented);
            }
            this.editHeader(request);
            URL url = new URL(request.getPath());
            Proxy proxy = this.router.query(request.getPath());
            if (proxy != Proxy.NO_PROXY) {
                LOGGER.config("doRequest", "Use the proxy; {0}", proxy);
            }
            LOGGER.fine("doRequest", "Send a response {0}", request);
            HttpURLConnection con = (HttpURLConnection)url.openConnection(proxy);
            con.setConnectTimeout(Timeout);
            this.sendRequest(con, request);
            response = this.receiveResponse(con, request);
            LOGGER.fine("doRequest", "Receive a response {0}", response);
        }
        catch (IOException e) {
            LOGGER.warning("doRequest", "Catch a IOException({0})", e.getMessage());
            LOGGER.catched(Level.FINE, "doRequest", e);
            response = HttpException.createResponse(request, Status.InternalServerError, e);
            LOGGER.fine("doRequest", "Receive an error response {0}", response);
        }
        catch (HttpException e) {
            response = e.createResponse(request);
            LOGGER.fine("doRequest", "Receive an error response {0}", response);
        }
        this.editHeader(response);
        LOGGER.exiting("doRequest", response);
        return response;
    }

    @Override
    public SocketChannel doConnectRequest(HttpRequest request) throws HttpException {
        assert (request != null);
        Pattern pat = Pattern.compile("(.+):(\\d+)");
        Matcher m = pat.matcher(request.getPath());
        if (m.find()) {
            try {
                String host = m.group(1);
                int port = Integer.valueOf(m.group(2));
                Proxy p = this.router.query(request.getPath());
                if (p == Proxy.NO_PROXY) {
                    InetSocketAddress addr = new InetSocketAddress(host, port);
                    SocketChannel ch = SocketChannel.open(addr);
                    return ch;
                }
                SocketChannel ch = SocketChannel.open();
                Socket s = ch.socket();
                s.connect(p.address());
                NoCloseInputStream input = new NoCloseInputStream(s.getInputStream());
                NoCloseOutputStream output = new NoCloseOutputStream(s.getOutputStream());
                request.setBody(new LimitedInputStream(request.getBody(), 0L));
                request.writeTo(output);
                ((OutputStream)output).flush();
                ((OutputStream)output).close();
                request.close();
                HttpResponse response = request.createResponse(input);
                if (response.getStatus() == Status.OK || response.getStatus() == Status.ConnectionEstablished) {
                    return ch;
                }
                throw new HttpException(response.getStatus());
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "doRequest", e);
                throw new HttpException(Status.BadGateway, (Throwable)e);
            }
        }
        throw new HttpException(Status.BadRequest);
    }

    private void sendRequest(HttpURLConnection con, HttpRequest request) throws HttpException {
        try {
            request.writeTo(con);
            request.close();
            con.connect();
        }
        catch (SocketTimeoutException e) {
            LOGGER.catched(Level.WARNING, "sendRequest", e);
            throw new HttpException(Status.GatewayTimeout, (Throwable)e);
        }
        catch (ConnectException e) {
            LOGGER.catched(Level.WARNING, "sendRequest", e);
            throw new HttpException(Status.GatewayTimeout, (Throwable)e);
        }
        catch (UnknownHostException e) {
            LOGGER.catched(Level.WARNING, "sendRequest", e);
            throw new HttpException(Status.NotFound, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.catched(Level.WARNING, "sendRequest", e);
            throw new InternalServerErrorException(e);
        }
    }

    private HttpResponse receiveResponse(HttpURLConnection con, HttpRequest request) throws HttpException {
        HttpResponse ret = null;
        try {
            LOGGER.fine("receiveResponse", "{0}: {1} : {2}", con, con.getResponseMessage(), con.getHeaderFields());
            int code = con.getResponseCode();
            InputStream resStream = null;
            if (code == -1) {
                throw new InternalServerErrorException("Recieve an invalid message.");
            }
            resStream = code < 400 ? con.getInputStream() : con.getErrorStream();
            String encode = con.getHeaderField(HeaderName.ContentEncoding.toString());
            if (encode != null) {
                if ("gzip".equalsIgnoreCase(encode)) {
                    resStream = new GZIPInputStream(resStream);
                } else if ("deflate".equalsIgnoreCase(encode)) {
                    resStream = new DeflaterInputStream(resStream);
                }
            }
            ret = request.createResponse(Status.valueOf(code), resStream);
            HttpHeader resHeader = ret.getHeader();
            Map<String, List<String>> fields = con.getHeaderFields();
            for (String key : fields.keySet()) {
                if (key == null) continue;
                for (String value : fields.get(key)) {
                    resHeader.add(key, value);
                }
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
        return ret;
    }

    private void editHeader(HttpRequest request) {
        LOGGER.entering("cleanHeader", request);
        assert (request != null);
        HttpHeader header = request.getHeader();
        header.set(HeaderName.AcceptEncoding, "gzip, identity");
        String timeout = null;
        boolean close = false;
        if (header.containsKey(HeaderName.KeepAlive)) {
            timeout = header.get(HeaderName.KeepAlive);
        } else if (header.containsValue(HeaderName.Connection, Close)) {
            close = true;
        }
        this.removeHopByHopHeader(header);
        if (this.router.query(request.getPath()) == null && header.containsKey(HeaderName.ProxyConnection)) {
            for (String value : header.get(HeaderName.ProxyConnection).split(",")) {
                header.remove(value.trim());
            }
            header.remove(HeaderName.ProxyConnection);
        }
        if (timeout != null) {
            header.set(HeaderName.Connection, HeaderName.KeepAlive.toString());
            header.set(HeaderName.KeepAlive, timeout);
        } else if (close) {
            header.set(HeaderName.Connection, Close);
        }
        header.add(HeaderName.Via, String.format(VIA_FORMAT, request.getVersion(), this.name));
        request.setVersion("1.1");
        LOGGER.exiting("cleanHeader");
    }

    private void editHeader(HttpResponse response) {
        LOGGER.entering("cleanHeader", response);
        assert (response != null);
        HttpHeader header = response.getHeader();
        this.removeHopByHopHeader(header);
        if (header.containsKey(HeaderName.ProxyConnection)) {
            for (String value : header.get(HeaderName.ProxyConnection).split(",")) {
                header.remove(value.trim());
            }
            header.remove(HeaderName.ProxyConnection);
        }
        header.add(HeaderName.Via, String.format(VIA_FORMAT, response.getVersion(), this.name));
        response.setVersion("1.1");
        LOGGER.exiting("cleanHeader");
    }

    private void removeHopByHopHeader(HttpHeader header) {
        if (header.containsKey(HeaderName.Connection)) {
            boolean isClose = false;
            for (String value : header.get(HeaderName.Connection).split(",")) {
                String tvalue = value.trim();
                if (Close.equalsIgnoreCase(tvalue)) {
                    isClose = true;
                    continue;
                }
                header.remove(value.trim());
            }
            header.remove(HeaderName.Connection);
            if (isClose) {
                header.set(HeaderName.Connection, Close);
            }
        }
    }

    static {
        LOGGER = Logger.getLogger(ProxyRequestHandler.class);
        String classname = ProxyRequestHandler.class.getName();
        Properties defaults = new Properties();
        try {
            defaults.load(ProxyRequestHandler.class.getResourceAsStream("default.conf"));
        }
        catch (IOException e) {
            LOGGER.severe("<class init>", "Cannot load default configs ({0})", e);
        }
        String tout = String.format("%s.Timeout", classname);
        Timeout = Integer.valueOf(System.getProperty(tout, defaults.getProperty(tout)));
        LOGGER.config("<init>", "Load a constant: Timeout = {0}", Timeout);
    }
}

