/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import nor.http.server.HttpRequestHandler;
import nor.http.server.nserver.RequestHandleWorker;
import nor.network.Connection;
import nor.util.log.Logger;

class ConnectionManager
implements Closeable {
    private final HttpRequestHandler handler;
    private final ExecutorService pool;
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class);

    public ConnectionManager(HttpRequestHandler handler, int maxThreads) {
        LOGGER.entering("<init>", handler, maxThreads);
        assert (handler != null);
        this.pool = maxThreads == 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(maxThreads);
        this.handler = handler;
        LOGGER.exiting("<init>");
    }

    public boolean offer(Connection e) {
        boolean res;
        LOGGER.entering("offer", e);
        assert (e != null);
        if (e.closed()) {
            res = false;
        } else {
            RequestHandleWorker worker = new RequestHandleWorker(e, this.handler);
            this.pool.execute(worker);
            LOGGER.finer("offer", "Offer a new connection and send notify message.", new Object[0]);
            res = true;
        }
        LOGGER.exiting("offer", res);
        return res;
    }

    @Override
    public void close() {
        LOGGER.entering("close", new Object[0]);
        this.pool.shutdownNow();
        try {
            if (!this.pool.awaitTermination(120L, TimeUnit.SECONDS)) {
                LOGGER.warning("close", "Thread pool did not terminate.", new Object[0]);
            }
        }
        catch (InterruptedException e) {
            LOGGER.catched(Level.WARNING, "close", e);
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        LOGGER.exiting("close");
    }
}

