/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.local;

import java.util.Calendar;
import java.util.Date;
import nor.http.ContentType;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;
import nor.http.server.local.Resource;
import nor.util.log.Logger;

public class TextResource
extends Resource {
    private static final Logger LOGGER = Logger.getLogger(TextResource.class);
    private static final ContentType DefaultContentType = new ContentType("text/plain");
    private String text;
    private final ContentType type;
    private Date modified;

    public TextResource(String name, String text, ContentType type) {
        super(name);
        LOGGER.entering("<init>", name, text, type);
        assert (text != null);
        assert (type != null);
        this.text = text;
        this.type = type;
        this.modified = Calendar.getInstance().getTime();
        LOGGER.exiting("<init>");
    }

    public TextResource(String name, String text, String type) {
        this(name, text, new ContentType(type));
    }

    public TextResource(String name, String text) {
        this(name, text, DefaultContentType);
    }

    public String getText() {
        LOGGER.entering("getText", new Object[0]);
        String ret = this.text;
        LOGGER.exiting("getText", (Object)ret);
        return ret;
    }

    public void setText(String text) {
        LOGGER.entering("setText", text);
        assert (text != null);
        this.text = text;
        this.modified = Calendar.getInstance().getTime();
        LOGGER.exiting("setText");
    }

    @Override
    public HttpResponse doGet(String path, HttpRequest request) {
        LOGGER.entering("doGet", path, request);
        assert (path != null);
        assert (request != null);
        HttpResponse ret = request.createResponse(Status.OK, this.text);
        HttpHeader header = ret.getHeader();
        header.add(HeaderName.ContentType, this.type.toString());
        LOGGER.exiting("doGet", ret);
        return ret;
    }

    public String toString() {
        return this.text + "(" + this.modified + ")";
    }
}

