/*
 * Decompiled with CFR 0.152.
 */
package nor.http.error;

import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;

public class MethodNotAllowedException
extends HttpException {
    private final Method[] allowed;

    public MethodNotAllowedException(Method[] allowed) {
        this(null, null, allowed);
    }

    public MethodNotAllowedException(String message, Method[] allowed) {
        this(message, null, allowed);
    }

    public MethodNotAllowedException(Throwable cause, Method[] allowed) {
        this(null, cause, allowed);
    }

    public MethodNotAllowedException(String message, Throwable cause, Method[] allowed) {
        super(Status.MethodNotAllowed, message, cause);
        this.allowed = allowed;
    }

    @Override
    public HttpResponse createResponse(HttpRequest request) {
        HttpResponse ret = super.createResponse(request);
        HttpHeader header = ret.getHeader();
        for (Method m : this.allowed) {
            header.add(HeaderName.Allow, m.toString());
        }
        return ret;
    }
}

