/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import nor.http.HeaderName;
import nor.http.Http;
import nor.http.HttpHeader;
import nor.http.HttpMessage;
import nor.http.HttpRequest;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.error.InternalServerErrorException;
import nor.http.io.HeaderInputStream;
import nor.util.io.LimitedInputStream;
import nor.util.log.Logger;

public class HttpResponse
extends HttpMessage {
    private final HttpRequest request;
    private int code;
    private String message;
    private String version;
    private final HttpHeader header;
    private static final Logger LOGGER = Logger.getLogger(HttpResponse.class);

    HttpResponse(HttpRequest request, InputStream input) throws HttpException {
        LOGGER.entering("<init>", request, input);
        assert (request != null);
        assert (input != null);
        try {
            String buf;
            BufferedReader in = new BufferedReader(new InputStreamReader(new HeaderInputStream(input)));
            while ((buf = in.readLine()) != null) {
                Matcher m = Http.ResponseLinePattern.matcher(buf);
                if (!m.matches()) continue;
                this.version = m.group(1);
                this.code = Integer.parseInt(m.group(2));
                this.message = m.group(3);
                break;
            }
            if (this.code == 0) {
                throw new InternalServerErrorException();
            }
            this.request = request;
            this.header = new HttpHeader(in);
            if (Method.HEAD.equals(this.getRequest().getMethodString())) {
                this.getHeader().set(HeaderName.ContentLength, "0");
            } else if (100 <= this.code && this.code < 200 || this.code == 204 || this.code == 304) {
                this.getHeader().set(HeaderName.ContentLength, "0");
            }
            this.setBody(HttpMessage.decodeStream(input, this.header));
        }
        catch (IOException e) {
            throw new InternalServerErrorException();
        }
        LOGGER.exiting("<init>");
    }

    HttpResponse(HttpRequest request, Status status, InputStream body) {
        assert (request != null);
        assert (status != null);
        this.request = request;
        this.code = status.getCode();
        this.message = status.getMessage();
        this.version = Http.Version;
        this.header = new HttpHeader();
        this.setBody(body);
    }

    HttpResponse(HttpRequest request, Status status, InputStream body, long length) {
        assert (request != null);
        assert (status != null);
        this.request = request;
        this.code = status.getCode();
        this.message = status.getMessage();
        this.version = Http.Version;
        this.header = new HttpHeader();
        this.header.set(HeaderName.ContentLength, Long.toString(length));
        this.setBody(new LimitedInputStream(body, length));
    }

    public HttpRequest getRequest() {
        LOGGER.entering("getRequest", new Object[0]);
        HttpRequest ret = this.request;
        LOGGER.exiting("getRequest", ret);
        return ret;
    }

    public int getCode() {
        LOGGER.entering("getCode", new Object[0]);
        int ret = this.code;
        LOGGER.exiting("getCode", ret);
        return ret;
    }

    public Status getStatus() {
        LOGGER.entering("getStatus", new Object[0]);
        Status ret = Status.valueOf(this.getCode());
        LOGGER.exiting("getStatus", (Object)ret);
        return ret;
    }

    public String getMessage() {
        LOGGER.entering("getMessage", new Object[0]);
        String ret = this.message;
        LOGGER.exiting("getMessage", (Object)ret);
        return ret;
    }

    @Override
    public String toString() {
        String ret = String.format("Response[status=%s, path=%s]\r\n%s", new Object[]{this.getStatus(), this.getPath(), this.header});
        return ret;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setStatus(Status status) {
        this.code = status.getCode();
        this.message = status.getMessage();
    }

    @Override
    public String getVersion() {
        LOGGER.entering("getVersion", new Object[0]);
        String ret = this.version;
        LOGGER.exiting("getVersion", (Object)ret);
        return ret;
    }

    @Override
    public String getPath() {
        return this.getRequest().getPath();
    }

    @Override
    public String getHeadLine() {
        return String.format(Http.ResponseLineTemplate, this.version, this.code, this.message);
    }

    @Override
    public HttpHeader getHeader() {
        return this.header;
    }
}

