/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import nor.http.HeaderName;
import nor.http.HttpHeader;

public class Cookie {
    private final HttpHeader header;
    private final Map<String, List<String>> entries = new HashMap<String, List<String>>();
    private static final Logger LOGGER = Logger.getLogger(Cookie.class.getName());

    private Cookie(HttpHeader header) {
        this.header = header;
        if (this.header.containsKey(HeaderName.Cookie)) {
            for (String entry : this.header.get(HeaderName.Cookie).split(",")) {
                int index = entry.indexOf("=");
                if (index == -1) continue;
                String key = entry.substring(0, index);
                String value = entry.substring(index + 1);
                if (this.entries.containsKey(key)) {
                    this.entries.get(key).add(value);
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(value);
                this.entries.put(key, list);
            }
        }
    }

    public void clear() {
        LOGGER.entering(Cookie.class.getName(), "clear");
        this.entries.clear();
        this.header.remove(HeaderName.Cookie);
        LOGGER.exiting(Cookie.class.getName(), "clear");
    }

    public void add(String key, String value) {
        LOGGER.entering(Cookie.class.getName(), "add", new Object[]{key, value});
        assert (key != null);
        assert (value != null);
        if (this.entries.containsKey(key)) {
            this.entries.get(key).add(value);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            this.entries.put(key, list);
        }
        this.header.set(HeaderName.Cookie, this.toString());
        LOGGER.exiting(Cookie.class.getName(), "add");
    }

    public void set(String key, String value) {
        LOGGER.entering(Cookie.class.getName(), "set", new Object[]{key, value});
        assert (key != null);
        assert (value != null);
        this.entries.remove(key);
        this.add(key, value);
        LOGGER.exiting(Cookie.class.getName(), "set");
    }

    public void remove(String key) {
        LOGGER.entering(Cookie.class.getName(), "remove", key);
        assert (key != null);
        this.entries.remove(key);
        this.header.set(HeaderName.Cookie, this.toString());
        LOGGER.exiting(Cookie.class.getName(), "remove");
    }

    public String[] get(String key) {
        LOGGER.entering(Cookie.class.getName(), "get", key);
        assert (key != null);
        String[] ret = this.entries.get(key).toArray(new String[0]);
        LOGGER.exiting(Cookie.class.getName(), "get", ret);
        return ret;
    }

    public String[] keys() {
        LOGGER.entering(Cookie.class.getName(), "keys");
        String[] ret = this.entries.keySet().toArray(new String[0]);
        LOGGER.exiting(Cookie.class.getName(), "keys", ret);
        return ret;
    }

    public String toString() {
        LOGGER.entering(Cookie.class.getName(), "toString");
        StringBuilder builder = new StringBuilder();
        for (String key : this.entries.keySet()) {
            for (String value : this.entries.get(key)) {
                builder.append(key);
                builder.append("=");
                builder.append(value);
                builder.append(";");
            }
        }
        if (builder.length() != 0) {
            builder.setLength(builder.length() - 2);
        }
        String ret = builder.toString();
        LOGGER.config(String.format("Cookie\u30a8\u30f3\u30c8\u30ea[%s]", ret));
        LOGGER.exiting(Cookie.class.getName(), "toString", ret);
        return ret;
    }

    public static Cookie get(HttpHeader header) {
        return new Cookie(header);
    }
}

