/*
 * Decompiled with CFR 0.152.
 */
package nor.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import nor.core.Context;
import nor.core.plugin.Plugin;
import nor.core.proxy.ProxyServer;
import nor.http.server.HttpRequestHandler;
import nor.http.server.local.TextResource;
import nor.http.server.proxyserver.ProxyRequestHandler;
import nor.http.server.proxyserver.Router;
import nor.util.io.Stream;
import nor.util.log.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;

public class Nor {
    private ProxyServer server;
    private final ProxyRequestHandler handler;
    private final Router router = new Router();
    private final File rootConfDir;
    private final File localConfDir;
    private final Context context = new Context();
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private static final Logger LOGGER = Logger.getLogger(Nor.class);
    private static final String ConfigFileTemplate = "%s.conf";
    private static final String LoggindConfigFile = "logging.conf";
    private static Nor nor;

    private Nor(String rootConfDir) {
        assert (rootConfDir != null);
        this.rootConfDir = new File(rootConfDir);
        this.localConfDir = new File(this.rootConfDir, this.context.getHostName());
        this.localConfDir.mkdirs();
        File base = new File(this.rootConfDir, "nor.conf");
        try {
            Properties baseProp = new Properties();
            baseProp.load(new FileInputStream(base));
            System.getProperties().putAll((Map<?, ?>)baseProp);
            File local = new File(this.localConfDir, "nor.conf");
            if (!local.exists()) {
                InputStream in = this.getClass().getResourceAsStream("nor.conf");
                FileOutputStream out = new FileOutputStream(local);
                Stream.copy(in, out);
                ((OutputStream)out).close();
                in.close();
            }
            Properties localProp = new Properties();
            localProp.load(new FileInputStream(local));
            System.getProperties().putAll((Map<?, ?>)localProp);
        }
        catch (IOException e) {
            LOGGER.catched(Level.SEVERE, "Cannot load config file", e);
            RuntimeException ne = new RuntimeException("Cannot start nor.");
            LOGGER.throwing("<init>", ne);
            throw ne;
        }
        this.handler = new ProxyRequestHandler(Nor.class.getSimpleName(), this.router);
    }

    public boolean enable(Plugin plugin) {
        LOGGER.entering("enable", plugin);
        assert (plugin != null);
        boolean ret = Boolean.parseBoolean(System.getProperty(String.format("%s.enable", plugin.getClass().getName()), "true"));
        LOGGER.exiting("enable", ret);
        return ret;
    }

    private void init(List<URL> jarUrls) throws IOException {
        File dir;
        LOGGER.entering("init", new Object[0]);
        this.server = new ProxyServer(this.handler, this.router);
        String pluginPath = System.getProperty("nor.plugin");
        if (pluginPath != null && (dir = new File(pluginPath)).isDirectory()) {
            for (File f : dir.listFiles()) {
                try {
                    jarUrls.add(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.catched(Level.WARNING, "init", e);
                }
            }
        }
        for (URL url : jarUrls) {
            URLClassLoader loader = new URLClassLoader(new URL[]{url});
            for (Plugin p : ServiceLoader.load(Plugin.class, loader)) {
                String name = p.getClass().getName();
                if (!this.enable(p)) continue;
                File common = new File(this.rootConfDir, String.format(ConfigFileTemplate, name));
                File local = new File(this.localConfDir, String.format(ConfigFileTemplate, name));
                p.init(common, local);
                this.server.attach(p);
                this.plugins.add(p);
                LOGGER.info("init", "Loading a plugin {0}", p.getClass().getName());
            }
        }
        File route = new File(this.localConfDir, "route.conf");
        if (!route.exists()) {
            String buf;
            InputStream in = this.getClass().getResourceAsStream("route.conf");
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            PrintWriter w = new PrintWriter(new FileWriter(route));
            while ((buf = r.readLine()) != null) {
                w.println(buf);
            }
            w.close();
            r.close();
        }
        Properties routings = new Properties();
        FileReader rin = new FileReader(route);
        routings.load(rin);
        ((Reader)rin).close();
        for (Object key : routings.keySet()) {
            String skey = (String)key;
            this.router.put(skey, routings.getProperty(skey));
        }
        LOGGER.exiting("init");
    }

    private void start() throws IOException {
        LOGGER.entering("start", new Object[0]);
        String addr = System.getProperty("nor.address");
        int port = Integer.valueOf(System.getProperty("nor.port"));
        this.server.localResourceRoot().add(new TextResource("/nor/core/proxy.pac", this.server.getPAC(addr, port, Boolean.valueOf(System.getProperty("nor.https", "false"))), "application/x-javascript-config"));
        this.server.start(addr, port);
        LOGGER.exiting("start");
    }

    private void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        this.server.close();
        for (Plugin p : this.plugins) {
            p.close();
        }
        LOGGER.exiting("close");
    }

    public static HttpRequestHandler getRequestHandler() {
        return Nor.nor.handler;
    }

    public static Router getRouter() {
        return Nor.nor.router;
    }

    public static void main(String[] args) {
        LOGGER.info("main", "Start up...", new Object[0]);
        Options ops = new Options();
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set directory which has config files");
        ops.addOption(OptionBuilder.create((String)"config"));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given configu file for logging system");
        ops.addOption(OptionBuilder.create((String)"log"));
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given directory for a serch path of plugins");
        Option pluginsPath = OptionBuilder.create((String)"plugin_dir");
        ops.addOption(pluginsPath);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given plugin file");
        Option plugins = OptionBuilder.create((String)"plugin");
        ops.addOption(plugins);
        ops.addOption("help", false, "show this help");
        try {
            InputStream logStream;
            BasicParser parser = new BasicParser();
            CommandLine cmd = parser.parse(ops, args);
            if (cmd.hasOption("help")) {
                HelpFormatter help = new HelpFormatter();
                help.printHelp("nor", ops, true);
                System.exit(0);
            }
            if (cmd.hasOption("log")) {
                logStream = new FileInputStream(cmd.getOptionValue("log"));
            } else {
                String file = System.getProperty("nor.log", LoggindConfigFile);
                logStream = Nor.class.getResourceAsStream(file);
            }
            Logger.loadConfig(logStream);
            logStream.close();
            nor = cmd.hasOption("config") ? new Nor(cmd.getOptionValue("config")) : new Nor(System.getProperty("nor.config", "config"));
            ArrayList<URL> pluginJar = new ArrayList<URL>();
            if (cmd.hasOption("plugin")) {
                for (String filename : cmd.getOptionValues("plugin")) {
                    File f = new File(filename);
                    pluginJar.add(f.toURI().toURL());
                }
            }
            if (cmd.hasOption("plugin_dir")) {
                for (String dirname : cmd.getOptionValues("plugin_dir")) {
                    File dir = new File(dirname);
                    if (!dir.isDirectory()) continue;
                    for (String filename : dir.list()) {
                        File f = new File(dir, filename);
                        pluginJar.add(f.toURI().toURL());
                    }
                }
            }
            nor.init(pluginJar);
            nor.start();
            System.in.read();
            nor.close();
        }
        catch (UnrecognizedOptionException e) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("nor", ops, true);
        }
        catch (Exception e) {
            LOGGER.catched(Level.SEVERE, "main", e);
        }
        LOGGER.info("main", "End.", new Object[0]);
    }

    private static final class Template {
        public static final String PLUGIN_ENABEL = "%s.enable";

        private Template() {
        }
    }

    private static final class Key {
        public static final String LISTEN_ADDRESS = "nor.address";
        public static final String LISTEN_PORT = "nor.port";

        private Key() {
        }
    }
}

