/*
 * Decompiled with CFR 0.152.
 */
package nor.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.util.log.Logger;

public class Context {
    private final String host;
    private static final Logger LOGGER = Logger.getLogger(Context.class);
    private static final String GatewayRegexWindows = "\\s*(?:\\d+\\.\\d+\\.\\d+\\.\\d+)\\s*(?:\\d+\\.\\d+\\.\\d+\\.\\d+)\\s*(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s*(?:\\d+\\.\\d+\\.\\d+\\.\\d+)";
    private static final String GatewayRegexLinux = "\\s*(?:\\d+\\.\\d+\\.\\d+\\.\\d+)\\s*(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s*(?:\\d+\\.\\d+\\.\\d+\\.\\d+)";
    private static final String Windows = "Windows";
    private static final String Linux = "Linux";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context() {
        LOGGER.entering("<init>", new Object[0]);
        String host = null;
        try {
            Process netstat = new ProcessBuilder("netstat", "-rn").start();
            BufferedReader in = new BufferedReader(new InputStreamReader(netstat.getInputStream()));
            Pattern ipPat = null;
            String os = System.getProperty("os.name");
            if (os.startsWith(Windows)) {
                ipPat = Pattern.compile(GatewayRegexWindows);
            } else if (os.startsWith(Linux)) {
                ipPat = Pattern.compile(GatewayRegexLinux);
            }
            if (ipPat != null) {
                String buf;
                while ((buf = in.readLine()) != null) {
                    String ip;
                    Matcher m = ipPat.matcher(buf);
                    if (!m.find() || "0.0.0.0".equals(ip = m.group(1))) continue;
                    InetAddress addr = InetAddress.getByName(ip);
                    host = addr.getCanonicalHostName();
                    break;
                }
            }
            in.close();
            netstat.destroy();
            this.host = host;
        }
        catch (IOException e) {
            try {
                LOGGER.warning("<init>", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "<init>", e);
                this.host = host;
            }
            catch (Throwable throwable) {
                this.host = host;
                LOGGER.info("<init>", "Gateway Host: {0}", this.host);
                throw throwable;
            }
            LOGGER.info("<init>", "Gateway Host: {0}", this.host);
        }
        LOGGER.info("<init>", "Gateway Host: {0}", this.host);
        LOGGER.exiting("<init>");
    }

    public String getHostName() {
        LOGGER.entering("getHostName", new Object[0]);
        String ret = this.host;
        LOGGER.exiting("getHostName", (Object)ret);
        return ret;
    }
}

