
////////////////////////////////
///// NOA へ問い合わせて得る値 /////

function patientId(){
	if (parent()){
        return parent().patientId();
	} else
		return "";
}

function anotherId(){
	if (parent()){
		var aid = parent().valueForTag("PatientTable.anotherId");
		return (aid) ? aid : "";
	} else
		return "";
}

function patientKanjiName(){
	if (parent())
		return parent().valueForTag("NameSection.patientKanjiName");
	else 
		return "";
}

var _owner;
function setOwner(name){
	_owner = name;
}
function owner(){
	if (_owner)
		return _owner;
	else if (parent()){
		setOwner(parent().owner());
		return parent().owner();
	} else
		return "";
}

function open_chart(patientId){
    // patientId がカルテIDなら、カルテを開く
    if ((patientId.length == 8) && isDigit(patientId))
        parent().openChart(patientId);
}

///// NOA へ問い合わせて得る値 /////
////////////////////////////////

//var _isFold;
var _records;
function setRecords(obj){
	_records = obj;
}
function records(){
	return _records;
}
function recordForId(pid){
	// pid の含まれるレコードを返す
	for (num in _records){
		var rec = _records[num];
		if (rec.patientId == pid)
			return rec;
	}
	return null;
}

/////////////////////////////////////////////
///// neuron.js を介したサーバとの通信 ///////////

function gotRemind(answer){
	// リマインダーの内容をサーバから受け取る
	// CONTENTS
	var obj = eval('(' + answer + ')');

    setRecords(obj);

    showRemind();
}
function getRemind(pid){
	// リマインダーの内容をリクエスト
    var args = new Object();
    args["owner"] = parent().owner();
    args["patientId"] = pid;
    args["type"] = 0; // 0:リマインダーのタイトル名 1:ToDo の patientId
    
    NRCall("GET_REMINDER", args, gotRemind);
}

function puttedRemind(answer){
	// リマインダーの内容をサーバから受け取る
	//alert("=== puttedRemind\n"+answer); //##
	closeFloatPanel();
    getRemind(""); //-- 2016-12 改定前のリマインダー
	//getRemind(patientId()); // 2016-12 改定前は ptientId() として "" が与えられていた
}
function addRecord(pid){
	// pid のデータをサーバへ書き込む
    var args = new Object();
    args["owner"] = parent().owner();
    args["patientId"] = pid;
    args["type"] = 0; // いずれ使うかも知れない
    args["dataString"] = document.getElementById("memo").value;

    NRCall("PUT_REMINDER", args, puttedRemind);
}

function deleteRemind(pid){
	// pid のデータをサーバから削除
	var name = recordForId(pid).patientKanjiName;
	
	if (confirm(pid + " " + name + " のレコードを削除していいですか")){
		// 空データを送れば削除になる
        var args = new Object();
        args["owner"] = parent().owner();
        args["patientId"] = pid;
        args["type"] = 0; // いずれ使うかも知れない
        args["dataString"] = "";
        
        NRCall("PUT_REMINDER", args, puttedRemind);
	}
}

///// neuron.js を介したサーバとの通信 ///////////
/////////////////////////////////////////////


function showEditPanel(pid){
	// pid の編集パネルを開く
	var name = "";
	var value = "";
	var date = "";
	var rec = recordForId(pid);
    
	if (rec){
		name = rec.patientKanjiName;
		value = rec.dataString;
		date = " ( " + rec.updateTime + " )";
	} else if (pid == patientId()){
		name = patientKanjiName();
	}

	// データ編集パネルを生成
    var panel = new FloatPanel("_floatPanel", 5, 5, 330, "編集パネル");
    var elm = panel.contents;
	var tbl = newTABLE(elm, "base-table");
	
	var tr = newTR(tbl, "", "");
	tr.style.fontSize = "10pt";
	var td = newTD(tr, "", pid + " " + name + date);
	td.style.textAlign = "center";
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var ta = newTEXTAREA(td, "memo", 50, 10, value);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
    td.style.textAlign = "right";
	var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "カルテを開く";
	bt.setAttribute("onclick", "open_chart('" + pid + "')");
	var bt = newDIV(td, "/fixButton");
    bt.innerHTML = "確定";
	bt.setAttribute("onclick", "addRecord('" + pid + "')");
	
    ta.focus();
}

function newRecord(){
	// 新規レコードを追加
    /*
	if (! _owner){
		var owner = prompt("owner を入力してください", "");
		if (owner.length > 0)
			setOwner(owner);
		else
			return;
	}
     */
	
	var pid = prompt("「カルテID」または「タイトル」を入力\n＊タイトルには「アルファベット」か「数字」しか使えません", patientId());
	if (pid && pid.length){
		showEditPanel(pid);
	}
}

function showRemind(){
	// remind のコンテンツを表示
	var elm = document.getElementById("historyArea");
	elm.innerHTML = "";
    
	var obj = records();
	if (obj){
		for (num in obj){
			var rec = obj[num];
            
            var dl = newDL(elm, "/remindItem");
            
            // 患者情報
			var dt = newDT(dl, "");
            var header = newDIV(dt, "/header");
			header.setAttribute("onclick","showEditPanel('" + rec.patientId + "')");
            
            var dv = newDIV(header, "/patientInfo");
            var name = (rec.patientKanjiName == "?") ? "" : rec.patientKanjiName;
            dv.innerHTML = rec.patientId + " " + name;
            
            var dv = newDIV(header, "/updateTime");
            dv.innerHTML = rec.updateTime + " ";
            
			var im = newIMAGE(dv, "redCross/expandIcon", "./remove-field.png", "?");
			im.style.height = "11px";
			im.style.verticalAlign = "top";
			im.setAttribute("onclick", "deleteRemind('" + rec.patientId + "')");
            setInfoTip("redCross", "削除"); // INFO

            // コメント
            var dv = newDIV(dt, "/comment");
            dv.innerHTML = transferCR(rec.dataString);
		}
	}
}

function reminderHelp(){
	// 別途ヘルプをパネル表示
	window.open("./reminderHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initReminder(){
	var elm = document.getElementById("base");
    var pframe = new PictureFrame(elm, "80%", "100%");
    
    // === HEADER =================
    // LEFT --
    var dv = pframe.headerLeft;
    // TITLE
    var sp = newSPAN(dv, "rTitle/titleLabel");
    sp.innerHTML = "リマインダー";
    sp.style.fontSize = "9pt";
    sp.style.marginRight = "10px";
    
    // RIGHT --
    // 新規メモ
    var im = newIMAGE(pframe.headerRight, "greenCross/expandIcon", "./add-field.png", "?");
    im.setAttribute("onclick", "newRecord()");
    im.style.marginRight = "5px";
    setInfoTip("greenCross", "新規メモ作製"); // INFO

    // HELP
	var im = newIMAGE(pframe.headerRight, "help/expandIcon", "./help.png", "?");
	im.setAttribute("onclick", "reminderHelp()");
	im.style.height = "16px";
    setInfoTip("help", "取扱説明"); // INFO
    
	// === リスト表示エリア ==========
    pframe.body.setAttribute("id", "historyArea");
    
    // === FOOTER =================
    var dv = pframe.footerLeft;
    dv.innerHTML = version();
    dv.style.fontSize = "10pt";
    dv.style.color = "#aaa";

    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "リマインダー・ツール";

	// 過去の伝票を検索しリストアップ
    getRemind(""); //-- 2016-12 改定前のリマインダー
	//getRemind(patientId());
}

function version(){
    return "Ver.170419";
//	return "Ver.150727";
}
