
////////////////////////////////
/// neuron.js による処理 /////////

function gotInPatient(answer){
    var obj = JSON.parse(answer);
    
    console.log("gotInPatient: ", answer); //##

    // 入院カルテの取り扱いがあれば入院検索ツールを表示
    for (key in obj){
        makeInPatientArea();
    }
}
function getInPatient(){
    // 入院カルテの有無をサーバへ問い合わせ
    var args = new Object();
    args["ProgressSection.status"] = "1"; // 検索条件
    args["patientId"] = "";
    args["from"] = "1900-01-01";
    args["to"] = today();
    args["unique"] = "on";
    console.log("find: args", args); //##
    
    NRCall("FIND", args, gotInPatient, true);
}

function found(answer){
    // 検索結果を表示
    var obj = JSON.parse(answer);
    
    showResults(obj);
}
function findInPatient(){
    // 検索を実行
    var from = document.getElementById("from2").value;
    var to = document.getElementById("to2").value;
    
    // listMaker へ渡す情報を localStorage に記憶
    var st = "条件検索（ ";
    st += from + " から " + to + " で";
    st += "入院カルテの検索結果 ）";
    setListMakerHeader(st);
    
    var args = new Object();
    args["ProgressSection.status"] = "1"; // 検索条件
    args["patientId"] = "";
    args["from"] = from;
    args["to"] = to;
    args["unique"] = "on";
    //console.log("find: args", args); //##
    
    NRCall("FIND", args, found);
}

/// neuron.js による処理 /////////
////////////////////////////////

function makeInPatientFinder(){
    // 入院検索画面を生成
    var elm = elmFor("inPatientFinderArea");
    elm.innerHTML = "";
    elm.style.marginBottom = "10px";
    elm.style.fontSize = "9pt";
    
    // 検索範囲
    var date = today(); // lib.js
    var array = date.split("-");
    var yy = array[0] * 1;
    var mm = array[1] * 1;
    var dd = array[2] * 1;
    
    var div = newDIV(elm, "");
    var label = nengou(yy-1); // 西暦に相当する年号
    newDatePopUp(div, "from2", label, yy, 1, 1, false);
    var tx = newTEXT(div, "から");
    
    var div = newDIV(elm, "/clearfix");
    var dv = newDIV(div, "/left-side");
    dv.style.paddingLeft = "0";
    dv.style.width = "230px";
    var label = nengou(yy); // 西暦に相当する年号
    newDatePopUp(dv, "to2", label, yy, mm, dd, false);
    var tx = newTEXT(dv, "まで");

    // 検索ボタン
    var dv = newDIV(div, "/right-side");
    var bt = newDIV(dv, "/greenButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "findInPatient()");
}

