
<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("'", $array);
        $array = explode("%xa;", $val); // DocMaker の Image 用
        $val = implode("\\'", $array);
        return $val;
    }
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (preg_match("/\)/", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    ////////////////////////////////////////////////////
    ///// 旧バージョン用ディレクトリ ////////////////////////
    function _infoSack(){
        // ファイルを保存する directory を返す
        $dir = "../NOA_ARCHIVE/infoSack";
        if (! file_exists($dir)) mkdir($dir);
        
        return $dir;
    }
    function listBox(){
        // ### 旧バージョンのデータを読み込むために残した機能 ###
        // データファイルを保存する directory を返す
        $dir = _infoSack()."/list";
        if (! file_exists($dir)) mkdir($dir);
        
        return $dir;
    }
    function oldFileBox(){
        // 画像ファイルを保存する directory を返す
        $dir = _infoSack()."/file";
        if (! file_exists($dir)) mkdir($dir);
        
        return $dir;
    }
    ///// 旧バージョン用ディレクトリ ////////////////////////
    ////////////////////////////////////////////////////

    
    function rootDir(){
        // $rootDir = "../../" のような指定方法では認識されず "" になってしまう
        // return "./"; // infoSack 単体で動かす場合
        
        return "../NOA_ARCHIVE/";
    }
    function backupBox($owner){
        // バックアップを保存する directory を返す
        $dir = "../Users/$owner/INFO_SACK";
        if (! file_exists($dir)) mkdir($dir);

        echo "backupBox: $dir \n"; //##

        // 最新のバックアップが現在表示されるものになる
        $dir = "$dir/backup";
        if (! file_exists($dir)) mkdir($dir);
        
        echo "backupBox: $dir \n"; //##
        
        return $dir;
    }
    function fileBox($owner){
        // 画像ファイルを保存する directory を返す
        $dir = "../Users/$owner/INFO_SACK";
        if (! file_exists($dir)) mkdir($dir);
        
        $dir = "$dir/file";
        if (! file_exists($dir)) mkdir($dir);
        
        return $dir;
    }
    
    function filesInDir($dir){
        // $dir 中のファイル名の配列を返す
        $files = scandir($dir);
        
        // "_" で始まるファイル名を含まない配列を生成
        $count = count($files);
        $array = array();
        for ($i=0; $i < $count; $i++){
            $name = $files[$i];
            if (substr($name, 0, 1) == "_") continue;
            $array[] = $name;
        }
        return $array;
    }
    
    

    
    $command = $_POST['command'];
    $id = $_POST['id'];
    $owner = $_POST['owner'];
    $value = $_POST['value'];
    $value = decodeSTRING($value);

    if (strcmp($command,"PUT_INFO_OBJECTS") == 0){
        $path = backupBox($owner)."/$id";
        
        echo "<SEPARATOR>";
        if (file_put_contents($path, $value))
            echo ""; // 成功したら空文字列を返す
        else
            echo "$path への書き出しに失敗しました";
    } else if (strcmp($command,"GET_INFO_DIR") == 0){
        // backupBox 内のファイル名をリストアップ
        $dir = backupBox($owner);
        echo "backupBox: $dir \n"; //##
        
        $files = filesInDir($dir);

        echo "<SEPARATOR>";
        echo json_encode($files);
    } else if (strcmp($command,"GET_INFO_FILE") == 0){
        // メニュー構造を取得
        $dir = backupBox($owner);
        $path = "$dir/$value"; // $value にファイル名が入っている
        
        echo "<SEPARATOR>";
        echo file_get_contents($path);
    } else if (strcmp($command,"GET_DATA_URL") == 0){
        // データの URL を返す
        $dir = fileBox($owner);
        
        echo "<SEPARATOR>";
        echo "$dir/$value"; // $value にファイル名が入っている
    } else if (strcmp($command,"REMOVE_BACKUP") == 0){
        $dir = backupBox($owner);
        $oldPath = "$dir/$value"; // $value にファイル名が入っている
        $newPath = "$dir/_$value";
        
        // ファイル名の頭に削除マーク "_" を付ける
        rename($oldPath, $newPath);
        
        $files = filesInDir($dir);
        
        echo "<SEPARATOR>";
        echo json_encode($files);
    } else if (strcmp($command,"COPY_OLD_FILES") == 0){
        // ### 旧バージョンの画像ファイル類を新フォルダーへ移動 ###
        $oldDir = oldFileBox();
        $newDir = fileBox($owner);
        echo "<SEPARATOR>";
        if (rename($oldDir, $newDir))
            echo "$oldDir を $newDir へ移動しました";
        else
            echo "$oldDir を $newDir へ移動できませんでした";
    } else if (strcmp($command,"GET_INFO_LIST") == 0){
        // ### 旧バージョンのデータを読み込むために残した機能 ###
        // listBox 内のファイルをリストアップ
        $array = array();
        $dir = listBox();
        $files = scandir($dir);
        for ($i=0,$count=count($files); $i < $count; $i++){
            $filename = $files[$i];
            if ($filename == ".") continue;
            if ($filename == "..") continue;
            
            // folder は除外する
            $path = "$dir/$filename";
            if (scandir($path)) continue;
            
            // ファイル内容を読み出す
            $handle = @fopen($path, "r");
            if ($handle) {
                $buffer = "";
                while (!feof($handle)) {
                    $st = fgets($handle, 4096);
                    $buffer = "$buffer$st";
                }
                fclose($handle);
                $array[] = $buffer;
            }
        }
        $dir = _infoSack();
        $results = array();
        $results['fileBox'] = "$dir/file";
        $results['list'] = $array;
        
        // groupMenu を取得
        $buffer = "";
        $filename = "$dir/group.txt";
        $handle = @fopen($filename, "r");
        if ($handle) {
            while (!feof($handle)) {
                $st = fgets($handle, 4096);
                $buffer = "$buffer$st";
            }
            fclose($handle);
        }
        $results['group'] = $buffer;
        
        echo "<SEPARATOR>";
        echo json_encode($results);
    } else {
        echo "<p>( $command ) is wrong command *****</p>";
    }

?>
