
// HTML でのパラメータ渡し

function _owner(){
    var elm = elmFor("_owner");
    return (elm) ? elm.value : "";
}

function patient_id(){
    var elm = elmFor("_patientId");
    return (elm) ? elm.value : "";
}

function current_date(){
    var elm = elmFor("_currentDate");
    return (elm) ? elm.value : "";
}

// HTML でのパラメータ渡し

var _offsetX;
var _offsetY;
var _clientX;
var _clientY;
var _cursorLocked;
function pi_cursorLock(){ // mouse down
	_cursorLocked = true;
}
function pi_cursorUnlock(){ // mouse up
	_cursorLocked = false;
}
function pi_getMouseXY(evt){
	// マウスでパネルのタイトルを掴み移動させる
	// Firefox ではうまく動作しない
	if (_cursorLocked){ // mouse down
		var elm = document.getElementById("_postIt");
		elm.style.left = evt.clientX - _offsetX; // 表示するx座標
		elm.style.top = evt.clientY - _offsetY; // 表示するy座標
	} else { // mouse up
		// layerX layerY は Firefox のみの独自規格で、他のブラウザーは
		// offsetX offsetY だが、最近は Safari でも layerX layerY が動く
		// Firefox では evt.x evt.y は動かない
		_offsetX = evt.layerX;
		_offsetY = evt.layerY;
		_clientX = evt.clientX;
		_clientY = evt.clientY;
	}
}

//===== 旧 PostIt の設定 ======
//var _notOpen = 0;
//var _shrink = 1;
//var _openWithCondition = 2;
//var _openAnyway = 3;
//=========================== 
var _mode;
var _expand = 0;
//var _shrink = 1;
var _expired = 2; // 旧版との互換性のため 2 のまま

var _postItObj;
function setPostItObj(obj){
	_postItObj = obj;
}
function postItObj(){
	return _postItObj;
}

function savedPostIt(answer){
    if (trim(answer).length == 0){
        // 削除メッセージ
        alert("付箋は完全に削除されました");
    } else {
        var obj = JSON.parse(answer);
        console.log("savedPostIt", encodeObject(obj)); //##
        
        if (obj.type * 1 == _expired){
            alert("付箋は削除されました");
        } else {
            setPostItObjects(obj);
            
            // あらかじめ closePostIt() されていないとトグル式に閉じてしまう
            showPostIt();
        }
    }
}
function savePostIt(){
    // PostIt 内容を保存
    var elm = document.getElementById("textArea");
    elm.contentEditable = false;

    // RADIO ボックスから type を検出
    var elm = elmFor("removeCB");
    postItObj().type = (elm.checked) ? _expired : _expand;

    var val = document.getElementById("textArea").innerHTML;
    if (val.length > 0){
        val = transferToCR(val); // <br> を改行に変更
    }
    // 空データなら付箋は削除マークではなく実際に削除される
    val = trim(val);
    
    // savedPostIt（）に備え付箋を一旦閉じておく：その前に type, val を記憶
    closePostIt();
    
    //console.log("savePostIt", postItObj().type, val); //##
    
    // val が "" の場合、そのレコードは削除される
    var args = new Object();
    if (patient_id().length > 0){ // FRONT から開いた場合
        args["owner"] = _owner();
        args["patientId"] = patient_id();
        args["entryDate"] = current_date();
    } else {
        args["owner"] = owner();
        args["patientId"] = patientId();
        args["entryDate"] = currentDate();
    }
    args["type"] = postItObj().type;
    args["color"] = (_colorNumber) ? _colorNumber : 0;
    args["val"] = encodeSTRING(val);
    console.log("savePostIt", args); //##
    
    NRCall("PUT_POST_IT", args, savedPostIt, true);
}

function positionInHTML(position, html){
    // 見かけ上は平文に見える文字列上の位置を HTML 上の位置として返す
    var isTag = false;
    var plainPos = 0;
    for (pos in html){
        var ch = html.charAt(pos);
        
        if (ch == "<") isTag = true;
        if (!isTag){
            if (plainPos == position)
                return pos;
            plainPos++;
        }
        if (ch == ">") isTag = false;
    }
}

function getSelectedString(command){
    // 文字列に HTML 属性をつける
    var elm = document.getElementById("textArea");
    var st = htmlToPlain(elm.innerHTML); // HTML をプレーン・テキストに変換
    
    if (command == "strong"){
        // 選択部分を強調文字にする
        var ln = "<strong>" + st + "</strong>";
    } else if (command == "red"){
        var ln = "<font color='#f00'>" + st + "</font>";
    } else if (command == "blue"){
        var ln = "<font color='#00f'>" + st + "</font>";
    } else if (command == "plain"){
        var ln = st;
    }
    elm.innerHTML = ln;
}

var _colorNumber;
function changeToEditable(){
    // 付箋内容を編集できるようにする
    // textArea を編集可能状態にする
    var elm = document.getElementById("textArea");
    elm.contentEditable = true; // TEXT を編集可能状態にする
    elm.focus();
    
    // SPACE
    var tr = document.getElementById("spaceArea");
    tr.innerHTML = "";
    tr.style.height = "8px";
    
   // 受診日
    var tr = document.getElementById("entryDateArea");
    tr.innerHTML = "";
    var td = newTD(tr, "postitTD", "年月日");
    var date = (postItObj()) ? postItObj().entryDate : "";
    var td = newTD(tr, "", date);
    
    // 更新日
    var tr = document.getElementById("updateTimeArea");
    tr.innerHTML = "";
    var td = newTD(tr, "postitTD", "更新日");
    td.setAttribute("onclick", "showPostItObjects()");
    var update = (postItObj()) ? postItObj().updateTime : "";
    var td = newTD(tr, "", update);
    
    // 文字色
    var tr = document.getElementById("postItToolArea");
    tr.innerHTML = "";
    var td = newTD(tr, "", "");
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    sp.innerHTML = "文字色";
    var td = newTD(tr, "", "");
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var a = newA(sp, "赤", "#", "");
    a.setAttribute("onMouseUp", "getSelectedString('red')"); //####
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var a = newA(sp, "青", "#", "");
    a.setAttribute("onMouseUp", "getSelectedString('blue')"); //####
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var a = newA(sp, "強調文字", "#", "");
    a.setAttribute("onMouseUp", "getSelectedString('strong')"); //####
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var a = newA(sp, "平文", "#", "");
    a.setAttribute("onMouseUp", "getSelectedString('plain')"); //####
    
    // CHECK BOX
    var tr = document.getElementById("footerArea");
    tr.innerHTML = "";
    var td = newTD(tr, "", "");
    td.setAttribute("colspan", "2");
    var div = newDIV(td, "");
    
    var sp = newSPAN(div, "postItColorArea");
    sp.style.paddingRight = "5px";
    _colorNumber = postItObj().color * 1;
    showPostItColor();

    // 削除チェックボックス
    var sp = newSPAN(div, "");
    sp.style.fontSize = "10pt";
    sp.style.paddingRight = "10px";
    sp.style.position = "relative";
    sp.style.top = "8px";
    var status = (postItObj() && (postItObj().type * 1 == _expired)) ? 1 : 0;
    var cb = newCHECKBOX(sp, "removeCB", "削除", status);

    // BUTTON
    var sp = newSPAN(div, "");
    sp.style.position = "relative";
    sp.style.top = "6px";
    var bt = newDIV(sp, "/whiteButton");
    bt.innerHTML = "とりやめ";
	bt.setAttribute("onclick", "closePostIt()");
    var bt = newDIV(sp, "/fixButton");
    bt.innerHTML = "確定";
	bt.setAttribute("onclick", "savePostIt()");
}

function showPostItColor(){
    // 付箋色を表示
    var elm = elmFor("postItColorArea");
    elm.innerHTML = "付箋色";
    elm.setAttribute("onclick", "changePostItColor()");
    
    switch (_colorNumber){
        case 1: elm.setAttribute("class", "postItTagBlue"); break;
        case 2: elm.setAttribute("class", "postItTagYellow"); break;
        case 3: elm.setAttribute("class", "postItTagRed"); break;
        default: elm.setAttribute("class", "postItTagGreen"); break;
    }
    elm.style.top = "5";
    elm.style.left = "-4";
}
function changePostItColor(){
    // 付箋色を変更
    if (_colorNumber < 3)
        _colorNumber += 1;
    else
        _colorNumber = 0;
    
    showPostItColor();
}

function makePostIt(obj){
    // 付箋の本体を表示
    // showPostItForce() と共有
    setPostItObj(obj); // 現在扱っている PostIt を記憶
    
    // currentDate のページ・ヘッダーの Y 座標を返す
    var elm = document.getElementById(currentDate() + ".page");
    var pos = getPosition(elm);
	var x = 30; // 表示するx座標
	var y = pos.y + 80; // 表示するy座標
    var w = 280;
    var title = "付箋";
    var haction = "openHelp('postItHelp.html')"; // HELP ACTION
    var panel = new FloatPanel("_floatPanel", x, y, w, title, haction);
    if (!panel) return;
    var elm = panel.contents;
    elm.style.padding = "5px";
    
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.backgroundColor = "#ffe";
    
    ///// CONTENTS：子テーブルとして生成 //////////
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "postItContentsArea", "");
    td.style.padding = "10px";
    var tbl = newTABLE(td, "/base-table");
    
    // 付箋内容
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "textArea", "");
    td.setAttribute("colspan", "2");
    td.setAttribute("onclick", "changeToEditable()");
    if (obj && obj.value && obj.value.length)
        td.innerHTML = convertSTRING(obj.value, "\n", "<br>"); // 改行を <br> に変更
    else
        td.innerHTML = "";
    
    ///// 以下は編集モードでのみ表示 ///////////////
    var tr = newTR(tbl, "spaceArea", ""); // contents
    
    var tr = newTR(tbl, "entryDateArea", ""); // contents
    tr.style.fontSize = "9pt";
    tr.style.color = "#aaa";
    
    var tr = newTR(tbl, "updateTimeArea", ""); // contents
    tr.style.fontSize = "9pt";
    tr.style.color = "#aaa";
    
    // tool area
    var tr = newTR(tbl, "postItToolArea", ""); // contents
    tr.style.fontSize = "9pt";
    tr.style.color = "#aaa";
    
    // button area
    var tr = newTR(tbl, "footerArea", ""); // contents
}


function showPostItForce(){
    // obj が無くても強制的に付箋を開く：chart.js から利用
    // 空の obj を生成して付箋パネルを開く
    var elm = document.getElementById("_postIt");
    if (elm && elm.innerHTML.length){
        // トグル式に付箋を表示・非表示
        closePostIt();
        return;
    }
    
    var dateTime = currentDate();
    var obj = postItForDate(dateTime);
    if (obj){
        obj.entryDate = dateTime;
    } else {
        var obj = new Object();
        obj.entryDate = dateTime;
        obj.type = _expand;
        obj.value = "";
        obj.updateTime = "";
    }
    
    makePostIt(obj);
    changeToEditable();
}
function closePostIt(){
    // 付箋を閉じる
    if (patient_id().length > 0) return; // 別ウインドーで開いた場合は何もしない
    
    // closeFloatPanel() では他のカルテを開いた場合には機能しない
    var elm = elmFor("_floatPanel");
    elm.innerHTML = "";
    elm.style.left = -10000; // 表示するx座標
}
function showPostIt(){
	// ## あらかじめ base に _postIt エレメントの埋め込みが必要
    // obj = {"type":"0","entryDate":"...","value":"memo","updateTime":"..."}
    if (patient_id().length > 0){ // FRONT から開いた場合
        var obj = postItForDate(current_date()); // currentDate() 以前直近の obj
        if (obj && obj.value){
            if (obj.type == _expired){
                // expired type なら閉じて終了
                closePostIt(); // 他の日付の付箋を閉じる
            } else {
                make_postIt(obj);
            }
        } else {
            // obj が無く status が無ければ閉じて終わる
            closePostIt(); // 他の日付の付箋を閉じる
        }
    } else {
        var obj = postItForDate(currentDate()); // currentDate() 以前直近の obj
        
        parent().openPage(currentDate(), true); // そのページをアクティブにする
        if (obj && obj.value){
            if (obj.type == _expired){
                // expired type なら閉じて終了
                closePostIt(); // 他の日付の付箋を閉じる
            } else {
                makePostIt(obj);
            }
        } else {
            // obj が無く status が無ければ閉じて終わる
            closePostIt(); // 他の日付の付箋を閉じる
        }
    }
}


///////////////////////////////////////////////////////////////////
///// FRONT から呼ばれた場合 /////////////////////////////////////////

function make_postIt(obj){
    // 付箋の本体を表示
    setPostItObj(obj); // 現在扱っている PostIt を記憶
    
    // currentDate のページ・ヘッダーの Y 座標を返す
    var elm = elmFor("base");
    elm.innerHTML = "";
    elm.style.padding = "5px";
    elm.style.verticalAlign = "middle";
    
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.backgroundColor = "#ffe";
    tbl.style.border = "thin solid #aaa";
    tbl.style.width = "300px";
    tbl.style.marginLeft = "auto";
    tbl.style.marginRight = "auto";
    
    // ヘッダー
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    td.style.backgroundColor = "#ec9";
    var div = newDIV(td, "/left-side");
    div.style.fontSize = "11pt";
    var sp = newSPAN(div, "");
    sp.innerHTML = "付箋";
    sp.style.paddingRight = "10px";
    var sp = newSPAN(div, "");
    sp.innerHTML = patient_id();
    var div = newDIV(td, "/right-side");
    var img = newIMAGE(div, "", "help.png", "icon");
    img.style.height = "17px";
    img.setAttribute("onclick", "openHelp('./postItHelp.html')");
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "3px";
    
    ///// CONTENTS：子テーブルとして生成 //////////
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "postItContentsArea", "");
    td.style.padding = "10px";
    var tbl = newTABLE(td, "/base-table");
    
    // 付箋内容
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "textArea", "");
    td.setAttribute("colspan", "2");
    td.setAttribute("onclick", "changeToEditable()");
    if (obj && obj.value && obj.value.length)
        td.innerHTML = convertSTRING(obj.value, "\n", "<br>"); // 改行を <br> に変更
    else
        td.innerHTML = "";
    
    ///// 以下は編集モードでのみ表示 ///////////////
    var tr = newTR(tbl, "spaceArea", ""); // contents
    
    var tr = newTR(tbl, "entryDateArea", ""); // contents
    tr.style.fontSize = "9pt";
    tr.style.color = "#aaa";
    
    var tr = newTR(tbl, "updateTimeArea", ""); // contents
    tr.style.fontSize = "9pt";
    tr.style.color = "#aaa";
    
    // tool area
    var tr = newTR(tbl, "postItToolArea", ""); // contents
    tr.style.fontSize = "9pt";
    tr.style.color = "#aaa";
    
    // button area
    var tr = newTR(tbl, "footerArea", ""); // contents
    changeToEditable();
    
    var tr = newTR(tbl, "", ""); // contents
    var td = newTD(tr, "", ps_version());
    td.setAttribute("colspan", "2");
    td.style.paddingTop = "12px";
    td.style.textAlign = "right";
    td.style.fontSize = "9pt";
    td.style.color = "#aaa";
}

function gotPostIt(answer){
    // _owner(), patient_id() の PostIt レコードがサーバから返された
    var obj = JSON.parse(answer);
    //console.log("gotPostIt", encodeObject(obj)); //##

    for (dateTime in obj){
        var rec = obj[dateTime];
        if (isSameDate(dateTime, current_date())){
            obj.entryDate = current_date();

            make_postIt(rec);

            return;
        }
    }
    
    // obj が空だった場合
    var obj = new Object();
    obj.entryDate = current_date();
    obj.type = _expand;
    obj.value = "";
    obj.updateTime = "";
   
    make_postIt(obj);
}
function initPostIt(){
    // FRONT から呼ばれる時に使われる
    //console.log("initPostIt", _owner(), patient_id(), current_date()); //##
    
    // ウインドー・タイトルに カルテID・名前 を表示
    window.document.title = "付箋";

    var args = new Object();
    args["owner"] = _owner();
    args["patientId"] = patient_id();
    NRCall("GET_POSTIT", args, gotPostIt);
}

function ps_version(){
	return "Ver.140826";
}

