
/* 
///// FORM のフォーマットは MenuTable.value に以下の型式で記憶される /////
candida(||-|-,+-,+,++)トリコモナス(||-|-,+-,+)クラミジア(||-|-,+-,+)HIV()梅毒()淋菌()B群溶連菌()細菌(|||e.coli,なし,陰性,肺炎桿菌,黄色ブドウ状球菌)メモ()
///////////////////////////////////////////////////////////////////
*/

////////////////////////////////
/// neuron.js による処理 /////////

function removeArchiveFile(){
    // 選択されたファイルを削除
    //alert("== removeArchiveFile"); //##
    
    var filename = document.getElementById("fileNamePop").value; // 日付ファイル名
    var dir = _slipName + "/" + filename;
    
    //alert("removeArchiveFile->"+dir); //##
    
    document.getElementById("backupArea").innerHTML = "";
    
    remove_archive_file(owner(), "FORM", dir, alert);
}

function gotLayoutFile(answer){
    //　サーバから伝票レイアウトのバックアップ・ファイルを取り出して復元

    //alert("gotLayoutFile->"+answer); //##
    var array = JSON.parse(answer);
    //alert("gotLayoutFile->"+encodeObject(array)); //##
    
    // array = ["title", {"title":"value"}] 型式
    // array からテンプレートを復元
    var slipName = array[0];
    var obj = decodeObject(array[1]);
    
    var rec = new Object();
    rec.tag = cellLabel();
    rec.value = encodeObject(obj[slipName]);
    
    // _menuObj に追加
    addItemRecord(slipName, rec);
    
    // 伝票編集パネルを再表示
    openSlipEditor(slipName);
    
    // メッセージを表示
    alert("伝票( " + slipName + " )を保存するなら「登録」してください");
}
function getLayoutFile(){
    //　サーバから伝票レイアウトのバックアップ・ファイルを取り出して復元
    var filename = document.getElementById("fileNamePop").value; // 日付ファイル名
    var dir = _slipName + "/" + filename;
    
    var args = new Object();
    args["owner"] = owner();
    args["folder"] = "FORM";
    args["filename"] = dir;
    
    NRCall("GET_ARCHIVE_FILE", args, gotLayoutFile);
}

/// neuron.js による処理 /////////
////////////////////////////////

//////////////////////////////////////////////////////////
///// バックアップ /////////////////////////////////////////

function gotSlipBackup(answer){
    // バックアップ・ファイルの読み書きするペーンを表示
    // FORM のアーカイブ・ファイル名をポップアップに表示
    var obj = JSON.parse(answer);
    //alert("gotSlipBackup->"+encodeObject(obj)); //##
    
    var filenames = obj.files; // obj.path -- archive path
    var menuItems = new Array();
    for (num in filenames){
        // ファイル名が _ で始まる削除済みファイルを抜いたものをポップアップ表示
        var name = filenames[num];
        if (name.charAt(0) == "_") continue;
        
        menuItems.push(name);
    }
    
    var elm = document.getElementById("backupArea");
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.padding = "10px 10px 20px 10px";
    div.style.background = "#ffd";
    div.style.border = "thin solid #833";
    div.style.color = "#833"; // brown
    
    // バックアップから復元
    var dv = newDIV(div, "/clearfix");
    var ls = newDIV(div, "/left-side");
    ls.style.width = "80%";
    var sp = newSPAN(ls, "");
    sp.innerHTML = _slipName; // 伝票名
    sp.style.fontSize = "11pt";
    sp.style.paddingRight = "10px";
    sp.style.fontWeight = "bold";
    sp.style.color = "#000";
    var sp = newSPAN(ls, "");
    sp.innerHTML = "の伝票レイアウトを";
    sp.style.fontSize = "10pt";
    var rs = newDIV(div, "/right-side");
    
    // バックアップ・ファイルのポップアップ
    var dv = newDIV(div, "");
    var pm = newPopupMenu(dv, "fileNamePop", menuItems, "");
    //setInfoTip("fileNamePop", "過去のバックアップ・ファイル"); // HELP
    
    // 復元ボタン
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "から復元";
    bt.setAttribute("onclick", "getLayoutFile()");
    bt.style.position = "relative";
    bt.style.marginBottom = "5px";
    
    // バックアップ・ファイル削除ボタン
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "削除";
    bt.setAttribute("onclick", "removeArchiveFile()");
    bt.style.position = "relative";
    bt.style.marginBottom = "5px";
    
    var pos = getPosition(bt);
    window.scroll(0, pos.y);
}
function getSlipBackup(slipName){
    // FORM のアーカイブファイル・リストをサーバへリクエスト
    var elm = document.getElementById("backupArea");
    if (elm.innerHTML.length){ // toggle 式に開閉
        elm.innerHTML = "";
        return;
    }
    
    var args = new Object();
    args["owner"] = owner();
    args["folder"] = "FORM";
    args["filename"] = slipName;
    
    NRCall("GET_ARCHIVE_FILES", args, gotSlipBackup);
}

function savedBackup(answer){
    // 伝票編集パネルを閉じるとともに伝票を reload
    alert(answer);
    
    savedSlipTemplate(answer);
}
function saveBackup(answer){
    // バックアップファイルも保存
    var slipName = _slipName; // どういう訳か slipName() 型式では駄目
    
    // 伝票のテンプレートをバックアップのためアーカイブ
    // アーカイブ内容は array として格納しなければならないので array に入れる
    var value = slipStructute(slipName);
    var array = new Array();
    array.push(slipName);
    array.push(value);
    
    //alert("array->"+encodeObject(array)); //##
    
    var args = new Object();
    args["owner"] = owner();
    args["folder"] = "FORM";
    args["subfolder"] = slipName;
    args["value"] = encodeObject(array);
    
    NRPost("PUT_ARCHIVE_FILE", args, savedBackup);
}
function saveSlipTemplate(slipName){
    // 伝票テンプレートをサーバへ保存
    var value = structureForTemplate(slipName);
    
    //console.log("saveSlipTemplate->", cellLabel(), slipName, value); //##

    // CELL MENU では第２引数が cell.tag 伝票テンプレートでは第２引数が cell.label
	// 選択アイテムが存在しなければ登録、存在すれば頻度をインクリメント -- ??
	put_menu(owner(), cellLabel(), slipName, "", value, saveBackup);
}

///// バックアップ /////////////////////////////////////////
//////////////////////////////////////////////////////////


function structureForTemplate(slipName){
    // 実値を持つ伝票オブジェクトから、実値を抜いたオブジェクトを作成して返す
    var value = _menuObj[slipName]['value'];
    //console.log("structureForTemplate->", value) //##
    
    // value には各項目の実値も入っているが、テンプレート用に実値を削除したものとする
    if (value.length){
        var rec = decodeObject(value);
        for (label in rec){
            var val = rec[label];
            var array = val.split('|');
            array[5] = ""; // ５番目が値なのでこれを空にする
            rec[label] = array.join('|');
            //console.log(label, array) //##
        }
        // 属性値を更新したオブジェクトをエンコードし再び value に収納
        value = encodeObject(rec);
        //console.log("value->", value) //##
    }
    return value;
}

/////////////////////////////////
///// NOA 形式出力 ////////////////

function slipStructute(slipName){
    // 伝票構造を NOAフォーマットで出力
    var buff = structureForTemplate(slipName);
    
    return _slipName + "(" + buff + ")";
}

function showNOAFormat(){
    // NOA 形式で出力
    var elm = document.getElementById("backupArea");
    if (elm.innerHTML.length > 0){
        elm.innerHTML = "";
        return;
    }
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.padding = "10px 10px";
    div.style.background = "#ffd";
    div.style.border = "thin solid #833";
    div.style.color = "#833"; // brown
    
    // タイトル
    var dv = newDIV(div, "");
    dv.innerHTML = "NOA フォーマット文字列";
    dv.style.padding = "0 0 5px 5px";
    dv.style.fontSize = "10pt";
    
    // TEXTAREA
    var anObj = new Object();
    var obj = formForSlipName(_slipName);
    for (label in obj){
        var rec = obj[label];
        var array = new Array();
        for (attribute in rec){
            var val = rec[attribute];
            array.push(val);
        }
        anObj[label] = array.join("|");
    }
    var noaObj = new Object();
    noaObj[_slipName] = anObj;
    
    var dv = newDIV(div, "");
    dv.style.textAlign = "center";
	var ta = newTEXTAREA(dv, "", 35, 15, encodeObject(noaObj));
    
    // どういう訳か うまく機能しない
    var elm = elmFor("_floatPanel");
    var pos = getPosition(elm);
    window.scroll(0, pos.y + elm.offsetHeight);
    
//    console.log("y", pos.y); //##
//    console.log("pos.y + elm.offsetHeight", pos.y + elm.offsetHeight); //##
}

///// NOA 形式出力 ////////////////
/////////////////////////////////

////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function f_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
    // ここでは event.target.id は ラベル名 となっている
}

function f_drop(event){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    // id_name として ラベル名 が得られる
    //_initDebug(true); //##
    _debug("== f_drop"); //##
    
    var id_name = event.dataTransfer.getData("text");
    _debug("id_name->"+id_name); //##
    
    // id_name からドラッグされた要素を取得
    var drag_elm = document.getElementById(id_name);
    
    // ドロップ先にドラッグされた要素を追加
    moveTo(id_name, event.currentTarget);
    
    // エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
    event.preventDefault();
}
function moveTo(drop_id, target_node){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    var target_id = target_node.id;
    _debug("moveTo->"+drop_id+"->"+target_id); //##
    
    // dorp_id: ここでは ラベル名 が入っている
    if (drop_id == target_id) return; // 自分自身は無視
    
    // drop_id を target_id の位置へ挿入し再表示
    moveOrderSlip(drop_id, target_id);
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////

function savedSlipTemplate(answer){
    // 伝票削除後の状態を表示
    //alert("savedSlipTemplate->"+answer); //##

    // 伝票編集パネルを閉じる
    closeFloatPanel();
    
    // 伝票画面を初期化する：popup を load し「検査」欄からデータを読み込む
    initSlip();
//    initForm();
}
function deleteOrderSlip(slipName){
    // slipName の伝票をサーバから削除
    // ### これに対し form.js の removeOrderSlip() はメモリー上での削除
    if (confirm("「" + slipName + "」の伝票をサーバから削除していいですか")){
        remove_menu(owner(), cellLabel(), slipName, null, savedSlipTemplate);
    }
}

function addField(slipName){
    // slipName にフィールドを追加
    var label = prompt("新規項目名");
    if (label.length > 0){
        /* obj = "owner(ohashi)tag(検査)value(身長^[^||||dateType||年月日時分^]^体重^[^|kg|40..100|50,60,70,80|^]^)public(0)freq(23)menu(テスト)template()" 形式
         */
        var obj = menuObjFor(slipName); // 既存の伝票オブジェクト
        if (obj){
            obj.value += label + "()"; // 新規フィールドを追加
        } else { // 新規伝票の場合
            obj = new Object();
            obj.tag = cellLabel();
            // | を最低一つは入れておかないと初期値が undefined で表示される
            obj.value = label + "(|)";
            addItemRecord(slipName, obj);
        }

        // 伝票エディターを再表示
        openSlipEditor(slipName);
    }
}
function removeField(slipName, label){
    // slipName, label のフィールドを削除
    var obj = menuObjFor(slipName); // 既存の伝票オブジェクト
    var st = obj.value; // "日付(||||)身長(||||)体重(||||)" 形式

    // label のフィールドを削除
    var recs = decodeObject(st);
    delete recs[label];
    obj.value = encodeObject(recs);
    
    // 伝票エディターを再表示
    openSlipEditor(slipName);
}

function showDateTypePane(slipName, label){
    // 日付型式ペーンを生成
    var obj = formForSlipName(slipName);
    var rec = obj[label];
    _debug("== showDateTypePane->"+slipName+"->"+label+"->"+encodeObject(rec)); //##
    
    // HEADER ===============================
    var box = document.getElementById(label+".box");
    box.innerHTML = "";
    // タイトル・エレメントの ID には drag/drop で利用するため ラベル名 を指定しておく
    var div = newDIV(box, label+"/clearfix");
    div.style.backgroundColor = "#ec9";
    div.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
    div.setAttribute("ondragstart", "f_dragstart(event)");
    div.setAttribute("ondragover", "f_dragover(event)");
    div.setAttribute("ondrop", "f_drop(event)");
    // --- LEFT SIDE -------------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "130px";
    // 削除アイコン
    var im = newIMAGE(dv, "icon", "./remove-field.png", "X");
    im.style.height = "12px";
    var action = "removeField('"+slipName + "','" + label+"')";
    im.setAttribute("onclick", action);
    // LABEL
    var sp = newSPAN(dv, label+".label");
    sp.innerHTML = label;
    sp.style.paddingLeft = "10px";
    sp.style.fontSize = "10pt";
    sp.style.position = "relative";
    sp.style.top = "5px";
    sp.contentEditable = true; // フィールド名 を編集可能状態にする
    sp.setAttribute("onblur", "changeLabel(this,'"+slipName+"','"+label+"')");
    // --- RIGHT SIDE --------------------
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "0";
    // 型式選択タブ
    changeType(slipName, label, "dateType"); // rec.type をセット
    var sp = newSPAN(dv, "/gray-tab");
    sp.innerHTML = "一般型式";
    var action = "showGeneralTypePane('"+slipName+"','"+label+"')";
    sp.setAttribute("onclick", action);
    var sp = newSPAN(dv, "/white-tab");
    sp.innerHTML = "日付型式";
    sp.style.marginRight = "10px";
    
    // CONTENTS ===============================
    var div = newDIV(box, "");
    div.innerHTML = "表示形式 ";
    div.style.padding = "5px 10px";
    var array = ["年月日","年月","年月日時分"];
    var menuItem = rec.dateFormat; // ### 日付の表示形式は dateFormat として記憶
    var pm = newPopupMenu(div, "", array, menuItem);
    pm.setAttribute("onchange", "changeDateType(this,'"+slipName+"','"+label+"')");
}
function showGeneralTypePane(slipName, label){
    // 一般型式ペーンを生成
    //_initDebug(true) //##
    //_debug("== showGeneralTypePane->"+slipName+"->"+label); //##
    
    var obj = formForSlipName(slipName);
    var rec = obj[label];
    //_debug("rec->"+encodeObject(rec)); //##
    
    // HEADER ===============================
    var box = document.getElementById(label+".box");
    box.innerHTML = "";
    // タイトル・エレメントの ID には drag/drop で利用するため ラベル名 を指定しておく
    var div = newDIV(box, label+"/clearfix");
    div.style.backgroundColor = "#ec9";
    div.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
    div.setAttribute("ondragstart", "f_dragstart(event)");
    div.setAttribute("ondragover", "f_dragover(event)");
    div.setAttribute("ondrop", "f_drop(event)");
    // --- LEFT SIDE -----------------------------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "130px";
    // 削除アイコン
    var im = newIMAGE(dv, "icon", "./remove-field.png", "X");
    im.style.height = "12px";
    var action = "removeField('"+slipName + "','" + label+"')";
    im.setAttribute("onclick", action);
    // LABEL
    var sp = newSPAN(dv, label+".label");
    sp.innerHTML = label;
    sp.style.paddingLeft = "10px";
    sp.style.fontSize = "11pt";
    sp.style.position = "relative";
    sp.style.top = "5px";
    sp.contentEditable = true; // フィールド名 を編集可能状態にする
    sp.setAttribute("onblur", "changeLabel(this,'"+slipName+"','"+label+"')");
    // --- RIGHT SIDE -----------------------------------
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "0";
    // 型式選択タブ
    changeType(slipName, label, ""); // rec.type をセット
    var sp = newSPAN(dv, "/white-tab");
    sp.innerHTML = "一般型式";
    var sp = newSPAN(dv, "/gray-tab");
    sp.innerHTML = "日付型式";
    var action = "showDateTypePane('"+slipName+"','"+label+"')";
    sp.setAttribute("onclick", action);
    sp.style.marginRight = "10px";
    
    // 属性設定フィールド
    var div = newDIV(box, "/clearfix");
    // --- LEFT SIDE -----------------------------------
    var ls = newDIV(div, "/left-side");
    ls.style.width = "150px";
    ls.style.paddingTop = "5px";
    ls.style.paddingLeft = "5px";
    // default 値
    var dv = newDIV(ls, "");
    var val = (rec.fixed) ? rec.fixed : "";
    var fd = newFIELD(dv, label+".fixed", "初期値", 15, val);
    fd.setAttribute("onkeyup", "changeFixed(this,'"+slipName+"','"+label+"')");
    // 単位
    var dv = newDIV(ls, "");
    var val = (rec.unit) ? rec.unit : "";
    var fd = newFIELD(dv, label+".unit", "単位", 5, val);
    fd.setAttribute("onkeyup", "changeUnit(this,'"+slipName+"','"+label+"')");
    // 数値チェックボックス
    var dv = newDIV(ls, "");
    var status = (rec.charType) ? 1 : 0;
    var fd = newCHECKBOX(dv, label+".charType", "数値形式", status);
    fd.setAttribute("onchange", "changeCharType(this,'"+slipName+"','"+label+"')");
    // --- RIGHT SIDE -----------------------------------
    var rs = newDIV(div, "/right-side");
    rs.style.paddingRight = "0";
    // メニュー
    var dv = newDIV(rs, "");
    dv.style.textAlign = "left";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "メニュー";
    var dv = newDIV(rs, "");
    div.style.paddingBottom = "5px";
    var val = "";
    if (rec.menu && (rec.menu.length > 0)){
        var array = rec.menu.split(',');
        val = array.join('\n');
    }
    var fd = newTEXTAREA(dv, label+".menuField", 18, 5, val);
    fd.setAttribute("onkeyup", "changeMenu(this,'"+slipName+"','"+label+"')");
}

function openSlipEditor(slipName){
    // 伝票エディターを開く
    _slipName = slipName;
    
    var w = 310;
	var x = 10; // 表示するx座標
	var y = 30; // 表示するy座標
    var action = "openHelp('formEditorHelp.html')";
    var panel = new FloatPanel("_floatPanel", x, y, w, "伝票編集", action);
    if (!panel) return;
    var elm = panel.contents;
    elm.style.padding = "5px";

    // HEADER ==============================================
    var div = newDIV(elm, "/yellow-header");
    div.style.marginBottom = "5px";
    // 削除アイコン
    var im = newIMAGE(div, "icon", "./remove-field.png", "X");
    im.style.height = "12px";
    im.setAttribute("onclick", "deleteOrderSlip('" + slipName + "')");
    im.style.position = "relative";
    im.style.bottom = "2px";
    im.style.marginLeft = "9px";
    // 伝票名
    var sp = newSPAN(div, "");
    sp.innerHTML = slipName;
    sp.style.paddingLeft = "10px";
    sp.style.fontSize = "12pt";
    
    // CONTENTS ============================================
    var frame = newDIV(elm, "");
    frame.style.backgroundColor = "#ffe";
    frame.style.fontSize = "9pt";

    var obj = formForSlipName(slipName);
    for (label in obj){
        // generalPane または datePane を生成
        var box = newDIV(frame, label+".box");
        box.style.borderBottom = "2px solid #fff";
        
        // rec.type により入力ペーンを替える
        var rec = obj[label];
        _debug(label+" ->"+encodeObject(rec)); //##
        
        if (rec.type)
            showDateTypePane(slipName, label);
        else
            showGeneralTypePane(slipName, label);
    }
    
    // 新規項目追加 ========================================
    var div = newDIV(frame, "/clearfix");
    div.style.paddingBottom = "5px";
    var im = newIMAGE(div, "", "./add-field.png", "add");
    im.style.height = "13px";
    im.setAttribute("onclick", "addField('" + slipName + "')");
    im.style.paddingLeft = "10px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "新規項目追加";
    sp.style.paddingLeft = "5px";
    sp.style.paddingRight = "10px";
    
    // --- backup message ----------------------
    var div = newDIV(frame, "backupMessageArea");
    div.style.paddingBottom = "5px";
    
    // FOOTER ===========================================
    var footer = newDIV(elm, "/yellow-footer");
    var div = newDIV(footer, "/clearfix");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = fe_version();
    dv.setAttribute("onclick", "debugInfo()");
    dv.style.width = "40%";
    dv.style.color = "#555";
    dv.style.position = "relative";
    dv.style.top = "2px";
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "0";
    var bt = newDIV(dv, "/flatButton");
    bt.innerHTML = "とりやめ";
    bt.style.marginRight = "5px";
    bt.setAttribute("onclick", "closeFloatPanel()");
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "登録";
    bt.setAttribute("onclick", "saveSlipTemplate('" + slipName +"')");
    
    // OPTION =============================================
    var div = newDIV(elm, "/clearfix");
    div.style.paddingTop = "3px";
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "0";
    // バックアップ
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "10px";
    var a = newA(sp, "バックアップ", "#", "");
	a.setAttribute("onclick", "getSlipBackup('" + slipName + "')");
    a.style.fontSize = "9pt";
    // NOA 形式出力
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "10px";
    var a = newA(sp, "NOA 形式で出力", "#", "");
    a.setAttribute("onclick", "showNOAFormat()");
    a.style.fontSize = "9pt";

    var div = newDIV(elm, "backupArea");
}

function fe_version(){
    return "Ver.150221";
}


