
var _canvas;
function setCanvas(cv){
    _canvas = cv;
}
function canvas(){
    return _canvas;
}

var _patientImageType = 0;
var _galleryType = 1;
var _tempType = 2;
var _paneType;
function setPaneType(type){
    _paneType = type;
}
function paneType(){
    // ドラッグ・ドロップかファイル・アップロードかを返す
    return _paneType;
}

var _imageName;
function setImageName(name){
    _imageName = name;
}
function imageName(){
    return _imageName;
}

var _imageSrc;
function setImageSrc(img){
    _imageSrc = img;
}
function imageSrc(){
    return _imageSrc;
}

var _imageName;
function setImageName(name){
    _imageName = name;
}
function imageName(){
    return _imageName;
}

/////////////////////////
///// カルテからの継承値 ///

function patientId(){
    return (parent()) ? parent().patientId() : null;
}

function patientName(){
    return (parent()) ? parent().patientKanjiName() : null;
}

///// カルテからの継承値 ///
/////////////////////////

///////////////////////////////////
/// localStorage による処理 /////////

var _largeSize = 250;
var _middleSize = 80;
var _smallSize = 30;

function setThumbnailSize(elm){
    // サムネイル・サイズを変更
    if (elm.value == "大")
        window.localStorage["pictureThumbNailSize"] = _largeSize;
    else if (elm.value == "中")
        window.localStorage["pictureThumbNailSize"] = _middleSize;
    else
        window.localStorage["pictureThumbNailSize"] = _smallSize;
    
    // サムネイルを再表示
    getImages();
    
    // テンプレートを再表示
    showPatientImagePane();
}

var _imagePath;
function setImagePath(path){
    _imagePath = path;
}
function imagePath(){
    // サーバ内で画像の存在するパスを返す
    return _imagePath;
}

function thumbNailSize(){
    // サムネイル・サイズを返す
    var size = window.localStorage["pictureThumbNailSize"];
    return (size) ? size : _middleSize;
}

function thumbNailSizeName(){
    // サムネイル・サイズの名前を返す
    var size = thumbNailSize() * 1;
    switch(size){
        case _largeSize: return "大";
        case _smallSize: return "小";
        default: return "中";
    }
}

function getWindowSize(){
	// Picture tool のウインドー位置とサイズをサーバへリクエスト
    var size = window.localStorage["pictureToolWindowSize"];
    
	// サーバから得られたサイズにウインドーを調整する
	if (size){
		var args = size.split(",");
		var x = args[0] * 1;
		var y = args[1] * 1;
		var w = args[2] * 1;
		var h = args[3] * 1;
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.moveTo(x, y);
		window.resizeTo(w, h);
        
        //alert("getWindowSize->"+size); //##
	}
}
function putWindowSize(){
	// Picture tool のウインドー位置とサイズをサーバへ記憶
    if (window.name != "tools"){ // tool area で開いた場合はサイズを記憶しない
        // Booking のウインドー位置とサイズをサーバへ記憶
        put_windowSize(0, -22, "pictureToolWindowSize");

        showFadeoutInfo("messageArea", "ウィンドー・サイズを記憶しました", 800);
    }
}

function _setPictureExpand(elm){
    // Picture へマウス・オーバーで画像拡大するかどうかを記憶: gallary.js 用
    window.localStorage["pictureExpand"] = (elm.checked) ? "1" : "0";
    
    // マウス・オーバー再設定のため画像を再描画
    showGalleryPane();
}
function setPictureExpand(elm){
    // Picture へマウス・オーバーで画像拡大するかどうかを記憶
    window.localStorage["pictureExpand"] = (elm.checked) ? "1" : "0";
    
    // マウス・オーバー再設定のため画像を再描画
    getImages();
}
function pictureExpand(){
    var status = window.localStorage["pictureExpand"];
    
    return (status && status * 1) ? 1 : 0;
}

function setConfirmPictureCopy(elm){
    window.localStorage["confirmPictureCopy"] = (elm.checked) ? "1" : "0";
    
    // 再設定のため画像を再描画
    getImages();
}
function confirmPictureCopy(){
    // 画像転記時に確認パネルを表示するかどうかのステータスを返す
    var status = window.localStorage["confirmPictureCopy"];
    return (status) ? status * 1 : 0;
}

/// localStorage による処理 /////////
///////////////////////////////////



///////////////////////////
/// Ajax による処理 /////////

function gotImages(answer){
    var obj = JSON.parse(answer);
    // alert("gotImages->"+encodeObject(obj)); //##
    
    setImagePath(obj.path);
    showIconsVertical(obj.files);
}
function getImages(){
    // 画像ファイルのリストをサーバへリクエスト
    var args = new Object();
    if (paneType() == _patientImageType)
        args["container"] = patientId();
    else if (paneType() == _tempType)
        args["container"] = "tmp";
    else
        return;
    
    _postServer("GET_DIRECTORY", "pictServer.php", args, gotImages);
}

function removeImage(path, filename){
    // filename を削除
    if (! confirm(filename + "　の画像を削除します")){
        return;
    }
    
    var args = new Object();
    if (paneType() == _patientImageType)
        args["container"] = patientId();
    else if (paneType() == _tempType)
        args["container"] = "tmp";
    args["value"] = path + "/" + filename; // 削除する画像ファイルの full path
    
    _postServer("REMOVE_IMAGE", "pictServer.php", args, removedGalleryRow);
}

function savedTemplates(answer){
    console.log("savedTemplates->"+answer); //##
    
    // 保存ボタンを非表示
    toggleSaveButton(false);
    
    // テンプレートを再表示
    if (paneType() == _patientImageType)
        showPatientImagePane();
    else if (paneType() == _galleryType)
        getGallery();
    else if (paneType() == _tempType)
        showTempPane();
}
function saveTemplates(){
    // サーバーへギャラリーのインデックス情報を保存
    var elm = elmFor("uploadArea");
    elm.innerHTML = "";
    var sp = newSPAN(elm, "alertArea");
    sp.innerHTML = "編集結果をサーバへ保存中...";
    
    var array = templates();
    for (num in array){
        var filename = array[num];
        var rec = galleryInfoForName(filename);
        rec.freq = num;
        rec.label = elmFor(filename + ".label").innerHTML;
    }
    console.log("saveTemplates->"+encodeObject(_galleryInfo)); //##
    
    var owner = parent().owner();
    var tag = "PICTURE";
    var item = "GALLERY";
    var value = encodeObject(_galleryInfo);
    put_menu(owner, tag, item , "", value, savedTemplates);
}

function savedImage(answer){
    // 登録された画像を再表示
    //alert("savedImage->"+answer); //##
    
    var can = canvas();
    var ctx = can.getContext("2d");
    
    // キャンバス上の画像を削除
    ctx.clearRect(0, 0, can.width, can.height);
    
    // 保存ボタンを消す
    var bt = elmFor("saveButtonArea");
    if (bt) bt.innerHTML = "";
    
    // サムネイル列を再表示
    if (paneType() == _patientImageType)
        getImages();
    else if (paneType() == _galleryType)
        getGallery();
    else if (paneType() == _tempType)
        showTempPane();
    
    if (_sketchPad) _sketchPad.close();
}
function saveImage(){
    // ドラッグされた画像をサーバへ保存：_patientImageType　_galleryType　両方で使う
    //_initDebug(true); //##
    _debug("saveImage"); //##
    
    if (! patientId()){
        alert("カルテが特定されていません。対象カルテを検索し氏名などを確認してから画像を取り込んでください");
        return;
    }

    var imgSrc = imageSrc();
    _debug("imgSrc->"+imgSrc); //##

    var suffix = null;
    if (imgSrc.indexOf('data:image/png') >= 0){
        imgSrc = imgSrc.replace('data:image/png;base64,',''); // 頭の不要部分を削除
        suffix = "png";
    } else if (imgSrc.indexOf('data:image/jpeg') >= 0){
        imgSrc = imgSrc.replace('data:image/jpeg;base64,',''); // 頭の不要部分を削除
        suffix = "jpeg";
    }
    
    var filename = (suffix) ? todayAndTimeId()+"."+suffix : todayAndTimeId();

    _debug("paneType->"+paneType()); //##
    _debug("filename->"+filename); //##

    if (paneType() == _patientImageType){
        var args = new Object();
        args["patientId"] = patientId();
        args["folder"] = "";
        args["filename"] = filename;
        args["value"] = imgSrc;
        
        NRPost("PUT_IMAGE", args, savedImage);
    } else if (paneType() == _galleryType){
        var args = new Object();
        args["patientId"] = "TEMPLATES";
        args["folder"] = "";
        args["filename"] = filename;
        args["value"] = imgSrc;
        
        NRPost("PUT_IMAGE", args, savedImage);
    } else {
        var args = new Object();
        args["patientId"] = "tmp";
        args["folder"] = "";
        args["filename"] = filename;
        args["value"] = imgSrc;
        
        NRPost("PUT_IMAGE", args, savedImage);
    }
}

/// Ajax による処理 /////////
///////////////////////////

////////////////////////////////////////////////////////////
///// 画像取込ペーン //////////////////////////////////////////

function makeUploadPane(){
    // FORM を使って画像をアップロードするペーンを生成
    setPictureUploadType("1");
    
    var elm = elmFor("uploadSpace");
    elm.innerHTML = "";
    
    if (patientId()){
        var div = newDIV(elm, ""); // FORM は CSS でスペース制御できないので
        div.style.padding = "5px 5px 0 5px";
        // === FORM を生成 =============================
        var fm = newFORM(div, "pictServer.php"); // submit で起動される URL
        fm.setAttribute("id", "uploadForm");
        fm.setAttribute("name", "formForUpload"); // submit に必要
        // ### iframe を使うにはここがキモ ###
        fm.setAttribute("target", "iframeElement"); // iframe を指定
        
        // === ファイル選択ボタン ========================
        var div = newDIV(fm, "file");
        var dv = newDIV(div, "");
        var bt = newUploadBUTTON(dv, "imageFile", "files[]");
        // more FILES
        var dv = newDIV(fm, "");
        dv.style.fontSize = "9pt";
        var a = newA(dv, "ファイルをもうひとつ選択", "#", "");
        a.setAttribute("onclick", "file_append()");
        a.style.fontSize = "9pt";
        
        // === 転送データのコンテナー =====================
        var filename = todayAndTimeId();
        // key
        var fd = newFIELD(fm, "command", "", "", "SAVE_IMAGE");
        fd.setAttribute("NAME", "command"); // form で送られるパラメータ
        fd.setAttribute("type", "hidden");
        // patientId
        var fd = newFIELD(fm, "container", "", "", patientId());
        fd.setAttribute("NAME", "container"); // form で送られるパラメータ
        fd.setAttribute("type", "hidden");
        // imageId
        var fd = newFIELD(fm, "imageId", "", "", filename);
        fd.setAttribute("NAME", "imageId"); // form で送られるパラメータ
        fd.setAttribute("type", "hidden");
        
        // === アップロード・ボタン =======================
        // ### iframe を使うにはここがキモ ###
        // form を見せない形で処理するため submit-button 機能を別に作成
        var dv = newDIV(fm, "");
        dv.style.fontSize = "9pt";
        dv.style.marginBottom = "10px";
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = "画像添付";
        bt.setAttribute("onclick", "upload()");
        
        // === データ戻り先として iframe を作成 ===========
        // ### iframe を使うにはここがキモ ###
        var dv = newDIV(elm, "");
        dv.style.display = "none"; // 表示しない
        var fr = newIFRAME(dv, "iframeElement");
    } else {
        var dv = newDIV(elm, "");
        dv.innerHTML = "カルテを開いてからやり直してください";
        dv.style.color = "#b86125";
        dv.style.fontSize = "9pt";
        dv.style.paddingLeft = "10px";
    }
}

function makeDropPane(){
    // 画像をドロップするペーンを生成
    setPictureUploadType("0");
    
    var elm = elmFor("uploadSpace");
    elm.innerHTML = "";
    
    if (window.File && window.FileReader && window.FileList && window.Blob) {
        // 画像をドロップするエリア
        var div = newDIV(elm, "/clearfix");
        div.style.margin = "5px 5px 0 5px";
        
        // ### dragAndDrop ################
        var width = 250;
        var heght = 50;
        var can = newCANVAS(div, "myCanvas", width, heght, null);
        can.style.backgroundColor = "#ffd";
        setCanvas(can);
        
        // 保存ボタン・エリア
        var sp = newSPAN(div, "saveButtonArea");
        sp.style.paddingLeft = "5px";
        sp.style.position = "relative";
        sp.style.bottom = "7px";
        
        // 文字を描く
        var context = can.getContext("2d");
        context.font = "12px 'Times New Roman'";
        context.fillStyle = "gray";
        context.textAlign = "center"; // width / 2 を中心にする
        context.fillText("ここに画像をドロップ", width / 2, heght / 2 + 6);
        
        can.ondrop=function(e){
            FileDrop(e, can); // patientImage.js
            e.preventDefault();
        };
        
        can.ondragover=function(e){
            e.preventDefault();
        };
    } else {
        alert('このブラウザーでは File API のサポートが不十分です');
    }
}

function openGraffiti(){
    // スケッチ・パネルを開く
    window.open("./graffiti.php","graffiti"
                ,"width=900,height=900,scrollbars=yes,resizable=yes");
}

function makeTabSelector(type){
    // 画像読込選択タブを生成
    var elm = elmFor("uploadArea");
    elm.innerHTML = "";
    
    var tabDiv = newDIV(elm, "/clearfix");
    var dv = newDIV(tabDiv, "/left-side");
    dv.style.width = "100%";
    dv.style.paddingLeft = "0";
    dv.style.fontSize = "9pt";
    dv.style.backgroundColor = "#fff";
    
    // type でタブの状態を切り替える
    setPictureUploadType(type); // type を localStorage へ記憶
    switch (type * 1){
        case 1:
            // 画像読込領域を生成
            var div = newDIV(elm, "uploadSpace");
            div.style.margin = "0 5px";
            div.style.borderRadius = "0 10px 0 0";
            div.style.border = "thin solid #ccc";
            
            var sp = newSPAN(tabDiv, "/gray-tab");
            sp.innerHTML = "ドラッグ・ドロップ";
            sp.setAttribute("onclick", "makeTabSelector('0')");
            var sp = newSPAN(tabDiv, "/white-tab");
            sp.innerHTML = "アップロード";
            var sp = newSPAN(tabDiv, "/gray-tab");
            sp.innerHTML = "スケッチ";
            sp.setAttribute("onclick", "makeTabSelector('2')");
            
            makeUploadPane();
            break;
        case 2:
            var sp = newSPAN(tabDiv, "/gray-tab");
            sp.innerHTML = "ドラッグ・ドロップ";
            sp.setAttribute("onclick", "makeTabSelector('0')");
            var sp = newSPAN(tabDiv, "/gray-tab");
            sp.innerHTML = "アップロード";
            sp.setAttribute("onclick", "makeTabSelector('1')");
            var sp = newSPAN(tabDiv, "/white-tab");
            sp.innerHTML = "スケッチ";
            
            openGraffiti();
            break;
        default:
            // 画像読込領域を生成
            var div = newDIV(elm, "uploadSpace");
            div.style.margin = "0 5px";
            div.style.borderRadius = "0 10px 0 0";
            div.style.border = "thin solid #ccc";
            
            var sp = newSPAN(tabDiv, "/white-tab");
            sp.innerHTML = "ドラッグ・ドロップ";
            var sp = newSPAN(tabDiv, "/gray-tab");
            sp.innerHTML = "アップロード";
            sp.setAttribute("onclick", "makeTabSelector('1')");
            var sp = newSPAN(tabDiv, "/gray-tab");
            sp.innerHTML = "スケッチ";
            sp.setAttribute("onclick", "makeTabSelector('2')");
            
            makeDropPane();
            break;
    }
}

function showPatientImagePane(){
    // ペーン選択タブを生成し 画像読込タブを選択
    setPaneType(_patientImageType);
    
    var elm = elmFor("tabArea");
    elm.innerHTML = "";
    // --- ペーン選択タブ
    var div = newDIV(elm, "/left-side");
    div.style.width = "80%";
    div.style.paddingLeft = "0";
    div.style.fontSize = "9pt";
    var sp = newSPAN(div, "/white-tab");
    sp.innerHTML = "カルテ";
    var sp = newSPAN(div, "/gray-tab");
    sp.innerHTML = "図譜";
    sp.setAttribute("onclick", "showGalleryPane()");
    var sp = newSPAN(div, "/gray-tab");
    sp.innerHTML = "臨時";
    sp.setAttribute("onclick", "showTempPane()");
    // --- ヘルプ・アイコン
    var dv = newDIV(elm, "/right-side");
    var im = newIMAGE(dv, "helpB", "./help.png", "?");
    im.setAttribute("onclick", "help()");
    im.style.height = "18px";
    im.style.position = "relative";
    im.style.top = "6px";
    im.setAttribute("class", "expandIcon");
    
    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    // 画像読込エリア ==========================
    var dv = newDIV(elm, "uploadArea");
    // === サムネイル画像行を生成 ===============
    var div = newDIV(elm, "thumbNailRow");
    
    // 画像読込選択タブ
    makeTabSelector(pictureUploadType());
    
    // サムネイルを読み込む
    getImages();
}

///// 画像取込ペーン //////////////////////////////////////////
////////////////////////////////////////////////////////////


function open_image(url){
    // 本文中の Image をクリックした時に呼ばれる
	var win = window.open("imageViewer.php?value=" + url, "ImageViewer"
                          ,"width=1700,height=1700,scrollbars=yes,resizable=yes");
	win.focus();
}

function pastePicture(elm){
    // 画像を所見欄に貼り付ける    
    var filename = inner_text(elm); // FireFox 対策
    if (confirmPictureCopy() > 0){
        if (!confirm(filename + " を所見欄へ貼付しますか")) return;
    }

    var tag = "ProgressSection.object";
    var rec = parent().valueForTag(tag);
    var val = (rec) ? rec.value : "";
    var url = "<IMG:" + imagePath() + "/" + filename + ">";
    
    val = (trim(val).length == 0) ? url : val + url;
    
    // 画像を所見欄へ添付
    parent().addValueFromTool(val, "ProgressSection.object");
    return; //###
    
    // 画像を所見欄へ添付し save
    parent().gotValueFromTool(val, true);
}

function makeThumbnail(ul, path, file){
    // サムネイルを生成して返す
    var url = path + "/" + file;
    var sfx = suffix(file);
    var width = thumbNailSize();
    
    if ((sfx == "pdf") || (sfx == "PDF")){
        var img = "<IMG SRC=pdf.jpg width=" + width + ">";
    } else if (isImageFile(url)){
        var img = "<IMG SRC="+url+" width=" + width + ">";
    } else if (isMovieFile(url)){
        var img = "<IMG SRC=movie.jpg width=" + width + ">";
    } else if (sfx == "zip"){
        var img = "<IMG SRC=zip.png width=" + width + ">";
    } else if (sfx == "txt"){
        var img = "<IMG SRC=text.png width=" + width + ">";
    } else {
        var img = "<IMG SRC=file.png width=" + width + ">";
    }
    return img;
}

function help(){
    // ヘルプを開く
    switch (paneType()){
        case _patientImageType: 
            window.open("./pictureHelp.html","Help"
                        ,"width=450,height=700,scrollbars=yes,resizable=yes");
            break;
        case _galleryType: 
            window.open("./galleryHelp.html","Help"
                        ,"width=450,height=700,scrollbars=yes,resizable=yes");
            break;
        case _tempType: 
            window.open("./temporallyHelp.html","Help"
                        ,"width=450,height=700,scrollbars=yes,resizable=yes");
            break;
    }
}

function initPicture(){
	// テンプレートで FRONT のヘッダー部分を生成
    var elm = elmFor("base");
	elm.innerHTML = "";

    // ===== UPLOAD AREA ==============
    var div = newDIV(elm, "uploadArea");
    // ===== HEADER ===================
    var div = newDIV(elm, "/tool-header");
    // === LEFT SIDE ===
    var dv = newDIV(div, "/left-side");
	dv.style.position = "/relative";
	dv.style.top = "4px";
	// カルテID・氏名
    var pid = "";
    var name = "";
    if (patientId()){
        pid = patientId();
        name = patientName();
    }
    var sp = newSPAN(dv, "patientIdArea");
    sp.innerHTML = pid;
    sp.style.paddingLeft = "10px";
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "5px";
    sp.innerHTML = name;
    // === RIGHT SIDE ===
    var dv = newDIV(div, "/right-side");
    // --- サムネイル・サイズ変更
    var sp = newSPAN(dv, "");
    sp.innerHTML = "サムネイル";
    sp.style.fontSize = "9pt";
    sp.style.color = "#888";
    var sp = newSPAN(dv, "");
    sp.style.paddingRIght = "5px";
    var array = ["大","中","小"];
    var pm = newPopupMenu(sp, "", array, thumbNailSizeName());
    pm.setAttribute("onchange", "setThumbnailSize(this)");
    pm.style.position = "relative";
    pm.style.bottom = "2px";
    
    // 読込・図譜 選択エリア ================================
    var div = newDIV(elm, "tabArea/clearfix");
    div.style.backgroundColor = "#caecdc";

    var div = newDIV(elm, "contentsArea");
    div.style.fontSize = "9pt";
    div.style.backgroundColor = "#caecdc";

    showPatientImagePane(); // 画像添付ペーンを表示

    // FOOTER ===================================
    var div = newDIV(elm, "/tool-footer");
    div.style.marginTop = "5px";
    // LEFT SIDE ----------------------------
    var dv = newDIV(div, "/left-side");
    if (window.name != "iframe"){
        var sp = newSPAN(dv, "patientIdArea");
        sp.style.paddingRight = "10px";
        var im = newIMAGE(sp, "zoomIcon", "./zoom.png", "?");
        im.setAttribute("onclick", "putWindowSize()");
        im.style.height = "14px";
        im.style.position = "relative";
        im.style.top = "2px";
        im.setAttribute("class", "expandIcon");
        setInfoTip("zoomIcon", "画面サイズと位置を記憶"); // HELP
    }
    // RIGHT SIDE ----------------------------
    var dv = newDIV(div, "/right-side");
    var sp = newSPAN(dv, "/versionArea");
    sp.innerHTML = version();

    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "画像読込ツール";

    getWindowSize();
}

function version(){
	return "Ver.150308";
}


