

var _records; // Global 変数

function setRecords(obj){
	_records = obj;
}
function records(){
	return _records;
}
function recordForPatientId(pid){
	// pid に対応するレコードを返す
	var count = _records.length;
	for (var r=0; r < count; r++){
		var rec = _records[r];
		if (isSame(rec.patientId, pid))
			return rec;
	}
	return null;
}


////////////////////////////////
/// neuron.js による処理 /////////

function getPatientList(answer){
	// キーに一致したレコードをサーバから読込み
    //alert("getPatientList->"+answer); //##
    
	var elm = document.getElementById("contentsArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
	var tr = newTR(tbl, "/yellow-bar", "");
	var td = newTD(tr, "/label-center", "カルテ ID");
	var td = newTD(tr, "/label-center", "氏名");
	var td = newTD(tr, "/label-center", "ふりがな");
	var td = newTD(tr, "/label-center", "最終受診日");
	var td = newTD(tr, "/label-center", "更新日");
	
	var records = JSON.parse(answer);
	setRecords(records);
	var count = records.length;
	for (var r=0; r < count; r++){
		var rec = records[r];
		var tr = newTR(tbl, "/record", "");
		var patientId = rec.patientId;
		var td = newTD(tr, "", patientId);
		var td = newTD(tr, "", rec.patientKanjiName);
		var td = newTD(tr, "", rec.patientKanaName);
		var td = newTD(tr, "", rec.lastVisitDate);
		var td = newTD(tr, "", rec.updateTime);
		var action = "getTableRecords('" + patientId + "')";
		tr.setAttribute("onclick", action);
        setChangeColor(tr, "#000", "#fff");
	}
}
function showPatientList(key){
	// 検索キーにマッチしたカルテのリストを表示
	if (key.length == 0) return;

    get_patients(key, getPatientList); // サーバでアクセス・ログに記憶
}

function showTableRecords(answer){
	// 各テーブルに存在する patientId のレコード数を表示
    var obj = JSON.parse(answer);
    //alert("== showTableRecords->"+encodeObject(obj)); //##
    
	showPatient(obj);
}
function getTableRecords(patientId){
	// 各テーブルに存在する patientId のレコード数をリクエスト
    var args = new Object();
	args["patientId"] = patientId;
    NRCall("GET_TABLE_RECORDS", args, showTableRecords);
}

function removedTableRecords(answer){
	// 各テーブルに存在する patientId のレコード数を表示
	var patientId = answer;
	getTableRecords(patientId);
}
function removeTableData(table, patientId){
	// テーブルから patientId のデータの削除をサーバへリクエスト
	var name = (isSame(table, "ALL")) ? "すべてのテーブル" : table;
	var st = name +" から " + patientId + " のデータを全て削除していいですか？";
	if (confirm(st)){
        var args = new Object();
        args["table"] = table;
        args["patientId"] = patientId;
        
        NRCall("REMOVE_TABLE_RECORDS", args, removedTableRecords);
	}
}

/// neuron.js による処理 /////////
////////////////////////////////



function search(){
	var pid = document.getElementById("patientId").value;
	showPatientList(pid);
}

function showPatient(tableInfo){
	// サーバから返された JSON 形式の arguments から各テーブルごとのレコード数を得る
	var elm = document.getElementById("contentsArea");
	elm.innerHTML = "";

	var patientId = tableInfo.patientId;
	var rec = recordForPatientId(patientId);
	if (rec == null) return;
    
	if (tableInfo.sum * 1 == 0){
        var div = newDIV(elm, "");
        div.style.margin = "5px 10px";
        var sp = newSPAN(div, "");
        sp.style.padding = "5px 0";
		sp.style.color = "#f55";
        sp.innerHTML = patientId + " のレコードは全て削除されました";
		return;
	}
	
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
    tbl.style.margin = "10px 0";

	var tr = newTR(tbl, "/yellow-bar", "");
	var td = newTD(tr, "/label-center", "カルテ ID");
	var td = newTD(tr, "/label-center", "氏名");
	var td = newTD(tr, "/label-center", "ふりがな");
	var td = newTD(tr, "/label-center", "最終受診日");
	var td = newTD(tr, "/label-center", "更新日");
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "label-left", rec.patientId);
	var td = newTD(tr, "label-left", rec.patientKanjiName);
	var td = newTD(tr, "label-left", rec.patientKanaName);
	var td = newTD(tr, "label-left", rec.lastVisitDate);
	var td = newTD(tr, "", rec.updateTime);
	
	var tr = newTR(tbl, "/yellow-bar", "");
	var td = newTD(tr, "label-left", "このカルテID のデータの部分削除");
	td.setAttribute("colspan", "2");
	var td = newTD(tr, "label-left", "＊ 以下の処理は元へ戻せませんので慎重に行ってください");
    td.style.color = "red";
	td.setAttribute("colspan", "3");
	
	setLine(tbl, "NameSection", tableInfo);
	setLine(tbl, "AddressSection", tableInfo);
	setLine(tbl, "BasicSection", tableInfo);
	setLine(tbl, "MalitalSection", tableInfo);
	setLine(tbl, "HealthInsurance", tableInfo);
	setLine(tbl, "PublicInsurance", tableInfo);
	setLine(tbl, "ProgressSection", tableInfo);
	setLine(tbl, "UniversalSection", tableInfo);
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "label-left", "PatientTable");
	var td = newTD(tr, "label-left", tableInfo["PatientTable"] + " records");
	var td = newTD(tr, "label-left", "以下の「一括削除」を行った時のみ削除されます");
    td.style.fontSize = "10pt";
	td.setAttribute("colspan", "3");
	
	var tr = newTR(tbl, "/yellow-footerr", "");
	var td = newTD(tr, "label-left", "このカルテID のデータの一括削除");
	td.setAttribute("colspan", "2");
	var td = newTD(tr, "label-left", "");
	td.setAttribute("colspan", "3");
    var bt = newDIV(td, "/fixButton");
    bt.innerHTML = "すべてのテーブルから "+patientId+" のレコードを一括削除";
	var action = "removeTableData('ALL','"+patientId+"')";
	bt.setAttribute("onclick", action);
    bt.style.padding = "5px 10px";
	
	function setLine(tbl, tableName, tableInfo){
		var patientId = tableInfo.patientId;
		
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "label-left", tableName);
		var td = newTD(tr, "label-left", tableInfo[tableName] + " records");
		var td = newTD(tr, "label-left", "");
		td.setAttribute("colspan", "3");
		var bt = newDIV(td, "/whiteButton");
		bt.innerHTML = tableName+" から "+patientId+" のレコードをすべて削除";
		var action = "removeTableData('"+tableName+"','"+patientId+"')";
		bt.setAttribute("onclick", action);
        bt.style.padding = "3px 10px";
	}
}

function initRemoveTable(){
    // カルテ削除ツールを生成
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // === HEADER ==================================
    var div = newDIV(elm, "/yellow-header");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = "カルテ削除";
    
	// search area
    var div = newDIV(elm, "/yellow-body");
    div.style.padding = "5px 10px";
    div.innerHTML = "検索キー（ カルテID または ローマ字） ";
	var fd = newFIELD(div, "patientId", "", 15, "");
	fd.setAttribute("onchange", "search()");
	fd.focus();

    // contents area
    var div = newDIV(elm, "contentsArea");

    // === FOOTER ==================================
    var div = newDIV(elm, "/yellow-footer");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = version();
}

function version(){
	return "Ver.130914";
}

