
function code(){
	return document.getElementById("_code").value;
}

function name(){
	return document.getElementById("_name").value;
}

var _records;
function setRecords(array){
	// 読込まれたレコードを記憶
	_records = array;
}
function records(){
	return _records;
}
function recordAtIndex(num){
	return _records[num];
}

///////////////////////////
/// Ajax による処理 /////////

function searched(answer){
    var objects = JSON.parse(answer);
    setRecords(objects);
    showResult(objects);
}
function search(){
	// グローバル辞書パネル：検索キーによりデータを検索
	var code = document.getElementById("codeF").value;
	var name = document.getElementById("nameF").value;
	
	if (code.length + name.length == 0){
		alert("検索キーが指定されていません");
		return;
	}
	
    var args = new Object();
    args["code"] = code;
    args["name"] = name;
    
    _callServer("GET_GLOBAL_PRICE", "sysServer.php", args, searched);
}

/// Ajax による処理 /////////
///////////////////////////


function putPriceList(buff){
	// PriceList にレコードを返す
	window.close();
	window.opener.getGlobal(buff);
}

function clickedRow(row){
	// row 行のレコードを返送するかどうか確認パネル
	var obj = recordAtIndex(row);
	//alert(encodeObject(obj)); //##
    
    var w = 400;
	var x = 10; // 表示するx座標
	var y = 30; // 表示するy座標
    var elm = openSeeThroughPanel("_confirm", x, y, w, "確認パネル");
    if (!elm){
        alert("_confirm がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "8px";
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "base-table");
    tbl.style.fontSize = "10pt";
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "/yellow-label", "コード");
	// obj.code はグローバル辞書では長いものなので検索に使われたものに変更
	obj.code = document.getElementById("codeF").value;
	var td = newTD(tr, "/white-label", obj.code);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "/yellow-label", "請求コード");
	var td = newTD(tr, "/white-label", obj.requestCode);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "/yellow-label", "名称");
	var td = newTD(tr, "/white-label", obj.name);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "/yellow-label", "点数");
	var td = newTD(tr, "/white-label", obj.point);
	
	if (obj.unitName){
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "/yellow-label", "単位");
		var td = newTD(tr, "/white-label", obj.unitName);
	}
	
	if (obj.effectCode){
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "/yellow-label", "薬効コード");
		var td = newTD(tr, "/white-label", obj.effectCode);
	}
	
	if (obj.handanCode && obj.handanCode * 1){
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "/yellow-label", "判断料");
		// handanCode から handan を生成
		obj.handan = handan(obj.handanCode);
		var td = newTD(tr, "/white-label", obj.handan);
	}

	var tr = newTR(tbl, "", " ");
	var td = newTD(tr, "", "このレコードを PriceList へ ");
	td.style.textAlign = "right-side";
	td.style.color = "#930";
	var bt = newBUTTON(td, "", "転記");
	var action = "putPriceList('" + encodeObject(obj) + "')"
	bt.setAttribute("onclick", action);
	
	function handan(code){
		// handanCode から判断料を返す
		switch (code * 1){
			case 1: return "尿";
			case 2: return "血";
			case 3: return "生1";
			case 4: return "生2";
			case 5: return "免";
			case 6: return "微";
			case 7: return "病";
			default: return "";
		}
	}
}

function showResult(array){
    // グローバル辞書の検索結果をリスト表示
	var elm = document.getElementById("globalListArea");
	elm.innerHTML = "";
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
	
	// title
	var tr = newTR(tbl, "", "");
	tr.style.backgroundColor = "#6c9";
	var td = newTD(tr, "", "code");
    td.style.paddingLeft = "10px";
	var td = newTD(tr, "", "requestCode");
	var td = newTD(tr, "", "name");
	var td = newTD(tr, "", "point");
	var td = newTD(tr, "", "unitName");
	//var td = newTD(tr, "", "handan");
    
    //alert("showResult->"+encodeObject(array)); //##
	
	// records
    for (i in array){
		var obj = array[i];
		var tr = newTR(tbl, "/record", "");
		var action = "clickedRow('"+i+"')";
		tr.setAttribute("onclick", action);
		
		var td = newTD(tr, "", obj.code);
        td.style.paddingLeft = "10px";
		var td = newTD(tr, "", obj.requestCode);
		var td = newTD(tr, "", obj.name);
		var td = newTD(tr, "", obj.point);
		var td = newTD(tr, "", obj.unitName);
		//var td = newTD(tr, "", obj.handanCode);
	}
}

function openGlobalPanel(elm, code, name){
    // elm 内にグローバル辞書パネルを表示
    elm.innerHTML = "";
    
    // HEADER =============================
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "100%";
	var fd = newFIELD(dv, "codeF", "code ", 10, code);
	var fd = newFIELD(dv, "nameF", " name ", 20, name);
	fd.setAttribute("onchange","search()");
	var bt = newBUTTON(dv, "", "検索");
	bt.setAttribute("onclick","search()");
    
	// レコード表示エリア ====================
    var div = newDIV(elm, "globalListArea");
    div.style.backgroundColor = "#fff";
    
	// FOOTER =============================
    var div = newDIV(elm, "/tool-footer");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = version();
}

function initGlobal(){
	// PriceListGlobal からレコードを選択するパネルを表示
	var elm = document.getElementById("base");
    openGlobalPanel(elm, code(), name());
}

