/////////////////////////////////
///// リンク・セル ////////////////

var _links;
function linkObj(){
    // リンク情報を記憶するオブジェクト
    if (!_links) _links = new Object();
    return _links;
}
function setLinkObj(value){
    // 文字列 value から _links を生成
    value = trim(value);
    if (value.length > 0){
        _links = decodeObject(value);
    }
}
function linkForLabel(label){
    // label に対応するリンク：カルテID を返す
    return _links[label];
}

function setLink(){
    // 編集されたリンクを記憶・表示
    var label = elmFor("labelF").value;
    var link = elmFor("linkF").value;
    
    if (label.length * link.length > 0){
        var obj = linkObj();
        obj[label] = link;
        // 入力欄（hide）に _links を記録
        var dv = elmFor(currentTag() + ".value");
        dv.innerHTML = encodeObject(linkObj());
        // リンク・レコードを表示
        showLinks();
        // 編集パネルを閉じる
        closeFloatPanel();
    } else {
        alert("空欄のままでは登録できません");
    }
}
function removeLink(label){
    // リンク名：label のリンクを削除
    delete _links[label];
    // 入力欄（hide）に _links を記録
    var dv = elmFor(currentTag() + ".value");
    dv.innerHTML = encodeObject(linkObj());
    // リンク・レコードを表示
    showLinks();
    // 編集パネルを閉じる
    closeFloatPanel();
}

function openLinkPanel(label){
    // リンク編集パネルを開く
    var elm = elmFor("addButtonArea");
    var pos = getPosition(elm);
    
    var w = 280;
    var x = pos.x; // 表示するx座標
    var y = pos.y; // 表示するy座標
    var title = "リンク情報の編集";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title);
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "8px";
    elm.style.color = "#f55";
    var tbl = newTABLE(elm, "/base-table");
    var tr = newTR(tbl, "", "");
    // リンク名
    var td = newTD(tr, "", "");
    if (label){
        var fd = newFIELD(td, "labelF", "", 10, label);
    } else {
        var fd = newFIELD(td, "labelF", "", 10, "");
        fd.setAttribute("placeholder", "リンク名"); // 入力ヒントを表示
    }
    fd.focus();
    // カルテID
    var td = newTD(tr, "", "");
    if (label){
        var fd = newFIELD(td, "linkF", "", 10, linkForLabel(label), "number");
    } else {
        var fd = newFIELD(td, "linkF", "", 10, "", "number");
        fd.setAttribute("placeholder", "カルテID"); // 入力ヒントを表示
        fd.setAttribute("onchange", "setLink()");
    }
    // 確定ボタン
    var td = newTD(tr, "", "");
    var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "setLink()");
}

function showLinks(){
    // リンクオブジェクトの行を表示
    var elm = elmFor("linkEditorArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
    
    var records = linkObj();
    //console.log("showLinks", encodeObject(records)); //##
    
    for (label in records){
        var link = records[label];
        var tr = newTR(tbl, "/row", "");
        // リンク名
        var td = newTD(tr, "", label);
        td.style.paddingLeft = "5px";
        td.setAttribute("onclick", "openLinkPanel('" + label + "')");
        // リンク先
        var td = newTD(tr, "", link);
        td.setAttribute("onclick", "openLinkPanel('" + label + "')");
        // 削除アイコン
        var td = newTD(tr, "", "");
        var img = newIMAGE(td, "", "./remove-field.png", "-");
        img.style.height = "12px";
        img.setAttribute("class", "expandIcon");
        img.setAttribute("onclick", "removeLink('" + label + "')");
    }
}

function openLinkedChart(patientId){
    // patientId のカルテを開く
    window.open("/NOA/top.php?patientId=" + patientId);
}
function showLinkView(fid, value){
    // fid のエレメントにリンク情報をクリックできる形式で表示
    value = trim(value);
    if (value.length == 0){
        return;
    }
    
    var obj = decodeObject(value);
    var elm = elmFor(fid);
    elm.innerHTML = "";
    for (label in obj){
        var bt = newDIV(elm, "/blueButton");
        bt.innerHTML = label;
        bt.style.marginRight = "5px";
        var pid = obj[label];
        bt.setAttribute("onclick", "openLinkedChart('" + pid + "')");
    }
}

function linkBoxChanged(elm, tag){
    // 「入力欄を表示」チェックボックスがクリックされた
    setShowLinkField(elm);
    
    // 入力欄を再表示
    var dv = elmFor(tag + ".value");
    dv.style.display = (showLinkField()) ? "block" : "none"; // 入力欄を見えなくする：hide
}

function linkHelp(){
    openHelp("./linkHelp.html");
}

function openLinkEditor(tag, cell){
    // LINK CELL 編集欄を生成
    //console.log("== openLinkEditor", tag, cell.editorIsOpen); //##
    if (cell.editorIsOpen){ // 自分自身のエディターが開いている：保存して終了
        closeCellEditor('needSave'); // cell.editorIsOpen の status が変わる
        setCurrentTag(null); // closeCellEditor() でやるとタイミングによっては不整合発生
        return;
    } else { // 他に開いているエディターがあれば閉じる
        closeCellEditor('needSave');
    }
    
    if (cell) cell.editorIsOpen = true; // CELL のエディターが開いていることを記憶
    setCurrentTag(tag); // 編集中の CELL を記憶
    
    // CellEditor を開いた時、現在開いているツールを全て折り畳む
    tools().foldAllTools(cell.label);
    
    var elm = valueElementForTag(currentDate(), tag);
    elm.innerHTML = "";
    
    var div = newDIV(elm, tag + ".editorArea/editorArea");
    var obj = valueForTag(tag, currentDate());
    var val = (obj && obj.value) ? obj.value : "";
    
    // Agent データ・オブジェクトに値を記憶
    var agt = agent();
    agt.tag = tag;
    agt.cellValue = val;
    agt.cell = encodeObject(cell);
    setAgent(agt);
    
    // 入力欄 ==============================
    var dv = newDIV(div, tag + ".value");
    dv.setAttribute("class", "editorValue");
    dv.innerHTML = htmlForValue(val);
    dv.style.display = (showLinkField()) ? "brock" : "none"; // 入力欄を見えなくする：hide
    setBeforEdit(dv.innerHTML); // 編集前のエディター内容を記憶
    cell.originalValue = dv.innerText; // 編集前の表現形を CELL に記憶
    dv.contentEditable = true; // TEXT を編集可能状態にする
    setLinkObj(val); // val をデコードし linkObj() を生成
    
    // リンク入力・エリア ======================
    var dv = newDIV(div, "linkEditorArea");
    dv.style.border = "thin solid #ddd";
    showLinks();
    // 新規リンク追加ボタン
    var dv = newDIV(div, "addButtonArea");
    dv.style.margin = "3px 0 3px 0";
    dv.style.fontSize = "9pt";
    var img = newIMAGE(dv, "", "./add-field.png", "+");
    img.style.marginLeft = "11px";
    img.style.height = "12px";
    img.setAttribute("class", "expandIcon");
    img.setAttribute("onclick", "openLinkPanel()");
    var bt = newUL(dv, "/listMember");
    bt.innerHTML = "新規リンク";
    bt.setAttribute("onclick", "openLinkPanel()");
    bt.style.position = "relative";
    bt.style.bottom = "2px";
    // 入力欄表示チェックボックス
    var cb = newCHECKBOX(dv, "", "入力欄を表示", showLinkField());
    cb.setAttribute("onchange", "linkBoxChanged(this, '" + tag + "')");
  
    // FOOTER ===========================
    var pdv = newDIV(div, "/cellEditorPanel");
    var dv = newDIV(pdv, "/clearfix");
    // LEFT ----------------
    var left = newDIV(dv, "/left-side");
    left.style.paddingLeft = "5px";
    left.style.fontSize = "9pt";
    left.style.width = "120px";
    //left.style.border = "thin solid #f00"; //####
    // basicPage の場合は CELL 巾が小さいのでサイズを調整
    var isBasicPage = false;
    // HELP ICON
    var sp = newSPAN(left, "helpTip");
    setInfoTip("helpTip", "HELP"); // HELP
    sp.style.paddingRight = "10px";
    var img = newIMAGE(sp, "", "./help.png", "?");
    img.style.height = "15px";
    img.setAttribute("onclick", "linkHelp()");
    img.setAttribute("class", "expandIcon");
    // 透過 ICON
    var sp = newSPAN(left, "clearFieldTip");
    sp.style.paddingRight = "6px";
    setInfoTip("clearFieldTip", "前回記述が透けて見えるようにする"); // HELP
    var img = newIMAGE(sp, "", "./selection.png", "X");
    img.style.height = "13px";
    img.setAttribute("onclick", "clearValue('" + tag + "')");
    img.setAttribute("class", "expandIcon");
    
    // RIGHT ----------------
    var right = newDIV(dv, "/right-side");
    right.style.paddingRight = "0";
    // 保存ボタン
    var bt = newDIV(right, "/whiteButton");
    bt.innerHTML = "とりやめ";
    var action = "closeEditorAndShowValue('" + tag + "','close')";
    bt.setAttribute("onclick", action);
    var bt = newDIV(right, "/fixButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "jumpToNext('" + tag + "')");
}

///// リンク・セル ////////////////
/////////////////////////////////
