

/////////////////////////////////////////////////
///// GROUP_TEMPLATE ////////////////////////////

var _templateTag = "GROUP_TEMPLATE";
var _groupTemplates;

function setTemplateMenu(array){
    // NOA スタートアップで読み込まれる
    _groupTemplates = array;
}
function setGroupTemplates(answer){
    // メニュー編集後に再読込
    _groupTemplates = JSON.parse(answer);
    _debug("setGroupTemplates->"+encodeObject(_groupTemplates));
    
    showTemplateMenu();
}
function groupTemplates(){
    // テンプレートの配列を返す
    return _groupTemplates;
}
function groupTemplateObjectForTitle(title){
    // title に対応するテンプレート・オブジェクトを返す
    for (num in _groupTemplates){
        var obj = _groupTemplates[num];
        if (title == obj.menu)
            return obj;
    }
    return null;
}

function addGroupTemplate(){
	// テンプレート規定値を追加
    var title = window.prompt("この入力値セットのタイトルをつけてください", "");
    if (!title) return;
    
    // メニューに対応するオブジェクトに各欄の値を入れ、それを save する
    var obj = new Object();
    var array = layoutForMode(_progress_);
    for (num in array){
        var layoutObj = array[num];
        
        // 非表示セルはスキップ
        if (layoutObj.hitAndRun * 1) continue;

        var cell = cellForTag(layoutObj.tag);
        var rec = valueForTag(cell.tag, currentDate());
        var value = (rec && rec.value) ? rec.value : "";
        var isPast = (rec && rec.isPast) ? true : false;

        //_debug(layoutObj.label+"->"+isPast+"->"+value); //###
        
        // 過去が透けて見えるセルは空データとする
        if (isPast) value = "";
        if (cell) obj[cell.tag] = value;
    }
    //_debug("addGroupTemplate->"+encodeObject(obj)); //##
    
    var val = encodeSTRING(encodeObject(obj));
    put_menu(owner(), _templateTag, title, "", val, setGroupTemplates);
}
function removeGroupTemplate(label){
    // label に対応するメニューを削除
    if (confirm("「" + label + "」メニューを削除します")){
        remove_menu(owner(), _templateTag, label, null, setGroupTemplates);
    }
}

function redrawChart(answer){
    _debug("redrawChart->"+answer); //##
    
    closeFloatPanel();
    
    // カルテを再表示
    openChart(patientId());
}
function selectTemplateMenu(elm){
    // テンプレート・メニューが選択された結果を受けカルテを再表示
    //_initDebug(true); //##
    
    var title = elm.innerText; // innerText では改行が削除されるがここでは問題ない
    
    if (title == "...その他"){
        addGroupTemplate();
    } else {
        if (isReadOnly()){
            // readOnly モードなら警告パネルを開くだけで終了
            if (!confirm("過去カルテですが実行していいですか")) return;
        }
        
        // 選択されたテンプレートで各フィールドを上書きする
        var rec = groupTemplateObjectForTitle(title);
        if (rec){
            _debug("== selectTemplateMenu =="); //##
            
            // 選択されたメニュー内容で各欄を上書きする
            var obj = decodeObject(rec.value);
            // 各欄の value 中の '(',')' が表示時 object に展開されないよう encode
            var rec = new Object();
            for (tag in obj){
                var val = obj[tag];
                if (typeof(val) == "object"){
                    val = encodeObject(val); // object を文字列にする
                    val = encodeValue(val); // '(',')' を encode
                }
                val = transferToCR(val); // HTML 改行を全て "\n" に変換
                rec[tag] = val;
            }
            _debug("owner->"+owner()); //##
            _debug("patientId->"+patientId()); //##
            _debug("currentDate->"+currentDate()); //##
            _debug("timeLimit->"+timeLimit()); //##
            _debug("rec->"+encodeObject(rec)); //##
            
            put_page(owner(), patientId(), currentDate(), timeLimit(), rec, redrawChart);
        } else {
            alert(title + " に対応するメニュー・オブジェクトがありません");
        }
    }
}

function showTemplateMenu(){
    // テンプレート・パネルにメニューを表示
    var array = groupTemplates();
    //alert("showTemplateMenu->"+array); //##
    
    // groupTemplates() のコピーを生成して "...その他" を追加
    var templates = new Array();
    templates = templates.concat(array);
    var rec = new Object();
    rec.menu = "...その他";
    templates.push(rec);
    
    //alert("showTemplateMenu->"+encodeObject(templates)); //##
    
    var elm = document.getElementById("groupTemplateMenuArea");
    if (!elm) return; // Group CELL 編集モードではない場合
    
    elm.innerHTML = "";
    elm.style.padding = "5px 2px 0 5px";
    elm.style.fontSize = "9pt";
    
    for (num in templates){
        var rec = templates[num];
        var div = newDIV(elm, "/clearfix");
        // --- LEFT ---
        var dv = newDIV(div, "/left-side");
        dv.style.padding = "2px 0px";
        dv.style.width = "80%";
        var bt = newDIV(dv, "/blueButton");
        bt.innerHTML = rec.menu;
        bt.setAttribute("onclick", "selectTemplateMenu(this)");
        // --- RIGHT ---
        var dv = newDIV(div, "/right-side");
        dv.style.padding = "2px 0px";
        if (num < templates.length - 1){
            var img = newIMAGE(dv, "icon", "./remove-field.png", "X");
            var act = "removeGroupTemplate('" + rec.menu + "')";
            img.setAttribute("onclick", act);
        }
    }
}

function gotTemplateMenus(answer){
    // グループ・テンプレートをサーバから読み込む
    //alert("gotTemplateMenus->"+answer); //##
    var array = JSON.parse(answer);
    setTemplateMenu(array);
    
    showTemplateMenu();
}
function showGroupTemplatePanel(button, title, helpAction){
    // テンプレートを各欄に挿入
    var pos = getPosition(button);
    var w = 150;
	var x = pos.x - w + 10; // 表示するx座標
	var y = pos.y; // 表示するy座標
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, helpAction);
    var div = newDIV(elm, "groupTemplateMenuArea");
    
    if (_groupTemplates){
        showTemplateMenu();
    } else {
        // グループ・テンプレートをサーバから読み込む
        var args = new Object();
        args["owner"] = owner();
        NRCall("GET_MENU_TEMPLATE", args, gotTemplateMenus);
    }
}

///// GROUP_TEMPLATE ////////////////////////////
/////////////////////////////////////////////////

