<?php
    
	define('FPDF_FONTPATH','/Applications/MAMP/htdocs/FPDF/fpdf153/font/');
	require('../FPDF/fpdf153/mbfpdf.php');
	require("_printLib.php");
	
	class _MBFPDF extends MBFPDF
	{
		// MBFPDF ̃TuNXƂ _MBFPDF 錾
        // Header() Footer() JX^}CYĉŏs߂ɕKv
        
        function Header(){
			$headerTopMargin = 15;
			$headerLeftMargin = 10;
			$innerMargin = 8;
			$headerHeight = 18;
			$headerWidth = 160;
            
			// tHgw
			$this->SetFont(KOZMIN,'B', 14);
            
            // docMaker.js 瑗ꂽ JSON IuWFNg decode 
            // class Oŏ $obj FȂ̂łŏ
            $value = $_GET['value']; $value = stripslashes($value);
            $value = decodeSTRING($value);
            $obj = json_decode($value, true);
            
			// ^Cg 'fÏ񋟏'
			$x = $headerLeftMargin;
			$y = 2;
			$this->SetXY($x, $y);
			$this->Cell($headerWidth,5,convert($obj,'documentName'),0,0,'C');
            
			// 
			$x += $innerMargin;
			$y += 15;
			$this->SetFont(KOZMIN,'B', 12);
			$this->SetXY($x, $y);
			$this->Cell($headerWidth, 5,convert($obj,'addressee'), 0, 0, 'L');
            
			// N
			$this->SetFont(KOZMIN,'B', 10);
			$this->SetXY($x, $y);
			$this->Cell($headerWidth-15, 5,convert($obj,'timestamp'),0,0,'R');
            
			// RecLqg`
			$x = $headerLeftMargin;
			$y += 10;
			$this->Rect($x, $y, $headerWidth, 200);
            
            $hasPatientInfo = (strlen($obj['hasPatientInfo']) > 0) ? TRUE : FALSE;
            if (($this->PageNo() == 1) && $hasPatientInfo){
				// sṽy[WQy[Wڈȍ~ł͂̃wb_[͕\Ȃ
                
				// A
				$x += $innerMargin;
				$y += 5;
				$this->SetXY($x, $y);
                $name = convert($obj,'patientName');
                $sex = convert($obj,'sex');
                $st = "F $name l ( $sex )";
                $this->Cell($headerWidth, 5, $st, 0, 0,'L');
                
				// N߁EN
				$rightX = $headerLeftMargin+$headerWidth/2+14;
				$this->SetFont(KOZMIN,'B', 10);
				$this->SetXY($rightX, $y);
                $age = $obj['age'];
                $birthDate = $obj['birthDate'];
                $st = "N߁F$age  ( $birthDate  )";
				$this->Cell($headerWidth, 5, $st, 0, 0, 'L');
                
				// Z
				$y += 6;
				$this->SetXY($x, $y);
                $patientAddress = convert($obj,'patientAddress');
                $st = "ZF$patientAddress";
                $this->MultiCell(85, 5, $st, 0, 'L');
				
				// db
				$this->SetXY($rightX, $y);
                $patientPhone = convert($obj,'patientPhone');
                $st = "dbF$patientPhone";
				$this->Cell($headerWidth, 5, $st, 0, 0, 'L');
				
				// ҏ\Ȃꍇ
				// wb_[r̂ݕ`
				$x = $headerLeftMargin;
				$y += 12;
				$this->Line($x + 8, $y, $x + $headerWidth - 8, $y);
			}
			
			// Line break
			$this->Ln(15);
            
		}
        
		function Footer(){
			$footerTopMargin = 15;
			$footerLeftMargin = 10;
			$footerHeight = 22;
			$footerWidth = 160;
			
			// tHgw
			$this->SetFont(KOZMIN,'B', 10);
			
			//Go to 1.5 cm from bottom
			$this->SetY(-30);
			
            // docMaker.js 瑗ꂽ JSON IuWFNg decode 
            // class Oŏ $obj FȂ̂łŏ
            $value = $_GET['value']; $value = stripslashes($value);
            $value = decodeSTRING($value);
            $obj = json_decode($value, true);
            
			// tb^[e ==================
            // S摜 URL ͑΃pX̕Kv
            //$url = '../Users/ohashi/ohashi-clinic.png';
            $w = 0; // SEC[W̋
            $url = $obj['hospitalLogo'];
            if (strlen($url) > 0){
                $x = $footerLeftMargin;
                $y = $this->GetY() + 5;
                $w = 15;
                $this->Image($url, $x, $y, $w);
            }
            
            // {ݖ
			$x = $footerLeftMargin + $w + 1;
			$y = $this->GetY() + 2;
			$this->SetXY($x, $y);
			$this->SetFont(KOZMIN,'B', 12);
			$this->Cell($footerWidth, 10,convert($obj,'hospitalName'), 0,0,'L');
			$this->SetXY($footerLeftMargin + $footerWidth/2 + 10, $y);
			// Z
			$y += 6;
			$this->SetFont(KOZMIN,'B', 10);
			$this->SetXY($x, $y);
			$this->Cell($footerWidth,10,convert($obj,'hospitalAddress'),0,0,'L');
			// db
			$y += 6;
			$this->SetXY($x, $y);
			$this->Cell(35, 10, "dbF".$obj['hospitalPhone'], 0,0,'L');
			// FAX
            $x = $this->GetX() + 3;
            $this->SetX($x);
			$this->Cell(35, 10, "FAX: ".$obj['hospitalFAX'], 0,0,'L');
            
            
			if ($this->PageNo() == 1){
				// Py[Wڂ̂݁utTCv
				$x = $footerLeftMargin + $footerWidth/2 + 30;
				$this->SetY(-30);
				$y = $this->GetY() + 2;
				$this->SetXY($x, $y);
				$this->SetFont(KOZMIN,'B', 10);
				$this->Cell(30, 10, "tTC", 0,0,'L');
				// y[Ẅ󎚂Ȃ
			} else {
				// Qy[Wڈȍ~́utTCvȂ
				// y[W
				$this->SetY(-30);
				$y = $this->GetY() + 16;
				$this->SetXY($footerLeftMargin, $y);
				$this->SetFont(KOZMIN,'B', 8);
				$pageNum = 'Page '.$this->PageNo();
				$this->Cell($footerWidth, 5, $pageNum, 0, 0,'R');
			}
		}
	}
    
    function convert($obj, $name){
        // JSON 當oĕԂ
        return mb_convert_encoding($obj[$name], "SJIS", "UTF-8");
    }
    
    
	$pageWidth = 160;			// EJ킹OgŜ̕
	$leftMargin = 10;			// ʍ[̍J܂ł̃}[W
	$innerMargin = 8;			// g當͍s܂ł̃}[W
	$rowHeight = 5;				// Ps̍
	
	$pdf = new _MBFPDF('P', 'mm', array(180, 256)); // B5
	
    // docMaker.js 瑗ꂽ JSON IuWFNg decode 
    // class Oŏ $obj FȂ̂łŏ
    $value = $_GET['value']; $value = stripslashes($value);
    $value = decodeSTRING($value);
    $printObj = json_decode($value, true);
    
	// ̃tHgݒ
	$pdf->AddMBFont(KOZMIN ,'SJIS');
	if (strlen($printObj['isSmallFont']) > 0){
		$pdf->SetFont(KOZMIN,'B', 9);
		$rowHeight = 4;
	} else {
		$pdf->SetFont(KOZMIN,'B', 10);
		$rowHeight = 6;
	}
    
	// header()  footer() ̓RecɎIɑ}
	$pdf->SetTopMargin(30);
	$pdf->SetAutoPageBreak(true, 35); // [ 35 ̋ŉy[W
	
	// PDF ̈
	$pdf->AddPage();
	
	$x = $leftMargin + $innerMargin;
	$pdf->SetX($x);
	$w = $pageWidth - $innerMargin * 2;
    
	// Rec̈F Header  Footer  _MBFPDF Class ̒ŏ
    $pdf->SetX($x);
	$pdf->MultiCell($w, $rowHeight, convert($printObj,'greetings'), 0, 'L');
    $pdf->SetX($x);
	$pdf->MultiCell($w, $rowHeight, convert($printObj,'contents'), 0, 'L');
    
	$pdf->Output(); // $pdf->Output("docMaker.pdf","I"); ł͋
	
?>