<?php
    
	///////////////////////////////
	// print DOCUMENT with FPDF  //
	///////////////////////////////
	
	function leftBrackets(){
		// $leftBrackets = "＼^＼[＼^" では誤作動
		return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
	}
	function rightBrackets(){
		return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
	}
	function decodeObject($buff){
		// "key(value)" 形式の文字列を OBJECT に decode して返す
		$obj = array();
		for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
			$ch = substr($buff, $p, 1);
			if (strcmp($ch, "(") == 0){
				if ($nest == 0){
					$key = trim(substr($buff, $begin, $p - $begin)); // key 終端
					$begin = $p + 1; // value 開始位置
				}
				$nest++;
			} else if (strcmp($ch, ")") == 0){
				if (--$nest == 0){
					if ($nest == 0){
						// value 終端 ( trim しない )
						$value = substr($buff,$begin,$p-$begin);
						$begin = $p + 1; // key 開始位置
					}
					if (ereg(")", $value)){ // まだ入れ子になっているなら
						$obj[$key] = decodeObject($value);
					} else {
						// 特定文字を "(", ")" へ戻す
						$array = explode(leftBrackets(), $value);
						$value = join("(", $array);
						$array = explode(rightBrackets(), $value);
						$value = join(")", $array);
						
						$obj[$key] = $value;
					}
				}
			}
		}
		return $obj;
	}
	
    require_once '../TCPDF/tcpdf.php';
	
	// サイズの定数
	$pageWidth = 120;			// 左右カラム合わせた外枠全体の幅
	$pageHeight = 160; 			// 外枠の高さ
	$separatorWidth = 10;		// 左右カラムの間の間隔
	$colWidth = ($pageWidth-$separatorWidth) / 2;	// カラムの幅
	$labelWidth = 18;			// ラベル表示幅
	$topMargin = 10;				// 画面上端からのマージン
	$leftMargin = 30;			// 画面左端からの左カラムまでのマージン
	$colMargin = 5;				// カラムとテキストとの間隔
	$rowHeight = 6;				// １行の高さ
	
	//////////// PARENT から転送されたデータ /////////////
	$value = $_GET['value']; $value = htmlspecialchars($value);
	$args = decodeObject($value); // client 側との約束ごと
	$patientId = $args['patientId'];
	$anotherId = $args['anotherId'];
	$patientName = $args['patientName'];
	$date = $args['date'];
	$time = $args['time'];
	
	$address = $args['address'];
	$hospitalName = $args['hospitalName'];
	$phone = $args['phone'];
	$doctorName = $args['doctorName'];
	$comment1 = $args['comment1'];
	$comment2 = $args['comment2'];
    
    $pdf=new TCPDF('P', 'mm', array(180, 256)); // B5
    
    $pdf->SetFont('kozminproregular', '', 12);
	
    // default でヘッダー罫線がでることを防止: AddPage() より前に実行
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    
	$pdf->Open();
	$pdf->AddPage();
	
	// 外枠を描く
	$pdf->SetXY($leftMargin, $topMargin);
	$pdf->Cell($pageWidth, $pageHeight, '', 1, 0, 'L');
	
	// === header ===
	
	// 文書中のフォント設定
    $pdf->SetFont('kozminproregular', '', 14);
	
	// タイトル
	$x = $pageWidth/2 + 15;
	$y += $topMargin + $rowHeight;
	$pdf->SetXY($x, $y);
	$pdf->Cell(0, $rowHeight, "診察予約票", 0, 0, 'L');
	$y += 3; // space
	
	// セパレータ
	$x1 = $leftMargin + $colMargin;
	$x2 = $leftMargin + $pageWidth - $colMargin;
	$y += $rowHeight + 3;
    $pdf->SetLineWidth(0.2);
	$pdf->Line($x1, $y, $x2, $y);
	
	// === contents ===
	
	// カルテID 氏名
    $pdf->SetFont('kozminproregular', '', 10);
	$x = $leftMargin + $colMargin * 2;
	$y += 4;
	$pdf->SetXY($x, $y);
	if ($anotherId && (strlen($anotherId) > 0)){
		$st = "カルテ番号： $anotherId ( $patientId )";
	} else {
		$st = "ID： $patientId";
	}
	$pdf->Cell($pageWidth / 2, $rowHeight, $st, 0, 0, 'L');
	
	// カルテID 氏名
    $pdf->SetFont('kozminproregular', '', 20);
	$x = $leftMargin + $colMargin * 2;
	$y += $rowHeight + 2;
	$pdf->SetXY($x, $y);
	$st = "$patientName 様";
	$pdf->Cell($pageWidth / 2, $rowHeight, $st, 0, 0, 'L');
	
	// 予約日
    $pdf->SetFont('kozminproregular', '', 10);
	$y += $rowHeight + 3;
	$x = $leftMargin + $colMargin * 2;
	$pdf->SetXY($x, $y);
	$st = "次の診察予約日は下記の通りです";
	$pdf->Cell($pageWidth / 2, $rowHeight, $st, 0, 0, 'L');
	
	// 文書中のフォント設定
    $pdf->SetFont('kozminproregular', '', 17);
	
	$x = $leftMargin + $colMargin * 2;
	$y += $rowHeight + 2;
	$pdf->SetXY($x, $y);
	$st = "$date $time";
	$pdf->Cell($pageWidth / 2, $rowHeight, $st, 0, 0, 'L');
	
	// 担当医師名
    $pdf->SetFont('kozminproregular', '', 10);
	$x = $leftMargin + $colMargin * 2;
	$y += $rowHeight + 2;
	$pdf->SetXY($x, $y);
	$st = "担当医師： $doctorName";
	$pdf->Cell($pageWidth / 2, $rowHeight, $st, 0, 0, 'L');
	
	// コメント
	$y += $rowHeight + 4;
	$x = $leftMargin + $colMargin * 2;
	$pdf->SetXY($x, $y);
	$w = $pageWidth - $colMargin * 5;
	$pdf->MultiCell($w, $rowHeight, $comment1, 0, 'L');
	
	// 診察時間
	$y += $rowHeight * 5 + 4;
	$x = $leftMargin + $colMargin * 2;
	$pdf->SetXY($x, $y);
	$w = $pageWidth - $colMargin * 5;
	$pdf->MultiCell($w, $rowHeight, $comment2, 0, 'L');
	
	// === footer ===
	
	// セパレータ
	$x1 = $leftMargin + $colMargin;
	$x2 = $leftMargin + $pageWidth - $colMargin;
	$y = $pageHeight - $rowHeight * 3 + 3;
    $pdf->SetLineWidth(0.2);
	$pdf->Line($x1, $y, $x2, $y);
	
	// 施設情報
	$y += 3;
	$pdf->SetXY($x, $y);
	$st = "$address";
	$pdf->Cell($pageWidth / 2, $rowHeight, $st, 0, 0, 'L');
	
	// 施設情報
	$y += $rowHeight;
	$x += 8;
	$pdf->SetXY($x, $y);
	$st = "$hospitalName";
	$pdf->Cell($pageWidth / 2, $rowHeight, $st, 0, 0, 'L');
	
	$y += $rowHeight;
	$pdf->SetXY($x, $y);
	$st = "電話: $phone";
	$pdf->Cell($pageWidth / 2, $rowHeight, $st, 0, 0, 'L');
	
	$pdf->Output();
    
?>
