
var _infoList; // タグ分けされたデータオブジェクト
var _records; // サーバから返されたデータオブジェクト
var _fileBox;
function setInfoList(results){
    // サーバから得たデータオブジェクトのリストを元に infoSack 構造を生成
    _fileBox = results.fileBox;
    var obj = results.list;
    
    //_initDebug(true); //##
    _debug("_fileBox->"+_fileBox); //##
    _debug("results.group->"+results.group); //##
  //  _debug("setInfoList->"+encodeObject(obj)); //##
    
    if (results.group){
        var array = JSON.parse(results.group);
        setGroupObj(array);
        _debug("group->"+encodeObject(array)); //##
    }
    
    _records = new Object();
    _infoList = new Object();
    for (fid in obj){
        _debug(fid+"->"+encodeObject(obj[fid])); //##
        
        var st = obj[fid]; // JSON が文字列のままで解凍されていない
        var rec = JSON.parse(st);
        _records[rec.id] = rec;
        
        _debug("rec->"+encodeObject(rec)); //##

        // カテゴリーごとにデータを記憶
        var array = rec.group.split('^');
        for (num in array){
            var tag = array[num];
            if (! _infoList[tag]) _infoList[tag] = new Array();
            _infoList[tag].push(rec);
        }
    }
}
function infoList(){
    // データオブジェクトの塊を返す
    return _infoList;
}
function fileBox(){
    // サーバが画像を収納している path を返す
    return _fileBox;
}
function records(){
    // 全てのレコードを返す
    return _records;
}
function recordForId(fileId){
    // fileId に対応したデータオブジェクトを返す
    return _records[fileId];
}
function setRecordForId(rec, fieldId){
    // fieldId に対応する rec を保存
    _records[fileId] = rec;
}

function clickedLabel(filename){
    // データオブジェクトのラベルがクリックされた
    
    // filename から suffix を除去
    var pos = filename.lastIndexOf('.');
    var fileId = (pos > 0) ? filename.substr(0, pos) : filename; 
    var rec = recordForId(fileId);
    
    //alert(filename+"->"+encodeObject(rec)); //##
    
    if (editMode()){
        // 編集パネルを開く
        openEditor(fileId);
    } else {
        var url = (rec.url) ? rec.url : fileBox() + "/"+ filename;
        
        // ファイル以外の URL で行頭に "http://" がない場合はそれを行頭に追加
        if (rec.url && (url.indexOf("http://") < 0)) url = "http://" + url;
         
        window.open(url, "_blank");
    }
}

function changeLayout(elm){
    // 編集モード / 閲覧モードで レイアウトを変更
    setCloseCategory(elm); // localStorage.js
    initInfoSack();
}

var _editMode;
function editMode(){
    // 編集モードなら true を返す
    return (_editMode) ? true : false;
}
function changeMode(){
    // 編集モード / 閲覧モードを切り替える
    _editMode = (_editMode) ? false : true;

    if (_editMode){
        var elm = elmFor("workArea");
        elm.innerHTML = "";
        var div = newDIV(elm, "");
        div.style.padding = "5px 10px";
        div.style.fontSize = "10pt";
        
        var sp = newSPAN(div, "");
        sp.innerHTML = "レイアウト";
        sp.style.marginRight = "5px";
        var cb = newCHECKBOX(div, "", "カテゴリーのみ表示", closeCategory());
        cb.setAttribute("onchange", "changeLayout(this)"); 
    } else {
        elmFor("workArea").innerHTML = "";
    }

    initInfoSack();
}

function showInfoList(){
    // データオブジェクトをリスト形式で表示
    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "/base-table");
    
    //_initDebug(true); //##
    //_debug("showInfoList->"+encodeObject(obj)); //##
    //_debug("groupObj->"+groupObj()); //##
    
    // groupMenu() の順序で表示
    var obj = infoList();
    _debug("obj->"+encodeObject(obj)); //##
    
    var groups = groupObj();
    _debug("groups->"+encodeObject(groups)); //##

    for (num in groups){
        var tag = groups[num];
        var tr = newTR(tbl, "", "");
        tr.style.fontSize = "10pt";
        
        _debug("->"+tag); //##
        
        // カテゴリー
        var td = newTD(tr, "", tag);
        td.style.paddingLeft = "5px";
        //td.style.width = "90px";
        td.style.fontSize = "9pt";
        td.style.verticalAlign = "top";
        td.style.backgroundColor = "#aec";
        td.style.borderBottom = "2px solid #fff";
        
        // ファイル
        var td = newTD(tr, "", "");
        td.style.paddingLeft = "5px";
        td.style.borderBottom = "thin solid #ccc";
        td.style.verticalAlign = "top";
        var marked = (tag == "お気に入り") ? true : false;
        var array = obj[tag];
        for (num in array){
            var rec = array[num];
            var bt = newDIV(td, "/blueButton");
            bt.innerHTML = rec.label; // FireFox では innerText を使うと表示されない
            if (marked)
                bt.setAttribute("class", "yellowButton");
            var filename = rec.id + '.' + rec.suffix;
            bt.setAttribute("onclick", "clickedLabel('" + filename + "')");
        }
    }
}

function changedFavorite(answer){
    // データを再読込み
    showFadeoutInfo("messageArea", "「お気に入り」を更新しました", 500);
    GetInfoList(gotInfoList);
}
function changeFavorite(elm, fileId){
    // お気に入りチェックボックスがクリックされた
    var addMode = elm.checked;
    
    //_initDebug(true); //##
    _debug("addMode->"+addMode); //##
    
    var pos = fileId.lastIndexOf('.');
    var fileId = (pos > 0) ? fileId.substr(0, pos) : fileId; 
    var rec = recordForId(fileId);
    if (addMode){ // 「お気に入り」を追加
        if (rec.group){
            var ary = rec.group.split("^");
            if (indexOfArray(ary, "お気に入り") < 0){
                ary.splice(0,0,"お気に入り");
                rec.group = ary.join("^");
            }
        } else {
            rec.group = "お気に入り";
        }
    } else { // 「お気に入り」を削除
        if (rec.group){
            var ary = rec.group.split("^");
            var ix = indexOfArray(ary, "お気に入り");
            if (ix >= 0){
                ary.splice(ix, 1);
                rec.group = ary.join("^");
            }
        }
    }
    _debug("rec.group->"+rec.group); //##
    
    // お気に入りに追加して保存
    PutInfo(rec.id, rec, changedFavorite);
}
function showChild(tag){
    // tag カテゴリーに属するファイル名をリストアップ
    var elm = elmFor("childArea");
    elm.innerHTML = "";
    
    var obj = infoList();

    //_initDebug(true); //##
    _debug("->"+encodeObject(obj)); //##
    
    var array = obj[tag];
    for (num in array){
        var rec = array[num];
        if (rec.label.length == 0) continue;
        
        var filename = rec.id + '.' + rec.suffix;
        var ary = rec.group.split("^");
        var checked = (indexOfArray(ary, "お気に入り") >= 0) ? 1 : 0;
        
        var dv = newDIV(elm, "");
        // チェックボックス
        var cb = newCHECKBOX(dv, "", "", checked);
        cb.setAttribute("onchange", "changeFavorite(this,'" + filename + "')"); 
        // ファイル名
        var bt = newDIV(dv, "/listMember");
        bt.innerHTML = rec.label; // FireFox では innerText を使うと表示されない
        bt.setAttribute("onclick", "clickedLabel('" + filename + "')");
    }
    
    // 選択タグを斑点させて再表示
    showCategory(tag);
}
function showCategory(currentTag){
    // カテゴリー・ラベルを表示
    var div = elmFor("labelArea");
    div.innerHTML = "";
    
    //_initDebug(true); //##
    _debug("showCategory->"+currentTag); //##

    var groups = groupObj();
    for (num in groups){
        var tag = groups[num];
        var marked = false;
        if (tag == "お気に入り") marked = true;
        
        // ラベル
        var dv = newDIV(div, tag + ".tag/blueButton");
        dv.innerHTML = tag; // FireFox では innerText を使うと tag が表示されない
        dv.setAttribute("onclick", "showChild('" + tag + "')");
        dv.style.marginRight = "5px";
        if (tag == currentTag)
            dv.setAttribute("class", "selectedLabel");
        else if (marked)
            dv.setAttribute("class", "yellowButton");
        else if (tag == "未分類")
            dv.setAttribute("class", "listMember");
    }
}
function showInfoLabel(){
    // データオブジェクトをラベル形式で表示
    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    var div = newDIV(elm, "labelArea");
    var div = newDIV(elm, "childArea");
    div.style.margin = "10px";
    
    // groupMenu() の順序で表示
    showCategory();
}

function gotInfoList(answer){
    // データオブジェクトのリストを受け取る
    //alert("gotInfoList->"+answer); //##
    var obj = JSON.parse(answer);
    setInfoList(obj);
    //alert("gotInfoList->"+encodeObject(obj)); //##
    
    if (closeCategory())
        showInfoLabel(); // ラベル形式で表示
    else 
        showInfoList(); // リスト形式で表示
}

function showAddIcon(){
    // 追加アイコンを表示
    var div = elmFor("addIconArea");
    div.innerHTML = "";
    
    var sp = newSPAN(div, "/listMember");
    sp.style.padding = "0 15px";
    sp.setAttribute("onclick", "openEditor()");
    var im = newIMAGE(sp, "", "./add-field.png", "+");
    im.setAttribute("onclick", "add()");
    im.style.height = "12px";
    im.setAttribute("class", "expandIcon");
    im.style.position = "relative";
    im.style.top = "1px";
    var sp = newSPAN(sp, "");
    sp.innerHTML = "ファイルを追加";
    sp.style.paddingLeft = "3px";
}

function search(elm){
    // 検索を実行
    var key = elm.value;

    var w = 300;
	var x = 10; // 表示するx座標
	var y = 40; // 表示するy座標
    var elm = openSeeThroughPanel("_floatPanel",x,y,w,"検索結果");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); 
        return;
    }
    
    var recs = records();
    for (fid in recs){
        var rec = recs[fid];
        
        if (rec.label.indexOf(key) >= 0){
            var div = newDIV(elm, "");
            div.style.paddingLeft = "5px";
            var bt = newDIV(div, "/yellowButton");
            var ary = rec.group.split("^");
            var category = ary.join(" ");
            bt.innerHTML = category + "： " + rec.label;
            var filename = rec.id + '.' + rec.suffix;
            bt.setAttribute("onclick", "clickedLabel('" + filename + "')");
        }
    }
    var div = newDIV(elm, "");
    div.style.height = "10px";
}

function help(){
	// ヘルプパネルを表示
    window.open("./help.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initInfoSack(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    //_initDebug(true); //##
    _debug("initInfoSack->"+elm); //##
    
    // === HEADER ===============
    var div = newDIV(elm, "infoHeader");
    if (editMode()) 
        div.setAttribute("class", "yellow-header"); 
    else
        div.setAttribute("class", "tool-header"); 
    var dv = newDIV(div, "/left-side");
    dv.style.width = "150px";
    var sp = newSPAN(dv, "titleArea");
    sp.innerHTML = "InfoSack";
    var sp = newSPAN(dv, "controlArea");
    sp.style.paddingLeft = "30px";
    var dv = newDIV(div, "/right-side");
    // 検索フィールド
    var fd = newFIELD(dv, "searchF", "", 20, "");
    fd.setAttribute("onchange", "search(this)");
    fd.setAttribute("type", "search");
    fd.style.marginRight = "10px";
    fd.style.borderRadius = "10px";
    // HELP アイコン
	var im = newIMAGE(dv, "", "./help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "18px";
    im.setAttribute("class", "expandIcon");
    
    // === CONTENTS ===============
    var div = newDIV(elm, "contentsArea");
    div.style.margin = "5px 0 0 3px";
    var div = newDIV(elm, "addIconArea");
    div.style.marginBottom = "3pt";
    // 追加アイコン
    if (editMode()) showAddIcon(); 

    // === FOOTER ===============
    var div = newDIV(elm, "infoFooter");
    if (editMode()) 
        div.setAttribute("class", "yellow-footer"); 
    else
        div.setAttribute("class", "tool-footer"); 
    var dv = newDIV(div, "/left-side");
    dv.style.width = "30%";
    var sp = newSPAN(dv, "");
	var im = newIMAGE(dv, "", "./hammer.png", "?");
	im.setAttribute("onclick", "changeMode()");
	im.style.height = "16px";
    im.setAttribute("class", "expandIcon");
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = version();

    GetInfoList(gotInfoList);
}

function version(){
    // Since 2013-11-18
    return "Ver.140120";
}