
_source = ""; // Global 変数

function setSource(buff){
	_source = buff;
}
function source(){
	return _source;
}

function clearSearchKey(){
	var p = document.getElementById("source");
	p.value = "";
	if (owner().length > 0){
		var p = document.getElementById("text");
		p.value = "";
	}
}

function debug(){
	// debug用: status-bar に表示
	for (var i=0,st=""; i < arguments.length; i++)
		st += arguments[i] + " ";
	
	window.status = st; // status-bar に表示
}

function isHL7(src){
	return ((src.indexOf("MSH|") >= 0) && (src.indexOf("PID|") >= 0)) ? 1 : 0;
}

function isSpace(ch){
	if (ch == " ") return 1;
	if (ch == "\n") return 1;
	if (ch == "\t") return 1;
	return 0;
}

function trim(ln){
	var len = ln.length, i, begin = 0;
	
	// 行頭の空白を削除
	for (i=0; isSpace(ln.charAt(i)) && i < len; i++){
		begin = i + 1;
	}
	ln = ln.substr(begin);
	
	// 行末の空白を削除
	len = ln.length;
	for (i=len-1; isSpace(ln.charAt(i)) && i > 0; i--){
		ln = ln.substr(0, i);
	}
	
	return ln;
}

///////////////////////////////////////////////
///// parent から URI に添付して転送された値

function owner(){
	return parent().owner();
}

function hospitalId(){
	return parent().hospitalId(); // ### NOA から値を得る ###
}

function openChart(patientId, name){
	// カルテを開く
    parent().openChart(patientId);
}

///// parent から URI に添付して転送された値
///////////////////////////////////////////////


/////////////////////////////////
/// DOM 関連 ////////////////////

function _newTABLE(){
    var elm = document.createElement('TABLE');
	for (var i=0; i < arguments.length; i++){
		var st = arguments[i];
		var array = st.split("=");
		if (array.length > 1) elm.setAttribute(array[0], array[1]);
	}
	return elm;
}


function newGROUP(elm, label, table){
	var tbl = newTABLE(elm, "groupTable");
	tbl.className = "GROUP";
	
	// 伝票上端のラベル
	var tb = newTABLE(tbl, "subTable");
    var tr = newTR(tb, "", ""); 
	var td = newTD(tr, "labelTD", label);
	
	tbl.appendChild(table);
	
	return tbl;
}

function showUNIT(st){
	// 単表示チェックボックスにチェックが入っていなければ何もしない
	if (document.getElementById("isShowUnit").value.length > 0){
		// label 上にマウスが来た時だけ footer に、単位、範囲、異常値を表示
		var array = st.split("\^");
		var anId = array[0];
		if (array.length > 1){
			var unit = array[1];
			document.getElementById(anId).innerHTML = "<font size=2>"+unit+"</font>";
		}
		else
			document.getElementById(anId).innerHTML = "";
	}
}

_cellId = 0; // global 変数

function cellId(){
	return _cellId;
}
function setCellID(num){
	_cellId = num;
}

function newCELL(elm, label, quantity, unit, range, abnormalFlag){
	var tbl = newTABLE(elm, "subTable"); //### CELLSPACING, CELLPADDINGが必要？
	tbl.className = "CELL";
	
	if (isSame(abnormalFlag,"#H"))
		var tr = newTR(tbl, "highTR", ""); 
	else if (isSame(abnormalFlag,"#L"))
		var tr = newTR(tbl, "lowTR", ""); 
	else
		var tr = newTR(tbl, "", ""); 
	
	// CELL 上にマウスが来た時だけ footer に、単位、範囲、異常値を表示
	var aCellId = cellId();
	var anId = new String("CELL"+aCellId);
	if (range)
		var st = anId+"^"+unit+" (基準値: "+range+") "+abnormalFlag;
	else
		var st = anId;
	tr.setAttribute("onmousemove","showUNIT('"+st+"')");
	tr.setAttribute("onmouseout","showUNIT('"+anId+"')");
	
	// ラベル
	var td = newTD(tr, "cellLabel", label);
	
	// 数値
	var td = newTD(tr, "cellTD", "");
	var ip = newFIELD(td, label, "", 10, quantity);
	
	// セルの次行（単位などを表示）
	var tr = newTR(tbl, "", ""); 
	var td = newTD(tr, anId, "");
	td.setAttribute("colspan", "2");
	td.style.backgroundColor = "#fff";
	setCellID(aCellId + 1); // aCellId をインクリメント

	return tbl;
}

/// DOM 関連 ////////////////////
/////////////////////////////////

var _inputTablePosition;

function setTablePos(pos){
	_inputTablePosition = pos;
}
function tablePos(){
	return _inputTablePosition;
}

function textWithArray(array, inputTable, indent){
	if ((array.className != "ARRAY") && (array.className != "INPUT"))
		return array;
	
	// array を "key(value)..." 形式の文字列にして返す
	var ln = "";
	for (var i=0,num=0; i < array.length; i++){
		var obj = array[i];
		
		if (obj.className == "ARRAY"){
			var key = obj[0];
			var value = textWithArray(obj[1], inputTable, indent+1);
			
			// ### グループの区切りを見やすくするため改行を誇張 ###
			if (indent == 1)
				ln += key+"(\n\n"+value+"\n\n)";
			else
				ln += key+"("+value+")";
		}
		else if (obj.className == "INPUT"){
			var key = obj[0];
			var value = obj[1];
			
			// 入れ子階層を問わず inputTableをシーケンシャルに参照する必要あり numは外部保存
			var num = tablePos();
			var pos = value.indexOf("[");
			if (pos >= 0){ // range などの非表示値が含まれる
				var pos2 = value.indexOf(" ");
				if (pos2 > 0){ // 単位があった
					var st = value.substring(pos2);
					ln += key+"("+inputTable[num]+st+")";
				}
				else { // value のみで単位がなかった
					var range = value.substr(pos);
					ln += key+"("+inputTable[num]+range+")";
				}
			}
			else {
				ln += key+"("+inputTable[num]+")";
			}
			setTablePos(num+1);
		}
		else {
			ln += obj;
		}
	}
	
	return ln;
}

function hasChild(src){
	return ((src.indexOf("(") < 0) && (src.indexOf(")") < 0)) ? 0 : 1;
}

function arrayWithText(src){
	// "key(value)..." 形式の文字列を array にして返す
	if (! hasChild(src)) return src;
	
	var array = new Array();
	array.className = "ARRAY";
	var len=src.length, pos, nest, keybegin, valuebegin, key, num;
	for (pos=0,nest=0,keybegin=0,valuebegin=0,num=0; pos < len; pos++){
		var ch = src.charAt(pos);
		if (ch == '('){
			if (nest == 0){
				key = trim(src.substring(keybegin, pos));
				valuebegin = pos + 1;
			}
			nest++;
		}
		else if (ch == ')'){
			nest--;
			if (nest == 0){
				var val = trim(src.substring(valuebegin, pos));
				if (hasChild(val)){ // is array
					var ary = arrayWithText(val);
					var ar = new Array();
					ar.className = "ARRAY";
					ar[0] = key;
					ar[1] = ary;
					array[num++] = ar;
				}
				else { // is string
					var ar = new Array();
					ar.className = "INPUT";
					ar[0] = key;
					ar[1] = val; // range などの非表示値を含む
					array[num++] = ar;
				}
			}
			keybegin = pos + 1;
		}
	}
	
	return array;
}

function separateUNIT(ln){
	// ln = "411 X10000／UL [376-500]H" から
	// value="411" unit="X10000／UL range="376-500" abnormalFlag="H" を分離
	var value="", unit="", range="", flag="";
	var array = ln.split("\[");
	if (array.length > 1){
		var st = array[0];
		var array2 = (st.split(" "));
		if (array2.length > 1){
			value = array2[0];
			unit = array2[1];
		}
		else {
			value = st;
			unit = "";
		}
		st = array[1];
		var array3 = st.split("\]");
		range = array3[0];
		flag = (array3.length > 1) ? array3[1] : "";
	}
	else
		value = ln;
	
	return [value, unit, range, flag];
}

function domWithText(src, bgcolor){
	// "key(value)..." 形式の文字列を dom にして返す
	if (! hasChild(src)) return src;
	
	var tbl = _newTABLE("BORDER=0","WIDTH=100%","CELLSPACING=0","CELLPADDING=0");
	if (bgcolor) tbl.setAttribute("bgcolor", bgcolor);
	var len=src.length, pos, nest, keybegin, valuebegin, i, key, value;
	for (pos=0,nest=0,keybegin=0,valuebegin=0,i=0; pos < len; pos++){
		var ch = src.charAt(pos);
		if (ch == '('){
			if (nest == 0){
				key = trim(src.substring(keybegin, pos));
				valuebegin = pos + 1;
			}
			nest++;
		} else if (ch == ')'){
			nest--;
			if (nest == 0){
				var val = trim(src.substring(valuebegin, pos));
				if (hasChild(val)){ // is array
					var tb = domWithText(val, bgcolor);
					newGROUP(tbl, key, tb);
				//	tbl.appendChild(newGROUP(key, tb));
				}
				else { // is string
					var array = separateUNIT(val);
					var value = array[0];
					var unit = array[1];
					var range = array[2];
					var abnormalFlag = array[3];
					var cell = newCELL(tbl, key, value, unit, range, abnormalFlag);
				}
			}
			keybegin = pos + 1;
		}
	}
	
	return tbl;
}

function changeSrcAndShowTextArea(){
	// Form の入力値で src を修正して表示
	
	// <INPUT> ノードをピックアップして value を取り出し inputTable へ保存
	var inputTable = new Array();
	var array = document.getElementsByTagName("input");
	for (var i=0,num=0; i < array.length; i++){
		var node = array[i];
		if (node.type == "text")
			inputTable[num++] = node.value;
	}
	
	// "key(value)..." 形式の文字列を array に変換
	var array = arrayWithText(source());
	
	// array を "key(value)..." 形式の文字列に変換し Form の値で修正
	setTablePos(0);
	var src = textWithArray(array, inputTable, 0);
	setSource(src);
	
	showTextArea();
}

function xferHL7(type, list){
	var keys = null;
	switch (type){
		case 0: keys = ["fieldCharacter", "senderApp", "senderFacility"
						, "receiverApp", "receiverFacility", "messageDateTime", "security"
						, "messageType", "messageControlId", "processId"
						, "versionId", "sequenceId", "pointer", "responceType"
						, "appResponceType", "nationalCode", "characterCodeSet"
						, "language", "characterSwithing"]; break;
		case 1: keys = ["setId", "chartId", "receivedDateTime", "aliasId", 
						"patientName", "mothersOldName", "birtyDate", "sex", 
						"aliasName", "jinshu", "patientAddress", "groupCode",
						"phoneHome", "phoneWork", "language", "maritalStatus", 
						"shuukyou", "acountNumber", "insuranceNumber", 
						"licenseNumber", "mothersId", "jinshu2", "bornedPlace", 
						"twinFlag", "bornedNumber", "citizenId", "miritaryStatus", 
						"nationarity", "dethDate", "deathStatus"]; break;
		case 2: keys = ["setId", "cientOrderNumber", "scenterOrderNumber",
						"itemGroupId", "priority", "requestDateTime", 
						"examDateTime", "examTerminateDateTime", "saishuryou", 
						"saishusha", "kentaiShoriCode", "kikenCode", "clincalInfo", 
						"receivedDateTime", "kentaiZairyou", "orderdPerson", 
						"callBackPhoneNumber", "orderField1", "orderField2", 
						"jisshishaField1", "jisshishaField2", "kekkahannpukuNichiji",
						"account", "diagSectionId", "resultStatus"]; break;
		case 3: keys = ["setId", "type", "itemName", "subId", "result", "unit",
						"range", "abnormalFlag", "kakuritsu", "ijyouKensaTokushitsu", 
						"resultStatus", "normalDateTime", "userAccsessCheck", 
						"examDateTime", "userId", "examSekininsha", "kensaHouhou", 
						"templateCheck"]; break;
		case 4: keys = ["setId", "commentSource", "comment"]; break;
	}
	var results = new Array();
	for (var i=1; i < list.length; i++){
		var key = keys[i-1];
		var item = list[i];
		results[key] = (item.length > 0) ? item : "";
	}
	return results;
}

function isSame(st1, st2){
	return ((st1.length == st2.length) && (st1.indexOf(st2) == 0)) ? 1 : 0
}

function newNODE(type, hl7_array){
	var obj = new Object();
	
	switch (type){
		case 0: obj.className = "MSH"; break;
		case 1: obj.className = "PID"; break;
		case 2: obj.className = "OBR"; break;
		case 3: obj.className = "OBX"; break;
		case 4: obj.className = "NTE"; break;
	}
	obj.attributes = xferHL7(type, hl7_array);
	obj.children = new Array();
	
	return obj;
}

function getValuesForKey(array, keys){
	var results = new Array();
	for (name in array){
		for (var i=0; i < keys.length; i++){
			var key = keys[i];
			if (isSame(key, name)){
				var ln = array[name];
				var ary = ln.split("\^");
				
				results.push((ary.length > 1) ? ary[1] : ln);
			}
		}
	}
	return results;
}

function newROOT(){
	var obj = new Object();
	obj.className = "ROOT";
	obj.children = new Array();
	
	return obj;
}

function rootToSRC(obj, indent){
	var ln = "";
	for (name in obj){
		var val = obj[name];
		
		if (val.className == "ROOT"){
			// ### グループの区切りを見やすくするため改行を誇張 ###
			if (indent == 1)
				ln += "(\n\n"+rootToSRC(val, indent+1)+"\n\n)";
			else
				ln += "("+rootToSRC(val, indent+1)+")";
		} else if (name == "className")
			continue;
		else
			ln += val;
	}
	return ln;
}

function arrayToResults(array) {
	// array から NOA 形式に必要なものだけを取り出す
	var root = new Array();
	root.className = "ROOT";
	var results = new Array(), patientName = null;
	for (var no=0, num=0; no < array.length; no++){
		var obj = array[no], className = null;
		
		for (name in obj){
			if (name == "children") continue;
			else if (name == "className"){
				className = obj[name];
			}
			else if (name == "attributes"){
				if (className == "MSH"){
					var ary = getValuesForKey(obj[name], ["messageControlId"]);
					root.push(ary[0]);
				}
				else if (className == "PID"){
					var ary = getValuesForKey(obj[name], ["patientName"]);
					root.push(ary[0]);
				}
				else if (className == "OBR"){
					var ary = getValuesForKey(obj[name], ["itemGroupId"]);
					root.push(ary[0]);
				}
				else if (className == "OBX"){
					var keys = ["itemName","result","unit","range","abnormalFlag"];
					var ary = getValuesForKey(obj[name], keys);
                    
                    //alert("ary->"+encodeObject(ary)); //##
					
					// range 中の ( ) を削除
					var range = ary[3];
					if (range.indexOf("(") >= 0){
						var ar = range.split("(");
						var st = ar.join("");
						ar = st.split(")");
						range = ar.join("");
					}
					var unit = (ary[2].length) ? " "+ary[2] : "";
					var range = (range.length) ? "["+range+"]" : "";
					var abnormalFlag = (ary[4].length) ? "#"+ary[4] : "";
                    var label = simplyfyLabel(ary[0]);
					var ln = label+"("+ary[1]+unit+range+abnormalFlag+")";
					root.push(ln);
				}
				else if (className == "NTE"){
					var ary = getValuesForKey(obj[name], ["comment"]);
					root.push(ary[0]);
				}
			}
		}
		var child = arrayToResults(obj.children);
		if (child.length) root.push(child);
	}
	return root;
    
    function simplyfyLabel(ln){
        // "2A030000001930101-血色素量" を "血色素量" に簡略化して返す
        var pos = ln.indexOf("-");
        if (pos > 0)
            return ln.substr(pos + 1);
        else
            return ln;
    }
}

function arayWithHL7(src){
	if (src.length > 0){
		var dataDict = new Array();
		var list = src.split("\n");
		var count = list.length, msh, pid, obr, obx;
		
		for (var no=0, mshNum=0; no < count; no++){
			var ln = list[no];
			var aList = ln.split("\|");
			if (aList.length < 2) continue;
			
			var key = aList[0];
			
			if (isSame(key, "MSH")){
				msh = newNODE(0, aList);
				dataDict[mshNum++] = msh;
			}
			else if (isSame(key, "PID")){
				var arry = msh.children;
				pid = newNODE(1, aList);
				arry.push(pid);
			}
			else if (isSame(key, "OBR")){
				var arry = pid.children;
				obr = newNODE(2, aList);
				arry.push(obr);
			}
			else if (isSame(key, "OBX")){
				var arry = obr.children;
				obx = newNODE(3, aList);
				arry.push(obx);
			}
			else if (isSame(key, "NTE")){
				var arry = obx.children;
				var nte = newNODE(4, aList);
				arry.push(nte);
			}
		}
		return dataDict;
	}
	return null;
}

function showCells(){
    var src = document.getElementById("source").value;
	src = getRidOfSPACE(src); // 文字列中の空白を削除
    setSource(src);
    
    // パネルのサイズと位置を自動記憶
    putWindowSize();
	
	if (isHL7(src)){ // HL7 形式の入力文字列を NOA 形式に変換
		var array = arayWithHL7(src);
		var array = arrayToResults(array);
		var ln = rootToSRC(array, 0); // ln は range など非表示値を含む source 形式
		document.getElementById("source").value = ln;
	}
	else { // NOA 形式の文字列を FORM 形式で表示
		setCellID(0);
		var tbl0 = domWithText(src, "#66FFCC");
		tbl0.setAttribute("BORDER", "1"); // domWithText() 中で追加するとネスとされてしまう
		var elm = document.getElementById("base");
		elm.innerHTML = "";
		elm.appendChild(tbl0);
		
		var tbl = newTABLE(elm, "subTable");
		var tr = newTR(tbl, "", ""); 
		var td = newTD(tr, "footer", "");

		// changeSrcAndShowTextArea() で Source の INPUT 値のみを入力値と置換
		var ip = newCHECKBOX(td, "isShowUnit", "単位表示 ", 0);
		var ip = newBUTTON(td, "", "確定");
		ip.setAttribute("onclick", "changeSrcAndShowTextArea()");
	}
}

function kana2roma(kana){
	// 仮名文字をローマ字へ変換して返す
	var len = kana.length;
	var roma = "";
	for (var i=0; i < len; i++){
		var ch = kana.charAt(i);
		if (ch == "ア") ch = "a";
		else if (ch == "イ") ch = "i";
		else if (ch == "ウ") ch = "u";
		else if (ch == "エ") ch = "e";
		else if (ch == "オ") ch = "o";
		else if (ch == "カ") ch = "ka";
		else if (ch == "キ") ch = "ki";
		else if (ch == "ク") ch = "ku";
		else if (ch == "ケ") ch = "ke";
		else if (ch == "コ") ch = "ko";
		else if (ch == "サ") ch = "sa";
		else if (ch == "シ") ch = "shi";
		else if (ch == "ス") ch = "su";
		else if (ch == "セ") ch = "se";
		else if (ch == "ソ") ch = "so";
		else if (ch == "タ") ch = "ta";
		else if (ch == "チ") ch = "chi";
		else if (ch == "ツ") ch = "tsu";
		else if (ch == "テ") ch = "te";
		else if (ch == "ト") ch = "to";
		else if (ch == "ナ") ch = "na";
		else if (ch == "ニ") ch = "ni";
		else if (ch == "ヌ") ch = "nu";
		else if (ch == "ネ") ch = "ne";
		else if (ch == "ノ") ch = "no";
		else if (ch == "ハ") ch = "ha";
		else if (ch == "ヒ") ch = "hi";
		else if (ch == "フ") ch = "fu";
		else if (ch == "ヘ") ch = "he";
		else if (ch == "ホ") ch = "ho";
		else if (ch == "マ") ch = "ma";
		else if (ch == "ミ") ch = "mi";
		else if (ch == "ム") ch = "mu";
		else if (ch == "メ") ch = "me";
		else if (ch == "モ") ch = "mo";
		else if (ch == "ヤ") ch = "ya";
		else if (ch == "ユ") ch = "yu";
		else if (ch == "ヨ") ch = "yo";
		else if (ch == "ラ") ch = "ra";
		else if (ch == "リ") ch = "ri";
		else if (ch == "ル") ch = "ru";
		else if (ch == "レ") ch = "re";
		else if (ch == "ロ") ch = "ro";
		else if (ch == "ワ") ch = "wa";
		else if (ch == "ン") ch = "nn";
		else if (ch == "　") ch = " ";
		else if (ch == "ガ") ch = "ga";
		else if (ch == "ギ") ch = "gi";
		else if (ch == "グ") ch = "gu";
		else if (ch == "ゲ") ch = "ge";
		else if (ch == "ゴ") ch = "go";
		else if (ch == "ザ") ch = "za";
		else if (ch == "ジ") ch = "ji";
		else if (ch == "ズ") ch = "zu";
		else if (ch == "ゼ") ch = "ze";
		else if (ch == "ゾ") ch = "zo";
		else if (ch == "ダ") ch = "da";
		else if (ch == "ヅ") ch = "du";
		else if (ch == "デ") ch = "de";
		else if (ch == "ド") ch = "do";
		else if (ch == "バ") ch = "ba";
		else if (ch == "ビ") ch = "bi";
		else if (ch == "ブ") ch = "bu";
		else if (ch == "ベ") ch = "be";
		else if (ch == "ボ") ch = "bo";
		else if (ch == "パ") ch = "pa";
		else if (ch == "ビ") ch = "pi";
		else if (ch == "プ") ch = "pu";
		else if (ch == "ペ") ch = "pe";
		else if (ch == "ポ") ch = "po";
		else if (ch == "ー") ch = "-";
		// 「シャ」など２文字以上のキャラクターは手で修正
		roma += ch;
	}
	return roma;
}

function findPatient(){
	var key = document.getElementById("text").value;
	if (key.length == 0){
		document.getElementById("findResultArea").innerHTML = "";
		document.getElementById("message").innerHTML = "";
		return;
	}
	
	key = kana2roma(key);
	document.getElementById("text").value = key;

	showPatientList(key); // finder.js
}

function putWindowSize(st){
    // window のサイズと位置を localStorage に記憶
    var array = new Array();
	array.push(window.screenLeft);
	array.push(window.screenTop - 22);
	array.push(window.outerWidth);
	array.push(window.outerHeight);
    
    window.localStorage["HL7WindowSize"] = array.join(",");
    
    //alert("window サイズと位置を記憶しました");
}
function getWindowSize(){
    // window のサイズと位置を localStorage から取り出す
    var st = window.localStorage["HL7WindowSize"];
    if (!st) return;
    
    var array = st.split(",");
    var x = array[0] * 1;
    var y = array[1] * 1;
    var w = array[2] * 1;
    var h = array[3] * 1;
    // resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
    // としてもウインドー境界の制限で移動できない場合がある
    window.resizeTo(w, h);
    window.moveTo(x, y);

    //document.getElementById("message").innerHTML = "w:"+w+" h:"+h+" x:"+x+" y:"+y;
}

function help(){
	window.open("./help.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function showTextArea(){
	//alert("hospitalId:"+opener.top.noa); //##

	var elm = document.getElementById("base");
	elm.innerHTML = "";
    
    var panelFrame = newDIV(elm, "panelFrame");

    // === HEADER =========================
    var div = newDIV(panelFrame, "tool-header");
    var dv = newDIV(div, "left-side");
    dv.innerHTML = "HL7 を NOA フォーマットへ変換";
    dv.style.padding = "3px 0 2px 10px";
    var dv = newDIV(div, "right-side");
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "10px";
    sp.style.fontSize = "9pt";
    sp.style.position = "relative";
    sp.style.bottom = "2px";
    var a = newA(sp, "空欄にする", "#", "");
    a.setAttribute("onclick", "clearSearchKey()");
    var sp = newSPAN(dv, "");
    var img = newIMAGE(dv, "", "info.png", "i");
    img.style.width = "18px";
    img.setAttribute("onclick","help()");
    img.style.position = "relative";
    img.style.top = "2px";
    
    // === BODY ===========================
    var div = newDIV(panelFrame, "inputArea");
	var ta = newTEXTAREA(div, "source", "28", "27", source());
    // 入力ヒントを表示
    ta.setAttribute("placeholder", "HL7 の文字列をペーストしてください");
	ta.focus();

    // === FOOTER ========================
    var div = newDIV(panelFrame, "tool-footer");
    div.style.paddingTop = "5px";
    // --- LEFT ---
    var dv = newDIV(div, "left-side");
    dv.innerHTML = version();
    dv.style.position = "relative";
    dv.style.top = "2px";
    dv.style.width = "70px";
    dv.style.color = "#888";
    // --- RIGHT ---
    var dv = newDIV(div, "right-side");
    dv.style.position = "relative";
    dv.style.bottom = "2px";
    // 変換ボタン
    var bt = newDIV(dv, "whiteButton");
    bt.innerHTML = "変換";
	bt.setAttribute("onclick", "showCells()");
    bt.style.marginRight = "5px";
    bt.style.position = "relative";
    bt.style.bottom = "1px";
    // 検索フィールド
	if (owner().length > 0){
		// patient finder
		var fd = newFIELD(dv, "text", "", 20, "");
		fd.setAttribute("onchange", "findPatient()");
        fd.setAttribute("placeholder", "受診者のローマ字名"); // 入力ヒントを表示
        // fd.setAttribute("type", "search");
        fd.style.position = "relative";
        fd.style.bottom = "1px";
        var bt = newDIV(dv, "whiteButton");
        bt.innerHTML = "検索";
		bt.setAttribute("onclick", "findPatient()");
	}

    // result area
    var dv = newDIV(elm, "findResultArea");
    
	// ウインドー・サイズを localStorage から読み込みサイズ調整
    getWindowSize();
}

function version(){
	return "Ver.131220";
}
