

////////////////////////////////////////
/// Ajax による処理 //////////////////////

var _currentCode;
function setCurrentCode(code){
    _currentCode = code;
}
function currentCode(){
    // 現在選択されているコードを返す
    return _currentCode;
}

var _records;
function setRecords(array){
    _records = new Object();
    for (num in array){
        var rec = array[num];
        _records[rec.name] = rec;
    }
}
function records(){
    // 現在選択されているコードに対応するレコード・オブジェクトを返す
    return _records;
}
function urlForName(name){
    // 薬剤名に該当する URL を返す
    var rec = _records[name];
    var memo = rec.memo;
    if (!memo || (memo.length == 0)) return null;
    
    // rec.meno の中に "鎮痛・抗炎症剤 URL:voltaren.pdf ..." のような形でデータが入っている
    var array = memo.split("URL:");
    if (array.length > 1){
        var st = array[1];
        var ary = st.split(" ");
        return ary[0];
    } else {
        return null;
    }
}

function effectArray(){
	// type(約束、内用、屯用、外用) に応じた効能リストを返す
	var effectObj = new Object();
	var obj = records();
    for (name in obj){
        var rec = obj[name];
		var effects = rec.effect; // "鎮痛 解熱" 形式
		if (!effects || (effects.length == 0)) continue;
		
		var ary = effects.split(" ");
        for (j in ary){
			var effect = ary[j]; // "鎮痛" 形式
			// 効能をユニークにするため object の添字として保存
			if (effect.length) effectObj[effect] = name;
		}
	}
	
	// ユニークな効能を array に入れて返す
	var array = new Array();
	for (key in effectObj)
		array.push(key);
	array.sort();
	return array;
}

function gotRecord(){
	// HTTP 通信の状態が変化したら呼び出される関数
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("getRecords->"+value);
        
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
            var array = JSON.parse(ary[1]);
            setRecords(array);
            
            //alert("->"+encodeObject(array)); //##
            
			showPopupMenu();
        }
	} else {
		document.getElementById("popupMenuArea").innerHTML = "Loading data ...";
    }
}
function typeSelected(elm){
	// PHPサーバへリクエストを送り、データが返送されたら func() で受ける
	xmlHttpObject = createXMLHttpRequest(gotRecord);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var code = null;
        if (elm.value == "内用")
            code = "21";
        else if (elm.value == "屯用")
            code = "22";
        else if (elm.value == "外用")
            code = "23";
        
        setCurrentCode(code);

		var st = "./server.php?command=GET_LIST&value=" + code;
		//alert("loadData->"+st); //------
        
		xmlHttpObject.open("GET", st, true);
		xmlHttpObject.send(null);
	}
}

function gotDocument(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotDocument ->"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            // Image を別ウインドウで表示
            var url = encodeSTRING(array[1]);
            var win = window.open("imageViewer.php?value=" + url, ""
                                  ,"width=1000,height=1000,scrollbars=yes,resizable=yes");
            win.focus();
		}
	}
}
function getDocument(elm, isPanel){
    // ポップアップ・メニューで選択された名称に対する画像ファイルをサーバへリクエスト
	xmlHttpObject = createXMLHttpRequest(gotDocument);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        //_initDebug(true); //##
        var name = (isPanel) ? elm.innerText : elm.value;
        _debug("name->"+name); //##
        
        var url = urlForName(name);
        _debug("url-> "+url); //------
        
        if (url){
            // 間違って上位の path がついている場合があるので最下位の path にする
            var ary = url.split("/");
            url = ary[ary.length - 1];
            _debug("-> "+url); //------

            url = encodeSTRING(url);
            
            var st = "./server.php?command=GET_FILE&value=" + url;
            //_debug("getDocument->"+st); //------
            
            xmlHttpObject.open("GET", st, true);
            xmlHttpObject.send(null);
        } else {
            //alert(elm.value + " の添付書類は登録されていません");
            openManTool(name); // マニュアル取込ツールを開く
        }
	}
}

/// Ajax による処理 //////////////////////
////////////////////////////////////////


function showMenu(menus){
    // 薬剤名メニューを表示
    var elm = document.getElementById("popupMenuArea");
    elm.innerHTML = "";
    
    if (docViewerMenuType()){ // パネル型式のメニュー
        var div = newDIV(elm, "");
        div.style.padding = "8px";
        for (num in menus){
            var bt = newDIV(div, "/blueButton");
            bt.innerHTML = menus[num];
            bt.setAttribute("onclick", "getDocument(this,'panel')");
        }
    } else { // ロータリー型式のメニュー
        menus.splice(0, 1, "");
        var pu = newPopupMenu(elm, "namePopup", menus, "");
        pu.setAttribute("onchange", "getDocument(this)");
    }
}

function showPopupMenu(){
    // 薬剤名メニューを生成
    //_initDebug(true); //##
    
    var menus = new Array();
    //alert("menus->"+currentCode()+"->"+encodeObject(menus)); //##
    
    var obj = records();
    for (name in obj){
        var rec = obj[name];
        _debug(rec.code + "->"+rec.name); //##
        //_debug("->"+encodeObject(rec)); //##
        
        menus.push(name);
    }
    showMenu(menus);
}


//////////////////////////////////////////////////////////
///// 薬効で絞込 ///////////////////////////////////////////

function yakkouClicked(elm){
	// 薬効が選択されたら、それに一致した薬剤ポップアップを生成表示
	var yakkou = elm.innerHTML;
	closeFloatPanel();
    
	// 絞り込みキーを基に薬品名リストを作成
    var menus = new Array();
    var obj = records();
    for (name in obj){
        var rec = obj[name];
		var effects = rec.effect; // "鎮痛 解熱" 形式
		if (!effects || (effects.length == 0)) continue;
        if (effects.indexOf(yakkou) < 0) continue;
        
        menus.push(name);
    }
    showMenu(menus);
}
function openEffectPanel(){
	// 薬効で絞込のためのパネルを表示
    if (! currentCode()){
        alert("用法が選択されていません");
        return;
    }
    
    var w = 310;
	var x = 10; // 表示するx座標
	var y = 30; // 表示するy座標
    var title = "薬効で絞込み";
    var elm = openSeeThroughPanel("_floatPanel",x,y,w,title,"formEditorHelp()");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "5px";
 
    // パネル・メニューを表示
    var div = newDIV(elm, "");
    div.style.backgroundColor = "#fff";
    div.style.padding = "5px";
    div.style.borderRadius = "10px";
    
    var array = effectArray();
    for (num in array){
        var sp = newDIV(div, "/blueButton");
        sp.innerHTML = array[num];
        sp.setAttribute("onclick", "yakkouClicked(this)");
    }
}

///// 薬効で絞込 ///////////////////////////////////////////
//////////////////////////////////////////////////////////


function openManTool(name){
    // ガイド・パネルを開く
	window.open("./manTool.php?name="+name,"_blank");
}

function help(){
	// ヘルプパネルを表示
    window.open("./help.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initDocViewer(){
    var base = document.getElementById("base");
    
    // HEADER ================================
    var div = newDIV(base, "/tool-header");
    // -- LEFT ------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    // ラベル
    var sp = newSPAN(dv, "");
    sp.innerHTML = "添付書類 閲覧";
    // -- RIGHT ----------
    var dv = newDIV(div, "/right-side");
    // HELP
    var img = newIMAGE(dv, "", "Help.png", "Help");
    img.setAttribute("onclick","help()");
    img.style.width = "19px";
    img.setAttribute("class", "expandIcon");
    
    // docMaker BODY =====================================
    var div = newDIV(base, "contentsArea");
    div.style.padding = "10px 5px";
    
    // 薬剤タイプ選択
    var dv = newDIV(div, "typePopArea");
    dv.style.fontSize = "10pt";
    var array = ["", "内用", "屯用", "外用"];
	var pu = newPopupMenu(dv, "popup", array, "");
    pu.setAttribute("onchange", "typeSelected(this)");
    
    // 薬効ボタン
    var bt = newDIV(dv, "/flatButton");
    bt.innerHTML = "薬効";
    bt.setAttribute("onclick", "openEffectPanel()");
    bt.style.marginLeft = "5px";
    
    // 表示形式チェックボックス
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "10px";
    var cb = newCHECKBOX(sp, "", "パネル型式", docViewerMenuType());
    cb.setAttribute("onchange", "setDocViewerMenuType(this)"); // localStorage.js
    
    // 薬剤名選択
    var dv = newSPAN(div, "popupMenuArea");

    // FOOTER ==========================================
    var div = newDIV(base, "/tool-footer");
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    // --- RIGHT SIDE ---------------
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = version();
}

function version(){
    // Development started at 2013-10-07.
    return "Ver.131009";
}