
var _debugMode = false;
var _controlAreaWidth = 450;
var _controlAreaHeight = 90;

///////////////////////
///// dragAndDrop /////

var _graffitiImage;
function setGraffitiImage(img){
    _graffitiImage = img;
}
function graffitiImage(){
    return _graffitiImage;
}

function graffitiDrop(e, can){
    // el にドロップされた画像を描画
    var file = e.dataTransfer.files[0];
    if (!file) {
        alert('画像ファイルの実体がないのでドロップできません');
        return; // file の実体がないとドロップできない
    }
    
    if(!file.type.match(/image\/\w+/)){
        alert('画像ファイルしか受けつけられません');
        return;
    }
    
    var img = document.createElement("img");
    var reader = new FileReader(); 
    reader.onload = function(e) {
        img.src = e.target.result;
        if (img.src.indexOf('data:image/tiff;') >= 0)
            alert("TIFF 型式の画像はサポートされていません");
    }
    setGraffitiImage(img);
    
    // canvas へ描画
    img.onload = function() {
        var ctx = can.getContext("2d");
        
        // 再描画前に今までのイメージを消去
        ctx.clearRect(0, 0, can.width, can.height);
        
        // CANVAS のサイズをイメージ・サイズにする
        can.width = graffitiImage().width;
        can.height = graffitiImage().height;
        
        // 画像を表示するクリッピング領域を設定
        var width = graffitiImage().width;
        var height = graffitiImage().height;
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(width, 0);
        ctx.lineTo(width, height);
        ctx.lineTo(0, height);
        ctx.clip();
        
        // 画像の高さが can.height に収まるよう縮尺して表示
        ctx.drawImage(graffitiImage(), 0, 0, width, height);  
    }
    reader.readAsDataURL(file);
}

///// dragAndDrop /////
///////////////////////

////////////////////////////////////////////////////////////////
///// CANVAS をマウス・ドラッグで移動 //////////////////////////////

var _cursor_locked;
var _offset_x;
var _offset_y;
var _currentCanvas;

function layerInfo(can){
    // レイヤー情報を記した文字列を返す
    if (can){
        var context = can.getContext("2d");
        var st = "ID(" + can.id + ") ";
        st += "type(" + can.type + ") ";
        if (can.size) st += "size(" + can.size + ") ";
        if (can.alpha) st += "alpha(" + can.alpha + ") ";
        if (can.colorName) st += "color(" + can.colorName + ") ";
        if (can.text) st += "text(" + can.text + ") ";
        st += "pos(" + can.x + " / " + can.y + ") ";
        return st;
    } else {
        return "";
    }
}

function showController(can){
    // レイヤー上にコントロール情報を表示
    var div = elmFor("layerInfoArea");
    div.innerHTML = "";

    if (can){
        div.style.position = "absolute";
        div.style.left = can.x;
        div.style.top = can.y - 20;

        var sp = newSPAN(div, "");
        var im = newIMAGE(sp, "", "./close.png", "?");
        im.setAttribute("onclick", "removeLayer('" + can.id + "')");
        im.style.marginRight = "5px";
        im.style.height = "15px";
        im.setAttribute("class", "expandIcon");
       
        var sp = newSPAN(div, "");
        sp.innerHTML = layerInfo(can);
        sp.style.fontSize = "9pt";
        sp.style.color = "#00f";
    }
}

function cursor_lock(can){
    // マウス・ダウンに反応
    if (can.empty) return; // 画像ドロップ用の初期レイヤーだった
    
	_cursor_locked = true;
    _currentCanvas = can;
    
    if (can.editMode){
        // 編集モードから抜ける
        can.editMode = false;
        // _currentCanvas = null; // drag できなくなる
        
        // 画像が貼り付けられたレイアーの枠を消去
        can.style.border = "none";
    } else {
        // 編集/通常モードを canvas に記憶
        can.editMode = true;
        
        // 画像が貼り付けられたレイアーの枠を表示
        can.style.border = "3px solid #00f";
        
        // 他のレイアーの editMode があれば解除
        for (id in _layers){
            if (id == can.id) continue;
            
            var canvas = layerForId(id);
            canvas.editMode = false;
            canvas.style.border = "none";
        }
    }
    
    // 選択されたレイヤーのタイプを記憶
    _toolType = can.type; // setToolType() を使うと余計な動作が入ってしまう
    showToolSelector(); // 道具選択ボタンを再描画
    
    // 選択されたレイヤーの属性を各コントローラへ反映させる
    if (can.size) setPenSize(can.size); // ペン・サイズと透明度へ反映
    if (can.alpha) setAlpha(can.alpha);
    if (can.colorName) setPenColor(can.colorName); // カラー・パレットへ反映

    if (_debugMode){
        var context = can.getContext("2d");
        context.font = "14px 'Times New Roman'";
        context.fillStyle = "blue";
        context.textBaseline = "top";
        var st = layerInfo(can);
        context.fillText(st, 5, 5); 
    }
}
function cursor_unlock(){
    // マウス・アップに反応
	_cursor_locked = false;
    
    // 移動後、固定した位置を canvas に記憶
    var can = layerForId(_currentCanvas.id);
    var pos = getPosition(_currentCanvas);
    can.x = pos.x;
    can.y = pos.y;
    
    // 編集用コントローラを表示
    if (can && (can.editMode))
        showController(can);
    else
        showController();

    if (_debugMode){
        var context = can.getContext("2d");
        
        // ##### 文字の幅を取得 #####
        // var textWidth = context.measureText('Sample Text').width;
    }
}

var _oldX;
var _oldY;
function mouse_down(evt){
    var st = "DOWN: layerY: "+ evt.layerY + " clientY:" + evt.clientY + " screenY:" + evt.screenY;
    elmFor("_debug").innerHTML = st; //##
    
    _oldX = evt.layerX;
}
function mouse_up(evt){
    var st = "UP: layerY: "+ evt.layerY + " clientY:" + evt.clientY + " screenY:" + evt.screenY;
    elmFor("_debug").innerHTML = st; //##
    
    var elm = elmFor("canvasBaseArea");
    elm.style.border = "thin solid #f00";
    elm.style.position = "absolute";
    elm.style.left = _oldX;
}
function get_mouseXY(evt){
	// マウスでパネルのタイトルを掴み移動させる
	// Firefox ではうまく動作しない
	if (_cursor_locked){ // mouse down
		_currentCanvas.style.left = evt.clientX - _offset_x; // 表示するx座標
		_currentCanvas.style.top = evt.clientY - _offset_y; // 表示するy座標
	} else { // mouse up
		// layerX layerY は Firefox のみの独自規格で、他のブラウザーは
		// offsetX offsetY だが Safari でも layerX layerY が動く
		// Firefox では evt.x evt.y は動かない
        if (evt.layerY <= 0){
            cursor_unlock();
            return;
        }
        
		_offset_x = evt.layerX;
		_offset_y = evt.layerY;
	}
}

///// CANVAS をマウス・ドラッグで移動 //////////////////////////////
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
///// 画像の取り扱い /////////////////////////////////////////////

var _layers;
function setLayers(obj){
    _layers = obj;
}
function setLayer(can){
    // 画像を持つ CANVAS レイヤーを配列に記憶
    if (!_layers) _layers = new Object();
    
    _layers[can.id] = can;
}
function layerForId(id){
    // id に対応する CANVAS レイヤーを返す
    return _layers[id]
}

function copiedCanvas(elm, canvasId, canvas){
    // CANVAS のコピーを生成して返す
    var width = canvas.width;
    var height = canvas.height;
    var can = newCANVAS(elm, canvasId, width, height, null);
    can.style.position = "absolute";
    
    // 生成した can へ canvas の画像イメージを描画
    var context = can.getContext("2d");
    var img = document.createElement("img");
    img.src = canvas.toDataURL();
    context.drawImage(img, 0, 0, width, height);  
    
    // CANVAS の位置を設定
    can.style.left = can.x = canvas.x; // 表示するx座標
    can.style.top = can.y = canvas.y; // 表示するy座標
    can.type = canvas.type; // タイプをコピー
    can.text = canvas.text; // text をコピー
    can.size = canvas.size; // ペン・サイズをコピー
    can.colorName = canvas.colorName; // ペン・カラーをコピー
    
    // CANVAS をマウスで掴み可動にする
    /*
    can.setAttribute("onmousedown", "cursor_lock(this)"); 
    can.setAttribute("onmouseup", "cursor_unlock()"); 
     */
    can.setAttribute("ondblclick", "pullLayer(this)"); // doubleClick

    return can;
}

function pullLayer(elm){
    // elm のレイヤーを手前に移動
    var canvas = layerForId(elm.id);
    var targetId = canvas.id;
    
    // 全ての CANVAS を一旦クリアー
    var elm = elmFor("canvasBaseArea");
    elm.innerHTML = "";
    
    // 順番を変更して CANVAS を再表示
    var records = new Object();
    _canvasNum = 0;
    for (id in _layers){
        if (id == targetId) continue;
        
        // pullLayer() を命令したレイヤー以外を描画
        var canvas = layerForId(id);
        var can = copiedCanvas(elm, _canvasNum, canvas);
        records[_canvasNum++] = can;
    }
    // pullLayer() を命令したレイヤーを最後に描画
    var canvas = layerForId(targetId);
    var can = copiedCanvas(elm, _canvasNum, canvas);
    records[_canvasNum] = can;
    
    setLayers(records);
}

function removeLayer(targetId){
    // targetId のレイヤーを削除して CANVAS を再表示
    alert("removeLayer->"+targetId); //##
    
    var elm = elmFor("canvasBaseArea");
    elm.innerHTML = "";

    var records = new Object();
    _canvasNum = 0;
    for (id in _layers){
        if (id == targetId) continue;
        
        // removeLayer() を命令したレイヤー以外を描画
        var canvas = layerForId(id);
        var can = copiedCanvas(elm, _canvasNum, canvas);
        records[_canvasNum++] = can;
    }
    
    setLayers(records);
}

///// 画像の取り扱い /////////////////////////////////////////////
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
///// DRAW TOOLS ///////////////////////////////////////////////

var toolTypes = ["Pen","ToothPaste","Line","Text", "Image"];
var _toolType = toolTypes[0]; // default 値
var colorList = {
	"black"   : {"r":0,"g":0,"b":0},
	"blue"    : {"r":0,"g":0,"b":255},
	"red"     : {"r":255,"g":0,"b":0},
	"orange"  : {"r":255,"g":165,"b":81},
	"magenta" : {"r":255,"g":0,"b":255},
	"green"   : {"r":0,"g":255,"b":0},
	"cyan"    : {"r":0,"g":255,"b":255},
	"yellow"  : {"r":255,"g":255,"b":0},
	"white"   : {"r":255,"g":255,"b":255}
}
function color(name, noAlpha){
    // 色を返す
    var obj = colorList[name];
    if (noAlpha)
        return "rgb(" + obj.r + "," + obj.g + "," + obj.b + ")";
    else
        return "rgba(" + obj.r + "," + obj.g + "," + obj.b + "," + alpha() + ")";
}

function setToolType(type){
    // 道具を選択
    _toolType = type;
    
    if (_toolType == "Text"){
        var st = prompt("文字を入力");
        if (st.length == 0) return;
        
        setText(st); // 文字入力パネルを表示
        var can = makeFirstCANVAS(600, 220); // 呪文な大きさで作成
        can.type = type;
        drawText(can, text());

        // 画像の表示位置を調整
        can.x = 20;
        can.y = 140;
        can.style.left = can.x + "px";
        can.style.top = can.y + "px";
    } else if (_toolType == "Image"){
        var width = 150;
        var height = _controlAreaHeight;
        
        var can = makeFirstCANVAS(width, height); // 画像をドロップするエリアを表示
        can.type = type;
        
        // CANVAS に文字を表示しておく
        var context = can.getContext("2d");
        context.font = "12px 'Times New Roman'";
        context.textAlign = "center"; // width / 2 を中心にする
        context.fillText("ここに画像をドロップ", width / 2, height / 2 + 6); 
    } else {
        // インジケータにペンサイズを表示
        showIndicator();
    }
    
    // 道具選択ボタンを再描画
    showToolSelector();
}
function toolType(){
    // 道具の種類を返す
    return _toolType;
}

var _text;
function setText(st){
    _text = st;
}
function text(){
    return _text;
}

var _penSize = 1.9;
function changePenSize(){
    _penSize = penSizeBar.value * 1;
    
    if (toolType() == "Text") 
        redrawText();
    else
        showIndicator();
}
function setPenSize(size){
    _penSize = size;
    
    // ペン・サイズのスライダーを size に調整
    penSizeBar.value = size;
}
function penSize(){
    return _penSize;
}

var _alpha = 1;
function changeAlpha(){
    // 透明度を変える
    _alpha = alphaBar.value * 1;
    
    if (toolType() == "Text") 
        redrawText();
    else
        showIndicator();
}
function setAlpha(val){
    _alpha = val;
    
    // 透明度のスライダーを val に調整
    alphaBar.value = val * 1;
}
function alpha(){
    // 透明度
    return _alpha;
}

var _penColor = "black";
function setPenColor(name){
    // カラーパレットから選択された色を penColor に設定
    _penColor = name;
    showColorPallete();
    
    if (toolType() == "Text"){
        redrawText();
    } else {
        showIndicator();
    }
}
function penColor(flag){
    if (flag){
        // 透明度を反映しない
        var obj = colorList[_penColor];
        return "rgb(" + obj.r + "," + obj.g + "," + obj.b + ")";
    } else {
        // 透明度を反映
        return color(_penColor);
    }
}
function colorName(){
    // "white" などの色名を返す
    return _penColor;
}

function showIndicator(){
    // pen の色やサイズを表示
    var can = document.getElementById("indCanvas");
    var context = can.getContext("2d");
    
    // canvas を一旦クリア
    var w = can.width;
    var h = can.height;
    context.clearRect(0, 0, w, h);
    
    if (toolType() == "Text"){
        // 太さスライダーのサイズを元にフォント・サイズを返す
        // スライダー default 値 1.9 が 14pt になるように計算
        var x = 0;
        var y = h - 2;
        var size = Math.round(penSize() * 7.5);
        
        context.font = size + "px 'Times New Roman'";
        context.fillStyle = penColor();
        context.fillText(text(), x, y);
    } else {
        var startAngle = 0;
        var endAngle = 360 * Math.PI / 180;
        var x = w / 2;
        var y = h / 2;
        context.strokeStyle = "#ccc";
        context.fillStyle = penColor();
        context.beginPath();
        var size = penSize() * 1; // ペンのサイズを縮小して indicator に表示
        context.arc(x, y, size, startAngle, endAngle, false);
        context.fill();
        context.closePath();
        context.stroke();
    }
}

function redrawText(){
    // 文字を透明度やカラーパレット選択に伴い再描画
    var can = _currentCanvas;
    var context = can.getContext("2d");
    
    // canvas を一旦クリア
    var w = can.width;
    var h = can.height;
    context.clearRect(0, 0, w, h);
    
    // 太さスライダーのサイズを元にフォント・サイズを返す
    // スライダー default 値 1.9 が 14pt になるように計算
    var size = Math.round(penSize() * 7.5);
    
    context.font = size + "px 'Times New Roman'";
    context.fillStyle = penColor();
    context.fillText(can.text, 0, 0);
    
    // ペンのサイズ・カラー・透明度を CANVAS に記憶
    putAttributeTo(can);
}

function putAttributeTo(can){
    // レイヤーの属性を CANVAS に記憶
    can.size = penSize();
    can.colorName = colorName();
    can.alpha = alpha();
}

function showToolSelector(){
    // 道具選択ボタンを表示
    var elm = elmFor("toolSelectorArea");
    elm.innerHTML = "";
    for (num in toolTypes){
        var type = toolTypes[num];
        var dv = newSPAN(elm, "");
        dv.innerHTML = type;
        dv.style.display = "inline";
        dv.style.padding = "0 10px";
        if (type == toolType())
            dv.setAttribute("class", "blueActiveButton");
        else
            dv.setAttribute("class", "blueButton");
        dv.setAttribute("onclick", "setToolType('" + type + "')");
    }
    var dv = newSPAN(elm, "/clearButton");
    dv.innerHTML = "白紙";
    dv.style.display = "inline";
    dv.style.padding = "0 10px";
    dv.setAttribute("onclick", "clearDraw()");
}

function showColorPallete(){
    // カラーパレットを表示
    var elm = elmFor("colorPalleteArea");
    elm.innerHTML = "";
    
    for (name in colorList){
        var dv = newDIV(elm, "/colorChip");
        dv.innerHTML = "　　"; // 倍角スペース：これがないとカラーチップの幅がでない
  //      _penColor = name; // setPenColor(name) だと showColorPallete() が再帰してしまう
  //      dv.style.backgroundColor = penColor(true);
        dv.style.backgroundColor = color(name, true);
        dv.style.display = "inline";
        dv.setAttribute("onclick", "setPenColor('" + name + "')");
        if (name == colorName()){
            dv.setAttribute("class", "selectedColorChip");
        }
    }
}

function prickPoint(){
    // マウス・ダウンした位置を取得
    elmFor("messageArea").innerHTML = _offset_x+" / "+_offset_y; //##
}

function drawText(can, text){
    // 文字を描く
    can.empty = false; // 文字が描画され drag できるようになる
    can.text = text; // text を CANVAS に記憶
    
    // 太さスライダーのサイズを元にフォント・サイズを計算
    // スライダー default 値 1.9 が 14pt になるように計算
    var fontSize = Math.round(penSize() * 7.5);
    
    var context = can.getContext("2d");
    context.font = fontSize + "px 'Times New Roman'";
    context.fillStyle = penColor();
    context.textAlign = "left";
    context.textBaseline = "top";
    var x = 0; // 文字左端が CANVAS 左端から x シフトした位置
    var y = 0; // 文字上端が CANVAS 上端から y 下がった位置
    context.fillText(text, x, y);

    // ペンのサイズ・カラー・透明度を CANVAS に記憶
    putAttributeTo(can);
}

///// DRAW TOOLS ///////////////////////////////////////////////
////////////////////////////////////////////////////////////////

function showInfo(){
    // 情報を表示
    _initDebug(true); //##
    _debug("showInfo"); //##
    for (id in _layers){
        // pullLayer() を命令したレイヤー以外を描画
        var can = layerForId(id);
        _debug(id+"->"+can.x+" / "+can.y);
    }
}

function graffitiHelp(){
    // ヘルプを開く
	window.open("./sketchHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

var _canvasNum = 0;
function makeFirstCANVAS(width, height){
    // 画像ドロップする CANVAS を生成
    var elm = elmFor("canvasBaseArea");
    var canvasId = _canvasNum++;
    var can = newCANVAS(elm, canvasId, width, height, null);
    can.empty = true;
    can.style.border = "thin solid #ccc";
    can.style.position = "absolute";
    can.style.left = (_controlAreaWidth + _controlAreaHeight + 25) + "px";
    
    // CANVAS をマウスで掴み可動にする
    // window.onmousemove = get_mouseXY; // 座標取得のためどこかで宣言しておく必要あり
	can.setAttribute("onmousedown", "cursor_lock(this)"); 
	can.setAttribute("onmouseup", "cursor_unlock()"); 
	can.setAttribute("ondblclick", "pullLayer(this)"); // doubleClick

    // レイヤーを配列に記憶
    setLayer(can);
    
    can.ondrop=function(e){
        graffitiDrop(e, can);
        e.preventDefault();
        
        // 画像が貼り付けられたらボーダーを消す
        can.style.border = "none";
        can.empty = false; // 画像が描画された：drag できるようになる
        
        // 画像の表示位置を調整
        can.x = 10;
        can.y = 140;
        can.style.left = can.x + "px";
        can.style.top = can.y + "px";
    };
    
    can.ondragover=function(e){
        e.preventDefault();
    };
    
    return can;
}

function initGraffiti(){
    // 落書帳を初期化
    var elm = elmFor("base");
    elm.innerHTML = "";   

    _initDebug(true); //##

    // HEADER ===============================
    var div = newDIV(elm, "/yellow-header");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    var sp = newSPAN(dv, "");
    sp.innerHTML = parent().patientId();
    sp.style.paddingLeft = "10px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = parent().patientKanjiName();
    sp.style.paddingLeft = "5px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = parent().currentDate();
    sp.style.paddingLeft = "15px";
    // --- ヘルプ・アイコン
    var dv = newDIV(div, "/right-side");
    var sp = newSPAN(dv, "");
    sp.innerHTML = gr_version();
    sp.style.padding = "0 10px";
    sp.style.color = "#888";
    var im = newIMAGE(dv, "", "./help.png", "?");
    im.setAttribute("onclick", "graffitiHelp()");
    im.style.height = "18px";
    im.setAttribute("class", "expandIcon");
    
    // CONTROLLER ===========================
    var carea = newDIV(elm, "controllerArea/clearfix");
    carea.style.border = "thin solid #ccc";
    // PEN SIZE INDICATOR -------------------
    var height = _controlAreaHeight;
    var dv = newDIV(carea, "/left-side");
    dv.style.padding = "0";
    dv.style.width = height + "px";
    dv.style.height = height + "px";
    var cvs = newCANVAS(dv, "indCanvas", height, height, draw);
    showIndicator(); // ペン・サイズ初期値を表示
    // CONTROLLER ---------------------------
    var cdiv = newDIV(carea, "/left-side");
    cdiv.style.width = _controlAreaWidth + "px";
    cdiv.style.height = _controlAreaHeight + "px";
    cdiv.style.fontSize = "9pt";
    cdiv.style.border = "thin solid #ccc"; //##
    // SPACER
    var div = newDIV(cdiv, "");
    div.style.height = "5px";
    // FIRST CONTROLLER -------------
    var div = newDIV(cdiv, "");
    // ペンのサイズ
    var sp = newSPAN(div, "");
    sp.innerHTML = "太さ";
    var sp = newSPAN(div, "penSizeArea");
    newSlider(sp, "penSizeBar", 0.1, penSize(), 30, 0.1, "changePenSize()");
    // 透明度 
    var sp = newSPAN(div, "");
    sp.innerHTML = "透明度";
    sp.style.paddingLeft = "10px";
    newSlider(div, "alphaBar", 0.01, alpha(), 1, 0.01, "changeAlpha()");
    // SECOND CONTROLLER -----------
    var div = newDIV(cdiv, "");
    div.style.display = "inline";
    var sp = newSPAN(div, "");
    sp.innerHTML = "色　";
    // COLOR PALLETE
    var sp = newSPAN(div, "colorPalleteArea");
    showColorPallete();
    // THIRD CONTROLLER -------------
    var div = newDIV(cdiv, "/clearfix");
    div.style.marginTop = "5px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "道具";
    var sp = newSPAN(div, "toolSelectorArea");
    sp.style.paddingLeft = "10px";
    showToolSelector();
    // FOURTH CONTROLLER -----------
    var div = newDIV(cdiv, "");
    div.style.display = "inline";
    var sp = newSPAN(div, "");
    sp.innerHTML = "レイヤー";
    sp.style.paddingRight = "10px";
    sp.setAttribute("onclick", "showInfo()"); //##
    var sp = newSPAN(div, "layerIdArea");
    sp.style.paddingRight = "10px";
    var sp = newSPAN(div, "layerRemoveButtonArea");

    // CANVAS AREA ----------------
    var div = newDIV(carea, "canvasBaseArea");
    var dv = newDIV(div, "layerInfoArea");
    
	window.onmousemove = get_mouseXY; // マウスの位置を取得するようにする
	window.onmousedown = mouse_down; // マウスの位置を取得するようにする
	window.onmouseup = mouse_up; // マウスの位置を取得するようにする

    // マウス・クリックによる位置決めエリア =======
    var div = newDIV(elm, "backgroundArea");
    div.style.border = "thin solid #ccc";
    div.style.height = "600px";
    //div.setAttribute("onclick", "prickPoint()");
}

function gr_version(){
    //elmFor("messageArea").innerHTML = "editMode->"+can.editMode; //##
    return "Ver.140312";
}
