

function savedGroupMenuEditor(answer){
    // tag 要素を削除しておけば、後の kickCellEditor() で再読込される
    // kickCellEditor() 起動まで他の処理で時間を稼いだ方が良いようだ
    parent().removeMenusForTag(parent().currentTag());

    // エディターを閉じる
    window.top.tools.document.getElementById("base").innerHTML = "";
    
    // CellEditor のポップアップ更新
    parent().kickCellEditor(parent().currentTag()); // Ajax
}
function saveGroupMenuEditor(){
    // 確定ボタン：グループ・メニュ内容ーをサーバへ保存
    //_initDebug(true); //##
    _debug("== saveGroupMenuEditor =="); //##
    
    var obj = groupMenuObject();
    var subItems = new Object();
    var menuItem = "";
    for (tag in obj){
        if (tag == parent().currentTag()) menuItem = obj[tag];
        
        // グループメニューを持つ cell も meuItem と重複するがsubItems に取込む
        subItems[tag] = obj[tag];
    }
    _debug("menuItem->"+menuItem); //##
    _debug("subItems->"+encodeObject(subItems)); //##

    if (menuItem.length > 0)
        NRPutGroupMenu(parent().owner(), menuItem, "0", subItems, savedGroupMenuEditor);
    else
        alert("グループ名となる「主訴」が空欄です。やり直してください");
}

function groupMenuObject(){
    // サーバへ書き戻すためのグループメニュー・データ
    var obj = new Object();
    // 選択されているメニュー項目名
    var array = parent().progressTagArray();
    for (num in array){
        var tag = array[num];
        var elm = document.getElementById(tag+"F");
        if (!elm) continue; // pageHeader のフィールドは存在しない
        
        var val = elm.value;
        _debug(tag+" -> "+val); //##
        
        obj[tag] = val;
    }
    obj['freq'] = document.getElementById("freqF").value;

    _debug("groupMenuObject->"+encodeObject(obj)); //##
    
    return obj;
}

function groupMenuHelp(){
	// ヘルプパネルを表示
    window.open("./groupPrefHelp.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function closeGroupEditor(){
    // GROUP MENU EDITOR を閉じる
    var elm = document.getElementById("groupEditorArea");
    elm.innerHTML = "";
}
function openGroupMenuEditor(){
    // GROUP MENU EDITOR を生成
    //_initDebug(true); //##
    _debug("== openGroupMenuEditor =="); //##
    
    var elm = document.getElementById("groupEditorArea");
    if (elm.innerHTML.length){
        closeGroupEditor();
        return;
    }
    elm.innerHTML = "";
    elm.style.padding = "10px";
    
    var td = newTD(elm, "groupMenuEditorArea", "");
    td.setAttribute("colspan", "2");
    var panel = newDIV(td, "/groupEditorPanel");

    // HEADER ============================================
    var div = newDIV(panel, "/clearfix");
    div.style.paddingBottom = "5px";
    var dv = newDIV(div, "/left-side");
    dv.style.paddingLeft = "3px";
    dv.style.fontSize = "10pt";
    dv.style.width = "80%";
	var im = newIMAGE(dv, "", "./close.png", "x");
	im.setAttribute("onclick", "closeGroupEditor()");
	im.style.height = "13px";
    im.setAttribute("class", "expandIcon");
    var sp = newSPAN(dv, "");
    sp.innerHTML = "グループ・メニュー編集パネル";
    sp.style.marginLeft = "10px";
    var dv = newDIV(div, "/right-side");
	var im = newIMAGE(dv, "", "./help.png", "?");
	im.setAttribute("onclick", "groupMenuHelp()");
	im.style.height = "18px";
    im.setAttribute("class", "expandIcon");

    // CONTENTS ==========================================
    var tbl = newTABLE(panel, "/base-table");
    tbl.style.fontSize = "9pt";

    // 選択されているメニュー項目名
    var itemElm = document.getElementById("menuItem");
    var selectedItem = (itemElm) ? itemElm.value : "";
    _debug("selectedItem->"+ selectedItem); //##
    _debug("currentTag->"+ parent().currentTag()); //##

    var array = parent().progressTagArray();
    for (num in array){
        var tag = array[num];
        if (tag == "ProgressSection.note") continue;
        if (tag == "ProgressSection.pageHeader") continue;
        
        var label = parent().cellForTag(tag).label;
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", label);
        td.style.verticalAlign = "top";
        var td = newTD(tr, "", "");
        if (tag == parent().currentTag()){
            // 主訴欄：グループ・メニュー名
            var fd = newFIELD(td, tag+"F", "", 35, selectedItem);
            
            // 頻度
            var freq = (selectedItem.length) ? freqForItem(selectedItem) : "";
            var fd = newFIELD(td, "freqF", " 頻度", 5, freq);
            _debug("fd->"+fd); //##
        } else {
            var value = "";
            if (selectedItem.length){
                for (n in _menuArray){
                    var rec = _menuArray[n];
                    if (rec.menu == selectedItem) value = rec[tag];
                    if (!value) value = "";
                }
            }
            var fd = newTEXTAREA(td, tag+"F", 40, 4, value);
            _debug("field "+ tag+"F"); //##
            
        }
    }
    
    // FOTTER ============================================
    var div = newDIV(panel, "/clearfix");
    var dv = newDIV(div, "/right-side");
    dv.style.width = "100%";
    dv.style.paddingTop = "10px";
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveGroupMenuEditor()");
}

function initGroupMenuEditor(){
    // グループメニュー・エディターを単独で開く場合に起動
    // cellPreference から使う場合は initGroupMenuEditor() は使わない
    var elm = window.top.tools.document.getElementById("base");
	elm.innerHTML = "";

    // CONTENTS ==========================
    var div = newDIV(elm, "groupEditorArea");
    openGroupMenuEditor();
    window.top.tools.document.getElementById(parent().currentTag()+"F").focus();
}


