
var _offsetX;
var _offsetY;
var _clientX;
var _clientY;
var _cursorLocked;
function pi_cursorLock(){ // mouse down
	_cursorLocked = true;
}
function pi_cursorUnlock(){ // mouse up
	_cursorLocked = false;
}
function pi_getMouseXY(evt){
	// マウスでパネルのタイトルを掴み移動させる
	// Firefox ではうまく動作しない
	if (_cursorLocked){ // mouse down
		var elm = document.getElementById("_postIt");
		elm.style.left = evt.clientX - _offsetX; // 表示するx座標
		elm.style.top = evt.clientY - _offsetY; // 表示するy座標
	} else { // mouse up
		// layerX layerY は Firefox のみの独自規格で、他のブラウザーは
		// offsetX offsetY だが、最近は Safari でも layerX layerY が動く
		// Firefox では evt.x evt.y は動かない
		_offsetX = evt.layerX;
		_offsetY = evt.layerY;
		_clientX = evt.clientX;
		_clientY = evt.clientY;
	}
}

//===== 旧 PostIt の設定 ======
//var _notOpen = 0;
//var _shrink = 1;
//var _openWithCondition = 2;
//var _openAnyway = 3;
//=========================== 
// 旧 PostIt との整合性をとるため _shrink 以外はすべて _expand と認識
var _mode;
var _expand = 0;
var _shrink = 1;
var _expired = 2;

function clickedCheckBox(elm){
    if (elm.checked)
        postItObj().type = _shrink;
    else
        postItObj().type = _expand;
}

var _postItObj;
function setPostItObj(obj){
	_postItObj = obj;
}
function postItObj(){
	return _postItObj;
}

function closePostIt(){
	// 確認パネルを閉じる
	var elm = document.getElementById("_postIt");
	elm.innerHTML = "";
	elm.style.width = 0;
	// マウス・イベントが横取りされないようワークスペース外に押し出しておく
	// ## サイズ変更や disabled などやってみたが、不具合が出る
	window.onmousemove = false; // マウス制御を解除しておく
}

function savedPostIt(answer){
    if (answer.length == 0){
        // 削除メッセージ
        alert("付箋は完全に削除されました");
    } else {
        var obj = JSON.parse(answer);
        
        if (obj.type * 1 == _expired){
            alert("付箋は削除されました");
        } else {
            setPostItRecordAtDate(currentDate(), obj);
            
            // あらかじめ closePostIt() されていないとトグル式に閉じてしまう
            showPostIt();
        }
    }
}
function savePostIt(){
    // PostIt 内容を保存
    // textArea を編集不可状態にする
    var elm = document.getElementById("textArea");
    elm.contentEditable = false;

    // 収縮にチェックが入っていれば付箋内容を収縮
    if (document.getElementById("shrinkBox").checked)
        shrinkPostIt();
    
    var type = postItObj().type;
    var val = document.getElementById("textArea").innerHTML;
    
    if (document.getElementById("deleteBox").checked){
        type = _expired; // 削除マークをつける
    } else {
        if (val.length)
            val = transferToCR(val); // <br> を改行に変更
        // 空データなら付箋は削除マークではなく実際に削除される
        val = trim(val);
    }
    
    // savedPostIt（）に備え付箋を一旦閉じておく
    closePostIt();
    
    // val が "" の場合、そのレコードは削除される
    NRPutPostIt(owner(), patient_id(), currentDate(), type, val, savedPostIt);
}

function postItHelp(){
	// 別途ヘルプをパネル表示
	window.open("./postItHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function shrinkPostIt(){
    // status が true なら付箋をタイトルのみにする false なら内容を折畳む
    var elm = document.getElementById("contentsArea");
    elm.style.display = "none"; // 表示しない
}
function expandPostIt(){
    // status が true なら付箋をタイトルのみにする false なら内容を展開
    var elm = document.getElementById("contentsArea");
    elm.style.display = "block"; 
    document.getElementById("textArea").focus();
}
function togglePostIt(){
    // 付箋内容が表示されていれば折畳み、表示されていなければ展開
    var elm = document.getElementById("contentsArea");
    if (elm.style.display == "none"){
        expandPostIt();
    } else {
        shrinkPostIt();
    }
}

function positionInHTML(position, html){
    // 見かけ上は平文に見える文字列上の位置を HTML 上の位置として返す
    var isTag = false;
    var plainPos = 0;
    for (pos in html){
        var ch = html.charAt(pos);
        
        if (ch == "<") isTag = true;
        if (!isTag){
            if (plainPos == position)
                return pos;
            plainPos++;
        }
        if (ch == ">") isTag = false;
    }
}

function getSelectedString(command){
    // 文字列に HTML 属性をつける
    var elm = document.getElementById("textArea");
    var st = htmlToPlain(elm.innerHTML); // HTML をプレーン・テキストに変換
    
    if (command == "strong"){
        // 選択部分を強調文字にする
        var ln = "<strong>" + st + "</strong>";
    } else if (command == "red"){
        var ln = "<font color='#f0f'>" + st + "</font>";
    } else if (command == "blue"){
        var ln = "<font color='#00f'>" + st + "</font>";
    } else if (command == "plain"){
        var ln = st;
    }
    elm.innerHTML = ln;
}

function closePostItEditor(){
    // 編集モードを終了し表示モードとする
    var elm = document.getElementById("textArea");
    elm.contentEditable = false;

    var tr = document.getElementById("spaceArea");
    tr.innerHTML = "";
    tr.style.height = "0px";
    
    document.getElementById("entryDateArea").innerHTML = "";
    document.getElementById("updateTimeArea").innerHTML = "";
    document.getElementById("postItToolArea").innerHTML = "";
    document.getElementById("footerArea").innerHTML = "";
}

function changeToEditable(){
    // 付箋内容を編集できるようにする
    // textArea を編集可能状態にする
    var elm = document.getElementById("textArea");
    elm.contentEditable = true; // TEXT を編集可能状態にする
    elm.focus();
    
//    alert("changeToEditable->"+encodeObject(postItObj())); //### ohashi
    
    // SPACE
    var tr = document.getElementById("spaceArea");
    tr.innerHTML = "";
    tr.style.height = "8px";
    
   // 受診日
    var tr = document.getElementById("entryDateArea");
    tr.innerHTML = "";
    var td = newTD(tr, "postitTD", "年月日");
    var date = (postItObj()) ? postItObj().entryDate : "";
    var td = newTD(tr, "", date);
    
    // 更新日
    var tr = document.getElementById("updateTimeArea");
    tr.innerHTML = "";
    var td = newTD(tr, "postitTD", "更新日");
    var update = (postItObj()) ? postItObj().updateTime : "";
    var td = newTD(tr, "", update);
    
    // TOOLS
    var tr = document.getElementById("postItToolArea");
    tr.innerHTML = "";
    var td = newTD(tr, "", "");
    td.setAttribute("colspan", "2");
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var a = newA(sp, "赤", "#", "");
    a.setAttribute("onMouseUp", "getSelectedString('red')"); //####
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var a = newA(sp, "青", "#", "");
    a.setAttribute("onMouseUp", "getSelectedString('blue')"); //####
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var a = newA(sp, "強調文字", "#", "");
    a.setAttribute("onMouseUp", "getSelectedString('strong')"); //####
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
    var a = newA(sp, "平文", "#", "");
    a.setAttribute("onMouseUp", "getSelectedString('plain')"); //####
   
    // CHECK BOX
    var tr = document.getElementById("footerArea");
    tr.innerHTML = "";
    var td = newTD(tr, "right-side", "");
    td.setAttribute("colspan", "2");
    td.style.paddingTop = "10px";
    var sp = newSPAN(td, "");
    sp.style.fontSize = "10pt";
    sp.style.paddingRight = "5px";
    sp.style.verticalAlign = "middle";
	var cb = newCHECKBOX(sp, "deleteBox", "削除", 0);
    
    // 削除済み付箋が開かれた場合は _expand type に変更しておく
    if (postItObj() && postItObj().type && (postItObj().type * 1 == _expired))
        postItObj().type = _expand;

    var sp = newSPAN(td, "");
    sp.style.fontSize = "10pt";
    sp.style.paddingRight = "5px";
    sp.style.verticalAlign = "middle";
    var status = 0;
    if (postItObj() && postItObj().type && (postItObj().type * 1 == _shrink))
        status = 1;
	var cb = newCHECKBOX(sp, "shrinkBox", "収縮", status);
    cb.setAttribute("onchange", "clickedCheckBox(this)");
    
    // BUTTON
    var bt = newBUTTON(td, "", "確定");
	bt.setAttribute("onclick", "savePostIt()");
    var bt = newBUTTON(td, "", "とりやめ");
	bt.setAttribute("onclick", "savePostIt()");
    bt.setAttribute("onMouseUp", "closePostItEditor)");
}

function makePostIt(){
    // 付箋の本体を表示
    // showPostItForce() と共有
	var elm = document.getElementById("_postIt");
    elm.innerHTML = "";
	elm.style.left = 20; // 表示するx座標
	elm.style.top = pageHeaderY(); // 表示するy座標
	elm.style.visibility = "visible";
    if (elm.innerHTML.length){
        closePostIt();
        return; // 付箋がすでに開いていればトグル式に閉じる
    }
	
	elm.innerHTML = "";
    var obj = postItObj();
    
	// HEADER /////////////////
	var tbl = newTABLE(elm, "postitTable");
    
    // HEADER
	var tr = newTR(tbl, "", "");
    tr.style.backgroundColor = "#fc3";
    tr.style.border = "thin solid #888";
    // --- LEFT SIDE ---
	var td = newTD(tr, "left-side", "");
    td.style.width = "auto";
	td.setAttribute("onclick", "togglePostIt()");
    // CLOSE BOX
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "5px";
	var img = newIMAGE(sp, "icon", "./close.png", "?");
	img.setAttribute("onclick", "closePostIt()");
	img.style.verticalAlign = "middle";
	img.style.height = "11px";
	// 付箋タイトル
    var sp = newSPAN(td, "");
    sp.innerHTML = "付箋";
    // --- RIGHT SIDE ---
	var td = newTD(tr, "right-side", "");
    td.style.width = "15px";
	// HELP icon
	var img = newIMAGE(td, "icon", "./Help.png", "?");
	img.style.height = "16px";
    img.setAttribute("onclick", "postItHelp()");
    
    ///// CONTENTS：子テーブルとして生成 //////////
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "contentsArea", "");
    td.setAttribute("colspan", "2");
    td.style.padding = "20px 10px 20px 20px";
    var tbl = newTABLE(td, "base-table");
    
    // 付箋内容
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "textArea", "");
    td.setAttribute("colspan", "2");
    td.setAttribute("onclick", "changeToEditable()");
    if (obj && obj.value && obj.value.length)
        td.innerHTML = convertSTRING(obj.value, "\n", "<br>"); // 改行を <br> に変更
    else
        td.innerHTML = "";
    
    ///// 以下は編集モードでのみ表示 ///////////////
    var tr = newTR(tbl, "spaceArea", ""); // contents
    
    var tr = newTR(tbl, "entryDateArea", ""); // contents
    tr.style.fontSize = "9pt";
    tr.style.color = "#aaa";
    
    var tr = newTR(tbl, "updateTimeArea", ""); // contents
    tr.style.fontSize = "9pt";
    tr.style.color = "#aaa";
    
    // tool erea
    var tr = newTR(tbl, "postItToolArea", ""); // contents
    tr.style.fontSize = "9pt";
    
    // button erea
    var tr = newTR(tbl, "footerArea", ""); // contents
    
    // 旧 PostIt との整合性をとるため _shrink 以外はすべて _expand と認識
    if (postItObj() && (postItObj().type == _shrink))
        shrinkPostIt();
    else
        expandPostIt();
    
    function pageHeaderY(){
        // currentDate のページ・ヘッダーの Y 座標を返す
        var elm = document.getElementById(currentDate() + ".date");
        var pos = getPosition(elm.parentNode.parentNode);
        
        return pos.y + 35;
    }
}


function showPostItForce(){
    // obj が無くても強制的に付箋を開く
    // 空の obj を生成して付箋パネルを開く
    var elm = document.getElementById("_postIt");
    if (elm && elm.innerHTML.length){
        // トグル式に付箋を表示・非表示
        closePostIt();
        return;
    }
    
    var obj = postItFor(currentDate());
    
    if (obj){
        setPostItObj(obj);
    } else {
        var obj = new Object();
        obj.entryDate = currentDate();
        obj.type = _expand;
        obj.value = "";
        obj.updateTime = "";
        setPostItObj(obj);
    }
    
    makePostIt();
    changeToEditable();
}
function showPostIt(){
	// ## あらかじめ base に _postIt エレメントの埋め込みが必要
    // obj = {"type":"0","entryDate":"...","value":"memo","updateTime":"..."}
    var obj = postItFor(currentDate());

    if (obj){
        if (obj.type == 2){
            // expired type なら閉じて終了
            closePostIt(); // 他の日付の付箋を閉じる
        } else {
            setPostItObj(obj);
            makePostIt();
        }
    } else {
        // obj が無く status が無ければ閉じて終わる
        closePostIt(); // 他の日付の付箋を閉じる
    }
}

function ps_version(){
	return "Ver.121020";
}

