
////////////////////////////////////////////////
///// 電子カルテと接続するための API 
///// 　以下２つのメソッドを電子カルテにインプリすれば
///// 　電子カルテから電子処方箋を使えるようになる
////////////////////////////////////////////////

function getPrescription(value){
	// ### 標準 API：電子処方箋から受け取ったデータを表示 ###
	// JSON 形式の value を、電子カルテ固有の処方箋表示形式に変換して表示
	var obj = eval('(' + value + ')');
	document.getElementById("prsc").value = jsonToEMR(obj);
	
	function jsonToEMR(obj){
		// object をこの電子カルテの処方表示フォーマットへ変換
		var buff = "";
		for (key in obj){
			var val = obj[key];
			if (isSame(val.toString(), "[object Object]") > 0){
				// グループの中を処理
				buff +=  jsonToEMR(val);
			}
			else if (obj.code == 999){ // コメント
				buff += "\n# " + obj.name;
				return buff;
			}
			else {
				// レコードの処理
				// ### 用法行の頭に付ける "  ..." などの形式は電子カルテ毎に自由だが
				// ### 電子処方箋とのやりとりで、電子カルテ側で脱着できなけれならない。
				if (obj.code > 100) buff += "    ..... "; // 用法行の場合
				buff += obj.name + "(" + obj.dose + " " + obj.unit + ")\n";
				return buff;
			}
		}
		return buff;
	}
}

function putPrescription(){
	// ### 標準 API：電子処方箋を開き、処方データを渡す ###
	// 電子カルテからも以下と同様の呼び出しをすれば電子処方箋を使える
	// 電子カルテ固有の表示形式を以下の JSON 形式に変換して渡す
	var href = "./prescription.php?value='" + parameters() + "'";
	
	if (isDebugMode())
		alert("--- 処方箋へ送付する URL ---\n"+href);
	
	// tools エリアに「電子処方箋」を開く
	window.open(href, "tools", "");
	
	function parameters(){
		// ### 標準 API：URL に付加するパラメータ（処方箋データ形式）###
		// ### 以下のような JSON 形式で出力する
		// 　頭につく "0.0": などは、それぞれのオブジェクトを識別するための
		// 　階層化された ID で、これを元に挿入・削除などの操作を行える。
		// 　約束処方も、このような形式で DB に記憶される。
		// 　　しかし ID は電子処方箋側の都合によるものなので、「電子カルテとの交換規格」
		// 　から、はずす予定。
		// "prescription":{
		//	"0":{
		//		"0.0":{"code":"0","name":"トランサミンカプセル 250mg","dose":"6","unit":"Cap"},
		//		"0.1":{"code":"121","name":"分3内服 ８時間毎","dose":"5","unit":"日分"}},
		//	"1":{
		//		"1.0":{"code":"0","name":"アデスタンクリーム 500mg","dose":"1","unit":"回分"},
		//		"1.1":{"code":"123","name":"外用","dose":"1","unit":"回分"}},
		//	"2":{
		//		"2.0":{"code":"0","name":"ニューロタン錠 50mg","dose":"1","unit":"Tab"},
		//		"2.1":{"code":"122","name":"屯用 就寝前","dose":"5","unit":"日分"}}
		// }
		
		var currentDate = document.getElementById("currentDate").value;
		var prescriptionObj = prescriptionObject();
		var buff = '{';
		buff += '"currentDate":"'+ currentDate +'",';
		buff += '"patientId":"'+document.getElementById("patientId").value+'",';
		buff += '"hospitalAddress":"'+document.getElementById("hospitalAddress").value+'",';
		buff += '"hospitalPhone":"'+document.getElementById("hospitalPhone").value+'",';
		buff += '"hospitalName":"'+document.getElementById("hospitalName").value+'",';
		buff += '"loginName":"'+document.getElementById("loginName").value+'",';
		buff += '"name":"'+document.getElementById("name").value+'",';
		buff += '"furigana":"'+document.getElementById("furigana").value+'",';
		buff += '"sex":"'+document.getElementById("sex").value+'",';
		buff += '"birthDay":"'+birthday()+'",';
		buff += '"shubetsu":"'+document.getElementById("shubetsu").value+'",';
		buff += '"family":"'+document.getElementById("family").value+'",';
		buff += '"paymentRatio":"'+document.getElementById("paymentRatio").value+'",';
		buff += '"hokenshaBangou":"'+document.getElementById("insNumber").value+'",';
		buff += '"kigou":"'+document.getElementById("mark").value+'",';
		buff += '"bangou":"'+document.getElementById("number").value+'",';
		buff += '"kouhiFutanBangou":"'+document.getElementById("publicNumber").value+'",';
		buff += '"jyukyuuBangou":"'+document.getElementById("recipientNumber").value+'",';
		buff += '"prescription":'+ json2string(prescriptionObj);
		buff += '}';
		
		return buff;
		
		function birthday(){
			var koyomi = document.getElementById("wareki").value;
			var yy = document.getElementById("year").value;
			var seirekiYear = seirekiWithWareki(koyomi, yy);
			var mm = document.getElementById("month").value;
			var dd = document.getElementById("day").value;
			return seirekiYear+"-"+mm+"-"+dd;
		}
	}
	
	function json2string(obj){
		// JSON オブジェクトを文字列にして返す
		if (obj == null) return '""';
		
		var buff = '{';
		for (recNum in obj){
			var groupObj = obj[recNum];
			buff += '"'+recNum+'":{';
			var num = 0;
			for (code in groupObj){
				var po = groupObj[code];
				var recId = recNum+"."+num++;
				buff += '"'+recId+'":{';
				buff += '"code":"'+code+'",';
				buff += '"name":"'+po.name+'",';
				buff += '"dose":"'+po.dose+'",';
				buff += '"unit":"'+po.unit+'"},';
			}
			buff = buff.substr(0, buff.length - 1); // 末尾の余計な ',' を削除
			buff += '},';
		}
		buff = buff.substr(0, buff.length - 1); // 末尾の余計な ',' を削除
		buff += '}';
		return buff;
	}
	
	function prescriptionObject(){
		// 平文形式の処方を JSON 形式に encode して返す
		var buff = document.getElementById("prsc").value;
		if (buff.length == 0) return null;

		var records = buff.split("\n");
		var gId, num, i, count = records.length;
		var prscObj = new Object();
		var groupObj = new Object();
		var code = "0"; // 用法種別を示すコード
		for (i=gId=num=0; i < count; i++){
			var ln = records[i];
			if (ln.indexOf(".....") >= 0){
				// ln: "..... 分3内服 ８時間毎(5 日分)" のような形式
				// これにより用法行であることを検知
				var ary = ln.split(".....");
				ln = trim(ary[1]); // 文頭の "..... " を削除
				code = codeWithString(ln); // "121","122","123" いずれかを返す
			} else if (isSame(ln.substr(0,6),"----- ")){
				// ln: "----- 分3内服 ８時間毎(5 日分)" のような形式
				// これにより用法行であることを検知
				ln = ln.substr(6); // 文頭の "----- " を削除
				code = codeWithString(ln); // "121","122","123" いずれかを返す
			} else {
				// ln: "トランサミンカプセル 250mg(6 Cap)" のような形式 あるいは
				code = "" + num++; // (code < 100) で用法行ではない
			}
			
			// ln を解析して、名前、投与量、単位、を記憶したオブジェクト:obj を生成
			var array1 = ln.split("(");
			if (array1.length > 1){
				var obj = new Object();
				obj.name = array1[0];
				var ln2 = array1[1];
				var array2 = ln2.split(")");
				var ln3 = array2[0];
				var array3 = ln3.split(" ");
				obj.dose = array3[0];
				obj.unit = (array3.length > 1) ? array3[1] : "";
				groupObj[code] = obj;
			
				if (code * 1 > 100){
					var _gid = ""+gId++;
					prscObj[_gid] = groupObj;
					num = 0; // group 内のレコード id を初期化
					groupObj = new Object(); // 新しい groupObj を生成
				}
			}
		}
		return prscObj;
	}
}

///// 電子カルテと接続するための API ///////////////
////////////////////////////////////////////////


function isDebugMode(){
	return (document.getElementById("isDebugMode").checked) ? 1 : 0;
}

function codeWithString(ln){
	// ln: "..... 分3内服 ８時間毎(5 日分)" のような形式からコードを判別して返す
	if (ln.indexOf("内服", 0) >= 0)
		return "121";
	else if (ln.indexOf("内用", 0) >= 0)
		return "121";
	else if (ln.indexOf("頓", 0) >= 0)
		return "122";
	else if (ln.indexOf("屯", 0) >= 0)
		return "122";
	else if (ln.indexOf("外用", 0) >= 0)
		return "123";
	else
		return "121";
}

function timeStamp(){
	var date = new Date();
	var yy = date.getYear();
	var mm = date.getMonth() + 1;
	var dd = date.getDate();
	var hr = date.getHours();
	if (yy < 2000) { yy += 1900; }
	if (mm < 10) { mm = "0" + mm; }
	if (dd < 10) { dd = "0" + dd; }
	return yy + "-" + mm + "-" + dd;
}

function setDefaultValue(){
	var val = '"東京都千代田区神田駿河台2-5","03-1111-2222","ほっとクリニック","薮井 竹庵","03234200","後藤 久美子","ごとう くみこ","女","平成","2","3","23","政府","本人","3","123456","12-34","5678","654321","000088","アドナ 30mg(3 Tab)<br>トランサミンカプセル 250mg(6 Cap)<br>..... 分3内服 8時間毎(5 日分)<br>ザジテン点眼薬(5 ml)<br>..... 外用(1 回分)<br>ロキソニン錠 60mg(1 Tab)<br>..... 屯用 疼痛時(5 日分)"';
	document.getElementById("csv").value = val;
}

function loadCSV(){
	var tags = new Array("hospitalAddress","hospitalPhone","hospitalName","loginName","patientId","name","furigana","sex","wareki","year","month","day","shubetsu","family","paymentRatio","insNumber","mark","number","publicNumber","recipientNumber","prsc");
	var buff = document.getElementById("csv").value;
	buff = buff.substr(0, buff.length -1); // 行末の " を削除
	buff = buff.substr(1); // 行頭の " を削除
	var array = buff.split('","');
	var i, count=array.length;
	if (count > 21) count = 21;
	for (i=0; i < count; i++){
		var tag = tags[i];
		document.getElementById(tag).value = array[i];
	}
	
	// 処方の改行を処理して読み込む
	if (count >= 20){
		var prescription = array[20];
		var rows = prescription.split("<br>");
		var ln = rows.join("\n");
		document.getElementById("prsc").value = ln;
	}
	
	var dateTime = currentDateTime();
	var array = dateTime.split(" ");
	document.getElementById("currentDate").value = array[0];
}

function openCSVArea(){
	// CSV をペーストするエリアを開く
	var tbl = document.getElementById("inputTable");
	var isOpen = (tbl.innerHTML.length > 0) ? 1 : 0;
	tbl.innerHTML = "";
	if (! isOpen){
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "", "");
		var ta = newTEXTAREA(td, "csv", "60", "5", "");
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "", "");
		var bt = newBUTTON(td, "", "debug 用 default 値をセット");
		bt.setAttribute("onclick", "setDefaultValue()");
		var bt = newBUTTON(td, "", "上の CSV を読込む");
		bt.setAttribute("onclick", "loadCSV()");
	}
}

function loadNOA(){
	// NOA 形式のデータを読込む
	
	// 決め打ち
	document.getElementById("hospitalAddress").value = "東京都品川区荏原4-4-2";
	document.getElementById("hospitalPhone").value = "03-3784-3101";
	document.getElementById("hospitalName").value = "大橋医院";
	document.getElementById("loginName").value = "大橋 克洋";

	var buff = document.getElementById("NOA").value;
	// カルテ番号と名前の取得
	var array = buff.split("◆ (");
	var ln = array[1];
	var array = ln.split(")");
	var pidAndName = array[0];
	var ln = array[1];
	var array = pidAndName.split(" ");
	var pid = array[0];
	document.getElementById("patientId").value = pid;
	var name = pidAndName.substr(pid.length + 1);
	document.getElementById("name").value = name;
	// 受診日
	var array = ln.split("(");
	document.getElementById("currentDate").value = trim(array[0]);
	
	// 生年月日の取得
	var birthday = valueForLabel(buff, "生年月日");
	document.getElementById("wareki").value = birthday.substring(0,2);
	var array = birthday.substr(2).split("年");
	document.getElementById("year").value = array[0];
	var array = array[1].split("月");
	document.getElementById("month").value = array[0];
	var array = array[1].split("日");
	document.getElementById("day").value = array[0];
	
	// 保険種別の取得
	var val = valueForLabel(buff, "健保種別");
	if (isSame(val, "se")) 
		val = "政府"; 
	else if (isSame(val, "ko"))
		val = "国保";
	else if (isSame(val, "ku"))
		val = "組合";
	else if (isSame(val, "ky"))
		val = "共済";
	document.getElementById("shubetsu").value = val;
	
	// 保険区分の取得
	var kubun = valueForLabel(buff, "区分");
	if (isSame(kubun, "F")) kubun = "家族"; else kubun = "本人";
	document.getElementById("family").value = kubun;
	
	setValueToElement("furigana", "ふりがな");
	setValueToElement("sex", "性別");
	setValueToElement("paymentRatio", "負担率");
	setValueToElement("mark", "記号");
	setValueToElement("number", "番号");
	setValueToElement("insNumber", "保険者番号");
	setValueToElement("publicNumber", "負担者番号");
	setValueToElement("recipientNumber", "受給者番号");

	// 処方の取得
	var array = buff.split("院外処方(");
	var ln = array[1];
	var array = ln.split(")]");
	document.getElementById("prsc").value = trimAllLines(array[0]);
	
	function trimAllLines(ln){
		// ln の各行両端の空白を削除する
		var buff = "";
		var array = ln.split("\n");
		var newArray = new Array();
		for (var i=0, count = array.length; i < count; i++){
			var st = trim(array[i]);
			if (st.length > 0) newArray.push(st);
		}
		return newArray.join("\n");
	}

	function setValueToElement(tag, label){
		// label に対応する値を id: tag に相当する element に表示
		var buff = document.getElementById("NOA").value;
		var val = valueForLabel(buff, label);
		document.getElementById(tag).value = val;
	}
	
	function valueForLabel(buff, label){
		// buff 中から label に相当する値を取り出し返す
		var array = buff.split("["+label+"]");
		if (array.length > 1){
			var ary = array[1].split("[");
			var ary2 = ary[0].split("\n");
			var ary3 = ary2[0].split("(");
			return trim(ary3[0]);
		}
		return ""; // みつからなければ空文字を返す
	}
}

function openNOAArea(){
	// NOA データをペーストするエリアを開く
	var tbl = document.getElementById("inputTable");
	var isOpen = (tbl.innerHTML.length > 0) ? 1 : 0;
	tbl.innerHTML = "";
	if (! isOpen){
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "", "");
		var ta = newTEXTAREA(td, "NOA", "60", "5", "");
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "", "");
		var bt = newBUTTON(td, "", "ペーストした NOA データを読込む");
		bt.setAttribute("onclick", "loadNOA()");
	}
}

function init(){
	var base = document.getElementById("base");
	
	var tbl = newTABLE(base, "rootTable");
	var tr = newTR(tbl, "bar", "");
	var td = newTD(tr, "", "「電子処方箋」起動用簡易インタフェース (input.php)");
	td.setAttribute("colspan", "2");

	var tr = newTR(tbl, "public", "医療機関住所");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "hospitalAddress", "", 30, "");
	
	var tr = newTR(tbl, "public", "医療機関電話番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "hospitalPhone", "", 30, "");
	
	var tr = newTR(tbl, "public", "医療機関名");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "hospitalName", "", 30, "");
	
	var tr = newTR(tbl, "public", "処方医師名");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "loginName", "", 30, "");
	
	var tr = newTR(tbl, "", "処方年月日");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "currentDate", "", 30, "");
	
	var tr = newTR(tbl, "", "カルテ番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "patientId", "", 30, "");
	
	var tr = newTR(tbl, "", "氏名");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "name", "", 30, "");

	var tr = newTR(tbl, "", "ふりがな");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "furigana", "", 30, "");
	var array = new Array("女","男");
	var pp = makePopupMenu(td, "sex", array, "男");
	
	var tr = newTR(tbl, "", "生年月日");
	var td = newTD(tr, "", "");
	var array = new Array("明治","大正","昭和","平成");
	var pp = makePopupMenu(td, "wareki", array, "昭和");
	var fd = newFIELD(td, "year", "", 4, "");
	var tx = newTEXT(td, "年");
	var fd = newFIELD(td, "month", "", 4, "");
	var tx = newTEXT(td, "月");
	var fd = newFIELD(td, "day", "", 4, "");
	var tx = newTEXT(td, "日");
	
	var tr = newTR(tbl, "", "保険種別");
	var td = newTD(tr, "", "");
	var array = new Array("国保","政府","組合","共済");
	var pp = makePopupMenu(td, "shubetsu", array, "国保");
	var array = new Array("本人","家族");
	var pp = makePopupMenu(td, "family", array, "家族");
	var array = new Array("0","1","2","3");
	var pp = makePopupMenu(td, "paymentRatio", array, "3");
	var tx = newTEXT(td, "割負担");

	var tr = newTR(tbl, "", "保険者番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "insNumber", "", 30, "");
	
	var tr = newTR(tbl, "", "記号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "mark", "", 30, "");
	
	var tr = newTR(tbl, "", "番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "number", "", 30, "");
	
	var tr = newTR(tbl, "public", "公費負担番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "publicNumber", "", 30, "");
	
	var tr = newTR(tbl, "public", "受給者番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "recipientNumber", "", 30, "");
	
	var tr = newTR(tbl, "", "");
	// Medicinal attached papers
	var td = newTD(tr, "", "処方 ( ");
	var a = newA(td, "添付書類", "http://202.17.213.197/medicine/", "_blank");
	var tx = newTEXT(td, " )");
	
	var td = newTD(tr, "", "");
	var ta = newTEXTAREA(td, "prsc", "50", "8", "");
	
	var tr = newTR(tbl, "footer", "Author: Katsuhiro OHASHI");
	var td = newTD(tr, "footerRight", "");
	var tx = newTEXT(td, "debug");
	var cb = newCHECKBOX(td, "isDebugMode", " ", 0);
	var bt = newBUTTON(td, "", "NOA読込");
	bt.setAttribute("onclick", "openNOAArea()");
	var bt = newBUTTON(td, "", "CSV読込");
	bt.setAttribute("onclick", "openCSVArea()");
	var bt = newBUTTON(td, "", "処方箋を開く");
	bt.setAttribute("onclick", "putPrescription()");
	
	// 外部ファイル読込用エリア
	var tbl = newTABLE(base, "inputTable");
}
