

var _isDebugMode;
function setDebugMode(elm){
	_isDebugMode = (elm.checked) ? true : false;
}
function debugMode(){
    // デバッグモードかどうかを返す
	return _isDebugMode;
}



////////////////////////////////////////////////////////////////
///// Ajax /////////////////////////////////////////////////////

function　gotMenu(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        _debug("gotMenu->"+value); //##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = decodeObject(array[1]);
            setMenuObj(obj);
        }
        showMenu();
	} 
}
function getMenu(){
    // menu 構造をサーバから読込
    xmlHttpObject = createXMLHttpRequest(gotMenu);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
        array["owner"] = owner();
		array["menu"] = "1";
		array["filename"] = "menu.txt";
		
		var st = "./server.php?command=GET_FILE"
		+ "&value=" + encodeObject(array);

        _initDebug(false); //##
        _debug("getMenu-> "+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

var _mainMenu;
function gotSubMenu(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotSubMenu ===\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			//alert("gotSubMenu ==="+array[1]);
            var obj = decodeObject(array[1]);
            setSubMenuObjForMainMenu(obj, _mainMenu);
        }
        showSubMenuFor(_mainMenu);
		hideMessage("_message");
	} else 
		showMessage("_message", "サブメニューをリクエストしています ... ");
}
function getSubMenu(mainMenu){
    // SUBMENU をサーバへリクエスト
    xmlHttpObject = createXMLHttpRequest(gotSubMenu);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var array = new Array();
        array["owner"] = owner();
        array["menu"] = "1";
        array["filename"] = menuForMainMenu(mainMenu);
        
        _mainMenu = mainMenu;
        
        var st = "./server.php?command=GET_FILE"
        + "&value=" + encodeObject(array);
        //alert(st); //===
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
}

function removedBackupFile(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            // 削除メッセージ
            showFadeoutInfo("_debug", array[1], 1000);
        }
	}
}
function removeBackupFile(){
    // 現在選択されているバックアップ・ファイルをサーバから削除
	xmlHttpObject = createXMLHttpRequest(removedBackupFile);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner();
		array["menu"] = "1";
        array["filename"] = document.getElementById("backupFilePop").value;
		
		var st = "./server.php?command=REMOVE_FILE"
		+ "&value=" + encodeSTRING(encodeObject(array));
        
        //alert("removeBackupFile-> "+st+"<br>"); return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

///// Ajax /////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////


function isNewTag(tag){
    // "新規" で始まる tag 名なら true を返す
    return (tag.indexOf("新規") == 0) ? true : false;
}

function reloadMenu(){
    window.location.reload();
}

function saveMainMenu(){
    // mainMenu オブジェクトをサーバへ保存
    _debug("saveMainMenu-> menu.txt を保存"); //##
    
    putFile("menu.txt",encodeObject(menuObj()),true,true,showMenu);
    
    // putFile() は Ajax を起動するので間に合わない可能性がある、、
    //showMenu();
}

function saveSubMenu(obj, mainMenu){
    // subMenu オブジェクトをサーバへ保存
    if (! isNewTag(mainMenu)){
        _debug("=== saveSubMenu under "+mainMenu+" ==="); //##
        var filename = menuForMainMenu(mainMenu);
        
        _debug("save->"+filename+"->"+encodeObject(obj)); //##
        
        putFile(filename,encodeObject(obj),true,true,showMenu);
        
        // putFile() は Ajax を起動するので間に合わない可能性がある、、
        //showMenu();
    }
}

function fixChangedMenu(oldMenu){
    // 変更されたメニュー内容をメモリーに書き込む
    //_initDebug(true); //##
    _debug("=== fixChangedMenu: " + oldMenu + " ==="); //##
    
    var type = recordType(oldMenu);
    var elm = document.getElementById(oldMenu);
    _debug("element for oldMenu->"+elm); //##
    
    if (elm){
        // 旧エレメントを編集不可としコントローラを消去
        elm.contentEditable = false;
        hideMenuController(oldMenu);
        
        if (type == "menu"){
            // mainMenu を再生しサーバへ保存
            remakeMainMenu(oldMenu);
        } else  {
            remakeSubMenu(oldMenu);
        }
    }
    
    
    function remakeMainMenu(oldMenu){
        // 旧エレメントが mainMenu だったのでそれを再作成
        _initDebug(true); //##
        _debug("=== 旧エレメント mainMenu を再作成"); //##
        
        var newTag = document.getElementById(oldMenu).innerHTML;
        if (oldMenu != newTag){
            _debug("oldMenu->"+oldMenu+" newTag->"+newTag); //##
            _debug("oldRecs-> "+encodeObject(_menuObj)); //##
            _debug("--------- "); //##
            
            // 新規オブジェクトを現在カーソルのある位置に挿入
            var newRecs = new Object();
            for (mainMenu in _menuObj){
                if (oldMenu == mainMenu){
                    // 新規オブジェクトを oldMenu 位置に挿入
                    if (isNewTag(newTag)){
                        // mainMenu が新規タグ名なら
                        // mainMenu の指す filename は変わらない
                        newRecs[newTag] = _menuObj[mainMenu];
                    } else if (isNewTag(_menuObj[mainMenu])){
                        // mainMenu が" 新規メニュー" ではなく
                        // subMenu が "新規サブメニュー" であれば
                        // サブメニューのソースファイル名を newTag で設定
                        alert(_menuObj[mainMenu]); //##
                        newRecs[newTag] = newTag + ".txt";
                    } else {
                        // mainMenu の指す filename は変わらない
                        newRecs[newTag] = _menuObj[mainMenu];
                    }
                    // その位置にあったオブジェクトを削除
                    delete _menuObj[oldMenu];
                } else {
                    // 移動のないオブジェクトを追加
                    newRecs[mainMenu] = _menuObj[mainMenu];
                }
            }
            setMenuObj(newRecs);
            
            _debug("-- save->"+newTag+" on old->"+oldMenu); //##
            _debug("newRecs-> "+encodeObject(_menuObj)); //##
            _debug("--------- "); //##
            
            // mainMenu をサーバへ保存
            saveMainMenu();
       }
    }
    function remakeSubMenu(oldTag){
        // 旧エレメントが subMenu だったのでそれを再作成
        //_initDebug(false); //##
        _debug("--- 旧エレメント subMenu を再作成 ->"+oldTag); //##
        _debug("_menuObj->"+encodeObject(_menuObj)); //##
        _debug("---"); //##
        
        var mainMenu = mainMenuOf(oldTag);
        var subMenu = subMenuOf(oldTag);
        var labelTag = "label|" + mainMenu + "|" + subMenu;
        var uriTag = "URI|" + mainMenu + "|" + subMenu;
        _debug("labelTag ->"+labelTag); //##
        _debug("uriTag ->"+uriTag); //##

        // 新規オブジェクトを現在カーソルのある位置に挿入
        var newRecs = new Object();
        var subMenuObj = subMenuObjForMainMenu(mainMenu);
        var newSubMenu = document.getElementById(labelTag).innerHTML;
        _debug("subMenuObj->"+encodeObject(subMenuObj)); //##
        _debug("---"); //##
        if (subMenuObj){
            for (smenu in subMenuObj){
                _debug(smenu+" / "+subMenu); //##
               if (smenu == subMenu){
                    // 新規オブジェクトを subMenu 位置に挿入後
                    var uri = document.getElementById(uriTag).innerHTML;
                   _debug("newSubMenu-> "+newSubMenu+" uri-> "+uri); //##
                   // ## URI が "" だと nextSubMenu() で URI が  
                    // ## null となってコケルので URI に " " を入れる
                    newRecs[newSubMenu] = (uri) ? uri : " ";
                   _debug("change newSubMenu-> "+newSubMenu+" uri-> "+uri); //##
                    // その位置にあったオブジェクトを削除
                    delete subMenuObj[smenu];
                } else {
                    // 移動のないオブジェクトを追加
                    newRecs[smenu] = subMenuObj[smenu];
                }
            }
        } else {
            // 新規サブメニューの場合
            var uri = document.getElementById(uriTag).innerHTML;
            newRecs[newSubMenu] = uri;
        }
        setSubMenuObjForMainMenu(newRecs, mainMenu);
        
        _debug("newRecs-> "+encodeObject(newRecs)); //##
        _debug("save-> "+newSubMenu+" on old-> "+subMenu); //##
        
        if (isNewTag(newSubMenu)) return; //##
        
        // subMenu オブジェクトを保存
        saveSubMenu(newRecs, mainMenu);
    }
}

var _currentMenu;
function setCurrentMenu(tag){
    // 編集対象メニューを特定し編集可能にする
    _initDebug(false); //##
    
    // tag の element を編集可能状態にする
    document.getElementById(tag).contentEditable = true;
    
    var oldMenu = currentMenu();
    _debug("=== setCurrentMenu: "+tag+" === old:"+ oldMenu); //##
    
    if (oldMenu && (oldMenu != tag)){
        // 以前カーソルのあった「変更されたメニュー内容」をメモリーに書き込む
        fixChangedMenu(oldMenu);
    } 
    _currentMenu = tag;
    
    _debug("--- menuObj ---"); //##
    _debug(encodeObject(_menuObj)); //##
    _debug("---------------"); //##
    
    // tag によりコントローラの種類を区別して表示
    showController(tag);
}
function currentMenu(){
    return _currentMenu;
}

function recordType(tag){
    // tag: "mainMenu","label|mainMenu|subMenu","URI|mainMenu|subMenu"
    var array = tag.split("|");
    if (array[0] == "label")
        return "label";
    else if (array[0] == "URI")
        return "URI";
    else
        return "menu";
}
function mainMenuOf(tag){
    // tag から mainMenu を返す
    var array = tag.split("|");
    if (array.length > 1){
        return array[1];
    } else {
        return array[0];
    }
}
function subMenuOf(tag){
    // tag から subMenu を返す
    var array = tag.split("|");
    if (array.length == 3)
        return array[2];
    else
        return "";
}

function addMenu(){
    // 文章を追加
    var newRecs = new Object();

    // 新規オブジェクトを現在カーソルのある位置に挿入
    var cmenu = currentMenu();
    for (mainMenu in _menuObj){
        if (cmenu == mainMenu){
            newRecs[mainMenu] = _menuObj[mainMenu];
            // 新規オブジェクトを currentMenu の次の位置へ挿入後
            // サブメニューは空でも showSubMenuFor() で新規表示される
            newRecs["新規メニュー"] = "新規メニュー.txt";
            
            // 再表示後にここを指すようにする
            _currentMenu = "新規メニュー";
        } else {
            // 移動のないオブジェクトを追加
            newRecs[mainMenu] = _menuObj[mainMenu];
        }
    }
    setMenuObj(newRecs);
    
    saveMainMenu();
}
function removeMenu(tag){
    // メニューを削除
    delete _menuObj[tag];
    
    saveMainMenu();
}
function prevMenu(tag){
    // mainMenu を一つ前に移動
    var newRecs = new Object();
    var oldObj;
    var oldMenu;
    var nextMenu;
    
    for (mainMenu in _menuObj){
        if (tag == mainMenu){
            // ひとつ前のオブジェクトを避けておき、それを削除
            oldObj = newRecs[oldMenu];
            if (oldObj) delete newRecs[oldMenu];
            
            // mainMenu のオブジェクトを追加後、避けておいたオブジェクトを追加
            newRecs[mainMenu] = _menuObj[mainMenu];
            nextMenu = mainMenu;
            
            if (oldObj) newRecs[oldMenu] = oldObj;
        } else {
            // 移動のないオブジェクト
            oldMenu = mainMenu;
            newRecs[mainMenu] = _menuObj[mainMenu];
        }
    }
    _menuObj = newRecs;
    
    // mainMenu をサーバへ保存: ajax 起動するので最後に実行
    saveMainMenu();
}
function nextMenu(tag){
    // mainMenu を一つ後に移動
    var newRecs = new Object();
    var oldObj;
    var oldMenu;
    
    for (mainMenu in _menuObj){
        if (tag == mainMenu){
            // そのオブジェクトを避けておき、それを削除
            oldObj = _menuObj[mainMenu];
            oldMenu = mainMenu;
            delete newRecs[mainMenu];
        } else {
            newRecs[mainMenu] = _menuObj[mainMenu];
            if (oldObj){
                newRecs[oldMenu] = oldObj;
                oldObj = null;
            }
       }
    }
    if (oldObj) newRecs[oldMenu] = oldObj;

    _menuObj = newRecs;
    
    // mainMenu をサーバへ保存: ajax 起動するので最後に実行
    saveMainMenu();
}

function showController(tag){
    // tag によりコントローラの種類を区別して表示
    var type = recordType(tag);
    if (type == "menu")
        showMenuController(tag);
    else
        showSubMenuController(tag);
}
function showMenuController(tag){
    // タイトル右にコントローラを表示
    var tag = currentMenu();
    var elm = document.getElementById("ctrl." + tag);
    if (elm){
        elm.innerHTML = "";
        
        newTEXT(elm, "　");
        var img = newIMAGE(elm, "", "./arrowUp.png", "Up");
        img.style.height = "15px";
        img.setAttribute("onclick", "prevMenu('" + tag + "')");
        newTEXT(elm, " ");
        var img = newIMAGE(elm, "", "./arrowDown.png", "Down");
        img.style.height = "15px";
        img.setAttribute("onclick", "nextMenu('" + tag + "')");
        newTEXT(elm, " ");
        var img = newIMAGE(elm, "", "./add-field.png", "Add");
        img.style.height = "12px";
        img.setAttribute("onclick", "addMenu()");
        newTEXT(elm, " ");
        var img = newIMAGE(elm, "", "./remove-field.png", "Remove");
        img.style.height = "12px";
        img.setAttribute("onclick", "removeMenu('" + tag + "')");
        
        // controller 位置へスクロール
        var pos = getPosition(elm);
        window.scroll(0, pos.y - 50); 
    }
}
function hideMenuController(tag){
    // タイトル右のコントローラを隠す
    var elm = document.getElementById("ctrl." + tag);
    if (elm) elm.innerHTML = "";
}

function addSubMenu(tag){
    // サブメニューを追加
    var mainMenu = mainMenuOf(tag);
    var subMenu = subMenuOf(tag);
    var smObj = subMenuObjForMainMenu(mainMenu);
    
    //alert("== addSubMenu =="); //##
    //alert(mainMenu+"/"+subMenu+"->"+encodeObject(smObj)); //##

    // 新規オブジェクトを現在カーソルのある位置に挿入
    var newRecs = new Object();
    var newObj = new Object();
    for (smenu in smObj){
        if (smenu == subMenu){
            newRecs[smenu] = smObj[smenu];
            // 新規オブジェクトを currentMenu の次の位置へ挿入後
            newRecs["新規サブメニュー"] = "URI";
            // 再表示後にここを指すようにする
            _currentMenu = "label|"+mainMenu+"|"+"新規サブメニュー";
            //alert("_currentMenu->"+_currentMenu); //##
        } else {
            // 移動のないオブジェクトを追加
            newRecs[smenu] = smObj[smenu];
        }
    }
    //alert("newRecs->"+encodeObject(newRecs)); //##
    
    setSubMenuObjForMainMenu(newRecs, mainMenu);

    //alert("newRecs->"+encodeObject(subMenuObjForMainMenu(mainMenu))); //##

    // subMenu オブジェクトを保存
    saveSubMenu(newRecs, mainMenu);
}
function removeSubMenu(tag){
    // サブメニューを削除
    var mainMenu = mainMenuOf(tag);
    var subMenu = subMenuOf(tag);
    var smObj = subMenuObjForMainMenu(mainMenu);
    delete smObj[subMenu];
    
    // subMenu オブジェクトを保存
    saveSubMenu(smObj, mainMenu);
}
function prevSubMenu(tag){
    // サブメニューを一つ前に移動
    _initDebug(false); //##
    var newRecs = new Object();
    var oldObj;
    var oldMenu;
    var nextMenu;
    
    var mainMenu = mainMenuOf(tag);
    var subMenu = subMenuOf(tag);
    var subMenuObj = subMenuObjForMainMenu(mainMenu);
    
    _debug("=== prevSubMenu->"+mainMenu+" / "+subMenu); //##
    _debug("subMenuObj->"+encodeObject(subMenuObj)); //##
    
    for (sMenu in subMenuObj){
        if (sMenu == subMenu){
            // ひとつ前のオブジェクトを退避しておき、それを削除
            oldObj = newRecs[oldMenu];
            if (oldObj) delete newRecs[oldMenu];
            _debug(oldMenu+" delete->"+newRecs[oldMenu]); //##

            // subMenu のオブジェクトを追加後
            newRecs[sMenu] = subMenuObj[sMenu];
            nextMenu = "label|" + mainMenu + "|" + sMenu;
            _debug(sMenu+" -->"+subMenuObj[sMenu]); //##
            
            // 退避しておいたオブジェクトを追加
            if (oldObj) newRecs[oldMenu] = oldObj;
            _debug(oldMenu+" add->"+oldObj); //##
        } else {
            // 移動のないオブジェクト
            oldMenu = sMenu;
            newRecs[sMenu] = subMenuObj[sMenu];
            
            _debug(sMenu+" -->"+subMenuObj[sMenu]); //##
        }
    }
    setSubMenuObjForMainMenu(newRecs, mainMenu)
    _debug("changed subMenuObj->"+encodeObject(newRecs)); //##
    
    // subMenu オブジェクトを保存
    saveSubMenu(newRecs, mainMenu);
}
function nextSubMenu(tag){
    // サブメニューを一つ後に移動
    _initDebug(false); //##
    var newRecs = new Object();
    var oldObj;
    var oldMenu;
    
    var mainMenu = mainMenuOf(tag);
    var subMenu = subMenuOf(tag);
    var subMenuObj = subMenuObjForMainMenu(mainMenu);
    
    _debug("=== nextSubMenu->"+mainMenu+" / "+subMenu); //##
    _debug("subMenuObj->"+encodeObject(subMenuObj)); //##
    
    for (sMenu in subMenuObj){
        if (sMenu == subMenu){
            // そのオブジェクトを避けておき、それを削除
            oldObj = subMenuObj[sMenu];
            
            oldMenu = sMenu;
            nextMenu = "label|" + mainMenu + "|" + sMenu;
            _debug(sMenu+" delete->"+newRecs[sMenu]); //##
            delete newRecs[sMenu];
        } else {
            newRecs[sMenu] = subMenuObj[sMenu];
            if (oldObj){
                newRecs[oldMenu] = oldObj;
                oldObj = null;
                _debug(sMenu+" -->"+subMenuObj[sMenu]); //##
            }
        }
    }
    if (oldObj) newRecs[oldMenu] = oldObj;
    if (oldObj) _debug(oldMenu+" -->"+oldObj); //##
    
    setSubMenuObjForMainMenu(newRecs, mainMenu);
    _debug("changed subMenuObj->"+encodeObject(newRecs)); //##
    
    // subMenu オブジェクトを保存
    saveSubMenu(newRecs, mainMenu);
}

function showSubMenuController(tag){
    // タイトル右にコントローラを表示
    var mainMenu = mainMenuOf(tag);
    var subMenu = subMenuOf(tag);
    var labelTag = "label|" + mainMenu + "|" + subMenu;
    var elm = document.getElementById("ctrl." + labelTag);
    if (elm){
        elm.innerHTML = "";
        newTEXT(elm, "　");
        var img = newIMAGE(elm, "", "./arrowUp.png", "Up");
        img.style.height = "15px";
        img.setAttribute("onclick", "prevSubMenu('" + tag + "')");
        newTEXT(elm, " ");
        var img = newIMAGE(elm, "", "./arrowDown.png", "Down");
        img.style.height = "15px";
        img.setAttribute("onclick", "nextSubMenu('" + tag + "')");
        newTEXT(elm, " ");
        var img = newIMAGE(elm, "", "./add-field.png", "Add");
        img.style.height = "12px";
        img.setAttribute("onclick", "addSubMenu('" + tag + "')");
        newTEXT(elm, " ");
        var img = newIMAGE(elm, "", "./remove-field.png", "Remove");
        img.style.height = "12px";
        img.setAttribute("onclick", "removeSubMenu('" + tag + "')");
        
        // controller 位置へスクロール
        var pos = getPosition(elm);
        window.scroll(0, pos.y - 50); 
    }
}
function hideSubMenuController(tag){
    // タイトル右のコントローラを隠す
    var elm = document.getElementById("ctrl." + tag);
    if (elm) elm.innerHTML = "";
}

var _mainMenus;
var _mainMenuNumber;
function showSubMenuFor(mainMenu){
    // mainMenu に所属する subMenu を表示
    var tag = mainMenu;
	var tbl = document.getElementById("mapTable");
    var tr = newTR(tbl, "", "");
    tr.style.border = "thin solid #aaa";
    
    // MAIN MENU
    var td = newTD(tr, "", "");
    td.style.padding = "0px 5px";
    td.style.border = "thin solid #888";
    td.style.verticalAlign = "top";
    var sp = newSPAN(td, tag);
    sp.innerHTML = mainMenu;
    sp.setAttribute("onclick", "setCurrentMenu('" + tag + "')");
    var sp = newSPAN(td, "ctrl." + tag);
    
    // SUB MENU AREA
    var td = newTD(tr, "", "");
    td.style.border = "thin solid #888";
    var tbl2 = newTABLE(td, "frameTable");
    var obj = subMenuObjForMainMenu(mainMenu);
    if (obj){
        // subMenu ファイルの内容を表示
        for (subMenu in obj){
            var tr2 = newTR(tbl2, "", "");
            var td2 = newTD(tr2, "", "");
            // SUB MENU LABEL
            var tag1 = "label|" + mainMenu + "|" + subMenu;
            var sp = newSPAN(td2, tag1);
            sp.innerHTML = subMenu;
            sp.style.padding = "0px 10px";
            sp.setAttribute("onclick", "setCurrentMenu('" + tag1 + "')");
            // SUB MENU URI
            var tag2 = "URI|" + mainMenu + "|" + subMenu;
            var sp = newSPAN(td2, tag2);
            sp.innerHTML = obj[subMenu];
            sp.style.padding = "0px 10px";
            sp.style.color = "#00f";
            sp.setAttribute("onclick", "setCurrentMenu('" + tag2 + "')");
            var sp = newSPAN(td2, "ctrl." + tag1);
        }
    } else {
        // subMenu ファイルが無かったので、新規サブメニューを表示
        var tr2 = newTR(tbl2, "", "");
        var td2 = newTD(tr2, "", "");
        // SUB MENU LABEL
        var subMenu = "新規サブメニュー";
        var tag1 = "label|" + mainMenu + "|" + subMenu;
        var sp = newSPAN(td2, tag1);
        sp.innerHTML = subMenu;
        sp.style.padding = "0px 10px";
        sp.setAttribute("onclick", "setCurrentMenu('" + tag1 + "')");
        // SUB MENU URI
        var tag2 = "URI|" + mainMenu + "|" + subMenu;
        var sp = newSPAN(td2, tag2);
        sp.innerHTML = "URI";
        sp.style.padding = "0px 10px";
        sp.style.color = "#00f";
        sp.setAttribute("onclick", "setCurrentMenu('" + tag2 + "')");
        var sp = newSPAN(td2, "ctrl." + tag1);
    }
    
    // _meinMenus 全てをスキャンするまで再起的にサーバへリクエスト　
    if (++_mainMenuNumber < _mainMenus.length){
        getSubMenu(_mainMenus[_mainMenuNumber]);
    } else {
        // subMenu の読み込みが終了した
        var tag = currentMenu();
        if (tag) showController(tag);
    }
}
function showMenu(){
    // mainMenu を表示
    var mObj = menuObj();
	var elm = document.getElementById("contents");
	elm.innerHTML = "";
    var tbl = newTABLE(elm, "mapTable");
    
    // mainMenu の配列を生成
    _mainMenus = new Array();
    for (mainMenu in mObj){
        _mainMenus.push(mainMenu);
    }
    
    // SUBMENU をサーバへリクエスト
    _mainMenuNumber = 0;
    getSubMenu(_mainMenus[_mainMenuNumber]);
}

function editorSelected(elm){
    // EDITOR の種類を切り替える
    var label = (elm) ? elm.value : "文章編集";
    
    if (label == "文章編集")
        window.open("./docEditor.php", "contents");
}

function openEditorHelp(){
	// ヘルプパネルを表示
	var win = window.open("./editorHelp.html","Help"
                          ,"width=450,height=700,scrollbars=yes,resizable=yes");
	win.focus();
}

function initEditor(){
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    
    // HEADER
    var dv = newDIV(elm, "");
    dv.style.marginTop = "5px";
    var tbl = newTABLE(elm, "frameTable");
    var tr = newTR(tbl, "titleBar", "");
    // HEADER LEFT
    var td = newTD(tr, "left", "");
    td.style.width = "100px";
    var array = ["メニュー編集","文章編集"];
    var pu = makePopupMenu(td, "editorPop", array, "メニュー編集");
    pu.setAttribute("onchange", "editorSelected(this)");
    // HEADER MIDDLE
    var td = newTD(tr, "headerMiddleArea", "INFO BOARD EDITOR");
    // HEADER RIGHT
    var td = newTD(tr, "right", "");
    var cb = newCHECKBOX(td, "", "バックアップ", 0);
    cb.setAttribute("onchange", "openOptionArea(this)");
    var td = newTD(tr, "right", "");
    td.style.width = "17px";
    var sp = newSPAN(td, "");
    var img = newIMAGE(sp, "", "./info.png", "help");
    img.style.height = "17px";
	img.setAttribute("onclick","openEditorHelp()");
    
    // OPTION AREA
    var dv = newDIV(elm, "optionArea");
    
    // CONTENTS AREA
    var dv = newDIV(elm, "contents");
    
    // FOOTER
    var dv = newDIV(elm, "");
    var tbl = newTABLE(dv, "frameTable");
    var tr = newTR(tbl, "titleBar", "");
    // LEFT
    var td = newTD(tr, "left", version());
    td.style.height = "25px";
    var sp = newSPAN(td, "");
    sp.innerHTML = " owner ( " + owner() + " )";
    // RIGHT
    var td = newTD(tr, "right", "");
    var sp = newSPAN(td, "footerRightArewa");
    var cb = newCHECKBOX(td, "", "debug", 0);
    cb.setAttribute("onclick", "setDebugMode(this)");

    // MESSAGE and DEBUG AREA
    var dv = newDIV(elm, "message");
    var dv = newDIV(elm, "_debug");
    
    getMenu();
}

function version(){
    return "Ver.120103";
}
