//////////////////////////////////////////////////////////////////////////////
// $Id: nnda-defines.h,v 1.7 2004/04/25 12:50:43 mrsa Exp $
//
// nnda-defines.h
// nnDA Data structure definition file
//
// (C) 2004, NNsi project, all rights reserved.
//

#include <PalmOS.h>

// DA creator
#define nnDA_Creator    'nnDA'
#define nnDA_TITLESIZE  16
#define nnDA_DEFTITLE   "NNsi View DA"

// UnicodeToJis0208 e[uR[h
typedef struct
{
    UInt16 size;
    UInt16 table[256];
} UnicodeToJis0208Rec;

// Jis0208ToUnicode e[uR[h
typedef struct
{
    UInt16 code;
} Jis0208ToUnicodeRec;


// nnDA AA view form globals
// structure:
struct nnDADataType
{
    UInt32        palmOSVersion;   // foCXOSo[W
    UInt16        displayCommand;  // \R}h
    FontID        fontId;          // \tHghc
    UInt16        scale;           // \{
    UInt32        os5density;      // PalmOS5̉𑜓x
    RectangleType dimF;            // \̈̃TCY(coord̈)
    RectangleType area;            // \̈̃TCY(̈)
    UInt8        *areaP;           // \f[^̃|C^
    UInt16        length;          // \f[^
    UInt16        startX;          // `Jnꏊ
    UInt16        startY;          // `Iꏊ
    UInt16        maxX;            // `f[^ő(X)
    UInt16        maxY;            // `f[^ŏ(Y)
    UInt16       *singleWidth;     // VOoCg̕
    UInt16       *doubleWidth;     // _uoCg̕
#ifdef USE_CLIE
    UInt16        hrRef;           // SONY HRQƔԍ
    UInt16        hrVer;           // Sony HR̃o[Wԍ
#endif  // #ifdef USE_CLIE
    Char          title[nnDA_TITLESIZE + 4];  // tH[̃^CgTCY
};
typedef struct nnDADataType  nnDADataType;

// ̈̊m(|C^)
#define MEMALLOC_PTR(size)    MemPtrNew(size)

// ̈̃NA(|C^)
#define MEMFREE_PTR(ptr)        \
    if (ptr != NULL)            \
    {                           \
        MemPtrFree(ptr);        \
        ptr = NULL;             \
    }

// global feature id:
#define ADT_FTRID       1
#define ADT_FTRID_MEM   2

// other definitions...
#define BUFSIZE        48
#define MARGIN         16
#define BUF_MARGIN    128
#define DISP_LIMIT  10240

// NNsiƂ̘Ag@\p`
#define nnDA_NNSIEXT_VIEWSTART    "<NNsi:NNsiExt type=\"VIEW\">"
#define nnDA_NNSIEXT_ENDVIEW      "</NNsi:NNsiExt>"
#define nnDA_NNSIEXT_INFONAME     "<NNsi:Info>"
#define nnDA_NNSIEXT_ENDINFONAME  "</NNsi:Info>"

#define nnDA_NNSIEXT_UTF8FILE     "UTF8FILE:"
#define nnDA_NNSIEXT_UTF8FILEFOLD "UTF8FOLDFILE:"
#define nnDA_NNSIEXT_BINFILE      "BFILE:"
#define nnDA_NNSIEXT_FILE         "FILE:"
#define nnDA_NNSIEXT_FILE_FOLD    "FOLDFILE:"
#define nnDA_NNSIEXT_HELPLIST     "HELP:LIST"
#define nnDA_NNSIEXT_HELPVIEW     "HELP:VIEW"
#define nnDA_NNSIEXT_HELPUSERTAB  "HELP:FAVORTAB"
#define nnDA_NNSIEXT_HELPNNSISET  "HELP:NNSISET"
#define nnDA_NNSIEXT_HELPGETLOG   "HELP:GETLOG"


#define nnDA_TITLE_HELP_LIST      "ꗗʑ"
#define nnDA_TITLE_HELP_VIEW      "QƉʑ"
#define nnDA_TITLE_HELP_USERTAB   "[U^u"
#define nnDA_TITLE_HELP_NNSISET   "NNsiݒ"
#define nnDA_TITLE_HELP_GETLOG    "QƃOꗗʑ"

#define nnDA_DISPCOMMAND_NOTHING  0   // R}hwȂ
#define nnDA_DISPCOMMAND_FOLD     1   // [Ő܂Ԃ

// from SonyChars.h
#ifndef vchrJogPushedDown
  #define vchrJogPushedDown     (0x1704)
#endif
#ifndef vchrJogPushedUp
  #define vchrJogPushedUp       (0x1703)
#endif
#ifndef vchrJogUp
  #define vchrJogUp             (0x1700)
#endif
#ifndef vchrJogDown
  #define vchrJogDown           (0x1701)
#endif
#ifndef vchrJogPush
  #define vchrJogPush           (0x1705)
#endif
#ifndef vchrJogRelease
  #define vchrJogRelease        (0x1706)
#endif
#ifndef vchrJogBack
  #define vchrJogBack           (0x1707)
#endif

#ifndef vchrJogLeft
  #define vchrJogLeft           (0x1708)
#endif

#ifndef vchrJogRight
  #define vchrJogRight          (0x1709)
#endif

///// from PalmChars.h
#ifndef vchrNavChange
  #define vchrNavChange           (vchrPalmMin + 3)

  #define navBitUp                0x0001
  #define navBitDown              0x0002
  #define navBitLeft              0x0004
  #define navBitRight             0x0008
  #define navBitSelect            0x0010
  #define navBitsAll              0x001F

  #define navChangeUp             0x0100
  #define navChangeDown           0x0200
  #define navChangeLeft           0x0400
  #define navChangeRight          0x0800
  #define navChangeSelect         0x1000
  #define navChangeBitsAll        0x1F00
#endif

#ifdef USE_CLIE
/***** Sony HR-Lib *****/
#define sonySysFileCHRLib         'SlHr'             /* High Resolution */
#define sonySysFileTHRLib         sysFileTLibrary    /* 'libr' */
#define sonySysLibNameHR          "Sony HR Library"

/***** SONY High Resolution LIBRARY (from SonyHRLib.h)  *****/
#define HR_VERSION_SUPPORT_FNTSIZE        (0x200)
#define hrWidth                           320
#define hrHeight                          320

#define HR_TRAP(trapNum)                  SYS_TRAP(trapNum)

#define HRTrapGetAPIVersion               (sysLibTrapCustom)
#define HRTrapWinScreenMode               ((sysLibTrapCustom)+48)
#define HRTrapWinEraseRectangle           ((sysLibTrapCustom)+21)
#define HRTrapWinDrawChar                 ((sysLibTrapCustom)+8)

extern Err  HROpen(UInt16 refNum)
                                           HR_TRAP(sysLibTrapOpen);
extern Err  HRClose(UInt16 refNum)
                                           HR_TRAP(sysLibTrapClose);
extern Err  HRGetAPIVersion(UInt16 refNum, UInt16 *versionP)
                                           HR_TRAP(HRTrapGetAPIVersion);
extern Err  HRWinScreenMode(UInt16 refNum, WinScreenModeOperation operation, UInt32 *widthP, UInt32 *heightP, UInt32 *depthP, Boolean *enableColorP)
                                           HR_TRAP(HRTrapWinScreenMode);
extern void HRWinEraseRectangle(UInt16 refNum, RectangleType *rP, UInt16 cornerDiam)
                                           HR_TRAP(HRTrapWinEraseRectangle);
extern void HRWinDrawChar(UInt16 refNum, WChar theChar, Coord x, Coord Y)
                                           HR_TRAP(HRTrapWinDrawChar);
#endif
