/*============================================================================*
 *  FILE: 
 *     netent.c
 *
 *  Description: 
 *     lbg[NʐMق̃Gg|Cg
 *
 *===========================================================================*/
#define NETENT_C
#include "local.h"

/*==========================================================================*/
/*  NNshHttp_comm() : HTTPʐM                                              */
/*                                                                          */
/*==========================================================================*/
Err NNshHttp_comm(UInt16 type, Char *url, Char *cookie, Char *appendData,
                  UInt32 range, UInt32 endRange, Char *message)
{
    UInt16  lp, savedParam, port, sslMode;
    Char   *proxy;
    Err     ret;
    Boolean retry;

    retry   = false;
    sslMode = NNSH_SSLMODE_NOTSSL;
    proxy   = NULL;
    port    = 80;
    if (NNshParam->useProxy != 0)
    {
        port  = NNshParam->proxyPort;
        proxy = NNshParam->proxyURL;
    }
#ifdef USE_SSL
    else
    {
        // httpsvgȐꍇAAA
        if ((url[0] == 'h')&&(url[1] == 't')&&(url[2] == 't')&&(url[3] == 'p')&&
            (url[4] == 's')&&(url[5] == ':'))
        {
            sslMode = NNSH_SSLMODE_SSLV3;
            port    = 443;
            proxy   = NULL;
        }
    }
#endif

    // gCJE^[NA
    lp = 0;
    do
    {
        // httpʐMs
        ret = NNshHttp_commMain(type, url, cookie, appendData,
                                range, endRange, port, proxy, message, sslMode);
        lp++;

        // ܂ڑłȂꍇ́Ax؂
        if (ret == NNSH_ERRORCODE_FAILURECONNECT)
        {
            if (lp > NNshParam->nofRetry)
            {
                if (retry != true)
                {
                    //  gC񐔂𒴂ĂڑłȂꍇɂ́A
                    // x؂čĐڑ
                    savedParam = NNshParam->confirmationDisable;
                    NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
                    NNshNet_LineHangup();
                    NNshParam->confirmationDisable = savedParam;
                    ret = netErrTimeout;
                    lp  = 0;
                    retry = true;
                }
            }
            else
            {
                // gC񐔓B܂ł́AĐڑ{
                ret = netErrTimeout;
            }
        }
    } while ((lp <= NNshParam->nofRetry)&&(ret == netErrTimeout));
    return (ret);
}

/*==========================================================================*/
/*  NNshNet_LineHangup() : ؒf                                         */
/*                                                                          */
/*==========================================================================*/
void NNshNet_LineHangup(void)
{
    UInt16         netRef;

    if (NNshGlobal->netRef == 0)
    {
        // lbgCũI[v
        (void) SysLibFind("Net.lib", &(netRef));
    }
    else
    {
        netRef = NNshGlobal->netRef;
    }

    // ؒf̊mF
    if ((netRef != 0)&&
        (NNsh_ConfirmMessage(ALTID_CONFIRM,
                             MSG_MESSAGE_DISCONNECT, "", 0) == 0))
    {
        Show_BusyForm(MSG_DISCONNECT_WAIT);
        (void) NetLibClose(netRef, true);           // N[Y
        (void) NetLibFinishCloseWait(netRef);       // ڑ҂ؒf
        NNshGlobal->netRef = 0;

        Hide_BusyForm(true);
    }
    return;
}

/*==========================================================================*/
/*  WebBrowserCommand() : WebBrowserĂяo֐                            */
/*                                               Ă邩ȁH     */
/*==========================================================================*/
Err WebBrowserCommand(UInt32 creator, UInt16 subLaunch, UInt16 flags,
                      UInt16 cmd, Char *parameterP, UInt32 *resultP)
{
    Char             *newParamP;
    UInt32            result;
    UInt16            cardNo, size;
    LocalID           dbID;
    DmSearchStateType searchState;
    Err               ret;

    if (resultP != NULL)
    {
        *resultP = errNone;
    }
    // WebBrowserCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, creator, 
                                         true, &cardNo, &dbID);
    if (ret != errNone)
    {
        // WebBrowser(NetFront)CXg[ĂȂ
        NNsh_InformMessage(ALTID_ERROR, MSG_CANNOTFIND_BROWSER, "", ret);
        return (ret);
    }
    
    // childfork邩AIfork邩subLaunchŔ
    // IforkȂƓȂ̂
    if (subLaunch == 0)
    {
        // (NNsi)UIWebBrowserNꍇ
        if (parameterP != NULL)
        {
            // itqkj̈mۂ
            size = StrLen(parameterP);
            newParamP = MemPtrNew(size + MARGIN);
            if (newParamP == NULL)
            {
                // \ȃmۂłȂAG[
                return (memErrNotEnoughSpace);
            }
            MemSet  (newParamP, (size + MARGIN), 0x00);
            StrNCopy(newParamP, parameterP, size);

            // AvIĂ͎̈c悤ɂ
            MemPtrSetOwner(newParamP, 0);

            // AvP[VN
            ret = SysUIAppSwitch(cardNo, dbID, cmd, newParamP);
        }
    }
    else
    { 
        // Ȃ񂩂܂Ȃ...
        if (parameterP != NULL)
        {
            // itqkj̈mۂ
            size = StrLen(parameterP);
            newParamP = MemPtrNew(size + MARGIN);
            if (newParamP == NULL)
            {
                // \ȃmۂłȂAG[
                return (memErrNotEnoughSpace);
            }
            MemSet  (newParamP, (size + MARGIN), 0x00);
            StrNCopy(newParamP, parameterP, size);

            // AvP[Vfork(SubLaunch̏ꍇ)
            ret = SysAppLaunch(cardNo, dbID, flags, cmd, newParamP, &result);
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_ERROR, "SysAppLaunch()", "", ret);
                // ͌p //
            }
            if (resultP != NULL)
            {
                *resultP = result;
            }
            MemPtrFree(newParamP);
        }
    }
    return (ret);
}

/*==========================================================================*/
/*  OpenNetworkPreferences() : lbg[NݒʌĂяo֐             */
/*                                                  Ă邩ȁH  */
/*==========================================================================*/
void OpenNetworkPreferences(void)
{
    Err                  ret;
    UInt16               cardNo;
    LocalID              dbID;
    DmSearchStateType    state;

    // ϐ̏
    cardNo = 0;
    MemSet(&state, sizeof(state), 0x00);

    // lbg[Nݒʂ̃\[XƂĂB
    ret = DmGetNextDatabaseByTypeCreator(true, &state, sysFileTPanel,
                                         sysFileCNetworkPanel,
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // \[XƂɂ́AݒʂJ
        SysUIAppSwitch(cardNo, dbID, sysAppLaunchCmdPanelCalledFromApp, NULL);
    }
    return;
}

#ifdef USE_BT_CONTROL
/*==========================================================================*/
/*  OpenBluetoothPreferences() : BlutoothݒʌĂяo֐               */
/*                                                  Ă邩ȁH  */
/*==========================================================================*/
void OpenBluetoothPreferences(Boolean val)
#ifdef USE_BTTOGGLE_SDK
{
    UInt16            cardNo, code; 
    LocalID           dbID; 
    DmSearchStateType state;
    Err               err;
    UInt32            result;

    // BtToggleCXg[Ă邩ׂ
    err = DmGetNextDatabaseByTypeCreator(true, &state, 0, BtToggle_CRID, 
                                                         true, &cardNo, &dbID);
    if (err == errNone)
    {
        // BtToggleCXg[ĂAAA
        if (val == true)
        {
            code = BtToggleLaunchCmdBtOn;
        }
        else
        {
            code = BtToggleLaunchCmdBtOff;
        }
        SysAppLaunch(cardNo, dbID, 0, code, NULL, &result);
   }
   return;
}
#else
{
    Err                      ret;
    Int16                    ver;
    UInt16                   cardNo, size, btRefNum;
    LocalID                  dbID;
    DmSearchStateType        state;
    SvcCalledFromAppPBType  *data;
    UInt32                   creatorId;
    BluetoothPanelPrefsType *btPrefData;

    // ϐ̏
    cardNo = 0;
    MemSet(&state, sizeof(state), 0x00);

    // Bluetoothݒʂ̃\[XƂĂB
    creatorId = sysFileCBluetoothPanel;
    ret = DmGetNextDatabaseByTypeCreator(true, &state, sysFileTPanel,
                                         creatorId, true, &cardNo, &dbID);
    if (ret != errNone)
    {
        creatorId = sysFileCBluetoothPanelOld;

        // OS5ȑOBluetoothݒʂ̃\[XƂĂ
        ret = DmGetNextDatabaseByTypeCreator(true, &state, sysFileTPanel,
                                             creatorId, true, &cardNo, &dbID);
    }
    if (ret == errNone)
    {
        // bluetooth library
        {
            // btRefNum擾
            ret = SysLibFind(btLibName, &btRefNum);
            if (ret == sysErrLibNotFound)
            {
                // bluetooth library[h̏ꍇA[hł邩TryĂ݂B
                ret = SysLibLoad(sysFileTLibrary, sysFileCBtLib, &btRefNum);
            }
            NNsh_DebugMessage(ALTID_INFO, "SysLibLoad()", " ", ret);
            if (ret == errNone)
            {
                // Bluetooth LibrarySăN[Y (ꓬ...)
                ret =  BtLibOpen(btRefNum, false);
                NNsh_DebugMessage(ALTID_INFO, "BtLibOpen()", " ", ret);

                if (val == true)
                {
                    // BluetoothN
                    BtLibWake(btRefNum);
                    NNsh_DebugMessage(ALTID_INFO, "BtLibWake()", " ", ret);              
                }
                else
                {
                    // bluetoothx~
                    ret = BtLibSleep(btRefNum);
                    NNsh_DebugMessage(ALTID_INFO, "BtLibSleep()", " ", ret);              
                }

                // BtLibN[Y
                ret = btLibErrNoError;
                while (ret == btLibErrNoError)
                {
                    ret = BtLibClose(btRefNum);
                    NNsh_DebugMessage(ALTID_INFO, "BtLibClose()", " ", ret);
                }
            }
            else
            {
                btRefNum = 0;
            }
        }

        // Bt Panel Preference擾
        size = sizeof(BluetoothPanelPrefsType) + sizeof(SvcCalledFromAppPBType);
        data = MemPtrNew(size);
        if (data == NULL)
        {
            // \ȃmۂłȂAG[
            return;
        }
        MemSet(data, size, 0x00); 
        btPrefData = (BluetoothPanelPrefsType *) (data + 1);
        size = sizeof(BluetoothPanelPrefsType);
        ver = PrefGetAppPreferences(creatorId, kBluetoothPanelPrefID, 
                                    btPrefData, &size, true);
        if (ver != kBluetoothPanelPrefVersion)
        {
            NNsh_DebugMessage(ALTID_ERROR, "BtPanelPref:not match version", " ->", ver);
            return;
        }
        NNsh_DebugMessage(ALTID_INFO, btPrefData->friendlyName, 
                          "  BtOnOff:", btPrefData->bBlueTooth);

        // (Bt Panel PreferenceݒlύXAo^)
        btPrefData->bBlueTooth = val;
        PrefSetAppPreferences(creatorId, kBluetoothPanelPrefID, ver, 
                              btPrefData, size, true);

        // plJāABtgpݒ؂ւw
        data->cmd = svcCFACmdSetBtOnOff;
        data->data.bValue = btPrefData->bBlueTooth;

        // AvIĂ͎̈c悤ɂ
        MemPtrSetOwner(data, 0);

        // \[XƂɂ́AݒʂJ
        ret = SysUIAppSwitch(cardNo, dbID, sysAppLaunchCmdPanelCalledFromApp, data);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "SysUIAppSwitch()", " ret:", ret);
            // ͌p //
        }
    }
    return;
}
#endif  // #ifdef USE_BTTOGGLE_SDK
#endif  // #ifdef USE_BT_CONTROL

