/*============================================================================*
 *  FILE: 
 *     getlog.c
 *
 *  Description: 
 *     QƐpÕO擾
 *===========================================================================*/
#define GETLOG_C
#include "local.h"

#ifdef USE_LOGCHARGE

/*--------------------------------------------------------------------------*/
/*  getLogFileList() : Ot@C擾ׂURL̈ꗗ擾        */
/*                                                                          */
/*                                                                          */
/*        ̊֐̈ŁAXVf[^ : urlCnt, listArray, urlList */
/*--------------------------------------------------------------------------*/
static Err getLogFileList(Char *fileName, NNshGetLogDatabase *dbData, UInt16 *urlCnt, Char **listArray, Char **urlList)
{
    Err           ret;
    UInt16        maxCnt, maxSize, bufCnt, status;
    UInt32        offset, readSize;
    Char         *buffer, *ptr, *chkPtr, tempURL[MAX_URL], *urlPtr, *urlArray, *baseURL, *ptr2;
    NNshFileRef   fileRef;
    
    // 擾URLꗗ̍őTCYϐɔf
    maxCnt = *urlCnt;

    // 擾̃x[XƂȂURL𔽉f
    baseURL = dbData->dataURL;

    // ϐNA
    *urlCnt = 0;
    *listArray  = NULL;

    // URLꗗ̊i[̈mۂ
    maxSize = (MAX_URL + 1) * maxCnt + MARGIN;
    *urlList = MemPtrNew(maxSize);
    if (*urlList == NULL)
    {
        return (~errNone);
    }
    MemSet(*urlList, maxSize, 0x00);
    urlArray = *urlList;

    // t@Cǂݍݗ̈mۂ
    maxSize = NNshParam->bufferSize - maxSize;
    buffer = MemPtrNew(maxSize);
    if (buffer == NULL)
    {
        MEMFREE_PTR(*urlList);
        return (~errNone);
    }
    MemSet(buffer, maxSize, 0x00);
    maxSize = maxSize - MARGIN;    

    // t@C̃I[v
    ret = OpenFile_NNsh(fileName, NNSH_FILEMODE_READONLY, &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", fileName, ret);
        MEMFREE_PTR(buffer);
        MEMFREE_PTR(*urlList);
        return (ret);
    }

    // t@Cf[^ubNƂɎ擾
    status = NNSH_MSGTOKENSTATE_NONE;
    offset = 0;
    while ((ret == errNone)&&(status != NNSH_MSGTOKENSTATE_END))
    {
        readSize = 0;
        MemSet(buffer, maxSize, 0x00);
        ret  = ReadFile_NNsh(&fileRef, offset, maxSize, buffer, &readSize);
        if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
        {        
            // t@Cǂ݂݃G[AI
            NNsh_InformMessage(ALTID_ERROR, "ReadFile_NNsh() :", fileName, ret);
            break;
        }

        if (status == NNSH_MSGTOKENSTATE_END)
        {
            // ؂f[^̖܂ŌĂяoĂAbZ[W͏Ȃ
            if (ret != errNone)
            {
                break;
            }
            continue;
        }

        // f[^̐擪
        chkPtr = buffer;
        if (status == NNSH_MSGTOKENSTATE_NONE)
        {
            //  擪̋؂蕶T
            if (dbData->dataStart[0] != 0)
            {
                ptr = StrStr(buffer, dbData->dataStart);
                if (ptr == NULL)
                {
                    // f[^擪̋؂肪ȂA͏I
                    continue;
                }
                ptr = ptr + StrLen(dbData->dataStart);
                chkPtr = ptr;
                status = NNSH_MSGTOKENSTATE_MESSAGE;
            }
            else
            {
                status = NNSH_MSGTOKENSTATE_MESSAGE;
            }
        }
        if (status == NNSH_MSGTOKENSTATE_MESSAGE)
        {
            // ̋؂蕶Ă邩T
            if (dbData->dataEnd[0] != 0)
            {
                ptr = StrStr(buffer, dbData->dataEnd);
                if (ptr != NULL)
                {
                    // f[^𔭌I f[^͂܂łƂ
                    status = NNSH_MSGTOKENSTATE_END;
                    readSize = (ptr - buffer) + StrLen(dbData->dataEnd);
                }
            }
        }
        
        // AJ[T
        while ((chkPtr != NULL)&&(chkPtr < buffer + readSize))
        {
            // 啶AJ[ƏAJ[̗܂܂邩`FbN
            ptr = StrStr(chkPtr, "<a");
            ptr2 = StrStr(chkPtr, "<A");
                
            // AJ[Ȃ        
            if ((ptr == NULL)&&(ptr2 == NULL))
            {
                // Ƃ肠AƂ߂Ă݂B
                if (readSize > MARGIN)
                {
                    readSize = readSize - MARGIN;
                }
                // t@C̎̃ubNֈړ
                break;
            }

            // 啶AJ[̕AJ[Oɂ
            if ((ptr2 != NULL)&&(ptr > ptr2))
            {
                ptr = ptr2;
            }

            // AJ[AAAhrefAgr[gT
            chkPtr = ptr;
            while (ptr < buffer + readSize)
            {
                if (((*ptr == 'h')||(*ptr == 'H'))&&
                    ((*(ptr + 1) == 'r')||(*(ptr + 1) == 'R'))&&
                    ((*(ptr + 2) == 'e')||(*(ptr + 2) == 'E'))&&
                    ((*(ptr + 3) == 'f')||(*(ptr + 3) == 'F')))
                {
                    // hrefAgr[g
                    ptr = ptr + 4; // hrefǂݔ΂
                    while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr != 0x00))
                    {
                        ptr++;
                    }
                    if (*ptr == 0x00)
                    {
                       // AJ[̓rŃobt@؂ꂽBBB
                       readSize = (UInt32) (chkPtr - buffer);
                       chkPtr = NULL;
                       break;
                    }
                    ptr++;
                    
                    //f[^؂o
                    bufCnt = 0;
                    MemSet(tempURL, MAX_URL, 0x00);
                    urlPtr = tempURL;
                    while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr != 0x00)&&(bufCnt < (MAX_URL - 2)))
                    {
                        *urlPtr = *ptr;
                        urlPtr++;
                        ptr++;
                        bufCnt++;
                    }
                    if (*ptr == 0x00)
                    {
                       // AJ[̓rŃobt@؂ꂽBBB
                       readSize = (UInt32) (chkPtr - buffer);
                       chkPtr = NULL;
                       break;
                    }
                    // tempURLɐ؂oURLAꂪ(擾̂)ÓURL`FbN
                    chkPtr = ptr;

                    // x
                    ptr = StrStr(tempURL, "#");
                    if (ptr != NULL)
                    {
                        // #tĂAÓURLł͂Ȃ
                        chkPtr = ptr;
                        break;
                    }
                    ptr = tempURL;
                    if (((*ptr == 'h')||(*ptr == 'H'))&&
                        ((*(ptr + 1) == 't')||(*(ptr + 1) == 'T'))&&
                        ((*(ptr + 2) == 't')||(*(ptr + 2) == 'T'))&&
                        ((*(ptr + 3) == 'p')||(*(ptr + 3) == 'P')))
                    {
                        // httpvgR(URL)tAÓURLAURLXgɓo^
                        // (ő僊Nȉ̏ꍇ)
                        if (*urlCnt < maxCnt)
                        {
                            StrCopy(urlArray, tempURL);                        
                            listArray[*urlCnt] = urlArray;
                            urlArray = urlArray + StrLen(urlArray) + 1;
                            (*urlCnt)++;
                        }
                        break;
                    }

                    // x[XURL炩߃Rs[
                    StrCopy(urlArray, baseURL);
                    ptr = urlArray + StrLen(urlArray) - 1;
                    // '/'T
                    while ((ptr > urlArray)&&(*ptr != '/'))
                    {
                        ptr--;
                    }
                    ptr++;

                    // 擪̕mFRs[
                    if ((tempURL[0] == '.')||(tempURL[0] == '/'))
                    {
                        // ΃AhXpXH( '/'͂ƈُ킾ǁAAA)
                        StrCopy(ptr, &tempURL[1]);
                    }
                    else
                    {
                        StrCopy(ptr, tempURL);
                    }
                    // (ő僊Nȉ̏ꍇAURLƂēo^)
                    if (*urlCnt < maxCnt)
                    {
                        listArray[*urlCnt] = urlArray;
                        urlArray = urlArray + StrLen(urlArray) + 1;
                        (*urlCnt)++;
                    }
                    break;
                }                   // if (((*ptr == 'h')||(*ptr == 'H'))&& ...
                ptr++;
            }                           // while (ptr < buffer + readSize)
        }                                    // while (chkPtr != NULL)
        offset = offset + readSize;
    }                                            // while (ret == errNone)
    ret = errNone;

    // Ƃ܂
    CloseFile_NNsh(&fileRef);
    MEMFREE_PTR(buffer);
    return (ret);
}

/*--------------------------------------------------------------------------*/
/*  ReadOnlyLogDataPickup() : QƐpÕO擾                  */
/*                                                                          */
/*                                                                          */
/*                    ̊֐̈ŁAXVf[^ : url, fileName  */
/*--------------------------------------------------------------------------*/
Err ReadOnlyLogDataPickup(NNshGetLogDatabase *dbData, Char *url, Char *fileName, UInt16 recNum, UInt16 depth, UInt16 number)
{
    Err                  ret;
    Boolean              workAround;
    UInt16               index, bufSize, kanjiCode;
    UInt32               readSize, offset, dummy, offsetW;
    DmOpenRef            subjRef;
    Char                *ptr, *file, *realBuf, *chk;
    NNshSubjectDatabase *subjDb;
    NNshFileRef          fileRefR, fileRefW;

    // ̈mۂ
    bufSize = sizeof(NNshSubjectDatabase) + MARGIN;
    subjDb = MemPtrNew(bufSize);
    if (subjDb == NULL)
    {
        // ꎞ̈̊mۂɎs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", bufSize);
        return (~errNone);
    }
    MemSet(subjDb, sizeof(NNshSubjectDatabase) + MARGIN, 0x00);
  
    // w肳ꂽURL\
    NNsh_DebugMessage(ALTID_INFO, "url:", url, 0);

    // R[h
    kanjiCode = dbData->kanjiCode;

    // ꎞobt@̈m
    bufSize = NNshParam->bufferSize + MARGIN;
    realBuf = MemPtrNew(bufSize);
    if (realBuf == NULL)
    {
        // ꎞ̈̊mۂɎs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", bufSize);
        MEMFREE_PTR(subjDb);
        return (~errNone);
    }
    MemSet(realBuf, bufSize, 0x00);
    bufSize = bufSize - MARGIN;

    // Xf[^x[X̃I[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &subjRef);
    if (subjRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", " ", 0);
        MEMFREE_PTR(subjDb);
        MEMFREE_PTR(realBuf);
        return (~errNone);
    }

    // ot@C̓ƁAXcaɏރf[^
    if (StrLen(fileName) != 0)
    {
        // Ƀt@Cw肳Ăꍇɂ́Ãt@Cgp
        //                                      (t@CXDBɊi[)
        StrNCopy(subjDb->threadFileName, fileName, MAX_THREADFILENAME);
    }
    MemSet(fileName, sizeof(fileName), 0x00);

    // OFFLINEXVFSɊi[ꍇɂ́AfBNgtB
    workAround = false;
    if ((NNshParam->useVFS & NNSH_VFS_USEOFFLINE) != 0)
    {
        // Ox[XfBNgt
        if ((NNshGlobal->logPrefixH == 0)||
            ((ptr = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
        {
            StrCopy(fileName, LOGDATAFILE_PREFIX);
        }
        else
        {
            StrCopy(fileName, ptr);
            MemHandleUnlock(NNshGlobal->logPrefixH);
        }
        subjDb->msgState = FILEMGR_STATE_OPENED_VFS; 

        // CLIE4pstOĂ邩`FbN
        if ((NNshParam->useVFS & NNSH_VFS_WORKAROUND) != 0)
        {
            workAround = true;
        }       
    }
    else
    {
        subjDb->msgState = FILEMGR_STATE_OPENED_STREAM;        
    }    
    StrCopy(subjDb->threadTitle, dbData->dataTitlePrefix);
    StrCopy(subjDb->boardNick, OFFLINE_THREAD_NICK);
    subjDb->state = NNSH_SUBJSTATUS_UNKNOWN;

    // Ot@C̍\z
    file = &fileName[StrLen(fileName)];
    if (StrLen(subjDb->threadFileName) != 0)
    {
        // Ƀt@Cw肳Ăꍇ(̃t@C𗘗p)
        StrCat(fileName, subjDb->threadFileName);
    }
    else
    {
        // Ƀt@Cw肳ĂȂꍇ(IɃt@C𐶐)
        StrCat (fileName, FILE_LOGCHARGE_PREFIX);
        NUMCATI(fileName, recNum);
        StrCat (fileName, "-");
        NUMCATI(fileName, depth);
        StrCat (fileName, "-");
        NUMCATI(fileName, number);    
        StrCat (fileName, FILE_LOGCHARGE_SUFFIX);    
        StrNCopy(subjDb->threadFileName, file, MAX_THREADFILENAME);
    }

////////  _CNgwꍇɂ́Aɖ߂ĂƂȂ\  ////////
GET_URL_DATA:

    // f[^̎擾
    ret = NNshHttp_comm(HTTP_SENDTYPE_GET_NOTMONA, url, NULL, NULL,
                        HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
    if (ret != errNone)
    {
        // (^CAEgȊO)ʐMG[
        if (ret != netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR,MSG_ERROR_HTTP_COMM, "[logCharge]", ret);
            goto FUNC_END;
        }

        // ʐM^CAEg
        NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "[logCharge]", ret);
        goto FUNC_END;
    }

    // ǂݏot@C̃I[v
    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRefR);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", FILE_RECVMSG, ret);
        goto FUNC_END;
    }

    // ݃t@C̃I[v
    ret = OpenFile_NNsh(fileName, NNSH_FILEMODE_CREATE, &fileRefW);
    if (ret != errNone)
    {
        CloseFile_NNsh(&fileRefR);
        NNsh_DebugMessage(ALTID_ERROR, "Write File Open :", fileName, ret);
        goto FUNC_END;
    }

    // BUSYEBhE\
    Show_BusyForm(MSG_MESSAGE_ENTRY);

    // f[^̓ǂݏo
    readSize = 0;
    MemSet(realBuf, bufSize, 0x00);
    ret  = ReadFile_NNsh(&fileRefR, 0, bufSize, realBuf, &readSize);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read Failure :", FILE_RECVMSG, ret);
        goto CLOSE_END;
    }
    
    // if ((StrNCompare(realBuf,"HTTP/1.1 3", 10) == 0)||
    //     (StrNCompare(realBuf,  "HTTP/1.0 3", 10) == 0))
    if ((realBuf[0] == 'H')&&(realBuf[1] == 'T')&&(realBuf[2] == 'T')&&
        (realBuf[3] == 'P')&&(realBuf[9] == '3'))
    {
        // {ȂA"Location:" TׂA
        ptr = StrStr(realBuf, "http://");
        if (ptr != NULL)
        {
            // _CNgĂAAAʂURLēxf[^蒼
            Hide_BusyForm(false);
            CloseFile_NNsh(&fileRefR);
            CloseFile_NNsh(&fileRefW);
        
            chk = ptr;
            // f[^̖T
            while ((*chk != 0x0d)&&(chk < ptr + (MAX_URL - 1)))
            {
                chk++;
            }
            chk = 0x00;

            // VURLRs[
            MemSet(url, MAX_URL, 0x00);
            StrNCopy(url, ptr, MAX_URL);

            // f[^̍ēx蒼
            goto GET_URL_DATA;
        }
    }

    // R[h̃`FbN
    ptr = StrStr(realBuf, "charset=");
    if (ptr != NULL)
    {
        // ǂݔ΂
        ptr = ptr + StrLen("charset=");
        
        // 󔒕ǂݔ΂
        while ((*ptr == ' ')||(*ptr == '\t'))
        {
            ptr++;
        }
        if (StrNCaselessCompare(ptr, "iso-2022-jp", StrLen("iso-2022-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_JIS;
        }
        else if (StrNCaselessCompare(ptr, "euc-jp", StrLen("euc-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_EUC;
        }
        else if (StrNCaselessCompare(ptr, "x-euc-jp", StrLen("x-euc-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_EUC;
        }
        else if (StrNCaselessCompare(ptr, "shift_jis", StrLen("shift_jis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "x-sjis", StrLen("x-sjis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "shift-jis", StrLen("shift-jis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
    }

    // f[^̐擪T
    ptr = StrStr(realBuf, NNSH_HTTP_HEADER_ENDTOKEN);
    if (ptr == NULL)
    {
        // 擪Ȃ΁Af[^ubN̍ŏ͂
        NNsh_DebugMessage(ALTID_ERROR, "Data Failure :", FILE_RECVMSG, ret);
        ptr = realBuf;
    }

    // Rs[f[^̕␳
    //     ptrf[^{fB̐擪ɎĂB
    //     offsetǂݏot@C̐擪̃ItZbgĂB
    ptr = ptr + 4;   // 4́AStrLen(NNSH_HTTP_HEADER_ENDTOKEN) ƓB
    offset = (UInt32) (ptr - realBuf);

    // ^Cg̎擾
    file = StrStr(ptr, "<title>");
    if (file == NULL)
    {
        // ^Cg^OłȂꍇ...
        file = StrStr(ptr, "<TITLE>");
    }
    if (file != NULL)
    {
        file = file + StrLen("<TITLE>");
        chk = file;
        // ^Cgf[^̖T
        while ((*chk != '\0')&&(*chk != '<'))
        {
            chk++;
        }
        *chk = '\0';

        // X^Ci[̈Ƀf[^i[(R[h̕ϊYȂI)
        dummy = StrLen(subjDb->threadTitle);
        switch (kanjiCode)
        {
          case NNSH_KANJICODE_EUC:
            // EUC -> SJϊĊi[
            chk = MemPtrNew(StrLen(file) + MARGIN);
            if (chk != NULL)
            {
                StrCopySJ(chk, file);
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MemPtrFree(chk);
            }
            break;

          case NNSH_KANJICODE_JIS:
            // JIS -> SJϊĊi[(JIS...)
            chk = MemPtrNew(StrLen(file) + MARGIN);
            if (chk != NULL)
            {
                StrCopyJIStoSJ(chk, file);
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MemPtrFree(chk);
            }
             break;
 
          case NNSH_KANJICODE_SHIFTJIS:
          default:
            // ̂܂܊i[
            StrNCopy(&subjDb->threadTitle[dummy], file, MAX_THREADNAME - dummy - 1);
            break;
        }
    }

    // ɓǂݍ߂Ƃ́Af[^̃{fBt@CɃRs[
    ret = errNone;
    offsetW = 0;
    while (ret == errNone)
    {
        readSize = 0;
        MemSet(realBuf, bufSize, 0x00);
        ret  = ReadFile_NNsh(&fileRefR, offset, bufSize, realBuf, &readSize);

        offset  = offset + readSize;
        if ((readSize % 2) != 0)
        {
            // ݃TCYɕ␳(CLIE4p̕ی)
            if (workAround == true)
            {
                realBuf[readSize] = ' ';
                readSize++;
            }
        }
        (void) WriteFile_NNsh(&fileRefW, offsetW, readSize, realBuf, &dummy);
        offsetW = offsetW + readSize;
    }
    // Ot@CTCYL^
    subjDb->fileSize = offsetW;
    
    // BBS^CvɊR[hǉ
    subjDb->bbsType = NNSH_BBSTYPE_HTML | (kanjiCode << NNSH_BBSTYPE_CHAR_SHIFT);

    // Xf[^o^ς݂̏ꍇAxf[^폜
    // (Xf[^̂cáAt@Cł̃\[gĂȂ̂œȂAAA)
    if (IsExistRecord_NNsh(subjRef, subjDb->threadFileName, NNSH_KEYTYPE_CHAR, 0, &index) == errNone)
    {
        // f[^ɂAf[^XV
        ret = UpdateRecord_NNsh(subjRef, index, sizeof(NNshSubjectDatabase), subjDb);
    }
    else
    {
        // f[^ȂAf[^o^
        ret = EntryRecord_NNsh(subjRef, sizeof(NNshSubjectDatabase), subjDb);
    }

CLOSE_END:
    // t@C̃N[Y
    Hide_BusyForm(false);
    CloseFile_NNsh(&fileRefW);
    CloseFile_NNsh(&fileRefR);

FUNC_END:
    // f[^x[X̃N[Y
    CloseDatabase_NNsh(subjRef);

    MEMFREE_PTR(subjDb);
    MEMFREE_PTR(realBuf);
    return (ret);
}

/*==========================================================================*/
/*  GetReadOnlyLogData_NNsh() : QƐpÕO擾                      */
/*                                                                          */
/*==========================================================================*/
Err GetReadOnlyLogData_NNsh(void)
{
    Boolean              penState;
    UInt16               dbCount, loop, x, y, number, urlCnt;
    Char                *url, *fileName;
    Char                *urlListCnt[MAX_URL], *urlList;
    DmOpenRef            dbRef;
    NNshGetLogDatabase  *dbData;

    // URLmۃobt@̎擾
    url = MemPtrNew((MAX_URL * 2) + MARGIN);
    if (url == NULL)
    {
        return (~errNone);
    }
    MemSet(url, ((MAX_URL * 2) + MARGIN), 0x00);

    // t@Cmۃobt@̎擾
    fileName = MemPtrNew(MAXLENGTH_FILENAME + MARGIN);
    if (fileName == NULL)
    {
        MEMFREE_PTR(url);
        return (~errNone);
    }
    MemSet(fileName, (MAXLENGTH_FILENAME + MARGIN), 0x00);

    // DBi[̈m
    dbData = MemPtrNew(sizeof(NNshGetLogDatabase) + MARGIN);
    if (dbData == NULL)
    {
        MEMFREE_PTR(fileName);
        MEMFREE_PTR(url);
        return (~errNone);
    }
    MemSet(dbData, (sizeof(NNshGetLogDatabase) + MARGIN), 0x00);

    // QƐpO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        MEMFREE_PTR(dbData);
        MEMFREE_PTR(fileName);
        MEMFREE_PTR(url);
        return (~errNone);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &dbCount);

    // p[}lgQƃOf[^ǂݏo
    for (loop = 0; loop < dbCount; loop++)
    {
        // R[h̓ǂݏo
        GetRecord_NNsh(dbRef, loop, sizeof(NNshGetLogDatabase), dbData);

        // DB̃xA擾xƓꍇAAA
        // (x[̎͑SĂ擾)
        if ((NNshParam->getROLogLevel == 0)||
            (dbData->usable == NNshParam->getROLogLevel))
        {
            // Of[^̒o
            MemSet(url, (MAX_URL * 2), 0x00);
            StrNCopy(url, dbData->dataURL, (MAX_URL * 2));
            MemSet(fileName, MAXLENGTH_FILENAME, 0x00);
            (void) ReadOnlyLogDataPickup(dbData, url, fileName, loop, 0, 0);
            if (dbData->getDepth != 0)
            {
                // PKw̃Of[^擾
                urlCnt = MAX_URL;

                // BUSYEBhE\
                Show_BusyForm(MSG_CHECK_URLLIST);

                // Ot@CURLꗗ擾
                (void) getLogFileList(fileName, dbData, &urlCnt, urlListCnt, &urlList);

                Hide_BusyForm(false);

                for (number = 0; number < urlCnt; number++)
                {
                    // O擾(̈URL͉̊֐Ŕj󂳂邽)
                    MemSet(url, (MAX_URL * 2), 0x00);
                    StrNCopy(url, urlListCnt[number], (MAX_URL * 2));
                    MemSet(fileName, MAXLENGTH_FILENAME, 0x00);
                    (void) ReadOnlyLogDataPickup(dbData, url, fileName, loop, 1, number);
                }

                // URLꗗ
                MEMFREE_PTR(urlList);
            }
        }

        // y̏ԂE(ʃ^bvĂ邩mF)
        EvtGetPen(&x, &y, &penState);
        if (penState == true)
        {
            // y_EĂA~邩mFs
            if (NNsh_ErrorMessage(ALTID_CONFIRM,
                                  MSG_CONFIRM_ABORT_GETLOG, 
                                  MSG_NOTCHECK_RECORDS, dbCount - loop) == 0)
            {
                // OKꂽAbreak
                break;
            }
        }
    }

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    // DBR[ḧJ
    MEMFREE_PTR(dbData);
    MEMFREE_PTR(fileName);
    MEMFREE_PTR(url);

    return (errNone); 
}

#endif  // #ifdef USE_LOGCHARGE
