/*============================================================================*
 *  FILE: 
 *     machine.c
 *
 *  Description: 
 *     Palm device specific functions.
 *
 *===========================================================================*/
#define MACHINE_C
#include "local.h"

#ifdef USE_CLIE
// SONYpWOAVXg}XN
#define NUMBER_OF_MASKS    1
UInt16 NNshSonyJogMask[] = {
     sonyJogAstMaskType1, // tH[ɌʂɃ}XNݒ肷
     NUMBER_OF_MASKS,     // }XNtH[
     FRMID_MAIN,          sonyJogAstMaskAll,
     0, 0, 0, 0           // |]T...
};
#endif

// prototypes
void CheckVFSdevice_NNsh(void);

/*-------------------------------------------------------------------------*/
/*   Function :   VFSUnmountNotify                                         */
/*                               VFSUnmountꂽNotify          */
/*-------------------------------------------------------------------------*/
Err VFSUnmountNotify(SysNotifyParamType *notifyParamsP)
{
    NNshParam->useVFS = 0;

    // VFSunmountꂽƂʒm
    NNshGlobal->notifyUpdate = NNSH_VFS_UNMOUNTED; 
     
    EvtWakeup();

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   VFSMountNotify                                           */
/*                               VFSMountꂽNotify            */
/*-------------------------------------------------------------------------*/
Err VFSMountNotify(SysNotifyParamType *notifyParamsP)
{
    // Remount
    CheckVFSdevice_NNsh();

    // start.prcs&AppSwitcĥ
    notifyParamsP->handled |= vfsHandledStartPrc | vfsHandledUIAppSwitch;

    // VFSmountꂽƂʒm
    NNshGlobal->notifyUpdate = NNSH_VFS_MOUNTED; 

    // nilEvents
    EvtWakeup();

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   CheckVFSdevice_NNsh                                      */
/*                               VFS̃T|[g󋵂p[^ɔf */
/*-------------------------------------------------------------------------*/
void CheckVFSdevice_NNsh(void)
{
    Err            err;
    Char           dirName[sizeof(DATAFILE_PREFIX)+ MARGIN];
    UInt32         vfsMgrVersion, volIterator;
    VolumeInfoType volInfo;  
    LocalID        appDbID;
    UInt16         cardNo;

    // VFS̃T|[gLmFB
    vfsMgrVersion = 0;
    err = FtrGet(sysFileCVFSMgr, vfsFtrIDVersion, &vfsMgrVersion);
    if (err == errNone)
    {
        // VFS Mount & Unmount Notification̐ݒ
        // (Ƃ肠VFSMgrVFShĂȂĂォmountł悤ɓo^Ă)
        err = SysCurAppDatabase(&cardNo, &appDbID);
        if (err == errNone)
        {
            // VFSunmount & remountꂽnotify handlerݒ
            // shinhei 03/06/07 - PilotMainHandle悤ɕύX
            err = SysNotifyRegister(cardNo, appDbID, sysNotifyVolumeUnmountedEvent,
                                    NULL, sysNotifyNormalPriority, 0);
            err = SysNotifyRegister(cardNo, appDbID, sysNotifyVolumeMountedEvent,
                                    NULL, sysNotifyNormalPriority, 0);

            // Remount̎sysNotifyErrDuplicateEntry͖
            if (err == sysNotifyErrDuplicateEntry)
            {
                err = errNone;
            }
        }

        //  VFSgp\mFB(t@X}jAƂɂ)
        volIterator = vfsIteratorStart;
        while (volIterator != vfsIteratorStop)
        {
            err = VFSVolumeEnumerate(&(NNshGlobal->vfsVol), &volIterator);
            if (err != errNone)
            {
                NNsh_DebugMessage(ALTID_WARN, "VFSVolumeEnumerate()", "", err);
                break;
            }
            err = VFSVolumeInfo(NNshGlobal->vfsVol, &volInfo);
            if (err != errNone)
            {
                NNsh_DebugMessage(ALTID_WARN, "VFSVolumeInfo()", "", err);
                break;
            }
            // "VFS̓RpNgtbVgp"ݒ̏ꍇAAA
            if (NNshParam->vfsUseCompactFlash != 0)
            {
                if (volInfo.mediaType != ExpMediaType_CompactFlash)
                {
                    // VFSCFłȂ΁Ax
                    err = ~errNone;
                    continue;
                }
            }
#ifdef VFS_USE_ALTERNATIVE
            else
            {
                if (volInfo.mediaType == ExpMediaType_CompactFlash)
                {
                    // VFSCFꍇɂ́Ax
                    err = ~errNone;
                    continue;
                }
            }
#endif
            if (volInfo.fsType == vfsFilesystemType_VFAT)
            {                    
                // "VFSgp\ɎIVFS ON" ݒmF
                if (NNshParam->vfsOnAutomatic != 0)
                {

                    // VFS ONɂ
                    NNshParam->useVFS = ((NNSH_VFS_ENABLE)|
                                         (NNSH_VFS_WORKAROUND));
                }
                if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
                {
                    // NNshpf[^i[pfBNg쐬(VFS ON)
                    StrCopy(dirName, DATAFILE_PREFIX);
                    dirName[StrLen(dirName) - 1] = '\0';
                    err = CreateDir_NNsh(dirName);
                    NNsh_DebugMessage(ALTID_INFO, "Created :", dirName, err);
                    err = errNone;
                }
                break;
            }
        }
    }
    if (err != errNone)
    {
        // foCXVFST|[gȂꍇ́ANNshݒVFSgpݒNA
        NNshParam->useVFS = NNSH_NOTSUPPORT_VFS;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   ResetVFSNotifications                                    */
/*                                          VFS Notification  unregister */
/*-------------------------------------------------------------------------*/
void ResetVFSNotifications(void)
{
    UInt16 cardNo;
    LocalID appDbID;
  
    // Get application's cardNo and app database localID
    (void) SysCurAppDatabase(&cardNo, &appDbID);
  
    // Unregister unmount & mount notification    
    (void) SysNotifyUnregister(cardNo, appDbID, sysNotifyVolumeUnmountedEvent,
                               sysNotifyNormalPriority);
    (void) SysNotifyUnregister(cardNo, appDbID, sysNotifyVolumeMountedEvent,
                               sysNotifyNormalPriority);

    return;
}

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :   CLIEdisplayNotify                                        */
/*                                                CLIEfBXvCXV() */
/*-------------------------------------------------------------------------*/
Err CLIEdisplayNotify(SysNotifyParamType *notifyP)
{
    FormType *frm;

    // ---------------------------------------------------
    //    ӁFnotifyP ́ANULLŃR[
    // ---------------------------------------------------
    if (NNshGlobal->silkRef != 0)
    {
        frm = FrmGetActiveForm();
        HandEraResizeForm(frm);
        //   ʕ\̍XV́AW̃Cxg[vōsB̂߂ɁA
        // `wtOύXAnilEvent𔭍sB
        NNshGlobal->updateHR = NNSH_UPDATE_DISPLAY;
        EvtWakeup();
    }
    return (errNone);
}
#endif

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :   setCLIESupport_NNsh                                      */
/*                                              CLIET|[g@\ݒ肷 */
/*-------------------------------------------------------------------------*/
void SetCLIESupport_NNsh(void)
{
    SonySysFtrSysInfoP     infoP;
    Boolean                isColor;
    UInt32                 vskVer, width, height, depth;
    Err                    ret;

    infoP                        = NULL;
    NNshGlobal->jogAssistSetBack = NULL;

    // SONYfoCXǂ̃`FbN
    if ((FtrGet(sysFtrCreator, sysFtrNumOEMCompanyID, &depth) != 0)||
        (depth != sonyHwrOEMCompanyID_Sony))
    {
        // SONYfoCXłȂ΁AI
        return;
    }

    // JOGAVXg@\̐ݒ
    if (!FtrGet(sonySysFtrCreator, sonySysFtrNumSysInfoP, (UInt32 *)&infoP))
    {
        // JOGAVXg@\Ă邩ǂ`FbN
        if (infoP && (infoP->extn & sonySysFtrSysInfoExtnJogAst))
        {
            // ݂̃WOAVXg擾
            if(!FtrGet(sonySysFtrCreator, sonySysFtrNumJogAstMaskP,
                       (UInt32 *) &(NNshGlobal->jogAssistSetBack)))
            {
                // ݂̃WOAVXgۊǁANNsip̐ݒ
                 NNshGlobal->jogInfoBack =
                                            *(NNshGlobal->jogAssistSetBack);
                *(NNshGlobal->jogAssistSetBack) =  NNshSonyJogMask;

                // WOAVXgI[in̐ݒ͏ȗ(񂾂)
            }
        }
    }

    // SILK}l[W̎QƔԍ擾
    ret = SysLibFind(sonySysLibNameSilk, &(NNshGlobal->silkRef));
    if (ret == sysErrLibNotFound)
    {
        // SILK}l[W[h̏ꍇA[hł邩TryĂ݂B
        ret = SysLibLoad('libr',sonySysFileCSilkLib,&(NNshGlobal->silkRef));
    }
    if (ret != errNone)
    {
        // 281Silk}l[WR[h}[W
        ret = SysLibLoad(sonySysFileTSilkLib,
                         sonySysFileCSilkLib,
                         &(NNshGlobal->silkRef));    // OS5
        if (ret != errNone)
        {
            ret = SysLibLoad('libr','SlSi',&(NNshGlobal->silkRef));
        }
        if (ret != errNone)
        {
            // SILK}l[W͎gpłȂAɂSONY HRLIB[h
            NNshGlobal->silkRef = 0;
            goto SONY_HRLIB_LOAD;
        }
    }

    // SILKgpȂꍇɂ͎ɐi
    if (NNshGlobal->notUseSilk != 0)
    {
        NNshGlobal->silkRef = 0;
        NNshGlobal->silkVer = 1;
        goto SONY_HRLIB_LOAD;
    }

    // SILK}l[W̃o[WmF
    ret = FtrGet(sonySysFtrCreator, sonySysFtrNumVskVersion, &vskVer);
    if (ret != errNone)
    {
        // SILK}l[WVERSION1ATCŶ݃T|[g(NRp)
        if (SilkLibOpen(NNshGlobal->silkRef) == errNone)
        {
            // SILK̃TCYT|[gĂ邱Ƃ(SILK}l[W)ʒm
            SilkLibEnableResize(NNshGlobal->silkRef);
            NNshGlobal->silkVer = 1;
        }
    }
    else
    {
        // }WłAtB[`[ԍVer1G[ɂȂȂĂ̂,,,
        switch (vskVer)
        {
          case vskVersionNum1:
            // SILK}l[WVERSION1ATCŶ݃T|[g(NRp)
            if (SilkLibOpen(NNshGlobal->silkRef) == errNone)
            {
                // SILK̃TCYT|[gĂ邱Ƃ(SILK}l[W)ʒm
                SilkLibEnableResize(NNshGlobal->silkRef);
                NNshGlobal->silkVer = 1;
            }
            break;

          case vskVersionNum2:
            // SILK}l[WVERSION2A(NXȍ~)
            if (VskOpen(NNshGlobal->silkRef) == errNone)
            {
                // SILK̃TCY(c)T|[gĂ邱Ƃ(SILK}l[W)ʒm
                VskSetState(NNshGlobal->silkRef, vskStateEnable, vskResizeVertically);
                NNshGlobal->silkVer = 2;
            }
            break;

          case vskVersionNum3:
          default:
            // SILK}l[WVERSION2A(UXȍ~)Ȃ̃foCX
            if (VskOpen(NNshGlobal->silkRef) == errNone)
            {
                // SILK̃TCY()T|[gĂ邱Ƃ(SILK}l[W)ʒm
                VskSetState(NNshGlobal->silkRef, vskStateEnable, vskResizeHorizontally);
                NNshGlobal->silkVer = 3;
            }
            break;
        }
    }

    // sysNotifyDisplayChangeEventsubscribe
    ret = SysNotifyRegister(0, SOFT_CREATOR_ID, sysNotifyDisplayChangeEvent,
                            CLIEdisplayNotify, sysNotifyNormalPriority,
                            NULL);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_WARN, "SysNotifyRegister()", "", ret);
    }

SONY_HRLIB_LOAD:
    // SONY HiResgpȂꍇɂ́AŏI
    if (NNshParam->disableSonyHR != 0)
    {
        // HRLIB͎gpȂ
        NNshGlobal->hrRef    = 0;
        NNshGlobal->notUseHR = NNshParam->disableSonyHR;
        return;
    }

    // HRLIB̎QƔԍ擾
    ret = SysLibFind(sonySysLibNameHR, &(NNshGlobal->hrRef));
    if (ret == sysErrLibNotFound)
    {
        // HRLIB[h̏ꍇA[hł邩TryĂ݂B
        ret = SysLibLoad('libr', sonySysFileCHRLib, &(NNshGlobal->hrRef));
    }
    if (ret != errNone)
    {
        // HRLIB͎gpłȂ
        NNshGlobal->hrRef = 0;
        return;
    }
    // HRLIB̎gp錾HRLIB̃o[Wԍ擾
    HROpen(NNshGlobal->hrRef);
    HRGetAPIVersion(NNshGlobal->hrRef, &(NNshGlobal->hrVer));
    if (NNshGlobal->hrVer < HR_VERSION_SUPPORT_FNTSIZE)
    {
        // o[W̃nC]...ʃ[hmF...
        ret = HRWinScreenMode(NNshGlobal->hrRef, winScreenModeGet, 
                              &width, &height, &depth, &isColor);
        if (ret != errNone)
        {
            // HRLIB͎gpȂ
            HRClose(NNshGlobal->hrRef);
            NNshGlobal->hrRef = 0;
            return;
        }

        NNshGlobal->prevHRWidth = width;
        if (width != hrWidth)
        {
            // ʃ[hnC]łȂ̂ŁAnC][hɐ؂ւ
            width  = hrWidth;
            height = hrHeight;
            ret    = HRWinScreenMode(NNshGlobal->hrRef, winScreenModeSet,
                                     &width, &height, &depth, &isColor);
            if (ret != errNone)
            {
                // HRLIB͎gpȂ
                HRClose(NNshGlobal->hrRef);
                NNshGlobal->hrRef = 0;
                return;
            }
        }
    }
    else
    {
        // ʃ[h͕ύXȂB
        NNshGlobal->prevHRWidth = hrWidth;
    }
    return;
}
#endif

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :   resetCLIESupport_NNsh                                    */
/*                                                  CLIET|[g */
/*-------------------------------------------------------------------------*/
void ResetCLIESupport_NNsh(void)
{
    Boolean                isColor;
    UInt32                 width, height, depth;

    // JOGAVXg@\ɖ߂
    if (NNshGlobal->jogAssistSetBack != NULL)
    {
        *(NNshGlobal->jogAssistSetBack) = NNshGlobal->jogInfoBack;
    }

    if (NNshGlobal->silkRef == 0)
    {
        // SONYpVN̋@\gpȂꍇɂHRLIB̉
        goto SONY_HRLIB_UNLOAD;
    }

    // sysNotifyDisplayChangeEventunsubscribe
    (void) SysNotifyUnregister(0, SOFT_CREATOR_ID, sysNotifyDisplayChangeEvent,
                               sysNotifyNormalPriority);

    // SILK}l[W̉
    if (NNshGlobal->silkVer == 1)
    {
        // SILK}l[W(NRp)
        SilkLibDisableResize(NNshGlobal->silkRef);
        SilkLibClose(NNshGlobal->silkRef);
    }
    else
    {
        // VSILK}l[W(NXȍ~)
        VskSetState(NNshGlobal->silkRef, vskStateEnable, 0);
        VskClose(NNshGlobal->silkRef);
    }

SONY_HRLIB_UNLOAD:
    if (NNshGlobal->hrRef != 0)
    {
        // AvNɁAʃ[h猳ɖ߂
        if (NNshGlobal->prevHRWidth != hrWidth)
        {
            HRWinScreenMode(NNshGlobal->hrRef, winScreenModeGet,
                            &width, &height, &depth, &isColor);
            width      = stdWidth;
            height     = stdHeight;
            (void) HRWinScreenMode(NNshGlobal->hrRef, winScreenModeSet,
                                   &width, &height, &depth, &isColor);
        }
        // Sony HRLIB̎gpI
        HRClose(NNshGlobal->hrRef);
    }
    return;
}
#endif

#ifdef USE_HANDERA
/*-------------------------------------------------------------------------*/
/*   Function :   setHandEraSupport_NNsh                                   */
/*                                               HandErafoCX̃`FbN */
/*-------------------------------------------------------------------------*/
void SetHandEraSupport_NNsh(void)
{
    UInt32              handEraOsVersion;
    VgaScreenModeType   handEraScreenMode;     // XN[[h
    VgaRotateModeType   handEraRotateMode;     // ][h

    // HandEra QVGA T|[gLmFB
    handEraOsVersion = 0;
    if (_TRGVGAFeaturePresent(&handEraOsVersion))          
    {
        NNshGlobal->device = NNSH_DEVICE_HANDERA;
    }

    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        VgaGetScreenMode(&handEraScreenMode, &handEraRotateMode);
        VgaSetScreenMode(screenMode1To1, handEraRotateMode);
    }
}
#endif // #ifdef USE_HANDERA

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraMoveObject                                        */
/*                                                     IuWFNg̈ړ  */
/*-------------------------------------------------------------------------*/
void HandEraMoveObject(FormPtr frmP, UInt16 objIndex,
                              Coord x_diff, Coord y_diff)
{
    Boolean move = true;
    Coord   old_x, old_y;

#ifdef USE_GLUE
    if (FrmGlueGetObjectUsable(frmP, objIndex) != true)
    {
        // BĂIuWFNg͈ړȂ
            move = false;
    }
    else
#endif
    {
        FrmHideObject(frmP, objIndex);
    }
    FrmGetObjectPosition(frmP, objIndex, &old_x, &old_y);
    if (old_y < 110)
    {
        // ̕ɂIuWFNg͈ړȂ
        // ([x^...ƃJbR...)
        // x_diff = 0;
        y_diff = 0;
    }
    FrmSetObjectPosition(frmP, objIndex, old_x + x_diff, old_y + y_diff);

    // ړIuWFNg\
    if (move == true)
    {
        FrmShowObject(frmP, objIndex);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraResizeObject                                      */
/*                                                 IuWFNg̃TCY  */
/*-------------------------------------------------------------------------*/
void HandEraResizeObject(FormPtr frmP, UInt16 objIndex,
                         Coord x_diff, Coord y_diff)
{
    RectangleType r;
    Coord         old_x, old_y;

    FrmHideObject(frmP, objIndex);

    // IuWFNg̃TCY
    FrmGetObjectPosition(frmP, objIndex, &old_x, &old_y);
    if (old_y < 11)
    {
        // ̕ɂIuWFNg͑ɂȂ
        // (Ƃ肠...l...)
        return;
    }

    FrmGetObjectBounds(frmP, objIndex, &r);
    r.extent.x += x_diff;
    r.extent.y += y_diff;
    FrmSetObjectBounds(frmP, objIndex, &r);

    FrmShowObject(frmP, objIndex);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraResizeForm                                        */
/*                                                     tH[̃TCY  */
/*-------------------------------------------------------------------------*/
void HandEraResizeForm(FormPtr frmP)
{
    Coord           x, y, xDiff, yDiff;
    RectangleType   r;
    UInt16          objectIndex, numObjects, rowNum, nofRow, height;
    Int16           fldIndex, sclIndex;
    TableType      *tableP;
    ControlType    *ctlPtr;
    FormObjectKind  objType;
    WinHandle       winH;

    winH = FrmGetWindowHandle(frmP);
    if (WinModal(winH) == true)
    {
        /** [_tH[AEBhẼTCY͎{Ȃ **/
        return;
    }

    /**  **/
    fldIndex = -1;
    sclIndex = -1;

    /* VTCY */
    WinGetDisplayExtent(&x, &y);
    
    /* TCY */
    FrmGetFormBounds(frmP, &r);

    /* [_tH[łȂꍇAȂȉ̔Kvisj */
    r.topLeft.x = r.topLeft.x + 1;
    r.topLeft.y = r.topLeft.y + 1;
    r.extent.x  = r.extent.x  - 2;
    r.extent.y  = r.extent.y  - 2;

    xDiff = x - (r.topLeft.x + r.extent.x);
    yDiff = y - (r.topLeft.y + r.extent.y);

    if ((xDiff == 0)&&(yDiff == 0))
    {
        return;
    }

    /* TCY */
    r.extent.x = r.extent.x + xDiff;
    r.extent.y = r.extent.y + yDiff;
    WinSetWindowBounds(winH, &r);
        
    /* IuWFNg̈ړATCY */
    numObjects = FrmGetNumberOfObjects(frmP);
    for (objectIndex = 0; objectIndex < numObjects; objectIndex++)
    {
        objType = FrmGetObjectType(frmP, objectIndex);
        switch (objType)
        {
          case frmFieldObj:
            // tB[ḧړiXԓFieldjATCYiX\Fieldj
            if (FldGetVisibleLines((FieldType *) 
                                     FrmGetObjectPtr(frmP, objectIndex)) == 1)
            {
                // tB[ḧړ
                HandEraMoveObject(frmP, objectIndex, 0, yDiff);
            }
            else
            {
                // tB[h̃TCY
                HandEraResizeObject(frmP, objectIndex, xDiff, yDiff);
                fldIndex = objectIndex;
            }
            break;
          case frmControlObj:
            // {^֘Äړ
            ctlPtr = (ControlType *)FrmGetObjectPtr(frmP, objectIndex);
#if 0
            if ((CtlGlueGetControlStyle(ctlPtr) == buttonCtl)||
                (CtlGlueGetControlStyle(ctlPtr) == checkboxCtl)||
                (CtlGlueGetControlStyle(ctlPtr) == repeatingButtonCtl))
#endif
            {
                HandEraMoveObject(frmP, objectIndex, 0, yDiff);
            }
            break;
          case frmTableObj:
            HandEraResizeObject(frmP, objectIndex, xDiff, yDiff);
            tableP = FrmGetObjectPtr(frmP, objectIndex);
            nofRow = TblGetNumberOfRows(tableP);
            TblGetBounds(tableP, &r);
            height = (r.extent.y - r.topLeft.y) / nofRow + 1;
            for (rowNum = 0; rowNum < nofRow; rowNum++)
            {
                TblSetRowHeight(tableP, rowNum, height);
            }
            break;

          case frmGadgetObj:
            // KWFbg̃TCY
            HandEraResizeObject(frmP, objectIndex, xDiff, yDiff);
            break;

          case frmLabelObj:
          case frmGraffitiStateObj:
            // GSÏړ
            HandEraMoveObject(frmP, objectIndex, 0, yDiff);
            break;

          case frmScrollBarObj:
            // XN[o[̃TCYAړ
            HandEraResizeObject(frmP, objectIndex, 0, yDiff);
            HandEraMoveObject(frmP, objectIndex, xDiff, 0);
            sclIndex = objectIndex;
            break;

          case frmListObj:
            // XgIuWFNg͉ȂB

          default:
            // ???(Ȃ)
            break;
        }
    }
    if ((fldIndex >= 0) && (sclIndex >= 0))
    {
        // XN[o[̃Abvf[g
        NNshWinViewUpdateScrollBar(
              FrmGetObjectId(frmP, fldIndex), FrmGetObjectId(frmP, sclIndex)); 
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraMoveDialog                                        */
/*                                                   _CÖړ      */
/*-------------------------------------------------------------------------*/
void HandEraMoveDialog(FormPtr frmP)
{
    Coord         x, y;
    RectangleType r;

#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        /* Ŝ̃TCY */
        WinGetDisplayExtent(&x, &y);
    
        /* dialog̃TCY */
        FrmGetFormBounds(frmP, &r);

        /* Ȃȉ̔Kvisj */
        r.topLeft.x += 2; 
        r.topLeft.y += 2; 
        r.extent.x -= 4;
        r.extent.y -= 4;
        goto MOVE_OBJECT;
    }
#endif
#ifdef USE_CLIE
    // SILK}l[WnodmĂ邩H
    if (NNshGlobal->silkRef != 0)
    {
        /* Ŝ̃TCY */
        WinGetDisplayExtent(&x, &y);
    
        /* dialog̃TCY */
        FrmGetFormBounds(frmP, &r);

        /* Ȃȉ̔Kvisj */
        // r.topLeft.x -=2;
        // r.topLeft.y -=2;
        r.extent.x  -= 4;
        r.extent.y  -= 4;
        goto MOVE_OBJECT;
    }
#endif
    return;

MOVE_OBJECT:
    /* dialog̈ړ */
    if (y - (r.topLeft.y + r.extent.y) < 0)
    {
        r.topLeft.y = y - r.extent.y;
    }
    WinSetWindowBounds(FrmGetWindowHandle(frmP), &r);

    NNsi_FrmDrawForm(frmP, true);

    return;
}

/*=========================================================================*/
/*   Function :   NNshRestoreNNsiSetting                                   */
/*                                                     NNsiݒ̓ǂݍ  */
/*=========================================================================*/
void RestoreSetting_NNsh(Int16 version, UInt16 size, NNshSavedPref *prm)
{
    Err           ret;
    UInt32        offset;
    UInt16        cnt, nofRec;
    DmOpenRef     dbRef;
    Char         *ptr;

    // NNsiݒ̗̈
    nofRec = 0;

    if ((version == SOFT_PREFVERSION)&&(size == sizeof(NNshSavedPref)))
    {
        //  ݒ肳ꂽo[WƍNꂽo[Wэ\̃TCY
        // ꍇ̂݁ANNsiݒ𕜋B

        // ϐ 
        offset = 0;
        ptr    = (Char *) prm;

        // caANNsiݒǂݏo(R[h̓o^̌ˍŁAAA)
        OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
        GetDBCount_NNsh(dbRef, &nofRec);
        cnt = nofRec;
        while ((cnt != 0)&&(offset < sizeof(NNshSavedPref)))
        {
            ret = GetRecord_NNsh(dbRef,(cnt - 1),DBSIZE_SETTING, &ptr[offset]);
            if (ret != errNone)
            {
                // f[^ǂݏoɎs(̏ꍇANNsiݒ͏)
                NNsh_WarningMessage(ALTID_WARN, "Preference read failure", "", ret);
                nofRec = 0;
                break;
            }
            cnt--;
            offset = offset + DBSIZE_SETTING;
        }
        CloseDatabase_NNsh(dbRef);
    }
    if (nofRec == 0)
    {
        // NNsiݒ
        prm->lastFrmID        = NNSH_FRMID_MAIN;
        prm->bufferSize       = NNSH_WORKBUF_DEFAULT;
        prm->currentFont      = NNSH_DEFAULT_FONT;
        prm->sonyHRFont       = NNSH_DEFAULT_FONT;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   NNshSaveNNsiSetting                                      */
/*                                                         NNsiݒ̋L  */
/*-------------------------------------------------------------------------*/
void SaveSetting_NNsh(Int16 version, UInt16 size, NNshSavedPref *param)
{
    Err       ret;
    UInt32    offset;
    UInt16    nofRec;
    DmOpenRef dbRef;
    Char      *ptr;

    OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
    GetDBCount_NNsh(dbRef, &nofRec);
    while (nofRec != 0)
    {
        //  łNNsiݒ肪L^ĂꍇASR[h폜
        (void) DeleteRecordIDX_NNsh(dbRef, (nofRec - 1));
        nofRec--;
    }

    // NNsiݒDBɓo^(R[ho^̌ˍɒӁI)
    offset = 0;
    ptr    = (Char *) param;
    while (offset < sizeof(NNshSavedPref))
    {
        ret = EntryRecord_NNsh(dbRef, DBSIZE_SETTING, &ptr[offset]);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_WARN, "EntryRecord_NNsh()", "", ret);
            NNsh_DebugMessage(ALTID_WARN, "    ", "offset:", offset);
            NNsh_DebugMessage(ALTID_WARN, "    ", "size:", DBSIZE_SETTING);
            break;
        }
        offset = offset + DBSIZE_SETTING;
    }
    CloseDatabase_NNsh(dbRef);

    return;
}

/*=========================================================================*/
/*   Function :   NNshSilkMinimize                                         */
/*                                          OtBeBGAŏ */
/*=========================================================================*/
Err NNshSilkMinimize(FormType *frm)
{
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        SilkMinimizeWindow();
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
#ifdef USE_CLIE
    // SILK}l[WnodmĂ邩H
    if (NNshGlobal->silkRef != 0)
    {
        // SILK̍ŏs
        if (NNshGlobal->silkVer == 1)
        {
            // Version1(NRp)
            SilkLibResizeDispWin(NNshGlobal->silkRef, silkResizeToStatus);
        }
        else
        {
            // Version2(NXȍ~)
            VskSetState(NNshGlobal->silkRef, vskStateResize, vskResizeMin);
        }
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
    return (~errNone);
}

/*=========================================================================*/
/*   Function :   NNshSilkMaximize                                         */
/*                                          OtBeBGAő剻 */
/*=========================================================================*/
Err NNshSilkMaximize(FormType *frm)
{
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        SilkMaximizeWindow();
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
#ifdef USE_CLIE
    // SILK}l[WnodmĂ邩H
    if (NNshGlobal->silkRef != 0)
    {
        // SILK̍ő剻s
        if (NNshGlobal->silkVer == 1)
        {
            // Version1(NRp)
            SilkLibResizeDispWin(NNshGlobal->silkRef, silkResizeNormal);
        }
        else
        {
            // Version2(NXȍ~)
            VskSetState(NNshGlobal->silkRef, vskStateResize, vskResizeMax);
        }
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
    return (~errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   checkInstalledWebBrowser                                 */
/*                                        WebBrowser̃CXg[`FbN */
/*-------------------------------------------------------------------------*/
void CheckInstalledWebBrowser(void)
{
    UInt16            cardNo;
    LocalID           dbID;
    DmSearchStateType searchState;
    Err               ret;

    // NetFrontCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'NF3T', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // NetFrontCXg[Ă
        NNshGlobal->browserCreator    = 'NF3T';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    // WebBrowser 2.0CXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'NF3P', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // WebBrowser 2.0CXg[Ă
        NNshGlobal->browserCreator    = 'NF3P';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    // Xiino(PalmScape)CXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'PScp', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // XiinoCXg[Ă
        NNshGlobal->browserCreator    = 'PScp';
        NNshGlobal->browserLaunchCode = 0xfa21;
        return;
    }

    // Xiino(LEM)CXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'dXin', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // Xiino(LEM)CXg[Ă
        NNshGlobal->browserCreator    = 'dXin';
        NNshGlobal->browserLaunchCode = 0xfa21;
        return;
    }

    // BlazerCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'BLZ1', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // BlazerCXg[Ă
        NNshGlobal->browserCreator    = 'BLZ1';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    // Eudora WebCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'QCwb', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // Eudora WebCXg[Ă
        NNshGlobal->browserCreator    = 'QCwb';
        NNshGlobal->browserLaunchCode = 0xfa0;
        // NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

#if 0
    // PocketLinkCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'PLNK', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // PocketLinkCXg[Ă(but does not work...)
        NNshGlobal->browserCreator    = 'PLNK';
        // NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdOpenDB;
        return;
    }
#endif

    // Novarra Web Pro browserCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'NOVR', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // Novarra Web Pro browserCXg[Ă
        NNshGlobal->browserCreator    = 'NOVR';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    NNsh_DebugMessage(ALTID_INFO, MSG_CANNOTFIND_BROWSER, "", ret);
    return;
}

/*=========================================================================*/
/*   Function : KeyConvertFiveWayToJogChara                                */
/*                                  5Way̓̓R[hWÕR[hɕϊ */
/*=========================================================================*/
UInt16 KeyConvertFiveWayToJogChara(EventType *event)
{
    // 5way̓͂łȂ΁AL[R[ĥ܂܉
    if (event->data.keyDown.chr != vchrNavChange)
    {
        // n[hL[̊mFBBB
        if ((NNshParam->useHardKeyControl != 0)&&
            (event->data.keyDown.chr >= vchrHardKeyMin))
        {
            // n[hL[R[h̊mF
            switch (event->data.keyDown.chr)
            {
              case vchrHard1:
                // n[hL[P
                event->data.keyDown.chr = NNshParam->useKey.key1;
                break;

              case vchrHard2:
                // n[hL[Q
                event->data.keyDown.chr = NNshParam->useKey.key2;
                break;

              case vchrHard3:
                // n[hL[R
                event->data.keyDown.chr = NNshParam->useKey.key3;
                break;

              case vchrHard4:
                // n[hL[S
                event->data.keyDown.chr = NNshParam->useKey.key4;
                break;

              default:
                return (event->data.keyDown.chr);
                break;
            }
        }
        return (event->data.keyDown.chr);
    }

    if (((event->data.keyDown.keyCode) & (navBitSelect | navChangeSelect))
         == navChangeSelect)
    {
        // WOƓɂ
        return (vchrJogRelease);
    }
    if ((event->data.keyDown.keyCode) & navBitLeft)
    {
        // J[\L[Ɠɂ
        return (chrLeftArrow);
    }
    if ((event->data.keyDown.keyCode) & navBitRight)
    {
        // J[\L[EƓɂ
        return (chrRightArrow);
    }

    // LȊO͂̂܂܉
    return (event->data.keyDown.chr);
}

#ifdef USE_HIGHDENSITY
/*-------------------------------------------------------------------------*/
/*   Function :   SetDoubleDensitySupport_NNsh                             */
/*                                              𑜓xT|[g̃`FbN */
/*-------------------------------------------------------------------------*/
void SetDoubleDensitySupport_NNsh(void)
{
    UInt32  version;

    // 𑜓xT|[gݒ
    NNshGlobal->os5HighDensity = (UInt32) kDensityLow;

#ifdef USE_CLIE
    if (NNshGlobal->hrRef != 0)
    {
        // CLIEA𑜓x̃`FbNȂ(CLIEnC]g)
        return;
    }
#endif

    // 𑜓xtB[`[̎擾
    if (FtrGet(sysFtrCreator, sysFtrNumWinVersion, &version) != 0)
    {
        // 𑜓xtB[`[̃T|[gȂ
        return;
    }
    NNsh_DebugMessage(ALTID_INFO, "Window Version", ": ", version);
    if (version < 4)
    {
        //@𑜓x̃T|[gȂAI
        //  (Ő񂾂낤...}jAɂ͂Ă...)
        return;
    }

    // Window̉𑜓x擾
    WinScreenGetAttribute(winScreenDensity, &(NNshGlobal->os5HighDensity));

    // Ƃ肠AW𑜓xɂ
    WinSetCoordinateSystem(kCoordinatesStandard);

    return;
}
#endif   // #ifdef USE_HIGHDENSITY
