/*============================================================================*
 *  FILE: 
 *     nnshset.c
 *
 *  Description: 
 *     NNsh parameter setting functions for NNsh.
 *
 *===========================================================================*/
#define NNSHMAIN_C
#include "local.h"


/*=========================================================================*/
/*   Function : saveMacroData                                              */
/*                                                 }NXNvg̏o  */
/*=========================================================================*/
static Boolean  saveMacroData(void)
{
    return (false);
}

/*=========================================================================*/
/*   Function : loadMacroData                                              */
/*                                             }NXNvg̓ǂ݂  */
/*=========================================================================*/
static Boolean  loadMacroData(void)
{
    return (false);
}

/*=========================================================================*/
/*   Function : changeDispFont                                             */
/*                                                         tHg̕ύX  */
/*=========================================================================*/
static Boolean changeDispFont()
{
    NNshParam->currentFont = FontSelect(NNshParam->currentFont);
    NNsi_putLine(FrmGetActiveForm(), GADID_GADGET_FIELD, 
                        BTNID_FIELDUP, BTNID_FIELDDOWN, NNSH_STEP_REDRAW);
    return (true);
}
/*=========================================================================*/
/*   Function : extractMacroData                                           */
/*                                       }NXNvg̎s̈֏o  */
/*=========================================================================*/
Boolean  extractMacroData(void)
{
    Err          ret;
    UInt16       butID;
    EventType   *dummyEvent;

    // }No͂邩ǂmF
    butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_OUTPUT_MACRO, "", 0);
    if (butID != 0)
    {
        // }Nf[^̏o͂𒆎~
        return (true);
    }

    // }Nf[^̕ۑ
    ret = WriteMacroDBData(DBNAME_MACROSCRIPT,
                           DBVERSION_MACROSCRIPT,
                           DATA_CREATOR_ID, 
                           NNshGlobal->currentScriptLine,
                           NNshGlobal->scriptArea);
    if (ret == errNone)
    {
        NNsh_InformMessage(ALTID_INFO, MSG_WRITE_OK, DBNAME_MACROSCRIPT, ret);

        // NNsiI邩ǂmF
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_APLEND, "", 0);
        if (butID == 0)
        {
            // AvP[VI
            dummyEvent = &(NNshGlobal->dummyEvent);
            MemSet(dummyEvent, sizeof(EventType), 0x00);
            dummyEvent->eType = appStopEvent;
            EvtAddEventToQueue(dummyEvent);
        }
        NNshGlobal->editFlag = false;
        return (true);
    }
    NNsh_DebugMessage(ALTID_ERROR, "Write Failure :", DBNAME_MACROSCRIPT, ret);
    return (false);
}


/*=========================================================================*/
/*   Function : deleteAllScript                                            */
/*                                                     XNvg̑S폜  */
/*=========================================================================*/
Boolean deleteAllScript(void)
{
    if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_ALLDELETE, "", 0) == 0)
    {
        NNshGlobal->currentScriptLine = 0;
        
        MemSet(NNshGlobal->scriptArea, sizeof(NNshMacroRecord), 0x00);

        // ʂĕ`悷
        NNsi_putLine(FrmGetActiveForm(), GADID_GADGET_FIELD, 
                             BTNID_FIELDUP, BTNID_FIELDDOWN, NNSH_STEP_REDRAW);
        NNshGlobal->editFlag = true;
    }
    return (true);
}

/*=========================================================================*/
/*   Function : Handler_ViewLineAction                                     */
/*                                                       Cxgnh  */
/*=========================================================================*/
Boolean NNsh_KeyDownEvt(EventType *event)
{
    UInt16 command;

    // R}h
    command = NNSH_STEP_REDRAW;

    switch (KeyConvertFiveWayToJogChara(event))
    {
      case vchrPageDown:
      case vchrJogDown:
      case vchrTrgJogDown:
      case vchrNextField:
      case vchrThumbWheelDown:
      case chrDownArrow:
        // 1y[W
        command = NNSH_STEP_PAGEDOWN;
        break;

      case vchrPageUp:
      case vchrJogUp:
      case vchrTrgJogUp:
      case vchrPrevField:
      case vchrThumbWheelUp:
      case chrUpArrow:
        // 1y[W
        command = NNSH_STEP_PAGEUP;
        break;

      case chrCapital_R:  // RL[̓
      case chrSmall_R:
        // }Nf[^̓ǂݍ
        return (loadMacroData());
        break;

      case chrCapital_S:  // SL[̓
      case chrSmall_S:
        // }Nf[^̏
        return (saveMacroData());
        break;

      case chrCapital_F:  // FL[̓
      case chrSmall_F:
        // \tHg̕ύX
        return (changeDispFont());
        break;

      // HandEra JOG PushI/EnterL[͎
      case vchrJogRelease:
      case chrCarriageReturn:
      case chrLineFeed:
      case vchrThumbWheelPush:
        // }Nf[^̐ݒ
        return (extractMacroData());
        break;

      default:
        // LȊÕL[ł͉Ȃ
        break;
    }
    if (command != NNSH_STEP_REDRAW)
    {
        // y[Wړ
        NNsi_putLine(FrmGetActiveForm(), GADID_GADGET_FIELD, BTNID_FIELDUP, BTNID_FIELDDOWN, command);
        return (true);
    }
    // Ȃ
    return (false);
}

/*=========================================================================*/
/*   Function :   NNsh_RctPointEvt                                         */
/*                                       CtH[̃Cxgnh  */
/*=========================================================================*/
Boolean NNsh_RctPointEvt(EventType *event, RectangleType *dimF)
{
    Boolean          edit = false;
    UInt16           fontHeight, nlines, line;
    Coord            pointX, pointY, dimX, dimY;
    NNshMacroRecord *source;

    // tHg擾
    fontHeight   = FntCharHeight();
    if (fontHeight == 0)
    {
        // tHgُAI
        return (false);
    }

    // Wn̕ϊ(|Cg)
    pointY = event->screenY - dimF->topLeft.y;
    pointX = event->screenX - dimF->topLeft.x;
    NNsi_ConvertLocation(&pointX, &pointY);

    // Wn̕ϊ
    dimX   = dimF->extent.x;
    dimY   = dimF->extent.y;
    NNsi_ConvertLocation(&dimX, &dimY);
    
    // 𑜓xɂ킹ĕ\\s(nlines)vZ
    nlines = ((dimY) / (fontHeight));

    // f[^̊i[Ă̈擾
    source = (NNshMacroRecord *) NNshGlobal->scriptArea;

    // ^bvꂽCsڂvZ
    line = (pointY / fontHeight) +  NNshGlobal->pageTopLine;
    if (line <= NNshGlobal->currentScriptLine)
    {
        // ^bvꂽs̕ҏW_CAOJ
        edit = OpCodeInputDialog((line + 1), &(source[line]));
        // ԍŌ̍sҏWAPsҏẄǉB
        if ((edit == true)&&(line == NNshGlobal->currentScriptLine))
        {
            (NNshGlobal->currentScriptLine)++;
        }

        // ʂĕ`悷
        NNsi_putLine(FrmGetActiveForm(), GADID_GADGET_FIELD, 
                             BTNID_FIELDUP, BTNID_FIELDDOWN, NNSH_STEP_REDRAW);
        NNshGlobal->editFlag = true;
    }
    return (edit);
}

/*=========================================================================*/
/*   Function :   NNsh_MainCtlEvt                                          */
/*                                       CtH[̃Cxgnh  */
/*=========================================================================*/
Boolean NNsh_MainCtlEvt(EventType *event)
{
    switch (event->data.ctlSelect.controlID)
    {
      case BTNID_SET_NNSIMACRO:
        // }Nf[^̐ݒ
        return (extractMacroData());
        break;

      case BTNID_DB_SAVE:
        // }Nۑ
        return (saveMacroData());
        break;

      case BTNID_DB_READ:
        // }Nǂݍ
        return (loadMacroData());
        break;
  
      default:
        // ̑
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   NNsh_MainCtlRepEvt                                       */
/*                                       CtH[̃Cxgnh  */
/*=========================================================================*/
Boolean NNsh_MainCtlRepEvt(EventType *event)
{
    UInt16 command;

    // R}h
    command = NNSH_STEP_REDRAW;

    switch (event->data.ctlRepeat.controlID)
    {
      case BTNID_FIELDUP:
        // 1y[W
        command = NNSH_STEP_PAGEUP;
        break;

      case BTNID_FIELDDOWN:
        // 1y[W
        command = NNSH_STEP_PAGEDOWN;
        break;
  
      default:
        // ̑
        break;
    }
    if (command != NNSH_STEP_REDRAW)
    {
        // y[Wړ
        NNsi_putLine(FrmGetActiveForm(), GADID_GADGET_FIELD, 
                                      BTNID_FIELDUP, BTNID_FIELDDOWN, command);
        return (true);
    }
    return (false);

}

/*=========================================================================*/
/*   Function :   NNsh_MainMenuEvt                                         */
/*                                       CtH[̃Cxgnh  */
/*=========================================================================*/
Boolean NNsh_MainMenuEvt(EventType *event)
{

    switch (event->data.menu.itemID)
    {
      case MNUID_VERSION:
        // o[W̕\
        ShowVersion_NNsh();
        break;
      case MNUID_CHANGEFONT:
        // \tHg̕ύX
        return (changeDispFont());
        break;

      case MNUID_ALLDELETE:
        // S폜
        return (deleteAllScript());
        break;

      default:
        // Ȃ
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   Hander_MainForm                                          */
/*                                     NNsiݒn()Cxgnh  */
/*=========================================================================*/
Boolean Handler_MainForm(EventType *event)
{
    FormType      *frm;
    RectangleType  dimF;

    switch (event->eType)
    { 
      case menuEvent:
        // j[I
        return (NNsh_MainMenuEvt(event));
        break;

      case ctlSelectEvent:
        // {^ꂽ
        return (NNsh_MainCtlEvt(event));
        break;

      case ctlRepeatEvent:
        // {^ꂽ
        return (NNsh_MainCtlRepEvt(event));
        break;

      case penDownEvent:
        frm = FrmGetActiveForm();
        FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_GADGET_FIELD),&dimF);
        if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
        {
            // Gadget^bv
            return (NNsh_RctPointEvt(event, &dimF));
        }
        return (false);
        break;
      case keyDownEvent:
        // keyꂽ
        return (NNsh_KeyDownEvt(event));
        break;

      default: 
        return (false);
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   OpenForm_MainForm                                        */
/*                                                      MAINtH[J */
/*=========================================================================*/
Err OpenForm_MainForm(FormType *frm)
{
    RectangleType dimF;    

    // tB[hɃ_~[f[^
    NNshWinSetFieldText(frm, FLDID_DB_INFO, true, "", 80);
    
    FrmGetObjectBounds(frm, FrmGetObjectIndex(frm, GADID_GADGET_FIELD), &dimF);

    NNsi_putLine(frm, GADID_GADGET_FIELD, BTNID_FIELDUP, BTNID_FIELDDOWN, NNSH_STEP_TO_TOP);

    return (errNone);
}
