/*============================================================================*
 *  FILE: 
 *     msgview.c
 *
 *  Description: 
 *     Message(Thread) Viewer for NNsh. 
 *
 *===========================================================================*/
#define MSGVIEW_C
#include "local.h"
#include "Clipboard.h"

static Err PartReceiveMessage_View(void);
static void NNsh_Search_Message(UInt16 type, Char *str, Boolean flag);
static Err NNsh_Get_MessageToBuf(NNshMessageIndex *idxP, UInt16 msg, UInt16 type, Boolean flag);

/*-------------------------------------------------------------------------*/
/*   Function : pickupAnchor                                               */
/*                                    bZ[W̃AJ[oёI */
/*-------------------------------------------------------------------------*/
static Boolean pickupAnchor(NNshMessageIndex *idxP, Char *buffer, UInt16 size)
{
    Boolean ret;
    UInt16  itemCnt, bufCnt, getState, kanji, btnId;
    UInt32  dataSize;
    Char   *data, *chkPtr, *ptr, *labelP, *addrAddr[MAX_URL_LIST + 1], *ptr2;
    Char    tempURL[MAX_URL * 2 + MARGIN], tempLabel[MAX_NAMELABEL], *addrLabel;

    // AJ[of[^obt@̃TCYijm肷
    if ((idxP->openMsg + NNshParam->blockDispMode) > idxP->nofMsg)
    {
        dataSize = (idxP->msgOffset)[idxP->nofMsg];
    }
    else
    {
        dataSize = (idxP->msgOffset)[idxP->openMsg + NNshParam->blockDispMode];
    }
    dataSize = dataSize - (idxP->msgOffset)[idxP->openMsg - 1];

    if (idxP->fileOffset > (idxP->msgOffset)[idxP->openMsg - 1])
    {
         // f[^obt@Ƀf[^ǂݍ܂ĂȂ(肦Ȃ͂...)
         // G[ɂ
         return (false);
    }

    // f[^ẍ̊m
    addrLabel = MemPtrNew(((MAX_URL_LIST + 1) * MAX_NAMELABEL + MARGIN));
    if (addrLabel == NULL)
    {
        // f[^̈mێsAG[ɂ
        return (false);
    }
    MemSet(addrLabel, ((MAX_URL_LIST + 1) * MAX_NAMELABEL + MARGIN), 0x00);
    labelP = addrLabel;

    // "URLmF"BUSYtH[o͂
    Show_BusyForm(MSG_CHECK_URLLIST);
    

    // ϐdataɁAAJ[擪̃|C^ݒ肷
    data = idxP->buffer + (idxP->msgOffset)[idxP->openMsg - 1] - idxP->fileOffset - MARGIN;
    itemCnt = 0;
    chkPtr = data;

    // AJ[؂oC
    while (chkPtr < data + dataSize)
    {
        // obt@ɂAJ[Ti啶Ə̃AJ[j
        ptr = StrStr(chkPtr, "<a");
        ptr2 = StrStr(chkPtr, "<A");
        if ((ptr == NULL)&&(ptr2 == NULL))
        {
            // AJ[ȂA[v𔲂
            break;
        }
        // 啶AJ[̕OɂA啶AJ[Lɂ
        if ((ptr2 != NULL)&&(ptr > ptr2))
        {
            ptr = ptr2;
        }
        while (ptr < data + dataSize)
        {
            // 'href' T
            if (((*ptr == 'h')||(*ptr == 'H'))&&
                ((*(ptr + 1) == 'r')||(*(ptr + 1) == 'R'))&&
                ((*(ptr + 2) == 'e')||(*(ptr + 2) == 'E'))&&
                ((*(ptr + 3) == 'f')||(*(ptr + 3) == 'F')))
            {
                // hrefAgr[g
                ptr = ptr + 4; // hrefǂݔ΂
                while ((*ptr != '"')&&(*ptr != 0x00))
                {
                    ptr++;
                }
                if (*ptr == 0x00)
                {
                    // AJ[̓rŃobt@؂ꂽBBB[v𔲂
                    break;
                }
                ptr++;

                // URL؂oobt@̏
                bufCnt = 0;
                MemSet(tempURL, sizeof(tempURL), 0x00);

                if (StrNCaselessCompare(ptr, "http://", StrLen("http://")) != 0)
                {
                    // httpURLł͂ȂA炩߃x[XURLt
                    StrCopy(tempURL, idxP->baseURL);
                    bufCnt = StrLen(tempURL);

                    // URĹAzXg̐΃AhXw
                    if (*ptr == '/')
                    {
                        // zXg؂
                        bufCnt = StrLen("http://");
                        while ((tempURL[bufCnt] != '/')&&(tempURL[bufCnt] != '\0'))
                        {
                            bufCnt++;
                        }
                        tempURL[bufCnt] = '\0';                                                
                    }
                    else if (*ptr == '.')
                    {
                        // URĹÄʒu瑊΃AhXw肾ꍇAAA
                        ptr++;
                        ptr++;
                    }
                }

                // URLf[^̐؂o
                while ((*ptr != '"')&&(*ptr != 0x00)&&(bufCnt < (sizeof(tempURL) - 2)))
                {
                    tempURL[bufCnt] = *ptr;
                    ptr++;
                    bufCnt++;
                }
                // AJ[^O̖܂œǂݔ΂
                while ((*ptr != '>')&&(*ptr != 0x00))
                {
                    ptr++;
                }
                ptr++;

                // AJ[x̐؂o
                kanji = idxP->bbsType & NNSH_BBSTYPE_CHARSETMASK;
                getState = HTTP_ANCHORSTATE_NORMAL;
                bufCnt = 0;
                MemSet(tempLabel, MAX_NAMELABEL, 0x00);
                while ((*ptr != 0x00)&&(ptr < data + dataSize)&&
                        (bufCnt < (MAX_NAMELABEL - 2)))
                {
                    if ((kanji == NNSH_BBSTYPE_CHAR_JIS)&&(*ptr == 0x1b))
                    {
                        // GXP[vR[h KNJ/ANK؂ւ
                        if ((*(ptr + 1) == 0x24)&&(*(ptr + 2) == 0x42))
                        {
                            // R[hɐ؂ւ
                            getState = HTTP_ANCHORSTATE_KANJI;
                            tempLabel[bufCnt] = *ptr;
                            bufCnt++;
                            ptr++;
                            tempLabel[bufCnt] = *ptr;
                            bufCnt++;
                            ptr++;
                            tempLabel[bufCnt] = *ptr;
                            bufCnt++;
                            // ptr++ ́AifubN̎ɂƂŎ{
                        }
                        else if ((*(ptr + 1) == 0x28)&&(*(ptr + 2) == 0x42))
                        {
                            // ANK[hɐ؂ւ
                            getState = HTTP_ANCHORSTATE_NORMAL;
                            tempLabel[bufCnt] = *ptr;
                            bufCnt++;
                            ptr++;
                            tempLabel[bufCnt] = *ptr;
                            bufCnt++;
                            ptr++;
                            tempLabel[bufCnt] = *ptr;
                            bufCnt++;
                            // ptr++ ́AifubN̎ɂƂŎ{
                        }
                    }
                    else if ((*ptr == 0x0a)||(*ptr == 0x0d))
                    {
                        // sR[h͓ǂݔ΂
                    }
                    else if ((getState == HTTP_ANCHORSTATE_NORMAL)&&(*ptr == '<'))
                    {
                        getState = HTTP_ANCHORSTATE_ANCHOR;
                        if ((*(ptr + 1) == 'A')||(*(ptr + 1) == 'a'))
                        {
                            // ̃AJ[A
                            ptr--;
                            break;
                        }
                    }
                    else if ((getState == HTTP_ANCHORSTATE_ANCHOR)&&(*ptr == '>'))
                    {
                        getState = HTTP_ANCHORSTATE_NORMAL;
                    }
                    else if ((getState == HTTP_ANCHORSTATE_NORMAL)||
                              (getState == HTTP_ANCHORSTATE_KANJI))
                    {
                        tempLabel[bufCnt] = *ptr;
                        bufCnt++;
                    }
                    ptr++;                
                }
                
                // HTTPAJ[ő吔ɓBĂȂꍇAf[^
                if (itemCnt < MAX_URL_LIST)
                {
                    // URLAJ[i[
                    addrAddr[itemCnt] = MemPtrNew(StrLen(tempURL) + MARGIN);
                    if (addrAddr[itemCnt] == NULL)
                    {
                        // ̈mێsA[v𔲂
                        break;
                    }
                    MemSet(addrAddr[itemCnt], (StrLen(tempURL) + MARGIN), 0x00);
                    StrCopy(addrAddr[itemCnt], tempURL);

                    // f[^x(R[hϊɎ{)i[
                    switch (kanji)
                    {
                      case NNSH_BBSTYPE_CHAR_JIS:
                        StrCopyJIStoSJ(labelP, tempLabel);
                        break;

                      case NNSH_BBSTYPE_CHAR_EUC:
                        StrCopySJ(labelP, tempLabel);
                        break;

                      case NNSH_BBSTYPE_CHAR_SJIS:
                      default:
                        StrCopy(labelP, tempLabel);
                        break;
                    }
                    // ̖ɏȗL
                    labelP[StrLen(labelP)] = chrEllipsis;

                    // |C^̗̈Ɉړ
                    labelP = labelP + StrLen(labelP) + 1;

                    // ACe𑝂₷
                    itemCnt++;
                }
            }
            ptr++;
        }
        chkPtr = ptr;
    }  // while (chkPtr < data + dataSize)
    Hide_BusyForm(false);
    if (itemCnt == 0)
    {
        // PAJ[ȂAI
        return (false);
    }
    ret = false;

    // IEBhE\AURL̑I𑣂
    btnId = NNshWinSelectionWindow(FRMID_DIRSELECTION, addrLabel, itemCnt, 0);

    // OK{^ꂽƂAAA
    if (btnId != BTNID_JUMPCANCEL)
    {
        // f[^Rs[
        StrCopy(buffer, addrAddr[NNshGlobal->jumpSelection]);
        ret = true;

        // ꉞAJy[W(URL)\ł悤ɂĂ
        NNsh_DebugMessage(ALTID_INFO, buffer, MSG_WEBLAUNCH_CONFIRM, 0);
    }

    // mۂ̈J
    for (bufCnt = 0; bufCnt < itemCnt; bufCnt++)
    {
        MEMFREE_PTR(addrAddr[bufCnt]);
    }
    MEMFREE_PTR(addrLabel);

    return (ret); 
}

/*-------------------------------------------------------------------------*/
/*   Function : checkHideMessage                                           */
/*                                                  (Ȉ)NGL[[h{ */
/*-------------------------------------------------------------------------*/
static void checkHideMessage(Char *buffer)
{
    UInt16  loop, maxCnt;
    Char   *ptr, **data;

    NNshNGwordDatabase *dbData;
    DmOpenRef           dbRef;
    MemHandle           dbH;
    
    // NG`FbNPQsꍇAAA
    if ((NNshParam->hideMessage & NNSH_USE_NGWORD1AND2) == NNSH_USE_NGWORD1AND2)
    {
        // NGL[[hɈ邩`FbN
        if (NNshParam->hideWord1[0] != '\0')
        {
            if ((NNshParam->useRegularExpression != 0)&&
                (NNshGlobal->hide1.wordmemH != 0))
            {
                // NGL[[h𕡐w肵ꍇ...
                data = MemHandleLock(NNshGlobal->hide1.wordmemH);
                for (loop = 0; loop < NNshGlobal->hide1.nofWord; loop++)
                {
                    if (StrStr(buffer, data[loop]) != NULL)
                    {
                        // L[[hI
                        MemHandleUnlock(NNshGlobal->hide1.wordmemH);
                        goto REPLACE_MESSAGE;
                    }
                }
                MemHandleUnlock(NNshGlobal->hide1.wordmemH);
            }
            else
            {
                // NGL[[h𕡐w肵Ȃꍇ
                if (StrStr(buffer, NNshParam->hideWord1) != NULL)
                {
                    goto REPLACE_MESSAGE;
                }
            }
        }
        if (NNshParam->hideWord2[0] != '\0')
        {
            if ((NNshParam->useRegularExpression != 0)&&
                (NNshGlobal->hide2.wordmemH != 0))
            {
                // NGL[[h𕡐w肵ꍇ...
                data = MemHandleLock(NNshGlobal->hide2.wordmemH);
                for (loop = 0; loop < NNshGlobal->hide2.nofWord; loop++)
                {
                    if (StrStr(buffer, data[loop]) != NULL)
                    {
                        // L[[hI
                        MemHandleUnlock(NNshGlobal->hide2.wordmemH);
                        goto REPLACE_MESSAGE;
                    }
                }
                MemHandleUnlock(NNshGlobal->hide2.wordmemH);
            }
            else
            {
                // NGL[[h𕡐w肵Ȃꍇ
                if (StrStr(buffer, NNshParam->hideWord2) != NULL)
                {
                    goto REPLACE_MESSAGE;
                }
            }
        }
    }

    // NGmF-3{ꍇAAADBĂяođSR[h̕`FbN
    if ((NNshParam->hideMessage & NNSH_USE_NGWORD3) == NNSH_USE_NGWORD3)
    {
        // NG[hi[pDB̎擾
        OpenDatabase_NNsh(DBNAME_NGWORD, DBVERSION_NGWORD, &dbRef);
        if (dbRef == 0)
        {
            // ODB̃I[vsAI
            return;
        }

        // R[h擾
        GetDBCount_NNsh(dbRef, &maxCnt);

        // (S)f[^ǂݏoāANGL[[h`FbN
        for (loop = 0; loop < maxCnt; loop++)
        {
            GetRecordReadOnly_NNsh(dbRef, loop, &dbH, (void **) &dbData);

            // NGL[[hv邩`FbN
            if (StrStr(buffer, dbData->ngWord) != NULL)
            {
                // NGL[[hvA\Ȃ
                ReleaseRecordReadOnly_NNsh(dbRef, dbH);
                CloseDatabase_NNsh(dbRef);
                goto REPLACE_MESSAGE;
            }
            ReleaseRecordReadOnly_NNsh(dbRef, dbH);
        }
        // ȂADBN[Y
        CloseDatabase_NNsh(dbRef);
    }
    return;

REPLACE_MESSAGE:
    ptr = StrStr(buffer, " ");
    if (ptr == NULL)
    {
        ptr = buffer;
    }
    else
    {
        ptr++;
    }
    // bZ[Wu
    StrCopy(ptr, "* * *\n* * *\n");
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : setFavoriteLabel                                           */
/*                                            Cɓݒ̃xݒ */
/*-------------------------------------------------------------------------*/
static void setFavoriteLabel(FormType *frm, UInt16 attribute)
{
    ControlType *selP;

    // Cɓݒ̃ZN^gKIuWFNg擾
    selP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, SELTRID_FAVOR_THREAD));
    if (selP == NULL)
    {
        // IuWFNg̎擾s
        return;
    }

    switch (attribute & NNSH_MSGATTR_FAVOR)
    {
      case NNSH_MSGATTR_FAVOR_L1:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR_L1);
        break;

      case NNSH_MSGATTR_FAVOR_L2:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR_L2);
        break;

      case NNSH_MSGATTR_FAVOR_L3:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR_L3);
        break;

      case NNSH_MSGATTR_FAVOR_L4:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR_L4);
        break;

      case NNSH_MSGATTR_FAVOR:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR);
        break;

      default:
        // Cɓł͂Ȃ
        CtlSetLabel(selP, NNSH_ATTRLABEL_NOTFAVOR);
        break;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : outputMemoPad                                              */
/*                                                    փt@Co */
/*-------------------------------------------------------------------------*/
static void outputMemoPad(void)
{
    UInt16            len;
    FormType         *frm;
    Char             *buf, *ptr;
    NNshMessageIndex *idxP;

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;

    // Rs[pobt@̈mۂ
    buf = MemPtrNew(NNSH_LIMIT_MEMOPAD);
    if (buf == NULL)
    {
        // o͂LZ
        NNsh_InformMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL,
                           " size:", NNSH_LIMIT_MEMOPAD);
        return;
    }

    // ̐擪ɃX^Cgo͂
    StrCopy(buf, idxP->threadTitle);
    StrCat (buf, "\n---\n");

    // f[^ޗ̈^Cǧɐݒ肷
    ptr = buf + StrLen(buf);
    len = NNSH_LIMIT_MEMOPAD - StrLen(buf);

    // tB[hf[^obt@ɃRs[
    frm  = FrmGetActiveForm();
    NNshWinGetFieldText(frm, FLDID_MESSAGE, ptr, len);

    // Xf[^֓fo
    SendToLocalMemopad(idxP->threadTitle, buf);

    // obt@̈J
    MemPtrFree(buf);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : openWebBrowser                                             */
/*                                                       WebuEUŊJ */
/*-------------------------------------------------------------------------*/
static void openWebBrowser(UInt16 confirmation, Char *buffer, UInt16 size)
{
    MemHandle  memH;
    UInt16     len, savedParam;
    Char      *urlP, *ptr, *dest;

    // Nbv{[hɂf[^擾
    MemSet(buffer, size, 0x00);
    memH = ClipboardGetItem(clipboardText, &len);
    if ((len != 0)&&(memH != 0))
    {
        urlP = MemHandleLock(memH);
        if (urlP != NULL)
        {
            ptr = StrStr(urlP, "tp://");
            if (ptr != NULL)
            {
                // URL擾("http://")
                ptr = ptr + StrLen("tp://");
                StrCopy(buffer, "http://");
                dest = &buffer[StrLen(buffer)];

                // Nbv{[hURL̕(ASCII)𒊏o
                while ((dest < buffer + size)&&
                        (*ptr > ' ')&&(*ptr < 0x7f)&&
                        (*ptr != '<')&&(*ptr != '>')&&(*ptr != '`')&&
                        (*ptr != '{')&&(*ptr != '}')&&(*ptr != '^')&&
                        (*ptr != '|')&&(*ptr != '"')&&                        
                        (ptr  < urlP + len))
                {
                    *dest = *ptr;
                    dest++;
                    ptr++;
                }
            }
            MemHandleUnlock(memH);                
        }
    }
    if (buffer[0] != 0x00)
    {
        // NetFrontw肳ꂽURLŋN邩mF
        savedParam = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = confirmation;
        if (NNsh_ConfirmMessage(ALTID_CONFIRM, buffer,
                                MSG_WEBLAUNCH_CONFIRM, 0) == 0)
        {
            NNshParam->confirmationDisable = savedParam;

            // NetFrontN(NNsiIɋN)
            (void) WebBrowserCommand(NNshGlobal->browserCreator,
                                     0, 0, 
                                     NNshGlobal->browserLaunchCode,
                                     buffer, NULL);
        }
        NNshParam->confirmationDisable = savedParam;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : jumpPrevious                                               */
/*                                                PÕbZ[W֖߂ */
/*-------------------------------------------------------------------------*/
static void jumpPrevious(void)
{
    NNshMessageIndex *idxP;

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;
 
    // 1łWvĂΖ߂
    if (idxP->prevMsg[idxP->histIdx] != 0)
    {
        idxP->openMsg = idxP->prevMsg[idxP->histIdx];
        idxP->histIdx = (idxP->histIdx != 0) ?
                                       (idxP->histIdx - 1) : (PREVBUF - 1);
    }
    (void) displayMessage(NNshGlobal->msgIndex, 0);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : jumpEdge                                                   */
/*                                             bZ[Ẅړ(擪/) */
/*-------------------------------------------------------------------------*/
static void jumpEdge(Boolean loc)
{
    NNshMessageIndex *idxP;

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;

    idxP->histIdx = (idxP->histIdx < (PREVBUF - 1)) ? (idxP->histIdx + 1) : 0;
    idxP->prevMsg[idxP->histIdx] = idxP->openMsg;
    if (loc == false)
    {
        // X̐擪
        idxP->openMsg    = 1;
    }
    else
    {
        // X̖
        idxP->openMsg    = idxP->nofMsg;
    }
    (void) displayMessage(NNshGlobal->msgIndex, 0);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : parseMessage                                               */
/*                                                  (bZ[W̐`) */
/*-------------------------------------------------------------------------*/
static void parseMessage(Char *buf, Char *source, UInt32 size,
                         UInt16 *nofJmp, UInt16 *jmpBuf, UInt16 kanjiCode,
                         Boolean setJumpFlag)
{
    Boolean kanjiMode;
    UInt32 dataStatus, jmp;
    UInt16 len; 
    Char *ptr, *dst, *num;

    dataStatus = MSGSTATUS_NAME;
    kanjiMode = false;

    // x߃[`... (PÂp[X)
    dst  = buf;
    ptr  = source;
    while (ptr < (source + size))
    {
        // JISR[h̕ϊWbN
        if (kanjiCode == NNSH_KANJICODE_JIS)
        {
            // JISSHIFT JIS̃R[hϊ
            if ((*ptr == '\x1b')&&(*(ptr + 1) == '\x24')&&(*(ptr + 2) == '\x42'))
            {
                // [hɐ؂ւ
                kanjiMode = true;
                ptr = ptr + 3;
                continue;
            }
            if ((*ptr == '\x1b')&&(*(ptr + 1) == '\x28')&&(*(ptr + 2) == '\x42'))
            {
                // ANK[hɐ؂ւ
                kanjiMode = false;
                ptr = ptr + 3;
                continue;
            }
            if (kanjiMode == true)
            {
                // JIS > SJIS ϊ
                ConvertJIStoSJ(dst, ptr);
                ptr = ptr + 2;
                dst = dst + 2;
                continue;
            }
        }
        if (*ptr == '&')
        {
            // "&gt;"  '>' ɒu
            if ((*(ptr + 1) == 'g')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == ';'))
            {
                *dst++ = '>';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                if ((setJumpFlag == true) && (*ptr <= '9')&&(*ptr >= '0'))
                {
                    // XԂ擾
                    num = ptr;
                    jmp = 0;
                    while ((*num <= '9')&&(*num >= '0'))
                    {
                        jmp = jmp * 10 + (*num - '0');
                        num++;
                    }
                    if ((*nofJmp < JUMPBUF)&&(jmp != 0))
                    {
                        // XԂobt@ɒǉ
                        jmpBuf[*nofJmp] = jmp;
                        (*nofJmp)++;
                    }
                }
                continue;
            }
            // "&lt;"  '<' ɒu
            if ((*(ptr + 1) == 'l')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == ';'))
            {
                *dst++ = '<';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&quot;"  '"' ɒu
            if ((*(ptr + 1) == 'q')&&(*(ptr + 2) == 'u')&&
                (*(ptr + 3) == 'o')&&(*(ptr + 4) == 't')&&(*(ptr + 5) == ';'))
            {
                *dst++ = '"';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&nbsp;"  '    ' ɒu
            if ((*(ptr + 1) == 'n')&&(*(ptr + 2) == 'b')&&
                (*(ptr + 3) == 's')&&(*(ptr + 4) == 'p')&&(*(ptr + 5) == ';'))
            {
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&amp;"  '&' ɒu
            if ((*(ptr + 1) == 'a')&&(*(ptr + 2) == 'm')&&
                (*(ptr + 3) == 'p')&&(*(ptr + 4) == ';'))
            {
                // MR̂ەϊ΍... ()
                if ((*(ptr + 5) == 'g')&&(*(ptr + 6) == 't')&&(*(ptr + 7) == ';'))
                {
                    *dst++ = '>';
                    ptr = ptr + 8;    // StrLen(TAG_AMP)+ 'g' + 't' + ';';
                    if ((setJumpFlag == true) && (*ptr <= '9')&&(*ptr >= '0'))
                    {
                        // XԂ擾
                        num = ptr;
                        jmp = 0;
                        while ((jmp < NNSH_MESSAGE_LIMIT)&&
                               (*num <= '9')&&(*num >= '0'))
                        {
                            jmp = jmp * 10 + (*num - '0');
                            num++;
                        }
                        if ((*nofJmp < JUMPBUF)&&(jmp != 0))
                        {
                            // XԂobt@ɒǉ
                            jmpBuf[*nofJmp] = jmp;
                            (*nofJmp)++;
                        }
                    }
                    continue;
                }
                // MR̂ەϊ΍... (܂)

                *dst++ = '&';
                ptr = ptr + 5;    // StrLen(TAG_AMP);
                continue;
            }
            // ͂肦Ȃ͂...ꉞB
            *dst++ = '&';
            ptr++;
            continue;
        }
        if (*ptr == '<')
        {
            //  "<>" ́AZp[^(Ԃɂĕς)
            if (*(ptr + 1) == '>')
            {
                ptr = ptr + 2;   // StrLen(DATA_SEPARATOR);
                switch (dataStatus)
                {
                  case MSGSTATUS_NAME:
                    // Ő؂
                    *dst++ = ' ';
                    *dst++ = ' ';
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_EMAIL;
                    break;

                  case MSGSTATUS_EMAIL:
                    // e-mail̋؂
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_DATE;
                    *dst++ = '\n';
                    break;

                  case MSGSTATUS_DATE:
                    // NEԂтhc̋؂
                    *dst++ = '\n';
                    *dst++ = '\n';
                    dataStatus = MSGSTATUS_NORMAL;
                    break;

                  case MSGSTATUS_NORMAL:
                  default:
                    // bZ[W̏I[
                    *dst++ = ' ';
                    *dst++ = '\0';
                    return;
                    break;
                }
                continue;
            }
            //  "<br>" ́Asɒu
            if (((*(ptr + 1) == 'b')&&(*(ptr + 2) == 'r')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'B')&&(*(ptr + 2) == 'R')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<p>" ́As2ɒu
            if (((*(ptr + 1) == 'p')&&(*(ptr + 2) == '>'))||
                ((*(ptr + 1) == 'P')&&(*(ptr + 2) == '>')))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 3;        // StrLen(DATA_NEWLINE);
                continue;
            }

            // <li>^OsR[h:ɒu
            if (((*(ptr + 1) == 'l')&&(*(ptr + 2) == 'i')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'L')&&(*(ptr + 2) == 'I')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = '';
                ptr = ptr + 4;
                continue;
            }   

            //  "<hr>" ́As === s ɒu
            if (((*(ptr + 1) == 'h')&&(*(ptr + 2) == 'r')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'R')&&(*(ptr + 2) == 'R')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = '=';
                *dst++ = '=';
                *dst++ = '=';
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<dt>"́Asɒu
            if (((*(ptr + 1) == 'd')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'D')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "</tr>"  "</td>" ́Asɒu
            if (((*(ptr + 1) == '/')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == 'r')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == 'R')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == 'd')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == 'D')&&(*(ptr + 4) == '>')))
            {
                *dst++ = '\n';
                ptr = ptr + 5;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<dd>" ́AsƋ󔒂Sɒu
            if (((*(ptr + 1) == 'd')&&(*(ptr + 2) == 'd')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'D')&&(*(ptr + 2) == 'D')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            // ̑̃^O͓ǂݔ΂
#ifdef USE_STRSTR
            ptr = StrStr(ptr, ">");
#else
            while ((*ptr != '>')&&(*ptr != '\0'))
            {
                ptr++;
            }
#endif
            ptr++;
            *dst++ = ' ';
            continue;
        }
        // R[hEUCꍇ...
        if (kanjiCode == NNSH_KANJICODE_EUC)
        {
            if (ConvertEUCtoSJ((UInt8 *) dst, (UInt8 *) ptr, &len) == true)
            {
                // EUC > SHIFT JISϊs
                dst = dst + len;
                ptr = ptr + 2;
                continue;
            }
            if (*ptr != '\0')
            {
                // ʂ̈ꕶ]
                *dst++ = *ptr;
            }
            ptr++;
            continue;
        }
        if (NNshParam->convertHanZen != 0)
        {
            if (((UInt8) *ptr >= 0x81)&&((UInt8) *ptr <= 0x9f))
            {
                // 2oCgƔ
                *dst++ = *ptr;
                ptr++;
                *dst++ = *ptr;
                ptr++;
                continue;
            }
            if (((UInt8) *ptr >= 0xe0)&&((UInt8) *ptr <= 0xef))
            {
                // 2oCgƔ
                *dst++ = *ptr;
                ptr++;
                *dst++ = *ptr;
                ptr++;
                continue;
            }
            // pJiSpϊ
            if (ConvertHanZen((UInt8 *) dst, (UInt8 *) ptr) == true)
            {
                dst = dst + 2;
                ptr++;
                continue;
            }
        }

        // Xy[XAĂꍇAPɌ炷
        if ((*ptr == ' ')&&(*(ptr + 1) == ' '))
        {
            ptr++;
            while ((*ptr == ' ')&&(ptr < (source + size)))
            {
                ptr++;
            }
            ptr--;
        }        

        // NULL  0x0a, 0x0d, 0x09(^u) ͖
        if ((*ptr != '\0')&&(*ptr != 0x0a)&&(*ptr != 0x0d)&&(*ptr != 0x09))
        {
            // ʂ̈ꕶ]
            *dst++ = *ptr;
        }
        ptr++;
    }
    *dst++ = '\0';
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : changeFont                                                 */
/*                                                          tHg̕ύX */
/*-------------------------------------------------------------------------*/
static void changeFont(void)
{
    FormType  *frm;

#ifdef USE_TSPATCH
    UInt32 fontId, ver;
    Err    ret;
#endif

    frm = FrmGetActiveForm();

    // tHgID̑I
    if (NNshParam->useSonyTinyFont != 0)
    {
        // SONYnC]tHgύX
        NNshParam->sonyHRFont = FontSelect(NNshParam->sonyHRFont);

        // tB[h̕`(nC])
        NNsi_HRFldDrawField(FrmGetObjectPtr(frm, 
                              FrmGetObjectIndex(frm, FLDID_MESSAGE)), 0);
        // XN[o[̍XV
        NNsi_HRSclUpdate(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, SCLID_MESSAGE)));
    }
    else
    {
        // ʏtHgύX
        NNshParam->currentFont = FontSelect(NNshParam->currentFont);

#ifdef USE_TSPATCH
        // TsPatch@\gƂ...
        if (NNshParam->notUseTsPatch == 0)
        {    
            // TsPatchKpǂ`FbN
            ret = FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_FONT_SUPPORT, &ver);
            if (ret == errNone)
            {    
                // TsPatchKp...tHgB
                switch (NNshParam->currentFont)
                {
                  case stdFont:
                    FtrGet(SmallFontAppCreator, SMF_FTR_TINY_FONT, &fontId);
                    break;

                  case boldFont:
                    FtrGet(SmallFontAppCreator, SMF_FTR_TINY_BOLD_FONT, &fontId);
                    break;

                  case largeFont:
                    FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_FONT, &fontId);
                    break;

                  case largeBoldFont:
                    FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_BOLD_FONT, &fontId);
                    break;

                  default:
                    fontId = NNshParam->currentFont;
                    break;
                }
                NNshParam->currentFont = fontId;
            }
        }
#endif  // #ifdef USE_TSPATCH

        // tB[h̕`(ʏ)
        FldSetFont(FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE)),
                                   NNshParam->currentFont);

        // XN[o[XVāAʏ̉ʕ`s
        NNshWinViewUpdateScrollBar(FLDID_MESSAGE, SCLID_MESSAGE);
        FrmDrawForm(frm);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : ReadMessage_Close                                          */
/*                                                      QƉʂ̃N[Y */
/*-------------------------------------------------------------------------*/
void ReadMessage_Close(UInt16 nextFormID)
{
    NNshMessageIndex *idxP;

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;
    if (idxP != NULL)
    {
        // uݒvĂꍇA
        if ((NNshParam->useBookmark != 0)&&(NNshParam->bookMsgNumber != 0))
        {
            if (NNshGlobal->bookmarkNick != NULL)
            {
                // ݒ肳ĂL
                StrCopy(NNshGlobal->bookmarkNick,
                        idxP->boardNick);
            }
            if (NNshGlobal->bookmarkFileName != NULL)
            {
                // ݒ肳ĂXhcL
                StrCopy(NNshGlobal->bookmarkFileName,
                        idxP->threadFile);
            }
        }

        MEMFREE_PTR((NNshGlobal->msgIndex)->msgOffset);

        CloseFile_NNsh(&(idxP->fileRef));
        MEMFREE_PTR(NNshGlobal->msgIndex);
    }

    // nC]pf[^lNA
    NNshGlobal->totalLine   = 0;
    NNshGlobal->nofPage     = 0;
    NNshGlobal->currentPage = 0;
    NNshGlobal->prevHRLines = 0;

#ifdef USE_COLOR
    // tH[I[vƂɍXVFɖ߂
    if (NNshParam->useColor != 0)
    {
        // F(OiFAFAwiF)ɖ߂
        UIColorSetTableEntry(UIObjectForeground, &NNshGlobal->fgColor);
        UIColorSetTableEntry(UIFieldText,        &NNshGlobal->txColor);
        UIColorSetTableEntry(UIFieldBackground,  &NNshGlobal->bgColor);
        UIColorSetTableEntry(UIFormFill,         &NNshGlobal->bgFormColor);
        UIColorSetTableEntry(UIDialogFill,       &NNshGlobal->bgDialogColor);
        UIColorSetTableEntry(UIAlertFill,        &NNshGlobal->bgAlertColor);
        UIColorSetTableEntry(UIObjectFill,       &NNshGlobal->bgObjectColor);

        // OiFƔwiFݒ肷
        WinSetForeColor(UIColorGetTableEntryIndex(UIFieldText));
        WinSetTextColor(UIColorGetTableEntryIndex(UIFieldText));
        WinSetBackColor(UIColorGetTableEntryIndex(UIFieldBackground));
    }
#endif

    // XIʂJ
    FrmEraseForm(FrmGetActiveForm());
    FrmGotoForm(nextFormID);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : displayMessageSub                                          */
/*                                                   bZ[W\C  */
/*-------------------------------------------------------------------------*/
static void displayMessageSub(UInt16 bbsType, Char *topP, UInt32 mesNum,
                              UInt32 offset,  UInt32 size, Char *buf,
                              Boolean setJumpFlag)
{
    Char        *ptr, *nameP;
    UInt32       msgSize;
    UInt16       kanjiCode, resNum;
#ifdef USE_ARMLET
    UInt32       armArgs[8], nofJump, lp, jmpMsg[JUMPBUF], hanzen;
    MemHandle    armH;
    void        *armP;
#endif
    NNshMessageIndex *idxP;
    idxP = NNshGlobal->msgIndex;

    // R[h̐ݒƃbZ[W̐`
    kanjiCode = NNSH_KANJICODE_SHIFTJIS;
    switch (bbsType & NNSH_BBSTYPE_MASK)
    {
      case NNSH_BBSTYPE_SHITARABAJBBS:
        kanjiCode = NNSH_KANJICODE_EUC;
        ptr = StrStr((topP + offset), NNSH_JBBSTOKEN_MSGSTART);
        if (ptr == NULL)
        {
            ptr = topP + offset;
        }
        else
        {
            ptr = ptr + StrLen(NNSH_JBBSTOKEN_MSGSTART);
        }
        // bZ[WTCY̌킹... (Ō̂QAĂȂ񂾂H)
        // msgSize = size - (ptr - (topP + offset)) - 2;
        msgSize = size - (ptr - (topP + offset));
        break;

      case NNSH_BBSTYPE_MACHIBBS:
        ptr = StrStr((topP + offset), NNSH_MACHITOKEN_MSGSTART);
        if (ptr == NULL)
        {
            ptr = topP + offset;
        }
        else
        {
            ptr = ptr + StrLen(NNSH_MACHITOKEN_MSGSTART);
        }
        // bZ[WTCY̌킹...
        msgSize = size - (ptr - (topP + offset)) - 2;
        break;

      case NNSH_BBSTYPE_SHITARABA:
        kanjiCode = NNSH_KANJICODE_EUC;
        ptr     = (topP + offset);
        msgSize = size;
        break;

      case NNSH_BBSTYPE_HTML:
        // R[hE
        kanjiCode = (NNSH_BBSTYPE_CHARSETMASK & bbsType) >> NNSH_BBSTYPE_CHAR_SHIFT;
        // not break;

      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_OTHERBBS:
      default:
        ptr     = (topP + offset);
        msgSize = size;
        break;
    }

    // 擪ɃbZ[Wԍ\
    if (NNshParam->boldMessageNum != 0)
    {
        StrCopy(buf, "y");
        NUMCATI(buf, mesNum);
        StrCat (buf, "z ");
    }
    else
    {
        StrCopy(buf, "[");
        NUMCATI(buf, mesNum);
        StrCat (buf, "] ");
    }

    // HTML^Cṽf[^Asڂɂ̓f[^\Ȃ悤ɏ׍H
    if ((bbsType & NNSH_BBSTYPE_MASK) == NNSH_BBSTYPE_HTML)
    {
        // ŉ炩̏H
        StrCat(buf, "\n");
    }

    // O̔pXԂƂĒǉ
    // (ɓ̂́AAAƂ肠...)
    nameP = ptr;
    while ((*nameP == ' ')||(*nameP == '\x0d'))
    { 
        nameP++;
    }
    resNum = 0;
    if ((*nameP >= '1')&&(*nameP <= '9'))
    {
        resNum = *nameP - '0';
        nameP++;
        while ((*nameP >= '0')&&(*nameP <= '9'))
        {
            resNum = resNum * 10 + *nameP - '0';
            nameP++;
        }

        if (setJumpFlag == true)
        {
            // O̐i[
            idxP->jumpMsg[idxP->nofJump] = resNum;
            (idxP->nofJump)++;
        }
    }
    
    // RAW-disp[h̃`FbN
    if (NNshParam->rawDisplayMode != 0)
    {
        // RAW-display[hA͒PRs[Ƃ
        StrNCopy((buf + StrLen(buf)), ptr, msgSize);
        return;
    }

// ARMletgpăbZ[W̉͂sB(łAȂ񂩖ʂȏ...)
#ifdef USE_ARMLET
    // ARMlet̊֐|C^擾
    if ((NNshParam->useARMlet != 0)&&(kanjiCode == NNSH_KANJICODE_SHIFTJIS))
    {
        armH = DmGetResource('armc', RSCID_parseMessage_ARM);
        if (armH != 0)
        {
            armP = MemHandleLock(armH);
            if (armP != NULL)
            {
                // ARMletgpẴCfbNX͏
                hanzen     = NNshParam->convertHanZen;
                MemSet(armArgs, sizeof(armArgs), 0x00);
                armArgs[0] = (UInt32) (buf + StrLen(buf));
                armArgs[1] = (UInt32) ptr;
                armArgs[2] = (UInt32) msgSize;
                armArgs[3] = (UInt32) &(nofJump);
                armArgs[4] = (UInt32) &(jmpMsg[0]);
                armArgs[5] = (UInt32) hanzen;
                armArgs[6] = (UInt32) &Han2ZenTable[0];
                armArgs[7] = (UInt32) setJumpFlag;
                (void) PceNativeCall(armP, armArgs);
                MemHandleUnlock(armH);

                if (setJumpFlag == true)
                {
                    // ȏA(68k)łĂX|CȂ...
                    for (lp = 0; ((lp < nofJump)&&(idxP->nofJump < JUMPBUF)); lp++)
                    {
                        idxP->jumpMsg[idxP->nofJump] = (UInt16) jmpMsg[lp];
                        (idxP->nofJump)++;
                    }
                }
            }
            else
            {
                // (W)CfbNX͏
                parseMessage((buf + StrLen(buf)), ptr, msgSize,
                             &(idxP->nofJump), &(idxP->jumpMsg[0]),kanjiCode,
                             setJumpFlag);
            }
            DmReleaseResource(armH);
        }
        else
        {
            // (W)CfbNX͏
            parseMessage((buf + StrLen(buf)), ptr, msgSize,
                         &(idxP->nofJump), &(idxP->jumpMsg[0]), kanjiCode,
                         setJumpFlag);
        }
    }
    else
#endif
    {
        // (W)CfbNX͏
        parseMessage((buf + StrLen(buf)), ptr, msgSize,
                     &(idxP->nofJump), &(idxP->jumpMsg[0]), kanjiCode,
                     setJumpFlag);
    }

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : displayMessage                                             */
/*                                                   bZ[W\  */
/*-------------------------------------------------------------------------*/
static Err displayMessage(NNshMessageIndex *idxP, UInt16 isBottom)
{
    FormType    *frm;
    FieldType   *fldP;
    MemHandle    txtH, oldTxtH;
    Err          ret = errNone;
    UInt16       msg, allocSize, lp;
    UInt32       offset;
    Char        *buf;

    // ϐ̏
    msg    = idxP->openMsg;
    offset = 0;

    //  w肳ꂽbZ[WԍÓ`FbNB
    if ((msg < 1)||(msg > idxP->nofMsg))
    {
        return (~errNone);
    }

    // obt@烁bZ[W擾
    ret = NNsh_Get_MessageToBuf(idxP, msg, GET_MESSAGE_TYPE_HALF, true);
    if ((ret == errNone)||(ret == vfsErrFileEOF)||(ret == fileErrEOF))
    {
        // \obt@mۂ
        if ((msg + NNshParam->blockDispMode) > idxP->nofMsg)
        {
            allocSize = (idxP->msgOffset)[idxP->nofMsg];
        }
        else
        {
            allocSize = (idxP->msgOffset)[msg + NNshParam->blockDispMode];
        }
        allocSize = allocSize - (idxP->msgOffset)[msg - 1] + TINYBUF;
        allocSize = allocSize + allocSize;

        txtH = MemHandleNew(allocSize);
        if (txtH == 0)
        {
            // ̈̊mۂɎsꍇAG[\
            NNsh_InformMessage(ALTID_WARN, MSG_SUBJECT_LISTFAIL,
                               " size:", allocSize);
            return (~errNone);
        }
        buf  = MemHandleLock(txtH);
        if (buf == NULL)
        {
            MemHandleFree(txtH);
            NNsh_InformMessage(ALTID_WARN, "MemHandleLock()", " ", 0);
            return (~errNone);
        }
        MemSet(buf, allocSize, 0x00);

        // Wvԍobt@
        idxP->nofJump = 0;
        idxP->dispMsg = NNshParam->blockDispMode;
        lp = 1;
        do {
            // bZ[W̐`
            offset = ((idxP->msgOffset)[msg - 1] - (idxP->fileOffset));
            displayMessageSub(idxP->bbsType, idxP->buffer, msg, offset,
                              (idxP->msgOffset)[msg] - (idxP->msgOffset)[msg - 1],
                              buf, true);
            msg++;
            // RAW-disp[hłȂAL[[h`FbNwĂƂ́A
            if ((NNshParam->rawDisplayMode == 0)&&(NNshParam->hideMessage != 0))
            {
                // (ȒP)NGL[[h`FbN
                checkHideMessage(buf);
            }

            if ((NNshParam->blockDispMode == 0)||(msg > idxP->nofMsg))
            {
                // A\łȂA̓X̖܂ŕ\()
                idxP->dispMsg = lp;
                break;
            }

            // f[^ւ̃Zp[^\
            StrCat(buf, "\n------\n");
            buf = buf + StrLen(buf);

            // obt@Ƀf[^ǂݍ܂Ă邩mF
            if (((idxP->msgOffset)[msg - 1]  < idxP->fileOffset)||
                ((idxP->msgOffset)[msg] - 1  > idxP->fileOffset + idxP->fileReadSize))
            {
                // ̃f[^ݓǂݍ܂Ăobt@ɑ݂Ȃꍇ͔
                idxP->dispMsg = lp;
                break;
            }            
            lp++;
        } while (lp <= NNshParam->blockDispMode);

       (void) MemHandleUnlock(txtH);

        //////////// tB[h̕\ ////////////
        frm     = FrmGetActiveForm();
        fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
        oldTxtH = FldGetTextHandle(fldP);
        FldSetTextHandle(fldP, NULL);
        FldSetTextHandle(fldP, txtH);
        if (oldTxtH != 0)
        {
            (void) MemHandleFree(oldTxtH);
        }


        // `惂[h̐؂ւ
        if (NNshParam->useSonyTinyFont != 0)
        {
            // tB[h̕\nϐNA
            NNshGlobal->totalLine   = 0;
            NNshGlobal->nofPage     = 0;
            NNshGlobal->currentPage = 0;
            NNshGlobal->prevHRLines = 0;

            // tB[h̕`(nC])
            NNsi_HRFldDrawField(fldP, isBottom);

            // XN[o[̍XV
            NNsi_HRSclUpdate(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, SCLID_MESSAGE)));
        }
        else
        {
            // tB[h̕`(ʏ)
            FldDrawField(fldP);

            // XN[o[̕\XV
            NNshWinViewUpdateScrollBar(FLDID_MESSAGE, SCLID_MESSAGE);

            FrmDrawForm(frm);
        }
    }

    // ǂ񂾃bZ[Wԍ(ƂCɓ)L
    MarkMessageIndex(NNshParam->openMsgIndex, NNSH_MSGATTR_NOTSPECIFY);

    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : moveMessageNext                                            */
/*                                           ЂƂ̃bZ[W\  */
/*-------------------------------------------------------------------------*/
static Boolean moveMessageNext(Boolean chkScroll)
{
    Boolean           ret = false;
    NNshMessageIndex *idxP;

    // indexϐɓ
    idxP = NNshGlobal->msgIndex;

    // bZ[W̃XN[`FbN
    if (chkScroll == true)
    {
        ret = NNshWinViewPageScroll(FLDID_MESSAGE, SCLID_MESSAGE, 0, winDown); 
    }

    if (NNshParam->blockDispMode == 0)
    {
        if ((ret != true)&&(idxP->openMsg < idxP->nofMsg))
        {
             // \bZ[WԍXVAʕ\B
             (idxP->openMsg)++;
             (void) displayMessage(NNshGlobal->msgIndex, 0);
             ret = true;
        }
    }
    else
    {
        // XA\[ĥƂ
        if (ret != true)
        {
            // \bZ[WԍXV
            if ((idxP->openMsg + idxP->dispMsg) <= idxP->nofMsg)
            {
                idxP->openMsg =  idxP->openMsg + idxP->dispMsg;

                // ʕ\B
                (void) displayMessage(NNshGlobal->msgIndex, 0);
                return (true);
            }
            if (idxP->openMsg < idxP->nofMsg)
            {
                // ܂œǂ񂾂ƂɂB
                idxP->openMsg =  idxP->nofMsg;

                // ǂ񂾃bZ[Wԍ(ƂCɓ)L
                MarkMessageIndex(NNshParam->openMsgIndex,
                                 NNSH_MSGATTR_NOTSPECIFY);
                ret = true;
            }
        }
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : moveMessagePrev                                            */
/*                                             ЂƂÕbZ[W\  */
/*-------------------------------------------------------------------------*/
static Boolean moveMessagePrev(Boolean chkScroll, UInt16 dispLoc)
{
    Int16             resNum;
    Boolean           ret = false;
    NNshMessageIndex *idxP;

    // indexϐɓ
    idxP = NNshGlobal->msgIndex;

    // bZ[W̃XN[`FbN
    if (chkScroll == true)
    {
        ret = NNshWinViewPageScroll(FLDID_MESSAGE, SCLID_MESSAGE, 0,  winUp);
    }

    // ƂŃt@N^KvH
    if (NNshParam->blockDispMode == 0)
    {
        if ((ret != true)&&(idxP->openMsg > 1))
        {
            // \bZ[WԍXVAʕ\B
            (idxP->openMsg)--;
            (void) displayMessage(NNshGlobal->msgIndex, dispLoc);
            ret = true;
        }
    }
    else
    {
        // XA\[ĥƂ
        if (ret != true)
        {
            // \bZ[WԍXV
            resNum = idxP->openMsg - NNshParam->blockDispMode;
            if (resNum >= 1)
            {
                idxP->openMsg = idxP->openMsg - NNshParam->blockDispMode;

                // ʕ\B
                (void) displayMessage(NNshGlobal->msgIndex,
                                      NNshParam->dispBottom);
            }
            else
            {
                idxP->openMsg = 1;

                // ʕ\B
                (void) displayMessage(NNshGlobal->msgIndex, 0);
            }
            ret = true;
        }
    }
    return (ret);
}
/*-------------------------------------------------------------------------*/
/*   Function : jumpMessage                                                */
/*                                                (bZ[WWv) */
/*-------------------------------------------------------------------------*/
static Boolean jumpMessage(FormType *frm, NNshMessageIndex *idxP)
{
    UInt16     tempMsg, num, btnId, size, nofItems, savedParam;
    UInt16     jumpList[NNSH_NOF_JUMPMSG_EXT + JUMPBUF + 2];
    UInt16     msgAttribute;
    EventType *dummyEvent;
    FieldType *fldP;
    Char      *numP, buffer[BUFSIZE * 2];
    MemHandle  txtH;

    // ͂ꂽl擾
    tempMsg = idxP->openMsg;
    fldP    = FrmGetObjectPtr(frm, 
                              FrmGetObjectIndex(frm, FLDID_MESSAGE_NUMBER));
    txtH = FldGetTextHandle(fldP);
    if (txtH != NULL)
    {
        numP = MemHandleLock(txtH);
        num = StrAToI(numP);

        // lÓȂ̂`FbN
        if ((num > 0)&&(num <= idxP->nofMsg))
        {
            tempMsg = num;
        }
        MemHandleUnlock(txtH);
    }

    // tB[hɓ͂ĂȂꍇ
    if (tempMsg == idxP->openMsg)
    {
        //  Go{^ꂽƂA͂ĂȂꍇA
        //  ߂XԍXgIuWFNgƂĕ\B
        size = (idxP->nofJump + NNSH_NOF_JUMPMSG_EXT + 1) * NNSH_JUMPMSG_LEN;
        idxP->jumpListTitles = MemPtrNew(size);
        if (idxP != NULL)
        {
            // Xgɕ\^CgXg쐬
            nofItems = 0; 
            MemSet(jumpList, sizeof(jumpList), 0x00);
            MemSet(idxP->jumpListTitles, 0x00, size);
            numP = idxP->jumpListTitles;

            if (NNshParam->addReturnToList != 0)
            {
                // XgɁuꗗցvǉ
                StrCopy(numP, NNSH_JUMPMSG_TO_LIST);
                numP = numP + sizeof(NNSH_JUMPMSG_TO_LIST);
                jumpList[nofItems] = (NNSH_JUMPSEL_TO_LIST);
                nofItems++;
            }

            // Wvԍݒ肷
            for (num = 0; num < idxP->nofJump; num++)
            {
                // Wvԍ͈͊Ȏ傫Ȓl̂Ƃ͕\Ȃ
                if (idxP->jumpMsg[num] <= idxP->nofMsg)
                {
                    StrCopy(numP, NNSH_JUMPMSG_HEAD);
                    NUMCATI(numP, idxP->jumpMsg[num]);
                    numP = numP + StrLen(numP) + 1;
                    jumpList[nofItems] = idxP->jumpMsg[num];
                    nofItems++;
                }
            }

            if (NNshParam->addMenuBackRtnMsg != 0)
            {
                // XgɁuP߂vǉ
                StrCopy(numP, NNSH_JUMPMSG_BACK);
                numP = numP + sizeof(NNSH_JUMPMSG_BACK);
                jumpList[nofItems] = (NNSH_JUMPSEL_BACK);
                nofItems++;
            }

            if (NNshParam->addJumpTopMsg != 0)
            {
                // XgɁu擪ցvǉ
                StrCopy(numP, NNSH_JUMPMSG_TOP);
                numP = numP + sizeof(NNSH_JUMPMSG_TOP);
                jumpList[nofItems] = (NNSH_JUMPSEL_TOP);
                nofItems++;
            }

            if (NNshParam->addJumpBottomMsg != 0)
            {
                // XgɁuցvǉ
                StrCopy(numP, NNSH_JUMPMSG_BOTTOM);
                numP = numP + sizeof(NNSH_JUMPMSG_BOTTOM);
                jumpList[nofItems] = (NNSH_JUMPSEL_BOTTOM);
                nofItems++;
            }

            if (NNshParam->addMenuMsg != 0)
            {
                // XgɁuj[vǉ
                StrCopy(numP, NNSH_JUMPMSG_OPEN_MENU);
                numP = numP + sizeof(NNSH_JUMPMSG_OPEN_MENU);
                jumpList[nofItems] = (NNSH_JUMPSEL_OPEN_MENU);
                nofItems++;
            }

            if (NNshParam->addLineGetPart != 0)
            {
                // XgɁu擾vǉ
                StrCopy(numP, NNSH_JUMPMSG_UPDATE);
                numP = numP + sizeof(NNSH_JUMPMSG_UPDATE);
                jumpList[nofItems] = (NNSH_JUMPSEL_UPDATE);
                nofItems++;
            }

            if (NNshParam->addLineDisconn != 0)
            {
                // XgɁuؒfvǉ
                StrCopy(numP, NNSH_JUMPMSG_HANGUP);
                numP = numP + sizeof(NNSH_JUMPMSG_HANGUP);
                jumpList[nofItems] = (NNSH_JUMPSEL_HANGUP);
                nofItems++;
            }

            if (NNshGlobal->browserCreator != 0)
            {
                if (NNshParam->addMenuSelAndWeb != 0)
                {
                    // XgɁuI+Webvǉ
                    StrCopy(numP, NNSH_JUMPMSG_OPENWEB);
                    numP = numP + sizeof(NNSH_JUMPMSG_OPENWEB);
                    jumpList[nofItems] = (NNSH_JUMPSEL_OPENWEB);
                    nofItems++;
                }
            }

            if ((NNshGlobal->browserCreator != 0)&&
                ((idxP->bbsType & NNSH_BBSTYPE_MASK) == NNSH_BBSTYPE_HTML))
            {
                // XgɁuNJvǉ
                StrCopy(numP, NNSH_JUMPMSG_OPENLINK);
                numP = numP + sizeof(NNSH_JUMPMSG_OPENLINK);
                jumpList[nofItems] = (NNSH_JUMPSEL_OPENLINK);
                nofItems++;
            }

            if (NNshParam->addMenuGraphView != 0)
            {
                // XgɁu`惂[hύXvǉ
                StrCopy(numP, NNSH_JUMPMSG_CHANGEVIEW);
                numP = numP + sizeof(NNSH_JUMPMSG_CHANGEVIEW);
                jumpList[nofItems] = (NNSH_JUMPSEL_CHANGEVIEW);
                nofItems++;
            }

            if (NNshParam->addMenuFavorite != 0)
            {
                // XgɁuCɓݒύXvǉ
                StrCopy(numP, NNSH_JUMPMSG_FAVORITE);
                numP = numP + sizeof(NNSH_JUMPMSG_FAVORITE);
                jumpList[nofItems] = (NNSH_JUMPSEL_FAVORITE);
                nofItems++;
            }
            if (NNshParam->addMenuOutputMemo != 0)
            {
                // XgɁuóvǉ
                StrCopy(numP, NNSH_JUMPMSG_OUTPUTMEMO);
                numP = numP + sizeof(NNSH_JUMPMSG_OUTPUTMEMO);
                jumpList[nofItems] = (NNSH_JUMPSEL_OUTPUTMEMO);
                nofItems++;
            }

            if (NNshParam->addDeviceInfo != 0)
            {
                // XgɁufoCXvǉ
                StrCopy(numP, NNSH_JUMPMSG_DEVICEINFO);
                numP = numP + sizeof(NNSH_JUMPMSG_DEVICEINFO);
                jumpList[nofItems] = (NNSH_JUMPSEL_DEVICEINFO);
                nofItems++;
            }

            // A2DACXg[Ă邩mF
            if (CheckInstalledResource_NNsh('DAcc', 'a2DA') != false)
            {
                // XgɁuAA\vǉ
                StrCopy(numP, NNSH_JUMPMSG_EXECA2DA);
                numP = numP + sizeof(NNSH_JUMPMSG_EXECA2DA);
                jumpList[nofItems] = (NNSH_JUMPSEL_EXECA2DA);
                nofItems++;
            }

#ifdef USE_BT_CONTROL
            // Bluetooth On/Off
            if (NNshParam->addBtOnOff != 0)
            {
                    // XgɁuBt On/Bt Offvǉ
                    StrCopy(numP, NNSH_JUMPMSG_BTOOTH_ON);
                    numP = numP + sizeof(NNSH_JUMPMSG_BTOOTH_ON);
                    jumpList[nofItems] = (NNSH_JUMPSEL_BTOOTH_ON);
                    nofItems++;

                    StrCopy(numP, NNSH_JUMPMSG_BTOOTH_OFF);
                    numP = numP + sizeof(NNSH_JUMPMSG_BTOOTH_OFF);
                    jumpList[nofItems] = (NNSH_JUMPSEL_BTOOTH_OFF);
                    nofItems++;
            }
#endif

            if (NNshParam->useBookmark != 0)
            {
                // XgɁuݒvǉ
                StrCopy(numP, NNSH_JUMPMSG_BOOKMARK);
                numP = numP + sizeof(NNSH_JUMPMSG_BOOKMARK);
                jumpList[nofItems] = (NNSH_JUMPSEL_BOOKMARK);
                nofItems++;
            }

            // IEBhE\
            btnId = NNshWinSelectionWindow(FRMID_JUMPMSG, idxP->jumpListTitles, nofItems, 0);
            if (btnId != BTNID_JUMPCANCEL)
            {
                // IXgԍR}h擾
                switch (jumpList[NNshGlobal->jumpSelection])
                {
                  case NNSH_JUMPSEL_BACK:
                    // POɔ񂾃bZ[Wɖ߂
                    jumpPrevious();
                    return (false);
                    break;

                  case NNSH_JUMPSEL_TO_LIST:
                    // XIʂɖ߂
                    ReadMessage_Close(FRMID_THREAD);
                    return (false);
                    break;

                  case NNSH_JUMPSEL_OPEN_MENU:
                    // j[J
                    // (_~[ō㕔penDownEvent𐶐)
                    dummyEvent = &(NNshGlobal->dummyEvent);
                    MemSet(dummyEvent, sizeof(EventType), 0x00);
                    dummyEvent->eType    = penDownEvent;
                    dummyEvent->penDown  = true;
                    dummyEvent->tapCount = 1;
                    dummyEvent->screenX  = 5;
                    dummyEvent->screenY  = 5;
                    EvtAddEventToQueue(dummyEvent);

                    // bZ[W()ĕ\
                    (void) displayMessage(idxP, 0);
                    return (false);
                    break;

                  case NNSH_JUMPSEL_UPDATE:
                    // 擾
                    (void) PartReceiveMessage_View();
                    return (false);
                    break;

                  case NNSH_JUMPSEL_HANGUP:
                    // ؒf
                    savedParam = NNshParam->confirmationDisable;
                    NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
                    NNshNet_LineHangup();
                    NNshParam->confirmationDisable = savedParam;

                    // bZ[W\
                    (void) displayMessage(idxP, 0);
                    return (true);
                    break;

                  case NNSH_JUMPSEL_OPENWEB:
                    // SI{WebuEUŊJ
                    frm  = FrmGetActiveForm();
                    fldP = FrmGetObjectPtr(frm, 
                                       FrmGetObjectIndex(frm, FLDID_MESSAGE));
                    savedParam = FldGetTextLength(fldP);

                    // I𕶎̏ݒ肷
                    savedParam = (savedParam > NNSH_LIMIT_COPYBUFFER) ?
                                           NNSH_LIMIT_COPYBUFFER : savedParam;
                    FldSetSelection(fldP, 0, savedParam);
                    FldCopy(fldP);
                    if (NNshGlobal->browserCreator != 0)
                    {
                        // WebBrowserŊJ(̂ƂAmFMSGȂ)
                        openWebBrowser(NNSH_OMITDIALOG_ALLOMIT, buffer, sizeof(buffer));
                    }
                    // bZ[W\
                    (void) displayMessage(idxP, 0);
                    return (true);
                    break;

                  case NNSH_JUMPSEL_TOP:
                    // 擪
                    tempMsg = 1;
                    break;

                  case NNSH_JUMPSEL_BOTTOM:
                    // 
                    tempMsg = idxP->nofMsg;
                    break;

                  case NNSH_JUMPSEL_CHANGEVIEW:
                    // `惂[hύX
                    if (NNshParam->useSonyTinyFont == 0)
                    {
                        // nC][h֕ύX
                        NNshParam->useSonyTinyFont = 1;
                    }
                    else
                    {
                        // ʏ탂[h֕ύX
                        NNshParam->useSonyTinyFont = 0;
                    }
                    MemPtrFree(idxP->jumpListTitles);

                    // ʂxĂxJ
                    ReadMessage_Close(FRMID_MESSAGE);
                    return (true);
                    break;

                  case NNSH_JUMPSEL_FAVORITE:
                    // X\
                    DisplayMessageInformations(NNshParam->openMsgIndex, 
                                               &msgAttribute);

                    // Cɓ񃉃xXV
                    setFavoriteLabel(FrmGetActiveForm(), msgAttribute);

                    // \XV(OS3.1foCXł͐^ɂȂ邽)
                    FrmDrawForm(FrmGetActiveForm());
                    (void) displayMessage(idxP, 0);
                    break;

                  case NNSH_JUMPSEL_DEVICEINFO:
                    // foCX\
                    ShowDeviceInfo_NNsh();

                    // \XV(OS3.1foCXł͐^ɂȂ邽)
                    FrmDrawForm(FrmGetActiveForm());
                    (void) displayMessage(idxP, 0);
                    break;

                  case NNSH_JUMPSEL_OUTPUTMEMO:
                    // ֏o͂
                    savedParam = NNshParam->confirmationDisable;
                    NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
                    (void) outputMemoPad();
                    NNshParam->confirmationDisable = savedParam;

                    // bZ[W\
                    (void) displayMessage(idxP, 0);
                    break;

                  case NNSH_JUMPSEL_BOOKMARK:
                    // ݒ
                    if (NNshParam->useBookmark != 0)
                    {
                        NNshParam->lastFrmID     = NNSH_FRMID_MESSAGE;
                        NNshParam->bookMsgIndex  = NNshParam->openMsgIndex;
                        NNshParam->bookMsgNumber = idxP->openMsg;
                        NNsh_InformMessage(ALTID_INFO, MSG_SET_BOOKMARK, "",0);
                    }

                    // bZ[W\
                    (void) displayMessage(idxP, 0);
                    break;
                    
                  case NNSH_JUMPSEL_OPENLINK:
                    // NJ
                    MemPtrFree(idxP->jumpListTitles);
                    executeViewAction(MULTIVIEWBTN_FEATURE_OPENURL);
                    return (true);
                    break;

                  case NNSH_JUMPSEL_EXECA2DA:
                    // a2DAN(AAQ)
                    MemPtrFree(idxP->jumpListTitles);
                    executeViewAction(MULTIVIEWBTN_FEATURE_EXECA2DA);

                    // bZ[W\
                    (void) displayMessage(idxP, 0);

                    return (false);
                    break;

#ifdef USE_BT_CONTROL
                  case NNSH_JUMPSEL_BTOOTH_ON:
                    // Bluetooth On
                    executeViewAction(MULTIVIEWBTN_FEATURE_BT_ON);
                    break;                  

                  case NNSH_JUMPSEL_BTOOTH_OFF:
                    // Bluetooth Off
                    executeViewAction(MULTIVIEWBTN_FEATURE_BT_OFF);
                    break;
#endif

                  default:
                    // wԍ̃bZ[WփWv
                    tempMsg = jumpList[NNshGlobal->jumpSelection];
                    break;
                }
            }
            MemPtrFree(idxP->jumpListTitles);
        }
        else
        {
            NNsh_DebugMessage(ALTID_ERROR, "Jump LIST Create Failure.", "", 0);
        }
    }

    // tB[hNA
    NNshWinSetFieldText(frm, FLDID_MESSAGE_NUMBER, true, "", 0); 

    // bZ[WړăWvAbZ[W\
    if (tempMsg != idxP->openMsg)
    {
        idxP->histIdx = 
                  (idxP->histIdx < (PREVBUF - 1)) ? (idxP->histIdx + 1) : 0;
        idxP->prevMsg[idxP->histIdx] = idxP->openMsg;
        idxP->openMsg = tempMsg;

        // bZ[W\
        (void) displayMessage(idxP, 0);
        return (true);
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function : selectScrollEvent                                          */
/*                                       XN[o[XVCxg̏  */
/*-------------------------------------------------------------------------*/
static Boolean sclRepEvt_DispMessage(EventType *event)
{
    Int16   lines;

    if (event->data.sclExit.newValue == event->data.sclExit.value)
    {
        // Ȃ
        return (true);
    }

    lines = event->data.sclExit.newValue - event->data.sclExit.value;
    if (lines < 0)
    {
        // XN[sw肵ăXN[(߂)
        NNshWinViewPageScroll(FLDID_MESSAGE, SCLID_MESSAGE, -lines, winUp);
    }
    else
    {
        // XN[sw肵ăXN[(iݕ)
        NNshWinViewPageScroll(FLDID_MESSAGE, SCLID_MESSAGE, lines, winDown);
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function : selectKeyDownEvent                                         */
/*                                                 L[ꂽ̏  */
/*                                (WOAVXgneẽWOǉ) */
/*-------------------------------------------------------------------------*/
static Boolean selEvt_KeyDown_DispMessage(EventType *event)
{
    // CfbNXȂꍇɂ́Areturn
    if (NNshGlobal->msgIndex == NULL)
    {
        return (false);
    }

    // L[R[hϊ(281AӁI)
    switch (KeyConvertFiveWayToJogChara(event))
    {
      // uv̏
      case vchrPageDown:
        (void) executeViewAction((NNshParam->viewFtr.down)&(MULTIVIEWBTN_FEATURE_MASK));
        break;

      // WO_C̏
      case vchrJogDown:
      case vchrTrgJogDown:
      case vchrThumbWheelDown:
      case chrDownArrow:
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_PAGEDOWN);
        break;

      case chrCapital_N:  // NL[̓
      case chrSmall_N:
        // ЂƂ̃bZ[WɈړ 
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_NEXT);
        break;

      // uv̏
      case vchrPageUp:
        (void) executeViewAction((NNshParam->viewFtr.up)&(MULTIVIEWBTN_FEATURE_MASK));
        break;

      // WO_C̏
      case vchrJogUp:
      case vchrTrgJogUp:
      case vchrThumbWheelUp:
      case chrUpArrow:
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_PAGEUP);
        break;

      case chrCapital_P:  // PL[̓
      case chrSmall_P:
        // ЂƂÕbZ[WɈړ
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_PREVIOUS); 
        break;

      // WO_C()̏
      case vchrJogPushedUp:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGUP;
#endif
        /** not break!!  **/

      // J[\L[()̏
      case chrLeftArrow:
      case vchrJogLeft:
      case chrCapital_R:  // RL[̓
      case chrSmall_R:
        // 񂵂łPÂÏグH
        if (NNshParam->notCursor != 0)
        {
             // ̃bZ[W\ďI
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_PREVIOUS);
        }
        else
        {
            // 10ÕX\
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_PAGEUP10);
        }
        break;

      // WO_C()̏
      case vchrJogPushedDown:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGDOWN;
#endif
        /** not break!!  **/

      // J[\L[(E)̏
      case chrRightArrow:
      case vchrJogRight:
      case chrCapital_F:  // FL[̓
      case chrSmall_F:
        // 񂵂łPÂÉH
        if (NNshParam->notCursor != 0)
        {
            // ̃bZ[W\ďI
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_NEXT);
        }
        else
        {
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_PAGEDOWN10);
        }
        break;

#ifdef USE_CLIE
      // JOG Push̏(萳mɂ̓{^𗣂Ƃ)
      case vchrJogRelease:
        if (NNshGlobal->tempStatus == NNSH_TEMPTYPE_CLEARSTATE)
        {
            // JOG PUSH{^Ɠȓ
            executeViewAction((NNshParam->viewFtr.jogPush)&(MULTIVIEWBTN_FEATURE_MASK));
        }
        // ꎞԂNA
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_CLEARSTATE;
        break;
#endif

      case vchrHard1:
        if (NNshParam->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // n[hL[PƂ̐ݒ
        executeViewAction((NNshParam->viewFtr.key1)&(MULTIVIEWBTN_FEATURE_MASK));
        break;

      case vchrHard2:
        if (NNshParam->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // n[hL[QƂ̐ݒ
        executeViewAction((NNshParam->viewFtr.key2)&(MULTIVIEWBTN_FEATURE_MASK));
        break;

      case vchrHard3:
        if (NNshParam->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // n[hL[RƂ̐ݒ
        executeViewAction((NNshParam->viewFtr.key3)&(MULTIVIEWBTN_FEATURE_MASK));
        break;

      case vchrHard4:
        if (NNshParam->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // n[hL[SƂ̐ݒ
        executeViewAction((NNshParam->viewFtr.key4)&(MULTIVIEWBTN_FEATURE_MASK));
        break;

      case vchrCapture:
        if (NNshParam->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // CLIELv`[{^Ƃ̐ݒ
        executeViewAction((NNshParam->viewFtr.clieCapture)&(MULTIVIEWBTN_FEATURE_MASK));
        break;

      // Sony obN{^/HandEra obN{^/ESCL[/XL[̏
      // case chrBackspace:
      case vchrJogBack:
      case chrEscape:
      case vchrThumbWheelBack:
      case chrCapital_X:  // XL[̓
      case chrSmall_X:
        // JOG Back{^̓
        executeViewAction((NNshParam->viewFtr.jogBack)&(MULTIVIEWBTN_FEATURE_MASK));
        break;

      //  HandEra Jog-Push/EnterL[Ƃ̏
      case chrCarriageReturn:
      case chrLineFeed:
      case vchrThumbWheelPush:
        // JOG Push{^̓
        executeViewAction((NNshParam->viewFtr.jogPush)&(MULTIVIEWBTN_FEATURE_MASK));
        break;

      // ÕWvXɖ߂(Back{^Ɠ)
      case chrCapital_Z:  // ZL[̓
      case chrSmall_Z:
        executeViewAction(MULTIVIEWBTN_FEATURE_RETURN);
        break;

      // LL[
      case chrCapital_L:
      case chrSmall_L:
        // tHgύX
        executeViewAction(MULTIVIEWBTN_FEATURE_CHANGEFONT);
        break;

      case chrCapital_V:  // VL[̓
      case chrSmall_V:
        // a2DAN
        executeViewAction(MULTIVIEWBTN_FEATURE_EXECA2DA);
        break;

      case chrCapital_H:  // HL[̓
      case chrSmall_H:
        // NJ
        executeViewAction(MULTIVIEWBTN_FEATURE_OPENURL);
        break;

      case chrCapital_U:  // UL[̓
      case chrSmall_U:
        // I{Web
        executeViewAction(MULTIVIEWBTN_FEATURE_SELANDWEB);
        break;

      case chrCapital_O:  // OL[̓
      case chrSmall_O:
        // ɏo
        executeViewAction(MULTIVIEWBTN_FEATURE_OUTPUTMEMO);
        break;

      case chrCapital_J:  // JL[̓
      case chrSmall_J:
        // XԎw̃bZ[W擾
        executeViewAction(MULTIVIEWBTN_FEATURE_GETMESNUM);
        break;

      // DL[
      case chrCapital_D:
      case chrSmall_D:
        executeViewAction(MULTIVIEWBTN_FEATURE_DRAWMODE);
        break;

      // QL[
      case chrCapital_Q:
      case chrSmall_Q:
        // ؒf
        executeViewAction(MULTIVIEWBTN_FEATURE_DISCONNECT);
        break;

      // CL[
      case chrCapital_C:
      case chrSmall_C:
        // foCX̏\
        executeViewAction(MULTIVIEWBTN_FEATURE_DEVICEINFO);
        break;

      // BL[
      case chrCapital_B:
      case chrSmall_B:
        // X̖
        executeViewAction(MULTIVIEWBTN_FEATURE_GOTOBOTTOM);
        break;

        // TL[
      case chrCapital_T:
      case chrSmall_T:
        // X̐擪
        executeViewAction(MULTIVIEWBTN_FEATURE_GOTOTOP);
        break;

        // Xy[XL[EGL[̓(bZ[WJUMP)
      case chrSpace:
      case chrCapital_G:
      case chrSmall_G:
        executeViewAction(MULTIVIEWBTN_FEATURE_JUMP);
        break;

      case chrCapital_W:  // WL[̓
      case chrSmall_W:
        // X(OFFLINEXłȂ̂ݏ݉)
        executeViewAction(MULTIVIEWBTN_FEATURE_WRITE);
        break;

      // l͂\邽߁AAAЂƂ̃L[ɂ
      case chrCapital_Y:
      case chrSmall_Y:
        // L[Y (Bt ON)
        executeViewAction(MULTIVIEWBTN_FEATURE_BT_ON);
        break;

      case chrCapital_I:
      case chrSmall_I:
        // L[I (Bt Off)
        executeViewAction(MULTIVIEWBTN_FEATURE_BT_OFF);
        break;

      default:
        // L[R[h\
        NNsh_DebugMessage(ALTID_INFO, "Pushed a key  code:", "",
                          event->data.keyDown.chr);
        return (false);
        break;
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   ctlSelEvt_DispMessage                                    */
/*                                                      {^̏ */
/*-------------------------------------------------------------------------*/
Boolean ctlSelEvt_DispMessage(EventType *event)
{
    // CfbNXȂꍇɂ́Areturn
    if (NNshGlobal->msgIndex == NULL)
    {
        return (false);
    }

    // ꂽ{^ɂď
    switch (event->data.ctlSelect.controlID)
    {
      case BTNID_TOP:
        if (NNshParam->searchMode != 0)
        {
            // 擪ɌČ
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCHBTM);
        }
        else
        {
            // X̐擪
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_GOTOTOP);
        }
        break;

      case BTNID_PREV_MESSAGE:
        if (NNshParam->searchMode != 0)
        {
            // O
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCHPREV);
        }
        else
        {
            // O{^ 
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_PREVIOUS);
        }
        break;

      case BTNID_NEXT_MESSAGE:
        if (NNshParam->searchMode != 0)
        {
            // 
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCHNEXT);
        }
        else
        {
            // {^ 
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_NEXT);
        }
        break;

      case BTNID_BOTTOM:
        if (NNshParam->searchMode != 0)
        {
            // 擪疖ɌČ
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCHTOP);
        }
        else
        {
            // {^(X̖)
            (void) executeViewAction(MULTIVIEWBTN_FEATURE_GOTOBOTTOM);
        }
        break;

      case BTNID_BACK_MESSAGE:
        // ߂{^ 
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_RETURN);
        break;

      case BTNID_JUMP:
        // GO{^
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_JUMP);
        break;

      case BTNID_WRITE_MESSAGE:
        // {^
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_WRITE);
        break;

      case SELTRID_THREAD_TITLE:  
        // ^Cg{^(ꗗʂɖ߂)
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_BACKTOLIST);
        break;

      case SELTRID_FAVOR_THREAD:
        // X\
        (void) executeViewAction(NNshParam->viewMultiBtnFeature);
        break;

      case CHKID_SEARCH:
        // [h ON/OFF
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCH);
        break;

      default:
        // Ȃ
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   MenuEvt_DispMessage                                      */
/*                                                    j[Ȉ */
/*-------------------------------------------------------------------------*/
Boolean menuEvt_DispMessage(EventType *event)
{
    switch (event->data.menu.itemID)
    {
      case MNUID_THREAD_SELECTION:
        // XIʂɖ߂
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_BACKTOLIST);
        break;

      case MNUID_THREAD_INFO:
        // X\
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_INFO);
        break;

      case MNUID_TOP_MESSAGE:
        // X̐擪ɃWv
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_GOTOTOP);
        break;

      case MNUID_BOTTOM_MESSAGE:
        // X̖ɃWv
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_GOTOBOTTOM);
        break;

      case MNUID_WRITE_MESSAGE:
        // X(OFFLINEXłȂ̂ݏ݉)
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_WRITE);
        break;

      case MNUID_GET_PART:
        // X擾
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_GETPART);
        break;

      case MNUID_GET_MESNUM:
        // XԎw̃bZ[W擾
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_GETMESNUM);
        break;

      case MNUID_NET_DISCONN:
        // ؒf
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_DISCONNECT);
        break;

      case MNUID_SET_BOOKMARK:
        // ݒ
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_BOOKMARK);
        break;

      case MNUID_FONT_MSGVIEW:
        // tHgύX
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_CHANGEFONT);
        break;

      case MNUID_HANDERA_ROTATE_MSGVIEW:
        // HandEra ʉ] //
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_ROTATE);
        break;

      case MNUID_CLIE_DRAW_MODE: 
        // `惂[hύX
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_DRAWMODE);
        return (true);
        break;

      case MNUID_OS5_LAUNCH_WEB:
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_OPENWEB);
        break;

      case MNUID_EDIT_COPY:
        // Rs[
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_COPY);
        break;

      case MNUID_SELECT_ALL:
        // ̑SI
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_SELECTALL);
        break;

      case MNUID_NET_CONFIG:
        // lbg[NݒJ
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_SETNETWORK);
        break;

      case MNUID_SEARCH:
        // 
        NNshParam->searchMode = 0;
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCH);
        break;

      case MNUID_SEARCH_NEXT:
        // 
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCHNEXT);
        break;

      case MNUID_SEARCH_PREV:
        // O
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCHPREV);
        break;

      case MNUID_SEARCH_TOP_TO_BOTTOM:
        // 擪疖
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCHTOP);
        break;

      case MNUID_SEARCH_BOTTOM_TO_TOP:
        // 擪
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_SEARCHBTM);
        break;

      case MNUID_OUTPUT_MEMOPAD:
        // bZ[W֏o͂
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_OUTPUTMEMO);
        break;

      case MNUID_SHOW_DEVICEINFO:
        // foCX̕\
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_DEVICEINFO);
        break;

      case MNUID_START_A2DA:
        // a2DAN(AA\)
        (void) executeViewAction(MULTIVIEWBTN_FEATURE_EXECA2DA);
        break;

      default:
        // LȊO
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   Hander_NNshMessage                                       */
/*                                                       Cxgnh  */
/*-------------------------------------------------------------------------*/
Boolean Handler_NNshMessage(EventType *event)
{
    Boolean   ret = false;
#ifdef USE_HANDERA
    FormType *frm;
#endif

    switch (event->eType)
    {
      case keyDownEvent:
        return (selEvt_KeyDown_DispMessage(event));
        break;

      case ctlSelectEvent:
        return (ctlSelEvt_DispMessage(event));
        break;

      case fldChangedEvent:
        NNshWinViewUpdateScrollBar(FLDID_MESSAGE, SCLID_MESSAGE);
        return (false);
        break;

      case menuEvent:
        return (menuEvt_DispMessage(event));
        break;

      case sclRepeatEvent:
        return (sclRepEvt_DispMessage(event));
        break;

#ifdef USE_HANDERA
      case displayExtentChangedEvent:
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            frm = FrmGetActiveForm();
            HandEraResizeForm(frm);
            UpdateFieldRegion();
            FrmDrawForm(frm);
        }
        break;
#endif

      case penDownEvent:
        if(NNshParam->useSonyTinyFont != 0)
        {
            /* tap ꂽ̈`FbN *
             *     㕔GA`FbN */
            if (NNshGlobal->fieldPos[0].startX <= event->screenX &&
               NNshGlobal->fieldPos[0].endX > event->screenX &&
               NNshGlobal->fieldPos[0].startY <= event->screenY &&
               NNshGlobal->fieldPos[0].endY > event->screenY)
           {
               (void) moveMessagePrev(true, NNshParam->dispBottom);
               return(true);
           }
           else
           {
               /* GA`FbN */
               if (NNshGlobal->fieldPos[1].startX <= event->screenX &&
                   NNshGlobal->fieldPos[1].endX > event->screenX &&
                   NNshGlobal->fieldPos[1].startY <= event->screenY &&
                   NNshGlobal->fieldPos[1].endY > event->screenY)
               {
                   (void) moveMessageNext(true);
                   return(true);
               }
           }
        }
        break;

      case frmOpenEvent:
        UpdateFieldRegion();
        break;
#if 0
      case menuOpenEvent:
      case fldEnterEvent:
      case popSelectEvent:
      case lstSelectEvent:
      case lstEnterEvent:
      case lstExitEvent:
      case sclExitEvent:
      case nilEvent:
#endif
      default:
        break;
    }
    return (ret);
}

/*=========================================================================*/
/*   Function : OpenForm_NNshMessage                                       */
/*                              (XbhVKǂݏoFbZ[W\ȊO) */
/*=========================================================================*/
Err OpenForm_NNshMessage(FormType *frm)
{
    Err                  ret;
    UInt16               bufferSize, fileMode;
    Char                 title   [NNSH_MSGTITLE_BUFSIZE];
    Char                 fileName[MAXLENGTH_FILENAME], *area;
    NNshSubjectDatabase  subjDB;
    ControlType         *selP;
    FieldAttrType        attr;
    FieldType           *fldP;
    NNshMessageIndex    *idxP;
#ifdef USE_TRUNCATE_TITLE
    UInt32               offset;
    UInt16               len;
    Coord                width;
    RectangleType        r;
#endif
#ifdef USE_COLOR
    IndexedColorType savedIndex;
    RGBColorType     drawColor;

    if (NNshParam->useColor != 0)
    {
#if 0
        FrmDrawForm(FrmGetActiveForm());
#endif
        
        // ݂̐F(OiFƕF)ۑ
        savedIndex = UIColorGetTableEntryIndex(UIObjectForeground);
        WinIndexToRGB(savedIndex, &(NNshGlobal->fgColor));
        savedIndex = UIColorGetTableEntryIndex(UIFieldText);
        WinIndexToRGB(savedIndex, &(NNshGlobal->txColor));

        // ݂̐F(wiFFtB[hAtH[A_CAO)ۑ
        savedIndex = UIColorGetTableEntryIndex(UIFieldBackground);
        WinIndexToRGB(savedIndex, &(NNshGlobal->bgColor));
        savedIndex = UIColorGetTableEntryIndex(UIFormFill);
        WinIndexToRGB(savedIndex, &(NNshGlobal->bgFormColor));

        savedIndex = UIColorGetTableEntryIndex(UIDialogFill);
        WinIndexToRGB(savedIndex, &(NNshGlobal->bgDialogColor));

        savedIndex = UIColorGetTableEntryIndex(UIAlertFill);
        WinIndexToRGB(savedIndex, &(NNshGlobal->bgAlertColor));

        savedIndex = UIColorGetTableEntryIndex(UIObjectFill);
        WinIndexToRGB(savedIndex, &(NNshGlobal->bgObjectColor));

        // ̐Fϊ
        WinIndexToRGB(NNshParam->colorViewFG,    &drawColor);
        UIColorSetTableEntry(UIObjectForeground, &drawColor);
        WinIndexToRGB(NNshParam->colorViewFG,    &drawColor);
        UIColorSetTableEntry(UIFieldText,        &drawColor);

        // wi̐Fw肳ꂽFɐݒ肷
        WinIndexToRGB(NNshParam->colorViewBG,    &drawColor);
        UIColorSetTableEntry(UIFieldBackground,  &drawColor);
        UIColorSetTableEntry(UIFormFill,         &drawColor);
        UIColorSetTableEntry(UIDialogFill,       &drawColor);
        UIColorSetTableEntry(UIAlertFill,        &drawColor);
        UIColorSetTableEntry(UIObjectFill,       &drawColor);

        // OiFƔwiFݒ肷
        WinSetForeColor(UIColorGetTableEntryIndex(UIFieldText));
        WinSetTextColor(UIColorGetTableEntryIndex(UIFieldText));
        WinSetBackColor(UIColorGetTableEntryIndex(UIFieldBackground));
    }
#endif

    // X܂擾
    ret = Get_Subject_Database(NNshParam->openMsgIndex, &subjDB);
    if (ret != errNone)
    {
        // subjectf[^x[Xf[^擾Ɏs
        NNsh_DebugMessage(ALTID_ERROR, "Get_Subject_Database()", "", ret);
        goto FUNC_END;
    }

    // ꎞobt@̈悪łɊmۂĂAēxƂȂB
    if (NNshGlobal->msgIndex != NULL)
    {
        MEMFREE_PTR((NNshGlobal->msgIndex)->msgOffset);
        idxP = NNshGlobal->msgIndex;
        CloseFile_NNsh(&(idxP->fileRef));
        MEMFREE_PTR(NNshGlobal->msgIndex);
    }
    bufferSize = sizeof(NNshMessageIndex) + NNshParam->bufferSize + MARGIN * 2;

    // memory leakSzȂ̂ňꉞmۑOfree testĂ
    MEMFREE_PTR(NNshGlobal->msgIndex);
    NNshGlobal->msgIndex = MemPtrNew(bufferSize);

    if (NNshGlobal->msgIndex == NULL)
    {
        NNsh_InformMessage(ALTID_ERROR, MSG_ERR_MEMPTR_NEW_BUFF, " size:",
                           bufferSize);
        ret = ~errNone;
        goto FUNC_END;
    }
    MemSet(NNshGlobal->msgIndex, bufferSize, 0x00);

    // bZ[WItZbg̈mۂ
    bufferSize = sizeof(UInt32) * (NNshParam->msgNumLimit + MARGIN);
    (NNshGlobal->msgIndex)->msgOffset = MemPtrNew(bufferSize);
    if ((NNshGlobal->msgIndex)->msgOffset == NULL)
    {
        // bZ[WItZbg̈̊mێs
        MEMFREE_PTR(NNshGlobal->msgIndex);
        NNsh_InformMessage(ALTID_ERROR, MSG_ERR_MEMPTR_NEW_BUFF, " size:",
                           bufferSize);
        ret = ~errNone;
        goto FUNC_END;
    }
    MemSet((NNshGlobal->msgIndex)->msgOffset, bufferSize, 0x00);

    // BBS^Cv[N̈ɃRs[
    idxP = NNshGlobal->msgIndex;
    idxP->bbsType = (UInt16) subjDB.bbsType;

    // ^Cgƃ{[hjbNl[A{[hhc[N̈ɃRs[
    StrNCopyHanZen(idxP->threadTitle, subjDB.threadTitle, MAX_THREADNAME - 1);
    StrNCopy(idxP->boardNick,   subjDB.boardNick,   MAX_NICKNAME - 1);
    StrNCopy(idxP->threadFile,  subjDB.threadFileName, MAX_THREADFILENAME - 1);

    // ǂݍރt@C̏
    MemSet (fileName, sizeof(fileName), 0x00);

    // OFFLINEX̂Ƃ́AboardNicktȂ悤ɂ
    if (StrCompare(subjDB.boardNick, OFFLINE_THREAD_NICK) != 0)
    {
        StrCopy(fileName, subjDB.boardNick);
    }
    else
    {
        // OFFLINEXVFSɊi[Ăꍇɂ́AfBNgtB
        if ((NNshParam->useVFS & NNSH_VFS_USEOFFLINE) != 0)
        {
            // Ox[XfBNgt
            if ((NNshGlobal->logPrefixH == 0)||
                ((area = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
            {
                StrCopy(fileName, LOGDATAFILE_PREFIX);
            }
            else
            {
                StrCopy(fileName, area);
                MemHandleUnlock(NNshGlobal->logPrefixH);
            }

            // ɃTufBNgĕt
            GetSubDirectoryName(subjDB.dirIndex, &fileName[StrLen(fileName)]);
        }
    }
    StrCat (fileName, subjDB.threadFileName);

    // t@Ĉ肩ŁAJ[h؂ւ
    if (subjDB.msgState == FILEMGR_STATE_OPENED_STREAM)
    {
        fileMode = ((NNSH_FILEMODE_TEMPFILE)|(NNSH_FILEMODE_READONLY));
    }
    else
    {
        fileMode = (NNSH_FILEMODE_READONLY);
    }
    ret = OpenFile_NNsh(fileName,fileMode,&(idxP->fileRef));
    if (ret != errNone)
    {
    // t@X̃Rs[Free͑ʖ!  
    //    MemPtrFree(idxP);
    //    idxP = NULL;
        NNsh_InformMessage(ALTID_ERROR, "Message File Open :", fileName, ret);

        // MemPtrFreéAԂ񂱂ꂪ̂͂AAA
        MEMFREE_PTR(NNshGlobal->msgIndex);
        goto FUNC_END;
    }
    GetFileSize_NNsh(&(idxP->fileRef), &(idxP->fileSize));

    //  bZ[WXbh̃CfbNX쐬
    ret = CreateMessageThreadIndex(idxP, &(idxP->nofMsg), idxP->msgOffset,
                                   (UInt16) subjDB.bbsType);
    if (ret != errNone)
    {
        NNsh_InformMessage(ALTID_ERROR, "ERR>index creation failure", "", ret);
        goto FUNC_END;
    }

    // A_[C̕\ݒ
    MemSet(&attr, sizeof(FieldAttrType), 0x00);
    fldP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
    FldGetAttributes(fldP, &attr);
    if (NNshParam->disableUnderline != 0)
    {
        attr.underlined = noUnderline;
    }
    else
    {
        attr.underlined = grayUnderline;
    }
    FldSetAttributes(fldP, &attr);

    // tH[^Cg̍XV(bZ[Wi[)
    StrCopy(title, "1:");
    NUMCATI(title, idxP->nofMsg);
    FrmCopyTitle(frm, title);

    // X^Cg\̈ɃX̂Rs[
    StrCopy(idxP->showTitle, idxP->threadTitle);

    // HandEra΍AAAX^CTruncate̓RpCXCb`w莞̂
#ifdef USE_TRUNCATE_TITLE
#ifdef USE_GLUE
    len   = StrLen(idxP->threadTitle);
    FrmGetObjectBounds(frm, FrmGetObjectIndex(frm, SELTRID_THREAD_TITLE), &r);
    width = r.extent.x - 4;
    if (FntCharsWidth(idxP->threadTitle, len) >= width)
    {
        // X^Cg\ɕ\łȂꍇAɏȗL
        width  = width - FntCharWidth(chrEllipsis);
        offset = FntWidthToOffset(idxP->showTitle, len, width, NULL, NULL);
        offset = TxtGlueGetTruncationOffset(idxP->showTitle, offset);
        idxP->showTitle[offset] = chrEllipsis;
        idxP->showTitle[offset + 1] = '\0';
    }
#endif
#endif
    // X^Cg̕\
    selP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, SELTRID_THREAD_TITLE));
    if (selP != NULL)
    {
        CtlSetLabel(selP, idxP->showTitle);
    }

    // ǂݏoӏ̊mF(ُȂ擪)
    if ((subjDB.currentLoc < 1)||(subjDB.currentLoc > idxP->nofMsg))
    {
        idxP->openMsg = 1;
    }
    else
    {
        idxP->openMsg = subjDB.currentLoc;
    }
    idxP->prevMsg[0] = idxP->openMsg;
    idxP->histIdx    = 0;

    // Ƃ肠t@C̐擪f[^ǂݍł
    switch (ret)
    {
        case errNone:
        case vfsErrFileEOF:
        case fileErrEOF:
          // read OK, create Index!
          ret = errNone;
          break;

        default:
          goto FUNC_END;
          break;
    }

    // 肪ݒ肳Ăꍇ́A̒l߂B
    if ((NNshParam->useBookmark != 0)&&(NNshParam->bookMsgNumber != 0))
    {
        if (NNshParam->bookMsgIndex == NNshParam->openMsgIndex)
        {
            (NNshGlobal->msgIndex)->openMsg = NNshParam->bookMsgNumber;
        }
    }

    // uCɓvݒZN^gK̃xɐݒ肷
    setFavoriteLabel(frm, subjDB.msgAttribute);

    // uXQƉʂŃtH[JXړȂvɃ`FbNȂꍇ
    if (NNshParam->notFocusNumField == 0)
    {
        // tH[JXbZ[WԍtB[hɐݒ
        FrmSetFocus(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE_NUMBER));
    }

    // [h`FbN{bNX̐ݒ
    CtlSetValue(FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_SEARCH)), 
                NNshParam->searchMode);

    // ʕ\
    (void) displayMessage(NNshGlobal->msgIndex, 0);
    NNshParam->lastFrmID = NNSH_FRMID_MESSAGE;
    return (errNone);

FUNC_END:
    // G[I
    ReadMessage_Close(FRMID_THREAD);
    return (ret);
}

/*=========================================================================*/
/*   Function : GetSubDirectoryName                                        */
/*                                                  TufBNg̎擾 */
/*=========================================================================*/
Err GetSubDirectoryName(UInt16 index, Char *dirName)
{
    DmOpenRef              dirRef;
    UInt16                 size, nextIndex;
    Int16                  depth, saveDepth;
    Err                    ret;
    Char                  *buffer;
    NNshDirectoryDatabase  dirDb;

    if (index == 0)
    {
        // wINDEXُ
        NNsh_DebugMessage(ALTID_INFO,
                          "There is not any sub-directory.", "", index);
        return (~errNone - 2);
    }

    OpenDatabase_NNsh(DBNAME_DIRINDEX, DBVERSION_DIRINDEX, &dirRef);

    // TufBNggbv擾
    MemSet(&dirDb, sizeof(NNshDirectoryDatabase), 0x00);
    ret = SearchRecord_NNsh(dirRef, &index, NNSH_KEYTYPE_UINT16, 0,
                            sizeof(NNshDirectoryDatabase), &dirDb, &saveDepth);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_INFO, "SearchRecord_NNsh() ret:", "",   ret);
        NNsh_DebugMessage(ALTID_INFO, " index:", "", index);

        GetDBCount_NNsh(dirRef, &size);
        for (nextIndex = 0; nextIndex < size; nextIndex++)
        {
            MemSet(&dirDb, sizeof(NNshDirectoryDatabase), 0x00);
            ret = GetRecord_NNsh(dirRef, nextIndex,
                                 sizeof(NNshDirectoryDatabase), &dirDb);
            NNsh_DebugMessage(ALTID_INFO, "GetRecord_NNsh() ret:", "", ret);
            NNsh_DebugMessage(ALTID_INFO, dirDb.dirName, " INDEX:", nextIndex);
            NNsh_DebugMessage(ALTID_INFO, dirDb.dirName, " dirIdx:", dirDb.dirIndex);
            NNsh_DebugMessage(ALTID_INFO, dirDb.dirName, " prevdx:", dirDb.previousIndex);
        }

        // DBR[hmۃG[
        CloseDatabase_NNsh(dirRef);
        return (ret);
    }
    NNsh_DebugMessage(ALTID_INFO, "depth:", dirDb.dirName, dirDb.depth);

    // ꎞIɗ̈mۂ
    size = (dirDb.depth + 1) * sizeof(Char) * MAX_DIRNAME + MARGIN;
    buffer = MemPtrNew(size);
    if (buffer == NULL)
    {
        // ̈mۃG[
        CloseDatabase_NNsh(dirRef);
        return (~errNone);
    }
    MemSet(buffer, size, 0x00);

    // TufBNgdirDB猟
    saveDepth = dirDb.depth - 1;
    for (depth = saveDepth; depth >= 0; depth--)
    {
        NNsh_DebugMessage(ALTID_INFO, "copy ", dirDb.dirName, depth);

        // fBNgRs[
        StrNCopy(&buffer[depth * sizeof(Char) * MAX_DIRNAME],
                 dirDb.dirName, (MAX_DIRNAME - 1));
        if (dirDb.previousIndex == 0)
        {
            // I
            break;
        }

        // fBNg
        nextIndex = dirDb.previousIndex;
        MemSet(&dirDb, sizeof(NNshDirectoryDatabase), 0x00);
        ret = SearchRecord_NNsh(dirRef, &(nextIndex), NNSH_KEYTYPE_UINT16, 0,
                                sizeof(NNshDirectoryDatabase), &dirDb, &index);
        if (ret != errNone)
        {
            // sAɂ
            NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh()", "", ret);
            break;
        }
    }

    // fBNgRs[
    for (depth = 0; depth <= saveDepth; depth++)
    {
        StrCat(dirName, &buffer[depth * sizeof(Char) * MAX_DIRNAME]);
    }
    NNsh_DebugMessage(ALTID_INFO, "SubDirectory:", dirName, depth);

    // Ƃ܂
    MemPtrFree(buffer);
    CloseDatabase_NNsh(dirRef);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : PartReceiveMessage_View                                    */
/*                                                            X擾 */
/*-------------------------------------------------------------------------*/
static Err PartReceiveMessage_View(void)
{
    Err                  ret;
    Char                 url[BUFSIZE];
    UInt16               index;
    NNshSubjectDatabase  subjDB;
    NNshBoardDatabase    bbsData;
    NNshMessageIndex    *idxP;

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;

    // bZ[Wf[^x[X擾
    ret = Get_Subject_Database(NNshParam->openMsgIndex, &subjDB);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "get_subject_database()", "", ret);
        return (ret);
    }

    // OFFLINEXIꂽꍇAXVs\
    if (StrCompare(subjDB.boardNick, OFFLINE_THREAD_NICK) == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE,
                           idxP->threadTitle, 0);
        return (~errNone);
    }
    
    ret = Get_BBS_Database(subjDB.boardNick, &bbsData, &index);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "Get_BBS_Database() nick:", 
                          subjDB.boardNick, ret);
        return (ret);
    }

    switch (subjDB.bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
      case NNSH_BBSTYPE_SHITARABAJBBS:
        // ܂BBSɑ΂č擾IA݃T|[gȂ(Ƃ肠?)
        NNsh_ErrorMessage(ALTID_WARN, MSG_NOTSUPPORT_MACHI, "", 0);
        return (~errNone);
        break;
#if 0
      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_SHITARABA:
      case NNSH_BBSTYPE_OTHERBBS:
#endif
      default:
        // ȂɂȂ
        break;
    }

    //  擾\@\LłlbgɐڑĂȂꍇA
    // 擾\񂷂邩mF
    if ((NNshParam->getReserveFeature != 0)&&(NNshGlobal->netRef == 0))
    {
        if (NNsh_ConfirmMessage(ALTID_CONFIRM,
                                NNSH_MSGINFO_RESERVE, "", 0) == 0)
        {
            // V\񎞂Ɏ擾\ݒ肵ďI
            subjDB.msgAttribute
                     = subjDB.msgAttribute | NNSH_MSGATTR_GETRESERVE;

            (void) update_subject_database(NNshParam->openMsgIndex, &subjDB);
            return (errNone);
        }
    }

    // ݎQƒ̃t@CUN[YĂ
    CloseFile_NNsh(&(idxP->fileRef));

    // X擾s
    MemSet (url, sizeof(url), 0x00);
    StrCopy(url, bbsData.boardURL);
    switch (subjDB.bbsType)
    {
      case NNSH_BBSTYPE_SHITARABA:
        // boardNickt
        StrCat (url, "bbs/");
        StrCat (url, subjDB.boardNick);
        break;
#if 0
      case NNSH_BBSTYPE_MACHIBBS:
      case NNSH_BBSTYPE_SHITARABAJBBS:
      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_OTHERBBS:
#endif
      default:
        // Ȃ
        break;
    }
    StrCat (url, "dat/");
    StrCat (url, subjDB.threadFileName);

    (void) Get_PartMessage(url, bbsData.boardNick, &subjDB, 
                           NNshParam->openMsgIndex, NULL);

    // \Ȃ
    ReadMessage_Close(FRMID_MESSAGE);
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function : NNsh_Search_Message                                        */
/*                                                            X   */
/*-------------------------------------------------------------------------*/
static void NNsh_Search_Message(UInt16 type, Char *str, Boolean flag)
{
    NNshMessageIndex *idxP;
    UInt16 start, end;
    Int16 step, len, cmpLen, msg;
    UInt32      offset;
    Char *ptr;
    Char backup;
    FormType *frm;
    FieldType        *fld;
    UInt8 codeExchange = 0;
    Char *strTmp, *strOrig = NULL;
    UInt16 size;

    // 񂪂ȂΏI
    if (StrLen(str) == 0)
    {
        return;
    }

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;
 
    // start, end  1 origin ōl
    switch(type)
    {
      case NNSH_SEARCH_METHOD_FROM_TOP:  //擪猟
        start = 1;
        end  = idxP->nofMsg + 1;
        step = 1;
        break;

      case NNSH_SEARCH_METHOD_NEXT:    //
        start = idxP->openMsg + 1;
        end = idxP->nofMsg + 1;
        step = 1;
        break;

      case NNSH_SEARCH_METHOD_PREV: //O
        start = idxP->openMsg - 1;
        end = 0;
        step = -1;
        break;

      case NNSH_SEARCH_METHOD_FROM_BOTTOM: //猟
        start = idxP->nofMsg;
        end = 0;
        step = -1;
        break;

      default:
        return;
        break;
    }

    strTmp = NULL;
    switch(idxP->bbsType)
    {
      case NNSH_BBSTYPE_SHITARABAJBBS:
      case NNSH_BBSTYPE_SHITARABA:
        // EUCBBS̏ꍇA SJIS->EUC ϊ
        size = StrLen(str) * 2;
        strTmp = MemPtrNew(size);
        if (strTmp == NULL)
        {
            // mێs
            NNsh_InformMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL,
                               " size:", size);
            goto SEARCH_END;
        }
        StrCopyEUC(strTmp, str);
        strOrig = str;
        str = strTmp;
        codeExchange = 1;
        break;
    }

    cmpLen = StrLen(str);
    // uv\ (hideBusyForm()܂)
    Show_BusyForm(MSG_FINDING_WAIT);
    
    for (msg = start; msg != end; msg += step)
    {
        NNsh_Get_MessageToBuf(idxP, msg, 
                         (step > 0) ? GET_MESSAGE_TYPE_TOP : GET_MESSAGE_TYPE_BOTTOM, false);

        // obt@ offset𒲂ׂ
        offset = (idxP->msgOffset)[msg - 1] - idxP->fileOffset;
        ptr = idxP->buffer + offset;
        len = (idxP->msgOffset)[msg] - (idxP->msgOffset)[msg - 1];

        //bZ[W̖ NULL terminate ĂȂ߁A
        //̃bZ[W̐擪̂P󂷂̂ŃobNAbv
        backup = *(ptr + len);
        *(ptr + len) = NULL;

        //ƍs
        if (StrStr(ptr, str))
        {
            Char *buf;
            
            // html ̃^OɈĂ\邽߁A
            // obt@\eɕϊčēx

            // ϊpobt@pӂ
            buf = MemPtrNew(len * 2); // 2{mۂĂΖȂƎv
            if (buf == NULL)
            {
                // mێs
                NNsh_InformMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL,
                                   " size:", len * 2);
                Hide_BusyForm(true);

                //obNAbvɖ߂ 
                *(ptr + len) = backup;
                goto SEARCH_END;
            }
            buf[0] = '\0';
            
            // \pɕϊ
            displayMessageSub(idxP->bbsType, idxP->buffer, idxP->openMsg,
                              offset, len, buf, false);
            
            if (codeExchange)
                strTmp = strOrig;
            else
                strTmp = str;
            
            if (StrStr(buf, strTmp))
            {
                //ϊobt@ł
                
                Hide_BusyForm(true);

                //obNAbvɖ߂ 
                *(ptr + len) = backup;

                if (idxP->openMsg != msg)
                {
                    if (flag == true)
                    {
                        idxP->histIdx = (idxP->histIdx < (PREVBUF - 1)) ?
                            (idxP->histIdx + 1) : 0;
                        idxP->prevMsg[idxP->histIdx] = idxP->openMsg;
                        idxP->openMsg = (idxP->openMsg < idxP->nofMsg - 10) ?
                            (idxP->openMsg + 10) : idxP->nofMsg;
                    }          
                    idxP->openMsg = msg;
                    (void) displayMessage(idxP, 0);
                }
                MemPtrFree(buf);
                goto SEARCH_END;
            }
            MemPtrFree(buf);
        }

        //obNAbvɖ߂ 
        *(ptr + len) = backup;
    }

    Hide_BusyForm(true);

    NNsh_ErrorMessage(ALTID_INFO, NNSH_MSGINFO_NOTFOUND, "", 0);

    // \XV(OS3.1foCXł͐^ɂȂ邽)
    frm = FrmGetActiveForm();
    FrmDrawForm(frm);
    if (NNshParam->useSonyTinyFont != 0)
    {
        // nC]tHgݒ蒆̎ɂ́AtB[h̍ĕ`s
        fld = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm,FLDID_MESSAGE));
        NNsi_HRFldDrawField(fld, 0);
    }

SEARCH_END:
    if (codeExchange)
        MemPtrFree(str);
}

/*-------------------------------------------------------------------------*/
/*   Function : NNsh_Get_MessageToBuf                                      */
/*                                                      bZ[W̓Ǎ   */
/*-------------------------------------------------------------------------*/
static Err NNsh_Get_MessageToBuf(NNshMessageIndex *idxP, UInt16 msg, UInt16 type, Boolean flag)
{
    Err ret = errNone;
    UInt32       readSize, offset, setMsg, backMsg, size;
    Int32 i;

    offset = 0;
    // f[^͍ǂݍ܂Ă̈ɂ邩`FbNB(킹...)
    if (((idxP->msgOffset)[msg - 1]  < idxP->fileOffset)||
        ((idxP->msgOffset)[msg] - 1  > idxP->fileOffset + idxP->fileReadSize))
    {
        // ݁Aǂݍ܂Ăobt@ɂ̓f[^ȂꍇBBB
        if ((idxP->msgOffset)[msg] < NNshParam->bufferSize)
        {
            // t@C̐擪ǂݍ
            offset = 0;
        }
        else if ((idxP->msgOffset)[msg - 1] >
                                     (idxP->fileSize - NNshParam->bufferSize))
        {
            // t@C̖ǂݍ
            offset = idxP->fileSize - NNshParam->bufferSize;
        }
        else
        {
            switch (type) 
            {
              case GET_MESSAGE_TYPE_HALF:
                // ߂郁bZ[W肷B
                backMsg = NNshParam->bufferSize / 1200;

                // (CfbNX̐擪 - backMsg)ǂݍ
                setMsg = (msg <= backMsg) ? 1 : (msg - backMsg);
                if ((idxP->msgOffset)[setMsg] > 10)
                {
                    offset = (idxP->msgOffset)[setMsg] - 10;  // 10̓}[W(ӖȂ)
                }
                else
                {
                    offset = 0;
                }
                if ((offset + NNshParam->bufferSize) < (idxP->msgOffset)[msg + 1])
                {
                    // backMsgbZ[WOǂݍݔ͈͊Oꍇ͂̏ꏊ
                    if ((idxP->msgOffset)[msg - 1] > 10)
                    {
                        offset = (idxP->msgOffset)[msg - 1] - 10; // 10̓}[W(ӖȂ)
                    }
                    else
                    {
                        offset = 0;
                    }
                }
                break;
                
              case GET_MESSAGE_TYPE_TOP:
                offset = (idxP->msgOffset)[msg - 1];
                break;

              case GET_MESSAGE_TYPE_BOTTOM:
                size = 0;
                i = msg - 1;
                while(i > 0)
                {
                    if (size + (idxP->msgOffset)[i + 1] - (idxP->msgOffset)[i] >
                                                         NNshParam->bufferSize)
                    {
                        break;
                    }
                    size = size + (idxP->msgOffset)[i + 1] - (idxP->msgOffset)[i];
                }
                offset = (idxP->msgOffset)[msg - 1] - size;
                break;
            }
        }
        
        if (flag == true)
        {
            // u҂āv\ (hideBusyForm()܂)
            Show_BusyForm(MSG_READ_MESSAGE_WAIT);
        }

        // f[^obt@ɓǂݍށB
        ret = ReadFile_NNsh(&(idxP->fileRef), offset, NNshParam->bufferSize,
                            &(idxP->buffer[0]), &readSize);
        if ((ret == errNone)||(ret == vfsErrFileEOF)||(ret == fileErrEOF))
        {
            idxP->fileOffset   = offset;
            idxP->fileReadSize = readSize;
        }

        if (flag == true) 
        {
            Hide_BusyForm(true);
        }
    }
    return(ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : UpdateFieldRegion                                          */
/*                                            tB[h^bvʒu̐ݒ   */
/*-------------------------------------------------------------------------*/
void UpdateFieldRegion(void)
{
    FormPtr frm;
    RectangleType r;

    frm = FrmGetActiveForm();
    if(FrmGetFormId(frm) != FRMID_MESSAGE)
      return;

    FrmGetObjectBounds(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE), &r);
    
    NNshGlobal->fieldPos[0].startX = r.topLeft.x;
    NNshGlobal->fieldPos[0].startY = r.topLeft.y;
    NNshGlobal->fieldPos[0].endX   = r.topLeft.x + r.extent.x;
    NNshGlobal->fieldPos[0].endY   = r.topLeft.y + r.extent.y / 2;

    NNshGlobal->fieldPos[1].startX = r.topLeft.x;
    NNshGlobal->fieldPos[1].startY = r.topLeft.y + r.extent.y / 2;
    NNshGlobal->fieldPos[1].endX   = r.topLeft.x + r.extent.x;
    NNshGlobal->fieldPos[1].endY   = r.topLeft.y + r.extent.y;
}

/*-------------------------------------------------------------------------*/
/*   Function : executeViewAction                                          */
/*                                            @\s(n[hL[p) */
/*-------------------------------------------------------------------------*/
static Boolean executeViewAction(UInt16 funcID)
{
    Char                 logMsg[BUFSIZE * 2], *txtP;
    Boolean              clip, err, ret = false;
    UInt16               item, frmId, start, end;
    FormType            *frm;
    FieldType           *fld;
    ControlType         *ctlP;
    NNshSubjectDatabase  subjDB;
    NNshMessageIndex    *idxP;
    NNshFileRef          fileRef;
    MemHandle            txtH;
    UInt32               size;
#ifdef USE_HANDERA
    VgaScreenModeType   handEraScreenMode;     // XN[[h
    VgaRotateModeType   handEraRotateMode;     // ][h
#endif

    // indexϐɓ
    idxP = NNshGlobal->msgIndex;

    // CfbNXȂꍇɂ́Areturn
    if (NNshGlobal->msgIndex == NULL)
    {
        return (false);
    }

    // @\R}hԍjumpSelectionɊi[(܂ǂȂ...B)
    NNshGlobal->jumpSelection = funcID;
    switch (funcID)
    {
      case MULTIVIEWBTN_FEATURE_INFO:
        // "X"
        item = 0;
        DisplayMessageInformations(NNshParam->openMsgIndex, &item);

        // Cɓ񃉃xXV
        setFavoriteLabel(FrmGetActiveForm(), item);

        // \XV(OS3.1foCXł͐^ɂȂ邽)
        FrmDrawForm(FrmGetActiveForm());
        (void) displayMessage(NNshGlobal->msgIndex, 0);
        break;

      case MULTIVIEWBTN_FEATURE_BACKTOLIST:
        // "ꗗʂ"
        ReadMessage_Close(FRMID_THREAD);
        break;

      case MULTIVIEWBTN_FEATURE_WRITE:
        // ""
        if (StrCompare(idxP->boardNick, OFFLINE_THREAD_NICK) != 0)
        {
            ReadMessage_Close(FRMID_WRITE_MESSAGE);
        }
        else
        {
            // WebBrowserURLJ
            if (NNshGlobal->browserCreator != 0)
            {
                // AJ[ꗗsbNAbv
                MemSet(logMsg, sizeof(logMsg), 0x00);
                ret = pickupAnchor(NNshGlobal->msgIndex, logMsg, sizeof(logMsg));
                if (ret == true)
                {
                    // w肳ꂽURLJ
                    // NetFrontN(NNsiIɋN)
                    (void) WebBrowserCommand(NNshGlobal->browserCreator,
                                              0, 0, 
                                              NNshGlobal->browserLaunchCode,
                                              logMsg, NULL);
                }
                (void) displayMessage(NNshGlobal->msgIndex, 0);
            }
            else
            {
                // "݃T|[gĂ܂" \s
                NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "(WRITE)", 0);
            }
        }
        break;

      case MULTIVIEWBTN_FEATURE_GETPART:
        // "擾"
        (void) PartReceiveMessage_View();
        break;

      case MULTIVIEWBTN_FEATURE_GETMESNUM:
        // "XԎw擾"
        clip  = false;

        //////// 񂪑IԂAI𕶎Nbv{[hɃRs[
        frm   = FrmGetActiveForm();
        frmId = FrmGetFocus(frm);
        if (frmId != noFocus)
        {        
            if (FrmGetObjectType(frm, frmId) == frmFieldObj)
            {
                fld = FrmGetObjectPtr(frm, frmId);
                FldGetSelection(fld, &start, &end);
                if (start != end)
                {
                    // I𕶎Rs[
                    FldCopy(FrmGetObjectPtr(frm, frmId));
                    if (NNshParam->useSonyTinyFont != 0)
                    {
                        // nC]tHgݒ蒆̎ɂ̓tB[hĕ`s
                        NNsi_HRFldDrawField(FrmGetObjectPtr(frm, frmId), 0);
                    }
                    clip = true;
                }
            }
        }

        // XԎw擾{
        ret = Get_MessageFromMesNum(&err, &item, clip);
        if (err == true)
        {
            // IÂƂBBSꗗĂ
            MEMFREE_PTR(NNshGlobal->bbsTitles);
        }
        // XԎw擾sƂ
        if (ret == true)
        {
            // XԎwōJĂ郌R[h̔ԍςmFB
            MemSet(&subjDB, sizeof(subjDB), 0x00);
            (void) Get_Subject_Database(NNshParam->openMsgIndex, &subjDB);
            if (StrCompare(subjDB.threadTitle, idxP->threadTitle) != 0)
            {
                // XR[hԍ(XԎw擾ɂ)ςI
                // (R[hԍP₷)
                (NNshParam->openMsgIndex)++;
                (NNshParam->startTitleRec)++;
                (NNshParam->endTitleRec)++;
            }

            // 擾\񃂁[hłȂƂAX擾AXJǂmF
            if (NNshParam->getReserveFeature == 0)
            {
                if (NNsh_ConfirmMessage(ALTID_CONFIRM,
                                        MSG_OPEN_CONFIRM_MESNUM, "", 0) == 0)
                {
                    // "OK"IꍇÃXJ
                    // (QƉʂĊJȂ) 
                    NNshParam->openMsgIndex      = item;
                    NNshParam->startTitleRec     = item;
                    NNshParam->endTitleRec       = item;
                    NNshParam->selectedTitleItem = 0;
                    ReadMessage_Close(FRMID_MESSAGE);

                    // (ꗗʂBBSꗗ́u擾ςݑSāvɂ)
                    NNshParam->lastBBS = NNSH_SELBBS_GETALL;
                    return (true);
                }
            }
        }
        else
        {
            // OS3.1foCX̎ɃLZƁAʂ̍ĕ`悪Kv
            frm = FrmGetActiveForm();
            FrmDrawForm(frm);
            if (NNshParam->useSonyTinyFont != 0)
            {
                // nC]tHgݒ蒆̎ɂ́AtB[h̍ĕ`s
                fld = FrmGetObjectPtr(frm,
                                         FrmGetObjectIndex(frm,FLDID_MESSAGE));
                NNsi_HRFldDrawField(fld, 0);
            }
        }
        return (false);
        break;

      case MULTIVIEWBTN_FEATURE_GOTOTOP:
        // "擪MSG"
        jumpEdge(false);
        break;

      case MULTIVIEWBTN_FEATURE_PREVIOUS:
        // "OMSG"
        (void) moveMessagePrev(false, 0);
        break;

      case MULTIVIEWBTN_FEATURE_PAGEUP:
        // "OXN["
        (void) moveMessagePrev(true, NNshParam->dispBottom);
        break;

      case MULTIVIEWBTN_FEATURE_PAGEDOWN:
        // "XN["
        (void) moveMessageNext(true);
        break;

      case MULTIVIEWBTN_FEATURE_NEXT:
        // "MSG"
        (void) moveMessageNext(false);
        break;

      case MULTIVIEWBTN_FEATURE_GOTOBOTTOM:
        // "MSG"
        jumpEdge(true);
        break;

      case MULTIVIEWBTN_FEATURE_JUMP:
        // "Go"
        jumpMessage(FrmGetActiveForm(), NNshGlobal->msgIndex);
        break;

      case MULTIVIEWBTN_FEATURE_RETURN:
        // "P߂"
        jumpPrevious();
        break;

      case MULTIVIEWBTN_FEATURE_COPY:
        // "Rs["
        frm   = FrmGetActiveForm();
        frmId = FrmGetFocus(frm);
        if (frmId == noFocus)
        {        
           // tH[JX擾łȂAI
            break;
        }
        if (FrmGetObjectType(frm, frmId) == frmFieldObj)
        {
            FldCopy(FrmGetObjectPtr(frm, frmId));
            if (NNshParam->useSonyTinyFont != 0)
            {
                // nC]tHgݒ蒆̎ɂ́AtB[h̍ĕ`s
                NNsi_HRFldDrawField(FrmGetObjectPtr(frm, frmId), 0);
            }
        }
        break;

      case MULTIVIEWBTN_FEATURE_SELECTALL:
        // "񂷂ׂđI"
        frm = FrmGetActiveForm();
        fld = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
        FldSetSelection(fld, 0, FldGetTextLength(fld));
        FrmSetFocus(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
        if (NNshParam->useSonyTinyFont != 0)
        {
            // nC]tHgݒ蒆̎ɂ́AtB[h̍ĕ`s
            NNsi_HRFldDrawField(fld, 0);
        }
        break;

      case MULTIVIEWBTN_FEATURE_SELANDWEB:
        // 񂷂ׂđIAWeb BrowserŊJ
        frm = FrmGetActiveForm();
        fld = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
        FldSetSelection(fld, 0, FldGetTextLength(fld));
        FrmSetFocus(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
        // not break; //

      case MULTIVIEWBTN_FEATURE_OPENWEB:
        // "Web"
        if (NNshGlobal->browserCreator == 0)
        {
            // "݃T|[gĂ܂" \s
            NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
            break;
        }

        // I𕶎gāANetFrontŊJ
        frm   = FrmGetActiveForm();
        frmId = FrmGetFocus(frm);
        if (frmId == noFocus)
        {        
           // tH[JX擾łȂAI
            break;
        }
        if (FrmGetObjectType(frm, frmId) == frmFieldObj)
        {
            // IĂ镶UNbv{[hɃRs[
            FldCopy(FrmGetObjectPtr(frm, frmId));

            // WebuEUŊJ
            openWebBrowser(NNshParam->confirmationDisable, logMsg, sizeof(logMsg));
        }
        break;

      case MULTIVIEWBTN_FEATURE_OUTPUTMEMO:
        // "o"
        outputMemoPad();
        break;

      case MULTIVIEWBTN_FEATURE_SEARCH:
        // ""
        frm  = FrmGetActiveForm();
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_SEARCH));
        if (NNshParam->searchMode == 1)
        {
            // [h𔲂
            NNshParam->searchMode = 0;
            CtlSetValue(ctlP, 0);
            break;
        }
        if (DataInputDialog(MSG_DIALOG_SEARCH_MESSAGE,
                            NNshParam->searchStrMessage, 
                            sizeof(NNshParam->searchStrMessage), 
                            NNSH_DIALOG_USE_SEARCH_MESSAGE, 
                            (void *)&item) == true)
        {
            CtlSetValue(ctlP, 1);
            NNshParam->searchMode = 1;
            NNsh_Search_Message(item, NNshParam->searchStrMessage, true);
        }
        else
        {
            // [h𔲂
            NNshParam->searchMode = 0;
            CtlSetValue(ctlP, 0);

            // OS3.1pł͉ʂ̍ĕ`悪Kv
            FrmDrawForm(frm);
            if (NNshParam->useSonyTinyFont != 0)
            {
                // nC]tHgݒ蒆̎ɂ́AtB[h̍ĕ`s
                fld = FrmGetObjectPtr(frm,
                                      FrmGetObjectIndex(frm, FLDID_MESSAGE));
                NNsi_HRFldDrawField(fld, 0);
            }
        }
        break;

      case MULTIVIEWBTN_FEATURE_SEARCHNEXT:
        // ""
        NNsh_Search_Message(NNSH_SEARCH_METHOD_NEXT, NNshParam->searchStrMessage, false);
        break;

      case MULTIVIEWBTN_FEATURE_SEARCHPREV:
        // "O"
        NNsh_Search_Message(NNSH_SEARCH_METHOD_PREV, NNshParam->searchStrMessage, false);
        break;

      case MULTIVIEWBTN_FEATURE_SEARCHTOP:
        // "擪猟"
        NNsh_Search_Message(NNSH_SEARCH_METHOD_FROM_TOP, NNshParam->searchStrMessage, false);
        break;

      case MULTIVIEWBTN_FEATURE_SEARCHBTM:
        // "猟"
        NNsh_Search_Message(NNSH_SEARCH_METHOD_FROM_BOTTOM, NNshParam->searchStrMessage, false);
        break;

      case MULTIVIEWBTN_FEATURE_CHANGEFONT:
        // "tHgύX"
        changeFont();
        break;

      case MULTIVIEWBTN_FEATURE_DRAWMODE:
        // "`惂[hύX"
        if (NNshParam->useSonyTinyFont == 0)
        {
            // nC][h֕ύX
            NNshParam->useSonyTinyFont = 1;
        }
        else
        {
            // ʏ탂[h֕ύX
            NNshParam->useSonyTinyFont = 0;
        }
        ReadMessage_Close(FRMID_MESSAGE);
        return (true);
        break;

#ifdef USE_HANDERA
      case MULTIVIEWBTN_FEATURE_ROTATE:
        // "ʂ̉](HE)"
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            VgaGetScreenMode(&handEraScreenMode, &handEraRotateMode);
            VgaSetScreenMode(screenMode1To1, 
                             VgaRotateSelect(handEraRotateMode));

            frm = FrmGetActiveForm();
            HandEraResizeForm(frm);
            FrmDrawForm(frm);
        }
        else
        {
            // "݃T|[gĂ܂" \s
            NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;
#endif // #ifdef USE_HANDERA

      case MULTIVIEWBTN_FEATURE_DISCONNECT:
        // "ؒf"
        NNshNet_LineHangup();
        break;

      case MULTIVIEWBTN_FEATURE_SETNETWORK:
        // "Networkݒ"
        OpenNetworkPreferences();
        break;

      case MULTIVIEWBTN_FEATURE_BOOKMARK:
        // "ݒ"
        if (NNshParam->useBookmark != 0)
        {
            NNshParam->lastFrmID     = NNSH_FRMID_MESSAGE;
            NNshParam->bookMsgIndex  = NNshParam->openMsgIndex;
            NNshParam->bookMsgNumber = idxP->openMsg;
            NNsh_InformMessage(ALTID_INFO, MSG_SET_BOOKMARK, "", 0);
        }
        else
        {
            // "݃T|[gĂ܂" \s
            NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;

      case MULTIVIEWBTN_FEATURE_DEVICEINFO:
        // "foCX"
        ShowDeviceInfo_NNsh();
        break;

      case MULTIVIEWBTN_FEATURE_PAGEUP10:
        // 10XO
        if (idxP->openMsg > 1)
        {
            // bZ[Wԍ10炵Aʕ\B
            idxP->histIdx = (idxP->histIdx < (PREVBUF - 1)) ?
                                                 (idxP->histIdx + 1) : 0;
            idxP->prevMsg[idxP->histIdx] = idxP->openMsg;
            idxP->openMsg = (idxP->openMsg > 11) ? (idxP->openMsg - 10) : 1;
            (void) displayMessage(NNshGlobal->msgIndex, 0);
        }
        break;

      case MULTIVIEWBTN_FEATURE_PAGEDOWN10:
        // 10X
        if (idxP->openMsg < idxP->nofMsg)
        {
            // bZ[Wԍ10₵Aʕ\B
            idxP->histIdx = (idxP->histIdx < (PREVBUF - 1)) ?
                                                 (idxP->histIdx + 1) : 0;
            idxP->prevMsg[idxP->histIdx] = idxP->openMsg;
            idxP->openMsg    = (idxP->openMsg < idxP->nofMsg - 10) ?
                                          (idxP->openMsg + 10) : idxP->nofMsg;
            (void) displayMessage(NNshGlobal->msgIndex, 0);
        }
        break;

      case MULTIVIEWBTN_FEATURE_GOTODUMMY:
        // _~[ʂ֑Jڂ
        ReadMessage_Close(FRMID_NNSI_DUMMY);
        break;

      case MULTIVIEWBTN_FEATURE_OPENURL:
        // WebBrowserURLJ(HTML̂Ƃ̂)
        if ((NNshGlobal->browserCreator != 0)&&
            ((idxP->bbsType & NNSH_BBSTYPE_MASK) == NNSH_BBSTYPE_HTML))
        {
            // AJ[ꗗsbNAbv
            MemSet(logMsg, sizeof(logMsg), 0x00);
            ret = pickupAnchor(NNshGlobal->msgIndex, logMsg, sizeof(logMsg));
            if (ret == true)
            {
                // w肳ꂽURLJ
                // NetFrontN(NNsiIɋN)
                (void) WebBrowserCommand(NNshGlobal->browserCreator,
                                          0, 0,  NNshGlobal->browserLaunchCode,
                                          logMsg, NULL);
            }
            (void) displayMessage(NNshGlobal->msgIndex, 0);
        }
        break;

      case MULTIVIEWBTN_FEATURE_EXECA2DA:
        // tB[hAf[^o
        frm = FrmGetActiveForm();
        fld = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
        txtH    = FldGetTextHandle(fld);
        if (txtH == 0)
        {
            // tB[h̃t@Cnh擾sAAAI
            return (false);
        }
        txtP = MemHandleLock(txtH);

        // t@CɃf[^o͂
        ret = OpenFile_NNsh(FILE_SENDMSG,
                            (NNSH_FILEMODE_READWRITE|NNSH_FILEMODE_TEMPFILE),
                            &fileRef);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "OpenFile_NNsh() ", " ret:", ret);
        }
        (void) WriteFile_NNsh(&fileRef, 0, StrLen(txtP), txtP, &size);
        CloseFile_NNsh(&fileRef);

        MemHandleUnlock(txtH);

        // Nbv{[hɁAa2DAɓnf[^ɂĂ̎wi[B
        MemSet (logMsg, sizeof(logMsg), 0x00);
        StrCopy(logMsg, A2DA_NNSIEXT_AADATASTART);
        StrCat (logMsg, A2DA_NNSIEXT_NNSICREATOR);
        StrCat (logMsg, A2DA_NNSIEXT_SRC_STREAM);
        StrCat (logMsg, A2DA_NNSIEXT_DATANAME);
        StrCat (logMsg, FILE_SENDMSG);
        StrCat (logMsg, A2DA_NNSIEXT_ENDDATANAME);
        StrCat (logMsg, A2DA_NNSIEXT_ENDDATA);
        ClipboardAddItem(clipboardText, logMsg, (StrLen(logMsg) + 1));

        // a2DAN
        (void) LaunchResource_NNsh('DAcc','a2DA','code',1000);
        break;

      case MULTIVIEWBTN_FEATURE_BT_ON:
        // Bluetooth ON
#ifdef USE_BT_CONTROL
        OpenBluetoothPreferences(true);
#endif  // #ifdef USE_BT_CONTROL
        break;

      case MULTIVIEWBTN_FEATURE_BT_OFF:
        // Bluetooth OFF
#ifdef USE_BT_CONTROL
        OpenBluetoothPreferences(false);
#endif  // #ifdef USE_BT_CONTROL
        break;

      default:
        // ̑(Ȃ)
        NNsh_DebugMessage(ALTID_WARN, "Unknown FuncID(view):", "", funcID);
        break;
    }
    return (false);
}
