/*============================================================================*
 *  FILE: 
 *     symbols.h
 *
 *  Description: 
 *     symbol definitions for NNsh.
 *
 *===========================================================================*/

//////////////////////////////////////////////////////////////////////////////
/***  DATABASE VERSIONS  ***/
#define SOFT_PREFID           100
#define SOFT_PREFVERSION      204

#define NNSH_PREFERID         200
#define NNSH_PREFERTYPE       105

#define SOFT_DBTYPE_ID        'Data'
#define OFFLINE_DBTYPE_ID     'GIKO'

#define DBNAME_BBSLIST        "BBS-NNsi"
#define DBVERSION_BBSLIST     160

#define DBNAME_SUBJECT        "Subject-NNsi"
#define DBVERSION_SUBJECT     160

#define DBNAME_SETTING        "Settings-NNsi"
#define DBVERSION_SETTING     111
#define DBSIZE_SETTING        32
#define DBVERSION_XML_SETTING 100

#define DBNAME_DIRINDEX       "DirIndex-NNsi"
#define DBVERSION_DIRINDEX    100

#define DBNAME_GETRESERVE     "GetReserve-NNsi"
#define DBVERSION_GETRESERVE  100

#define DBNAME_PERMANENTLOG    "LogPermanent-NNsi"
#define DBVERSION_PERMANENTLOG 100

#define DBNAME_TEMPORARYLOG    "LogTemporary-NNsi"
#define DBVERSION_TEMPORARYLOG 100

#define DBNAME_NGWORD          "NGWord-NNsi"
#define DBVERSION_NGWORD       100

//////////////////////////////////////////////////////////////////////////////

#define RSCID_createThreadIndexSub_ARM     1     // ARMlet֐ԍ̂P
#define RSCID_parseMessage_ARM             2     // ARMlet֐ԍ̂Q

//////////////////////////////////////////////////////////////////////////////

/** buffer size(small) **/
#define TINYBUF                      8
#define MINIBUF                     48
#define BUFSIZE                    128
#define HIDEBUFSIZE                128
#define PASSSIZE                     8
#define BIGBUF                     640
#define PREVBUF                     12
#define JUMPBUF                     16
#define NGWORD_LEN                  40


/** ꎞmۗ̈̕(5120 < x < 61000) **/
#define NNSH_WORKBUF_MIN          5120
#define NNSH_WORKBUF_MAX         61000
#define NNSH_WORKBUF_DEFAULT     32750
#define MARGIN                       4
#define FREE_SPACE_MARGIN         2048

/** ݎɊmۂobt@TCY **/
#define NNSH_WRITEBUF_MIN         4096
#define NNSH_WRITEBUF_MAX        16384
#define NNSH_WRITEBUF_DEFAULT     8192

#define NNSH_WRITELBL_MAX           26
#define NNSH_WRITELBL_HEAD        ""

#define NNSH_NEWTHREAD_MAX          32
#define NNSH_NEWTHREAD_LBLHEAD    "X:"

/** BBS-DB̕TCY **/
#define MAX_URL                     80
#define MAX_BOARDNAME               40
#define MAX_NICKNAME                16
#define LIMIT_BOARDNAME             20

/** Thread-DB ̕TCY **/
#define MAX_THREADFILENAME          32
#define MAX_THREADNAME              72
#define MAX_DIRNAME                 40
#define LIMIT_TITLENAME_DEFAULT     72
#define LIMIT_TITLENAME_MINIMUM     12
#define MAX_DEPTH                   10
#define MAX_LISTLENGTH              24

/** GetData-DB̕TCY **/
#define MAX_DATAPREFIX              32
#define MAX_DATATOKEN               80

/** URLꗗ̕\TCY **/
#define MAX_NAMELABEL               48
#define MAX_URL_LIST                24

/** ^Cgуẍ̗TCY **/
#define BBSSEL_PAGEINFO             12
#define NNSH_MSGTITLE_BUFSIZE       10

/** VFSt@C̍őTCY  **/
#define MAXLENGTH_FILENAME          256

/** _E[hɑz肷HTTPwb_TCY **/
#define NNSH_HTTPGET_HEADERMAX      400
#define NNSH_DOWNLOADSIZE_MIN      2048

/** ʐM^CAEgl(tick) **/
#define NNSH_NET_TIMEOUT           2500

/** bZ[W̍ő僌Xԍ **/
#define NNSH_MESSAGE_MAXNUMBER     1005
#define NNSH_MESSAGE_MAXLIMIT      25000
#define NNSH_MESSAGE_LIMIT         1000

/** BBS URL **/
#define URL_BBSTABLE_OLD         "http://www6.ocn.ne.jp/~mirv/bbstable.html"
#define URL_BBSTABLE             "http://www.ff.iij4u.or.jp/~ch2/bbstable.html"

#define URL_PREFIX                     "test/read.cgi/"
#define URL_PREFIX_IMODE               "test/r.i/"
#define URL_PREFIX_MACHIBBS            "bbs/read.pl?BBS="
#define URL_PREFIX_MACHIBBS_IMODE      "bbs/read.pl?IMODE=TRUE&BBS="
#define URL_PREFIX_SHITARABA           "cgi-bin/read.cgi?bbs="
#define URL_PREFIX_SHITARABA_IMODE     "cgi-bin/read.cgi?bbs="
#define URL_PREFIX_SHITARABAJBBS       "bbs/read.cgi?BBS="
#define URL_PREFIX_SHITARABAJBBS_IMODE "bbs/i.cgi?BBS="
#define FILE_THREADLIST                "subject.txt"

/** default font ID **/
#define NNSH_DEFAULT_FONT           stdFont
#define NNSH_DEFAULT_FONT_HR        stdFont

#define NNSH_NOTENTRY_THREAD        0xffff
#define NNSH_NOTENTRY_BBS           0xffff

/** OFFLINE LOG(for GIKO Shippo) **/
#define OFFLINE_THREAD_NAME         "QƐpO"
#define OFFLINE_THREAD_NICK         "!GikoShippo/"
#define OFFLINE_THREAD_URL          "file://"

#define FAVORITE_THREAD_NAME        "Cɓ"
#define GETALL_THREAD_NAME          "擾ςݑS"
#define NOTREAD_THREAD_NAME         "ǂ"
#define CUSTOM1_THREAD_NAME         "擾G["
#define CUSTOM2_THREAD_NAME         "Palm֘A"
#define CUSTOM3_THREAD_NAME         "VK(3ȓ)"
#define CUSTOM4_THREAD_NAME         "ő咴"
#define CUSTOM5_THREAD_NAME         "擾ۗ"

#define CUSTOM1_THREAD_HEAD         "1>"
#define CUSTOM2_THREAD_HEAD         "2>"
#define CUSTOM3_THREAD_HEAD         "3>"
#define CUSTOM4_THREAD_HEAD         "4>"
#define CUSTOM5_THREAD_HEAD         "5>"


#define NNSH_NOF_SPECIAL_BBS        9   // Ȕ̐
#define NNSH_SELBBS_NOTREAD         0   // ǂ
#define NNSH_SELBBS_GETALL          1   // 擾ςݑS
#define NNSH_SELBBS_FAVORITE        2   // CɓX
#define NNSH_SELBBS_CUSTOM1         3   // CUSTOM1
#define NNSH_SELBBS_CUSTOM2         4   // CUSTOM2
#define NNSH_SELBBS_CUSTOM3         5   // CUSTOM3
#define NNSH_SELBBS_CUSTOM4         6   // CUSTOM4
#define NNSH_SELBBS_CUSTOM5         7   // CUSTOM5
#define NNSH_SELBBS_OFFLINE         8   // OFFLINEX

// for NaNaShi FILE NAMEs
#define FILE_WRITEMSG               "write.txt"
#define FILE_WRITENAME              "writeName.txt"
#define FILE_WRITEMAIL              "writeMail.txt"
#define FILE_RECVMSG                "recv.txt"
#define FILE_SENDMSG                "send.txt"
#define FILE_XML_NNSISET            "NNsiSet.xml"
#define FILE_LOGCHARGE_PREFIX       "NNsiLog"
#define FILE_LOGCHARGE_SUFFIX       ".html"

#define DATAFILE_PREFIX             "/PALM/Programs/NNsh/"
#define LOGDATAFILE_PREFIX          "/PALM/Programs/2ch/"
#define LOGDIR_FILE                 "/PALM/Programs/2ch/logdir.txt"
#define DATAFILE_SUFFIX             ".dat"
#define CGIFILE_SUFFIX              ".cgi"

//  time diference between from 'Jan/01/1904' to 'Jan/01/1970'.
#define TIME_CONVERT_1904_1970      (2082844800 - 32400)
#define TIME_CONVERT_1904_1970_UTC  (2082844800)

/** VFS SETTINGS **/
#define NNSH_NOTSUPPORT_VFS         0xf000
#define NNSH_VFS_DISABLE            0x0000
#define NNSH_VFS_ENABLE             0x0001
#define NNSH_VFS_WORKAROUND         0x0002
#define NNSH_VFS_USEOFFLINE         0x0004
#define NNSH_VFS_DBBACKUP           0x0008
#define NNSH_VFS_DBIMPORT           0x0010
#define NNSH_VFS_DIROFFLINE         0x0020
#define NNSH_VFS_USE_CF             0x0040

#define NNSH_COPY_PALM_TO_VFS       0
#define NNSH_COPY_VFS_TO_VFS        1
#define NNSH_COPY_VFS_TO_PALM       2
#define NNSH_COPY_PALM_TO_PALM      4

#define NNSH_FILEMODE_CREATE        1
#define NNSH_FILEMODE_READWRITE     2
#define NNSH_FILEMODE_READONLY      4
#define NNSH_FILEMODE_TEMPFILE      8
#define NNSH_FILEMODE_APPEND        16

#define FILEMGR_STATE_DISABLED      0
#define FILEMGR_STATE_OPENED_VFS    1
#define FILEMGR_STATE_OPENED_STREAM 2

/** BBS-DB̕\(Iʂŕ\邩/Ȃ) **/
#define NNSH_BBSSTATE_VISIBLE       0x01         // \
#define NNSH_BBSSTATE_INVISIBLE     0x00         // \

#define NNSH_BBSSTATE_LEVELMASK     0x0e         // Xxo}XN
#define NNSH_BBSSTATE_NOTFAVOR      0xf1         // XxNA
#define NNSH_BBSSTATE_FAVOR_L1      0x02         // XxL1
#define NNSH_BBSSTATE_FAVOR_L2      0x04         // XxL2
#define NNSH_BBSSTATE_FAVOR_L3      0x06         // XxL3
#define NNSH_BBSSTATE_FAVOR_L4      0x08         // XxL4
#define NNSH_BBSSTATE_FAVOR         0x0e         // XxHIGH


/** BBS-DB̃{[h^Cv **/
#define NNSH_BBSTYPE_2ch            0x00         // 2ch(ʏ탂[h)
#define NNSH_BBSTYPE_MACHIBBS       0x01         // ܂BBS(ꃂ[h)
#define NNSH_BBSTYPE_SHITARABA      0x02         // BBS
#define NNSH_BBSTYPE_SHITARABAJBBS  0x03         // @JBBS
#define NNSH_BBSTYPE_OTHERBBS       0x04         // 2ch݊BBS
#define NNSH_BBSTYPE_PLUGINSUPPORT  0x05         // 2ch`ϊBBS
#define NNSH_BBSTYPE_HTML           0x06         // html`f[^
#define NNSH_BBSTYPE_ERROR          0xff         // {[h^CvG[
#define NNSH_BBSTYPE_MASK           0x1f         // {[h^CvMASK
#define NNSH_BBSTYPE_CHARSETMASK    0xe0         // {[h̕R[h
#define NNSH_BBSTYPE_CHAR_SJIS      0x00         // WR[h(SHIFT JIS)
#define NNSH_BBSTYPE_CHAR_EUC       0x20         // EUCR[h
#define NNSH_BBSTYPE_CHAR_JIS       0x40         // JISR[h(iso-2022-jp)
#define NNSH_BBSTYPE_CHAR_SHIFT     5            // EVtg


/** ꗗ\BBSꗗCɓ肩 **/
#define NNSH_FAVORLIST_MODE         1
#define NNSH_BBSLIST_MODE           0 


// f[^x[X̃L[^Cv()
#define NNSH_KEYTYPE_CHAR           0
#define NNSH_KEYTYPE_UINT32         1
#define NNSH_KEYTYPE_UINT16         2
#define NNSH_KEYTYPE_SUBJECT        3

// HTTPbZ[W쐬Ɏw
#define HTTP_SENDTYPE_GET                10
#define HTTP_SENDTYPE_GET_NOTMONA        11
#define HTTP_SENDTYPE_POST               20
#define HTTP_SENDTYPE_POST_OTHERBBS      30
#define HTTP_SENDTYPE_POST_MACHIBBS      40
#define HTTP_SENDTYPE_POST_SHITARABAJBBS 80
#define HTTP_SENDTYPE_POST_SHITARABA     90
#define HTTP_RANGE_OMIT             0xffffffff
#define HTTP_GETSUBJECT_LEN         4096
#define HTTP_GETSUBJECT_START       0
#define HTTP_GETSUBJECT_PART        0

// 
#define NNSH_SEARCH_ALL             0
#define NNSH_SEARCH_FORWARD         1
#define NNSH_SEARCH_BACKWARD       -1

// ݃bZ[WmFR}h
#define NNSH_WRITECHK_SPID          0
#define NNSH_WRITECHK_REPLY         1

// bZ[W̑
#define NNSH_MSGATTR_NOTSPECIFY    0xff   // uCɓvw͎w肵Ȃ
#define NNSH_MSGATTR_NOTFAVOR      0x4f   // uCɓvXłȂ(MASKl)
#define NNSH_MSGATTR_FAVOR_L1      0x10   // uCɓvx()
#define NNSH_MSGATTR_FAVOR_L2      0x20   // uCɓvx()
#define NNSH_MSGATTR_FAVOR_L3      0x30   // uCɓvx()
#define NNSH_MSGATTR_FAVOR_L4      0x80   // uCɓvx()
#define NNSH_MSGATTR_FAVOR         0xb0   // uCɓvX()
#define NNSH_MSGATTR_NOTERROR      0xbf   // uG[vXłȂ(MASKl)
#define NNSH_MSGATTR_ERROR         0x40   // uG[vXł
#define NNSH_MSGATTR_GETRESERVE    0x08   // u擾\vXł
#define NNSH_MSGATTR_NOTRESERVE    0xf7   // u擾\vXNA(MASK)

#define NNSH_ATTRLABEL_TITLE       ", Level:" 
#define NNSH_ATTRLABEL_NOTFAVOR    "-"    // uCɓvł͂Ȃ
#define NNSH_ATTRLABEL_FAVOR_L1    "L"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR_L2    "1"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR_L3    "2"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR_L4    "3"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR       "H"    // uCɓvx()


// ꎞ(݁AWO񂵏ԂL)
#define NNSH_TEMPTYPE_PUSHEDJOGUP   16
#define NNSH_TEMPTYPE_PUSHEDJOGDOWN  8
#define NNSH_TEMPTYPE_CLEARSTATE     0

//  ̑̏Ԓl
#define NNSH_NOT_EFFECTIVE          0
#define NNSH_UPDATE_DISPLAY         1
#define NNSH_SILK_CONTROL           1

#define NNSH_DISABLE                0
#define NNSH_ENABLE                 1

// NNsĩf[^x[XXV
#define NNSH_DB_UPDATE_BBS          0x0001
#define NNSH_DB_UPDATE_SUBJECT      0x0002
#define NNSH_DB_UPDATE_SETTING      0x0004
#define NNSH_DB_UPDATE_DIRINDEX     0x0008

#define NNSH_DB_MASK_BBS            0xfffe
#define NNSH_DB_MASK_SUBJECT        0xfffd
#define NNSH_DB_MASK_SETTING        0xfffb
#define NNSH_DB_MASK_DIRINDEX       0xfff7

//////////////////////////////////////////////////////////////////////////////

/********** HTMLԉ͗p ********/
#define HTTP_ANCHORSTATE_NORMAL     101
#define HTTP_ANCHORSTATE_ANCHOR     102
#define HTTP_ANCHORSTATE_LABEL      103
#define HTTP_ANCHORSTATE_KANJI      104

/**********  Xǂݏoԗp  *********/
#define NNSH_SUBJSTATUS_NOT_YET      0
#define NNSH_SUBJSTATUS_NEW          1
#define NNSH_SUBJSTATUS_UPDATE       2
#define NNSH_SUBJSTATUS_REMAIN       3
#define NNSH_SUBJSTATUS_ALREADY      4
#define NNSH_SUBJSTATUS_DELETE       5
#define NNSH_SUBJSTATUS_UNKNOWN      6
#define NNSH_SUBJSTATUS_GETERROR     7
#define NNSH_SUBJSTATUS_OVER         8

#define NNSH_MSGSTATE_NOTMODIFIED   10
#define NNSH_MSGSTATE_ERROR         20

#define NNSH_ERRORCODE_PARTGET        (~errNone - 12)
#define NNSH_ERRORCODE_FAILURECONNECT (~errNone -  5)
#define NNSH_ERRORCODE_THREADNOTHING  (~errNone - 88)
#define NNSH_ERRORCODE_WRONGVFSMODE   (~errNone - 10)
#define NNSH_ERRORCODE_COPYFAIL       (~errNone - 11)
#define NNSH_ERRORCODE_NOTFOUND       (~errNone - 12)

/**********  bZ[Wp[Xp  *********/
#define MSGSTATUS_NAME              1
#define MSGSTATUS_EMAIL             2
#define MSGSTATUS_DATE              3
#define MSGSTATUS_NORMAL            4

/**********  BBSLX  **************/
#define NNSH_BBSLIST_AGAIN         -1            // XēxmF


/*********** VmF{R}h ********/
#define NNSH_NEWARRIVAL_NORMAL      0            // ʏ擾[h
#define NNSH_NEWARRIVAL_ONLYMESNUM  1            // XԎw\̂̂̂

/////////////////////////////////////////////////////////////////////////////

/*** DATA TOKENS ***/
#define DATA_SEPARATOR              "<>"
#define DATA_NEWLINE                "<br>"

/** for BBS NAME PARSER **/
#define HTTP_TOKEN_ST_ANCHOR        "<A"
#define HTTP_TOKEN_ED_ANCHOR        "</A>"
#define HTTP_TOKEN_END              ">"


#define NNSH_KANJICODE_SHIFTJIS     0x00
#define NNSH_KANJICODE_EUC          0x01
#define NNSH_KANJICODE_JIS          0x02

#define NNSH_HTTP_HEADER_ENDTOKEN   "\x0d\x0a\x0d\0a"
#define NNSH_NGSET_SEPARATOR        ','
#define NNSH_FIELD_SEPARATOR        "<>"
#define NNSH_FIELD_SEPARATOR_MACHI  ","
#define NNSH_RECORD_SEPARATOR       "\x0a"
#define NNSH_SUBJTITLE_END          "("

#define NNSH_JBBSTOKEN_START        "\x0a<dt>"
#define NNSH_JBBSTOKEN_END          "<br><br>\x0a"
#define NNSH_JBBSTOKEN_MSGSTART     "\xcc\xbe\xc1\xb0\xa1\xa7" // OF
#ifdef OLD_MACHIBBS_TOKEN
#define NNSH_MACHITOKEN_START       "\x0d\x0a<dt>"
#define NNSH_MACHITOKEN_END         "<br><br>\x0a\x0d\x0a"
#else
#define NNSH_MACHITOKEN_START       "\x0a<dt>"
#define NNSH_MACHITOKEN_END         "<br><br>\x0a"
#endif
#define NNSH_MACHITOKEN_MSGSTART    "OF"
#define NNSH_MACHINAME_SUFFIX       "[܂BBS]"
#define NNSH_SHITARABA_SUFFIX       "[]"
#define NNSH_SHITARABAJBBS_SUFFIX   "[@JBBS]"

/** **/
#define NNSH_SYMBOL_WRITE_DONE      "݂܂B"
#define NNSH_SYMBOL_WRITE_NG        "dqqnq"

#define NNSH_DEVICE_NORMAL          0
#define NNSH_DEVICE_HANDERA         1

#define NNSH_VFS_USEMEDIA_ANY       0
#define NNSH_VFS_USEMEDIA_CF        1
#define NNSH_VFS_USEMEDIA_MS        2
#define NNSH_VFS_USEMEDIA_SD        3
#define NNSH_VFS_USEMEDIA_SM        4
#define NNSH_VFS_USEMEDIA_RD        5
#define NNSH_VFS_USEMEDIA_DoC       6

#define NNSH_JUMPMSG_LEN            10
#define NNSH_JUMPMSG_HEAD           ">>"

#define NNSH_JUMPMSG_BACK           "P߂"
#define NNSH_JUMPMSG_TO_LIST        "ꗗ"
#define NNSH_JUMPMSG_OPEN_MENU      "j["
#define NNSH_JUMPMSG_UPDATE         "擾"
#define NNSH_JUMPMSG_HANGUP         "ؒf"
#define NNSH_JUMPMSG_TOP            "擪"
#define NNSH_JUMPMSG_BOTTOM         ""
#define NNSH_JUMPMSG_OPENWEB        "SIWeb"
#define NNSH_JUMPMSG_CHANGEVIEW     "`惂[hύX"
#define NNSH_JUMPMSG_FAVORITE       "X"
#define NNSH_JUMPMSG_OUTPUTMEMO     ""
#define NNSH_JUMPMSG_BOOKMARK       "ݒ"
#define NNSH_JUMPMSG_DEVICEINFO     "foCX"
#define NNSH_JUMPMSG_OPENLINK       "NJ"
#define NNSH_JUMPMSG_EXECA2DA       "a2DA(AAQ)"

#define NNSH_NOF_JUMPMSG_EXT        15
#define NNSH_JUMPSEL_BACK           0x8001
#define NNSH_JUMPSEL_TO_LIST        0x8002
#define NNSH_JUMPSEL_OPEN_MENU      0x8003
#define NNSH_JUMPSEL_UPDATE         0x8004
#define NNSH_JUMPSEL_HANGUP         0x8005
#define NNSH_JUMPSEL_TOP            0x8006
#define NNSH_JUMPSEL_BOTTOM         0x8007
#define NNSH_JUMPSEL_OPENWEB        0x8008
#define NNSH_JUMPSEL_CHANGEVIEW     0x8009
#define NNSH_JUMPSEL_FAVORITE       0x800a
#define NNSH_JUMPSEL_OUTPUTMEMO     0x800b
#define NNSH_JUMPSEL_BOOKMARK       0x800c
#define NNSH_JUMPSEL_DEVICEINFO     0x800d
#define NNSH_JUMPSEL_OPENLINK       0x800e
#define NNSH_JUMPSEL_EXECA2DA       0x800f


#define NNSH_JUMPMSG_OPENBBS        "I"
#define NNSH_JUMPMSG_OPENMENU       "j["
#define NNSH_JUMPMSG_OPENNEW        "VmF"
#define NNSH_JUMPMSG_OPENLIST       "ꗗ擾"
#define NNSH_JUMPMSG_OPENGET        "X擾"
#define NNSH_JUMPMSG_OPENINFO       "X"
#define NNSH_JUMPMSG_OPENMES        "XQ"
#define NNSH_JUMPMSG_DISCONNECT     "ؒf"
#define NNSH_JUMPMSG_COPYMSG        "QƂփRs["
#define NNSH_JUMPMSG_DELMSG         "X폜"
#define NNSH_JUMPMSG_GRAPHMODE      "`惂[hύX"
#define NNSH_JUMPMSG_MULTISW1       "ړISW1"
#define NNSH_JUMPMSG_MULTISW2       "ړISW2"
#define NNSH_JUMPMSG_NNSIEND        "NNsiI"
#define NNSH_JUMPMSG_SHOWDEVINFO    "foCX"
#define NNSH_JUMPMSG_DIRSELECTION   "DirI"
#define NNSH_JUMPMSG_CHANGELOGLOC   "OʒuύX"
#define NNSH_JUMPMSG_CHANGELOGDIR   "DirύX"

#define NNSH_ITEMLEN_JUMPLIST       14      // XgACe
#define NNSH_JUMPSEL_NUMLIST        18      // XgACe
#define NNSH_JUMPSEL_OPENBBS        0x9000  // I
#define NNSH_JUMPSEL_OPENMENU       0x9001  // j[
#define NNSH_JUMPSEL_DISCONNECT     0x9002  // ؒf
#define NNSH_JUMPSEL_OPENNEW        0x9003  // VmF
#define NNSH_JUMPSEL_OPENLIST       0x9004  // ꗗ擾
#define NNSH_JUMPSEL_OPENGET        0x9005  // X擾
#define NNSH_JUMPSEL_OPENMES        0x9006  // XQ
#define NNSH_JUMPSEL_OPENINFO       0x9007  // X
#define NNSH_JUMPSEL_COPYMSG        0x9008  // QƂփRs[
#define NNSH_JUMPSEL_DELMSG         0x9009  // X폜
#define NNSH_JUMPSEL_GRAPHMODE      0x900a  // `惂[hύX
#define NNSH_JUMPSEL_MULTISW1       0x900b  // ړISW1
#define NNSH_JUMPSEL_MULTISW2       0x900c  // ړISW2
#define NNSH_JUMPSEL_NNSIEND        0x900d  // NNsiI
#define NNSH_JUMPSEL_SHOWDEVINFO    0x900e  // foCX
#define NNSH_JUMPSEL_DIRSELECTION   0x900f  // fBNgI
#define NNSH_JUMPSEL_CHANGELOGLOC   0x9010  // OʒuύX
#define NNSH_JUMPSEL_CHANGELOGDIR   0x9011  // fBNgύX

#define NNSH_STEP_ITEMUP           -1
#define NNSH_STEP_ITEMDOWN          1
#define NNSH_STEP_PAGEUP           -1
#define NNSH_STEP_PAGEDOWN          1
#define NNSH_STEP_REDRAW            0
#define NNSH_STEP_UPDATE           10
#define NNSH_STEP_TO_BOTTOM       100
#define NNSH_STEP_TO_TOP          NNSH_STEP_UPDATE

#define NNSH_ITEM_LASTITEM         0xffff

#define NNSH_DISP_NOTHING          0x0000   // Ȃ
#define NNSH_DISP_UPPERLIMIT       0x0001   // 
#define NNSH_DISP_HALFWAY          0x0002   // r
#define NNSH_DISP_ALL              0x0004   // S\
#define NNSH_DISP_LOWERLIMIT       0x0008   // 

#define NNSH_DISPMSG_NOTHING       "Ȃ"
#define NNSH_DISPMSG_UPPERLIMIT    ""
#define NNSH_DISPMSG_HALFWAY       "r"
#define NNSH_DISPMSG_ALL           "S\"
#define NNSH_DISPMSG_LOWERLIMIT    ""
#define NNSH_DISPMSG_UNKNOWN       "?????"

#define NNSH_MSGNUM_UNKNOWN        0xffff
#define NNSH_MSGNUM_NOTDISPLAY     0x0000

#define NNSH_LIMIT_COPYBUFFER      2000
#define NNSH_LIMIT_MEMOPAD         4000
#define NNSH_LIMIT_RETRY           5
#define NNSH_MEMOBUFFER_MERGIN     96

#define NNSH_BUSYWIN_MAXLEN        32

#define NNSH_WRITE_DELAYTIME       7
#define NNSH_NEWTHREAD_DELAYTIME   2
#define NNSH_WRITE_DELAYSECOND     45

#define NNSH_MSGTOKENSTATE_NONE    0
#define NNSH_MSGTOKENSTATE_MESSAGE 1
#define NNSH_MSGTOKENSTATE_END     2

#define NNSH_INPUTWIN_SEARCH       "TITLE"
#define NNSH_INPUTWIN_GETMESNUM    "X擾(XԎw)"
#define NNSH_INPUTWIN_MODIFYTITLE  "X^CgύX"
#define NNSH_INPUTWIN_NGWORD1      "NGP̓o^"
#define NNSH_INPUTWIN_NGWORD2      "NGQ̓o^"
#define NNSH_INPUTWIN_SETPASS      "NNsiN[hݒ"
#define NNSH_INPUTWIN_ENTPASS      "Register..."
#define NNSH_INPUTWIN_RESOLVE      "Host Name"

#define NNSH_DIALOG_USE_SEARCH      10
#define NNSH_DIALOG_USE_GETMESNUM   20
#define NNSH_DIALOG_USE_MODIFYTITLE 40
#define NNSH_DIALOG_USE_SEARCH_MESSAGE 60
#define NNSH_DIALOG_USE_SETNGWORD   80
#define NNSH_DIALOG_USE_PASS       100
#define NNSH_DIALOG_USE_RESOLVE    110
#define NNSH_DIALOG_USE_INPUTURL   120

// _CAOȗݒ
#define NNSH_OMITDIALOG_NOTHING      0x00
#define NNSH_OMITDIALOG_CONFIRM      0x01
#define NNSH_OMITDIALOG_WARNING      0x02
#define NNSH_OMITDIALOG_INFORMATION  0x04
#define NNSH_OMITDIALOG_ALLOMIT      ((NNSH_OMITDIALOG_CONFIRM)|(NNSH_OMITDIALOG_WARNING)|(NNSH_OMITDIALOG_INFORMATION))

// ړI{^֘A̐ݒ
#define NNSH_SWITCHUSAGE_FORMMASK   0x3f00
#define NNSH_SWITCHUSAGE_FUNCMASK   0x00ff

#define NNSH_SWITCHUSAGE_TITLE      0x2100

#define NNSH_SWITCHUSAGE_NOUSE      0x00  // ړIXCb`gpȂ
#define NNSH_SWITCHUSAGE_GETPART    0x01  // X擾[h(ꊇ/)
#define NNSH_SWITCHUSAGE_HANZEN     0x02  // pJiSpJiϊ
#define NNSH_SWITCHUSAGE_USEPROXY   0x03  // ProxyoRŃANZX
#define NNSH_SWITCHUSAGE_CONFIRM    0x04  // mF_CAȌȗ

#define NNSH_SWITCHUSAGE_SUBJECT    0x05  // XꗗS擾؂ւ  (ꗗʗp)
#define NNSH_SWITCHUSAGE_TITLEDISP  0x06  // Xꗗ`惂[hؑ  (ꗗʗp)
#define NNSH_SWITCHUSAGE_MSGNUMBER  0x07  // XꗗMSGԍ       (ꗗʗp)
#define NNSH_SWITCHUSAGE_GETRESERVE 0x08  // X擾ۗ[h      (ꗗʗp)
#define NNSH_SWITCHUSAGE_IMODEURL   0x09  // i-mode URLgp[h    (ꗗʗp)
#define NNSH_SWITCHUSAGE_BLOCKDISP  0x0a  // ][\[h        (ꗗʗp)
#define NNSH_SWITCHUSAGE_MACHINEW   0x0b  // ܂BBSVmF   (ꗗʗp)
#define NNSH_SWITCHUSAGE_USEPLUGIN  0x0c  // VmFɃ[mF  (ꗗʗp)
#define NNSH_SWITCHUSAGE_LISTUPDATE 0x0d  // ꗗ擾ƃXXV      (ꗗʗp)

// ړI{^̏ݒl
#define NNSH_SWITCH1USAGE_DEFAULT   NNSH_SWITCHUSAGE_GETPART    // X擾[h
#define NNSH_SWITCH2USAGE_DEFAULT   NNSH_SWITCHUSAGE_USEPROXY   // ProxyoRł̃ANZX

#define NNSH_SUBJSTATUSMSG_NOT_YET  "擾"
#define NNSH_SUBJSTATUSMSG_NEW      "VK擾"
#define NNSH_SUBJSTATUSMSG_UPDATE   "XV擾"
#define NNSH_SUBJSTATUSMSG_REMAIN   "ǂ"
#define NNSH_SUBJSTATUSMSG_ALREADY  ""
#define NNSH_SUBJSTATUSMSG_UNKNOWN  "ԕs"

/** X **/
#define MAX_SEARCH_STRING 64

/** X@ **/
#define NNSH_SEARCH_METHOD_FROM_TOP    0 //擪猟
#define NNSH_SEARCH_METHOD_NEXT        1 //
#define NNSH_SEARCH_METHOD_PREV        2 //O
#define NNSH_SEARCH_METHOD_FROM_BOTTOM 3 //猟

/** bZ[W擾@ **/
#define GET_MESSAGE_TYPE_TOP    1 // ւ̌p
#define GET_MESSAGE_TYPE_HALF   2 // XQƗp
#define GET_MESSAGE_TYPE_BOTTOM 3 // 擪ւ̌p


// FORM ID LIST
#define NNSH_FRMID_THREAD        0x1200    // ꗗ
#define NNSH_FRMID_MESSAGE       0x1201    // QƉ
#define NNSH_FRMID_DUMMY         0x1202    // _~[


// ړI{^̐ݒ
#define MAX_CAPTION                  6
#define LIMIT_CAPTION                4

#define MULTIBTN1_CAPTION_DEFAULT    "Q"
#define MULTIBTN1_FEATURE_DEFAULT    MULTIBTN_FEATURE_OPEN

#define MULTIBTN2_CAPTION_DEFAULT    "擾"
#define MULTIBTN2_FEATURE_DEFAULT    MULTIBTN_FEATURE_GET

#define MULTIBTN3_CAPTION_DEFAULT    "폜"
#define MULTIBTN3_FEATURE_DEFAULT    MULTIBTN_FEATURE_DELETE

#define MULTIBTN4_CAPTION_DEFAULT    "ؒf"
#define MULTIBTN4_FEATURE_DEFAULT    MULTIBTN_FEATURE_DISCONN

#define MULTIBTN5_CAPTION_DEFAULT    "ꗗ"
#define MULTIBTN5_FEATURE_DEFAULT    MULTIBTN_FEATURE_GETLIST

#define MULTIBTN6_CAPTION_DEFAULT    "V"
#define MULTIBTN6_FEATURE_DEFAULT    MULTIBTN_FEATURE_NEWARRIVAL

#define UPBTN_FEATURE_DEFAULT        MULTIBTN_FEATURE_SELECTPREV
#define DOWNBTN_FEATURE_DEFAULT      MULTIBTN_FEATURE_SELECTNEXT

#define JOGPUSH_FEATURE_DEFAULT      MULTIBTN_FEATURE_OPEN
#define JOGBACK_FEATURE_DEFAULT      MULTIBTN_FEATURE_SELMENU
#define CAPTURE_FEATURE_DEFAULT      MULTIBTN_FEATURE_INFO

#define MULTIBTN_FEATURE_MASK        0x00ff
#define MULTIBTN_FEATURE             0x7600

// ꗗʂ̋@\ݒi@\ԍj
//    ݒp^CǵA\[XŒ`(ƓĂKv)
#define MULTIBTN_FEATURE_INFO        0  // ""
#define MULTIBTN_FEATURE_OPEN        1  // "Q"
#define MULTIBTN_FEATURE_GET         2  // "X擾"
#define MULTIBTN_FEATURE_ALLGET      3  // "VK()擾"
#define MULTIBTN_FEATURE_PARTGET     4  // "擾"
#define MULTIBTN_FEATURE_DELETE      5  // "X폜"
#define MULTIBTN_FEATURE_SORT        6  // "X"
#define MULTIBTN_FEATURE_MODTITLE    7  // "X^CύX"
#define MULTIBTN_FEATURE_OPENWEB     8  // "uEUŊJ"
#define MULTIBTN_FEATURE_MESNUM      9  // "XԎw擾"
#define MULTIBTN_FEATURE_SEARCH     10  // "X^C"
#define MULTIBTN_FEATURE_NEXT       11  // ""
#define MULTIBTN_FEATURE_PREV       12  // "O"
#define MULTIBTN_FEATURE_TOP        13  // "擪ֈړ"
#define MULTIBTN_FEATURE_BOTTOM     14  // "ֈړ"
#define MULTIBTN_FEATURE_GETBBS     15  // "BBSꗗ擾"
#define MULTIBTN_FEATURE_USEBBS     16  // "gpBBSI"
#define MULTIBTN_FEATURE_COPYGIKO   17  // "QƐpCOPY"
#define MULTIBTN_FEATURE_DELNOTGET  18  // "擾ꗗ폜"
#define MULTIBTN_FEATURE_DBCOPY     19  // "DBVFSCOPY"
#define MULTIBTN_FEATURE_GRAPHMODE  20  // "`惂[hύX"
#define MULTIBTN_FEATURE_ROTATE     21  // "ʂ̉](HE)"
#define MULTIBTN_FEATURE_FONT       22  // "tHgύX"
#define MULTIBTN_FEATURE_NETWORK    23  // "Networkݒ"
#define MULTIBTN_FEATURE_SELMENU    24  // "Ij["
#define MULTIBTN_FEATURE_DISCONN    25  // "ؒf"
#define MULTIBTN_FEATURE_GETLIST    26  // "Xꗗ擾"
#define MULTIBTN_FEATURE_NEWARRIVAL 27  // "VmF"
#define MULTIBTN_FEATURE_NNSHSET    28  // "NNsiݒ(T)"
#define MULTIBTN_FEATURE_NNSHSET1   29  // "NNsiݒ-1"
#define MULTIBTN_FEATURE_NNSHSET2   30  // "NNsiݒ-2"
#define MULTIBTN_FEATURE_NNSHSET3   31  // "NNsiݒ-3"
#define MULTIBTN_FEATURE_NNSHSET4   32  // "NNsiݒ-4"
#define MULTIBTN_FEATURE_NNSHSET5   33  // "NNsiݒ-5"
#define MULTIBTN_FEATURE_NNSHSET6   34  // "NNsiݒ-6"
#define MULTIBTN_FEATURE_NNSHSET7   35  // "NNsiݒ-7"
#define MULTIBTN_FEATURE_NNSHSET8   36  // "NNsiݒ-8"
#define MULTIBTN_FEATURE_NNSHSET9   37  // "NNsiݒ-9"
#define MULTIBTN_FEATURE_VERSION    38  // "o[W"
#define MULTIBTN_FEATURE_SELECTNEXT 39  // "P"
#define MULTIBTN_FEATURE_SELECTPREV 40  // "P"
#define MULTIBTN_FEATURE_PREVPAGE   41  // "Oy[W"
#define MULTIBTN_FEATURE_NEXTPAGE   42  // "y[W"
#define MULTIBTN_FEATURE_NNSIEND    43  // "NNsiI"
#define MULTIBTN_FEATURE_NGWORD1    44  // "NG1ݒ"
#define MULTIBTN_FEATURE_NGWORD2    45  // "NG2ݒ"
#define MULTIBTN_FEATURE_USER1TAB   46  // "[U1^u"
#define MULTIBTN_FEATURE_USER2TAB   47  // "[U2^u"
#define MULTIBTN_FEATURE_DEVICEINFO 48  // "foCX"
#define MULTIBTN_FEATURE_GOTODUMMY  49  // "_~[ʂ"
#define MULTIBTN_FEATURE_NEWTHREAD  50  // "X"
#define MULTIBTN_FEATURE_USER3TAB   51  // "[U3^u"
#define MULTIBTN_FEATURE_USER4TAB   52  // "[U4^u"
#define MULTIBTN_FEATURE_USER5TAB   53  // "[U5^u"
#define MULTIBTN_FEATURE_DIRSELECT  54  // "DirI"
#define MULTIBTN_FEATURE_TABINFO    55  // "^u"
#define MULTIBTN_FEATURE_MOVELOGLOC 56  // "OǗύX"
#define MULTIBTN_FEATURE_MOVELOGDIR 57  // "DirύX"
#define MULTIBTN_FEATURE_TO_NOTREAD 58  // "'ǂ'"
#define MULTIBTN_FEATURE_TO_GETALL  59  // "'擾ςݑS'"
#define MULTIBTN_FEATURE_LOGCHARGE  60  // "QƐpO擾"
#define MULTIBTN_FEATURE_OPENURL    61  // "URL擾"
#define MULTIBTN_FEATURE_SETNGWORD3 62  // "NG-3ݒ"
#define MULTIBTN_FEATURE_SETLOGCHRG 63  // "QƃO擾ݒ"  

#define HARDKEY_FEATURE_MASK         0x00ff
#define HARDKEY_FEATURE              0x0000

// n[hL[̐ݒ
#define HARDKEY_FEATURE_DONOTHING    0  // NNsiŐ䂵Ȃ
#define HARDKEY_FEATURE_CONTROLNNSI  1  // NNsiŐ䂷
#define HARDKEY_FEATURE_TRANSJOGPUSH 2  // JOG PUSHƓɂ
#define HARDKEY_FEATURE_TRANSJOGBACK 3  // JOG BACKƓɂ

#define NNSH_BLOCKDISP_NOFMSG        5

#define NNSH_VFSDB_SETTING           0
#define NNSH_VFSDB_SUBJECT           1
#define NNSH_VFSDB_BBSLIST           2

#define NNSH_CONDITION_AND           0x0000  // AND
#define NNSH_CONDITION_OR            0x0001  // OR
#define NNSH_CONDITION_ALL           0x0003  // (S)

#define NNSH_CONDITION_NOTREADONLY   0x0004  // QƐpO͏O(rbg)

#define NNSH_CONDITION_LOGLOC_ALL    0x0018  // 
#define NNSH_CONDITION_LOGLOC_PALM   0x0008  // PalmO
#define NNSH_CONDITION_LOGLOC_VFS    0x0010  // VFSO

#define NNSH_CONDITION_GETERR_ALL    0x0060  // 
#define NNSH_CONDITION_GETERR_NONE   0x0020  //  G[Ȃ
#define NNSH_CONDITION_GETERR_ERROR  0x0040  //  擾G[

#define NNSH_CONDITION_GETRSV_ALL    0x0180  // 
#define NNSH_CONDITION_GETRSV_RSV    0x0080  //  ۗX
#define NNSH_CONDITION_GETRSV_NONE   0x0100  //  ۗX

#define NNSH_THREADLEVEL_MASK        0x00ff  // Xx}XN
#define NNSH_THREADCOND_MASK         0x7f00  // Xԃ}XN
#define NNSH_THREADCOND_SHIFT        8       // Xԃ}XN

#define NNSH_THREADLEVEL_UPPER       0       // Xx hȏh
#define NNSH_THREADLEVEL_LOWER       1       // Xx hȉh
#define NNSH_THREADLEVEL_ELSE        2       // Xx hȊOh
#define NNSH_THREADLEVEL_MATCH       3       // Xx hh

#define NNSH_BOARD_MATCH             0       // ݒ hh
#define NNSH_BOARD_ELSE              1       // ݒ hȊOh

// dX̃`FbN@
#define NNSH_DUP_CHECK_HIGH          1       // g
#define NNSH_DUP_CHECK_SLOW          2       // ͎gȂᑬ
#define NNSH_DUP_NOCHECK             3       // d`FbNsȂ

#define NNSH_STRING_SELECTION        0x0100  // 
#define NNSH_STRING_SETMASK          0x00ff  // 
#define NNSH_STRING_OR               0x0001  // 
#define NNSH_STRING_CUSTOM2_DEFAULT1 "Palm"
#define NNSH_STRING_CUSTOM2_DEFAULT2 "palm"
#define NNSH_STRING_CUSTOM2_DEFAULT3 "CLIE"

#define NNSH_LEVEL_ERROR            0x0000
#define NNSH_LEVEL_WARN             0x0001
#define NNSH_LEVEL_INFO             0x0002
#define NNSH_LEVEL_CONFIRM          0x0004
#define NNSH_LEVEL_DEBUG            0x0010

#define NNSH_TITLE_HARDKEYSET_TITLE  "ꗗʃn[hL[ݒ"
#define NNSH_HARDKEYCONTROL_TITLE    "n[hL[ݒ"
#define NNSH_TITLE_HARDKEYVIEW_TITLE "QƉʃn[hL[ݒ"

#define MULTIVIEWBTN_FEATURE_MASK    0x00ff
#define MULTIVIEWBTN_FEATURE         0x7300

#define UPBTN_VIEWFEATURE_DEFAULT    MULTIVIEWBTN_FEATURE_PAGEUP
#define DOWNBTN_VIEWFEATURE_DEFAULT  MULTIVIEWBTN_FEATURE_PAGEDOWN

#define JOGPUSH_VIEWFEATURE_DEFAULT  MULTIVIEWBTN_FEATURE_GETPART
#define JOGBACK_VIEWFEATURE_DEFAULT  MULTIVIEWBTN_FEATURE_BACKTOLIST
#define CAPTURE_VIEWFEATURE_DEFAULT  MULTIVIEWBTN_FEATURE_INFO

#define NNSH_DEFAULT_VIEW_LVLBTNFEATURE MULTIVIEWBTN_FEATURE_INFO


// QƉʂ̋@\ݒi@\ԍj
//    ݒp^CǵA\[XŒ`(ƓĂKv)
#define MULTIVIEWBTN_FEATURE_INFO        0  // "X"
#define MULTIVIEWBTN_FEATURE_BACKTOLIST  1  // "ꗗʂ"
#define MULTIVIEWBTN_FEATURE_WRITE       2  // ""
#define MULTIVIEWBTN_FEATURE_GETPART     3  // "擾"
#define MULTIVIEWBTN_FEATURE_GETMESNUM   4  // "XԎw擾"
#define MULTIVIEWBTN_FEATURE_GOTOTOP     5  // "擪MSG"
#define MULTIVIEWBTN_FEATURE_PREVIOUS    6  // "OMSG"
#define MULTIVIEWBTN_FEATURE_PAGEUP      7  // "OXN["
#define MULTIVIEWBTN_FEATURE_PAGEDOWN    8  // "XN["
#define MULTIVIEWBTN_FEATURE_NEXT        9  // "MSG"
#define MULTIVIEWBTN_FEATURE_GOTOBOTTOM 10  // "MSG"
#define MULTIVIEWBTN_FEATURE_JUMP       11  // "Go"
#define MULTIVIEWBTN_FEATURE_RETURN     12  // "P߂"
#define MULTIVIEWBTN_FEATURE_COPY       13  // "Rs["
#define MULTIVIEWBTN_FEATURE_SELECTALL  14  // "񂷂ׂđI"
#define MULTIVIEWBTN_FEATURE_OPENWEB    15  // "Web"
#define MULTIVIEWBTN_FEATURE_SELANDWEB  16  // "I+Web"
#define MULTIVIEWBTN_FEATURE_OUTPUTMEMO 17  // "o"
#define MULTIVIEWBTN_FEATURE_SEARCH     18  // ""
#define MULTIVIEWBTN_FEATURE_SEARCHNEXT 19  // ""
#define MULTIVIEWBTN_FEATURE_SEARCHPREV 20  // "O"
#define MULTIVIEWBTN_FEATURE_SEARCHTOP  21  // "擪猟"
#define MULTIVIEWBTN_FEATURE_SEARCHBTM  22  // "猟"
#define MULTIVIEWBTN_FEATURE_CHANGEFONT 23  // "tHgύX"
#define MULTIVIEWBTN_FEATURE_DRAWMODE   24  // "`惂[hύX"
#define MULTIVIEWBTN_FEATURE_ROTATE     25  // "ʂ̉](HE)"
#define MULTIVIEWBTN_FEATURE_DISCONNECT 26  // "ؒf"
#define MULTIVIEWBTN_FEATURE_SETNETWORK 27  // "Networkݒ"
#define MULTIVIEWBTN_FEATURE_BOOKMARK   28  // "ݒ"
#define MULTIVIEWBTN_FEATURE_DEVICEINFO 29  // "foCX"
#define MULTIVIEWBTN_FEATURE_PAGEDOWN10 30  // "10X"
#define MULTIVIEWBTN_FEATURE_PAGEUP10   31  // "10XO"
#define MULTIVIEWBTN_FEATURE_GOTODUMMY  32  // "_~[ʂ"
#define MULTIVIEWBTN_FEATURE_OPENURL    33  // "NJ"
#define MULTIVIEWBTN_FEATURE_EXECA2DA   34  // "A2DAN"

// Notify̍XV
#define NNSH_VFS_UNMOUNTED              100
#define NNSH_VFS_UNMOUNTED_WRITE        101
#define NNSH_VFS_UNMOUNTED_MESSAGE      102
#define NNSH_VFS_UNMOUNTED_OTHER        103
#define NNSH_VFS_MOUNTED                110

// NG`FbNgpEȂ
#define NNSH_USE_NGWORD1AND2            0x01
#define NNSH_USE_NGWORD3                0x10

// a2DAƂ̘Ag@\p`
#define A2DA_NNSIEXT_AADATASTART  "<NNsi:NNsiExt type=\"AA\">"
#define A2DA_NNSIEXT_ENDDATA      "</NNsi:NNsiExt>"
#define A2DA_NNSIEXT_SRC_STREAM   "<NNsi:Source>stream</NNsi:Source>"
#define A2DA_NNSIEXT_DATANAME     "<NNsi:Name>"
#define A2DA_NNSIEXT_ENDDATANAME  "</NNsi:Name>"
#define A2DA_NNSIEXT_NNSICREATOR  "<NNsi:Creator>NNsi</NNsi:Creator>"

#if 0
#define  ICMP_ECHOREPLY       0
#define  ICMP_DEST_UNREACH    3
#define  ICMP_SOURCE_QUENCH   4
#define  ICMP_REDIRECT        5
#define  ICMP_ECHO            8
#define  ICMP_TIME_EXCEEDED  11
#define  ICMP_PARAMETERPROB  12
#define  ICMP_TIMESTAMP      13
#define  ICMP_TIMESTAMPREPLY 14
#define  ICMP_INFO_REQUEST   15
#define  ICMP_INFO_REPLY     16
#define  ICMP_MASKREQ        17
#define  ICMP_MASKREPLY      18
 
#define  ICMP_NET_UNREACH     0
#define  ICMP_HOST_UNREACH    1
#define  ICMP_PROT_UNREACH    2
#define  ICMP_PORT_UNREACH    3
#define  ICMP_FRAG_NEEDED     4
#define  ICMP_SR_FAILED       5
#define  ICMP_NET_UNKNOWN     6
#define  ICMP_HOST_UNKNOWN    7
#define  ICMP_HOST_ISOLATED   8
#define  ICMP_NET_UNR_TOS    11
#define  ICMP_HOST_UNR_TOS   12
#define  ICMP_PKT_FILTERED   13
#define  ICMP_PREC_VIOLATION 14
#define  ICMP_PREC_CUTOFF    15
#endif
