/*============================================================================*
 *  FILE: 
 *     opcode.c
 *
 *  Description: 
 *     IyR[h̓_CAO
 *
 *===========================================================================*/
#define OPCODE_C

#include "local.h"



typedef struct
{
   UInt16  opCode;
   Boolean showDst;
   Boolean showSrc;
   UInt16  listID;
   Boolean showNumeric;
   Boolean showString;
} OpCodeShowTbl;

OpCodeShowTbl NNsiMacroOpTbl[] = 
{
  {  NNSH_MACROCMD_MACROEND,  false, false, 0, false, false },
  {  NNSH_MACROCMD_MOVE,      true,  true,  0, true,  false },
  {  NNSH_MACROCMD_ADD,       true,  true,  0, true,  false },
  {  NNSH_MACROCMD_SUB,       true,  true,  0, true,  false },
  {  NNSH_MACROCMD_AND,       true,  true,  0, true,  false },
  {  NNSH_MACROCMD_OR,        true,  true,  0, true,  false },
  {  NNSH_MACROCMD_XOR,       true,  true,  0, true,  false },
  {  NNSH_MACROCMD_MESSAGE,   false, true,  0, false, true  },
  {  NNSH_MACROCMD_EXECUTE,   false, false, MULTIBTN_FEATUREMSG_STRINGS, false, false },
  {  NNSH_MACROCMD_CMP,       true,  true,  0, true,  false },
  {  NNSH_MACROCMD_JMP,       false, true,  0, true,  false },
  {  NNSH_MACROCMD_JZ,        true,  true,  0, true,  false },
  {  NNSH_MACROCMD_JNZ,       true,  true,  0, true,  false },
  {  NNSH_MACROCMD_BEEP,      false, true,  0, true,  true  },
  {  NNSH_MACROCMD_BBSTYPE,   true,  false, 0, false, false },
  {  NNSH_MACROCMD_STRSTR,    true,  false, 0, false, true  },
  {  NNSH_MACROCMD_STRCMP,    true,  false, 0, false, true  },
  {  NNSH_MACROCMD_SETTABNUM, true,  false, 0, false, false },
  {  NNSH_MACROCMD_GETMESNUM, true,  false, 0, false, false },
  {  NNSH_MACROCMD_MESSTATUS, true,  false, 0, false, false },
  {  NNSH_MACROCMD_IMPORT,    false, false, 0, false, false },
  {  NNSH_MACROCMD_EXPORT,    false, false, 0, false, false },
  {  NNSH_MACROCMD_OPERATE,   true,  true,  FEATURE_NNSISETTING_STRINGS, true,   false },
  {  NNSH_MACROCMD_STATUS,    true,  false, FEATURE_NNSISETTING_STRINGS, false,  false },
  {  NNSH_MACROCMD_LAUNCHDA,  false, false, 0, false, true  },
  {  NNSH_MACROCMD_CLIPCOPY,  false, false, 0, false, true  },
  {  NNSH_MACROCMD_CLIPADD,   false, false, 0, false, true  },
  {  NNSH_MACROCMD_CLIPINSTR, true,  false, 0, false, true  },
  {  NNSH_MACROCMD_TITLECLIP, false, false, 0, false, false },
  {  NNSH_MACROCMD_SET_FINDBBSSTR, false, false, 0, false, false },
  {  NNSH_MACROCMD_SET_FINDTHREADSTR, false, false, 0, false, false },
  {  NNSH_MACROCMD_UPDATE_RESNUM, true, false, 0, false, false },
  {  NNSH_MACROCMD_JPL,       true,  true,  0, true,  false },
  {  NNSH_MACROCMD_JMI,       true,  true,  0, true,  false },
  {  NNSH_MACROCMD_OUTPUTTITLE, false, false, 0, false, false },
  {  NNSH_MACROCMD_OUTPUTCLIP, false, false, 0, false, false },
  {  NNSH_MACROCMD_REMARK,     false, false, 0, false, true },
  {  NNSH_MACROCMD_PUSH,       false, true,  0, true,  false }, 
  {  NNSH_MACROCMD_POP,        true,  false, 0, false,  false },
  {  NNSH_MACROCMD_GETRECNUM,  true,  false, 0, false, false },
  {  NNSH_MACROCMD_FINDTHREADSTRCOPY, false, false, 0, false, false },
  {  NNSH_MACROCMD_INPUTDIALOG,   false, false, 0, false, true },
  {  NNSH_MACROCMD_OUTPUTDIALOG,  false, false, 0, false, true },
  {  NNSH_MACROCMD_CONFIRMDIALOG, true,  false, 0, false, false },
  {  NNSH_MACROCMD_MESATTRIBUTE,  true,  false, 0, false, false },
  {  NNSH_MACROCMD_JUMPLAST,      false, true,  0, true,  false },
  {  0xffff, false, false, 0, false, false }
};

/*=========================================================================*/
/*   Function :  convertFromNNsiSetString                                  */
/*                                XgԍNNsiݒ擾̃f[^ɕϊ */
/*=========================================================================*/
static UInt16 convertFromNNsiSetString(UInt16 item)
{
    UInt16 num;

    switch (item)
    {
      case 0:
        num = NNSH_MACROOPCMD_DISABLE;
        break;

      case 1:
        num = NNSH_MACROOPCMD_AUTOSTARTMACRO;
        break;

      case 2:
        num = NNSH_MACROOPCMD_NEWARRIVAL_LINE;
        break;
   
      case 3:
        num = NNSH_MACROOPCMD_NEWARRIVAL_DA;
        break;   

      case 4:
        num = NNSH_MACROOPCMD_NEWARRIVAL_ROLOG; 
        break;   

      case 5:
        num = NNSH_MACROOPCMD_NEWARRIVAL_BEEP;
        break;

      case 6:
        num = NNSH_MACROOPCMD_COPY_AND_DELETE;
        break;  

      default:
        num = 0;
        break;
    }
    return (num);
}

/*=========================================================================*/
/*   Function :  convertNNsiSetString                                      */
/*                                  NNsiݒ擾̃f[^Xgԍɕϊ */
/*=========================================================================*/
static UInt16 convertNNsiSetString(UInt16 item)
{
    UInt16 num;

    switch (item)
    {
      case NNSH_MACROOPCMD_DISABLE:
        num = 0; 
        break;   

      case NNSH_MACROOPCMD_AUTOSTARTMACRO:
        num = 1; 
        break;   

      case NNSH_MACROOPCMD_NEWARRIVAL_LINE:
        num = 2; 
        break;
   
      case NNSH_MACROOPCMD_NEWARRIVAL_DA:
        num = 3; 
        break;   

      case NNSH_MACROOPCMD_NEWARRIVAL_ROLOG:
        num = 4; 
        break;   

      case NNSH_MACROOPCMD_NEWARRIVAL_BEEP:
        num = 5; 
        break;   

      case NNSH_MACROOPCMD_COPY_AND_DELETE:
        num = 6; 
        break;   

      default:
        num = 0; 
        break;   
    }
    return (num);
}

/*=========================================================================*/
/*   Function :   showHideRegister                                         */
/*                                                      WX^ԍݒ */
/*=========================================================================*/
static void showHideRegister(FormType *frm, Boolean disp, UInt16 regNum, UInt16 lblId, UInt16 popId, UInt16 lstId)
{
    UInt16 objIndex;

    if (disp == true)
    {
        objIndex = FrmGetObjectIndex(frm, popId);
        FrmShowObject(frm, objIndex);

        objIndex = FrmGetObjectIndex(frm, lblId);
        FrmShowObject(frm, objIndex);

        // WX^ԍÓmF
        if ((regNum >= NNSH_MACROOP_GR_OFFSET)&&(regNum <= NNSH_MACROOP_GR_MAX))
        {
            regNum = regNum - NNSH_MACROOP_GR_OFFSET + 1;
        }
        else
        {
            regNum = 0;
        }    
        NNshWinSetPopItems(frm, popId, lstId, regNum);
    }
    else
    {
        // WX^ԍ\Ȃ
        objIndex = FrmGetObjectIndex(frm, popId);
        FrmHideObject(frm, objIndex);

        objIndex = FrmGetObjectIndex(frm, lblId);
        FrmHideObject(frm, objIndex);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   createFeatureListStrings                                 */
/*                              XgO\[XꗗXg𐶐 */
/*-------------------------------------------------------------------------*/
static Err createFeatureListStrings(NNshWordList **lst, UInt16 strRscId)
{
    Err        ret;
    MemHandle  memH;
    Char      *ptr;

    // @\ꗗXg쐬ς݂Ȃ瑦
    if (*lst != NULL)
    {
        return (errNone);
    }

    // @\ꗗXg̊Ǘ̈mۂ
    *lst = MemPtrNew(sizeof(NNshWordList));
    if (*lst == NULL)
    {
        // ̈mۂɎs
        return (errNone);
    }
    MemSet(*lst, sizeof(NNshWordList), 0x00);

    // ꗗ@\Xg̎擾iXgO\[X擾j
    memH = DmGetResource('tSTR', strRscId);
    if (memH == 0)
    {
        return (~errNone);
    }
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        return (~errNone);
    }

    // XgO\[XXg`ɕ
    ret = SeparateWordList(ptr, *lst);
    if (ret != errNone)
    {
        // ̕ɎsAǗ̈JB
        MEMFREE_PTR(*lst);
    }
    MemHandleUnlock(memH);
    DmReleaseResource(memH);
    return (ret);
}
/*=========================================================================*/
/*   Function :   ControlOpSetDataItem                                     */
/*                                        OPR[hpœ͉\f[^ݒ */
/*=========================================================================*/
static void ControlOpSetDataItem(FormType *frm, OpCodeShowTbl *item, NNshMacroRecord *dataRec)
{
    ListType *lstP;
    Int32     num;
    UInt16    data;
    Char      bufNum[MINIBUF + MARGIN];
    
    // dstWX^
    if (item->showDst == true)
    {
        lstP   = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, LSTID_DESTINATION));
        dataRec->dst = LstGetSelection(lstP);
        if (dataRec->dst != 0)
        {
            dataRec->dst = dataRec->dst + NNSH_MACROOP_GR_OFFSET - 1;
        }
    }

    // srcWX^
    if (item->showSrc == true)
    {
        lstP   = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, LSTID_SOURCE));
        dataRec->src = LstGetSelection(lstP);
        if (dataRec->src != 0)
        {
            dataRec->src = dataRec->src + NNSH_MACROOP_GR_OFFSET - 1;
        }
    }

    // lݒ
    MemSet(bufNum, sizeof(bufNum), 0x00);
    NNshWinGetFieldText(frm, FLDID_VALUEFIELD, bufNum, MINIBUF);
    num = StrAToI(bufNum);
    dataRec->MacroData.numData.operator = num;
    
    // ݒ
    MemSet(bufNum, sizeof(bufNum), 0x00);
    NNshWinGetFieldText(frm, FLDID_INPUTFIELD, bufNum, MINIBUF);
    StrNCopy(dataRec->MacroData.strData.data, bufNum, MAX_STRLEN);

    // DA̐ݒ擾
    if (item->opCode == NNSH_MACROCMD_LAUNCHDA)
    {
        dataRec->MacroData.strData.data[2] = bufNum[0];
        dataRec->MacroData.strData.data[3] = bufNum[1];
        dataRec->MacroData.strData.data[4] = bufNum[2];
        dataRec->MacroData.strData.data[5] = bufNum[3];
    }

    // 
    switch (item->listID)
    {
      case FEATURE_NNSISETTING_STRINGS:
        lstP   = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, LSTID_OPEFUNC));
        data   = LstGetSelection(lstP);
        dataRec->MacroData.numData.subCommand = convertFromNNsiSetString(data);
        break;

      case MULTIBTN_FEATUREMSG_STRINGS:
        lstP   = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, LSTID_OPEFUNC));
        data   = LstGetSelection(lstP);
        dataRec->MacroData.numData.operator = data;
        break;

      case 0:
      default:
        // Ȃ
        break;
    }

    return;
}

/*=========================================================================*/
/*   Function :   ControlOpDataItem                                        */
/*                                        OPR[hpœ͉\f[^ݒ */
/*=========================================================================*/
static void ControlOpDataItem(FormType *frm, OpCodeShowTbl *item, NNshMacroRecord *dataRec)
{
    UInt16 objIndex, selection;
    Char   bufNum[MINIBUF + MARGIN];

    showHideRegister(frm, item->showDst, dataRec->dst, LABEL_DESTINATION, POPTRID_DESTINATION, LSTID_DESTINATION);
    showHideRegister(frm, item->showSrc, dataRec->src, LABEL_SOURCE,      POPTRID_SOURCE,      LSTID_SOURCE);

    if (NNshGlobal->featureList != NULL)
    {
        // @\ݒ胊Xgɒ`Ăꍇ͂̈
        ReleaseWordList(NNshGlobal->featureList);
        MEMFREE_PTR(NNshGlobal->featureList);
        NNshGlobal->featureList = NULL;
    }

    if (item->showNumeric == true)
    {
        objIndex = FrmGetObjectIndex(frm, LABEL_VARIABLE_VALUE);
        FrmShowObject(frm, objIndex);

        objIndex = FrmGetObjectIndex(frm, FLDID_VALUEFIELD);
        FrmShowObject(frm, objIndex);

        // l
        MemSet (bufNum, sizeof(bufNum), 0x00);
        NUMCATI(bufNum, dataRec->MacroData.numData.operator);
        
        NNshWinSetFieldText(frm, FLDID_VALUEFIELD, false, bufNum, (StrLen(bufNum) + MARGIN));
    }
    else
    {
        // l͂Ȃ
        objIndex = FrmGetObjectIndex(frm, LABEL_VARIABLE_VALUE);
        FrmHideObject(frm, objIndex);

        objIndex = FrmGetObjectIndex(frm, FLDID_VALUEFIELD);
        FrmHideObject(frm, objIndex);
    }
    
    if (item->showString == true)
    {
        objIndex = FrmGetObjectIndex(frm, LABEL_VARIABLE_STRING);
        FrmShowObject(frm, objIndex);

        objIndex = FrmGetObjectIndex(frm, FLDID_INPUTFIELD);
        FrmShowObject(frm, objIndex);

        // \
        if (item->opCode == NNSH_MACROCMD_LAUNCHDA)
        {
            // DÃNG[^IDݒ
            NNshWinSetFieldText(frm, FLDID_INPUTFIELD, false, 
                                &dataRec->MacroData.strData.data[2],
                                (MAX_STRLEN + MARGIN));
        }
        else
        {
            NNshWinSetFieldText(frm, FLDID_INPUTFIELD, false, 
                            dataRec->MacroData.strData.data, (MAX_STRLEN + MARGIN));
        }
    }
    else
    {
        // ͂Ȃ
        objIndex = FrmGetObjectIndex(frm, LABEL_VARIABLE_STRING);
        FrmHideObject(frm, objIndex);

        objIndex = FrmGetObjectIndex(frm, FLDID_INPUTFIELD);
        FrmHideObject(frm, objIndex);
    }

    if ((item->showNumeric == false)&&(item->showString == false))
    {
        // lwłȂꍇAx
        objIndex = FrmGetObjectIndex(frm, LABEL_VARIABLE_SET);
        FrmHideObject(frm, objIndex);
    }
    else
    {
        objIndex = FrmGetObjectIndex(frm, LABEL_VARIABLE_SET);
        FrmShowObject(frm, objIndex);
    }

    selection = dataRec->MacroData.numData.operator;
    switch (item->listID)
    {
      case FEATURE_NNSISETTING_STRINGS:
        selection = convertNNsiSetString(dataRec->MacroData.numData.subCommand);
        // not break!!

      case MULTIBTN_FEATUREMSG_STRINGS:
        objIndex = FrmGetObjectIndex(frm, LABEL_OPEFUNC);
        FrmShowObject(frm, objIndex);

        objIndex = FrmGetObjectIndex(frm, POPTRID_OPEFUNC);
        FrmShowObject(frm, objIndex);

        // @\ݒ胊Xg`
        createFeatureListStrings(&(NNshGlobal->featureList), item->listID);
        if (NNshGlobal->featureList != NULL)
        {
            NNshWinSetPopItemsWithList(frm, POPTRID_OPEFUNC, LSTID_OPEFUNC,
                                       NNshGlobal->featureList, selection);
        }
        break;

      case 0:
      default:
        // 샊Xg\Ȃ
        objIndex = FrmGetObjectIndex(frm, LABEL_OPEFUNC);
        FrmHideObject(frm, objIndex);

        objIndex = FrmGetObjectIndex(frm, POPTRID_OPEFUNC);
        FrmHideObject(frm, objIndex);
        break;
    }

    return;
}

/*=========================================================================*/
/*   Function : prepareOpCodeDialog                                        */
/*                                                 tH[Ƀf[^𔽉f  */
/*=========================================================================*/
void prepareOpCodeDialog(FormType *frm, NNshMacroRecord *dataRec, UInt16 opCode)
{
    OpCodeShowTbl *dataPtr;

    // ߂ɂāAʂɕ\ACeύX
    dataPtr = NNsiMacroOpTbl;
    while (dataPtr->opCode != 0xffff)
    {
        if (dataPtr->opCode == opCode)
        {
            ControlOpDataItem(frm, dataPtr, dataRec);
            return;
        }
        dataPtr++;
    }
    return;
}

/*=========================================================================*/
/*   Function :   Handler_opCodeAction                                     */
/*                                            OPR[hp̃Cxgnh */
/*=========================================================================*/
Boolean Handler_opCodeAction(EventType *event)
{
    FormType        *frm;
    NNshMacroRecord *dataRec;

    switch (event->eType)
    { 
      case menuEvent:
        // j[I
        break;

      case ctlSelectEvent:
        // {^ꂽ
        break;

      case ctlRepeatEvent:
        // {^ꂽ
        break;

      case keyDownEvent:
        // keyꂽ
        break;

      case popSelectEvent:
        // |bvAbvgK[Iꂽ
        if (event->data.popSelect.listID == LSTID_OP_CODE)
        {
            frm = FrmGetActiveForm();
            dataRec = NNshGlobal->dataRec;
            prepareOpCodeDialog(frm, dataRec, event->data.popSelect.selection);
            return (false);
        }
        break;

      case lstSelectEvent:
        break;

      case lstEnterEvent:
        break;

      default: 
        return (false);
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function : effectOpCodeData                                           */
/*                                                tH[f[^擾 */
/*=========================================================================*/
void effectOpCodeData(FormType *frm, NNshMacroRecord *dataRec)
{
    UInt16         opCode;
    ListType      *lstP;
    OpCodeShowTbl *dataPtr;

    // OPR[h擾
    lstP   = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, LSTID_OP_CODE));
    opCode = LstGetSelection(lstP);


    // ߂ɂāAʂɕ\ĂACe肷
    dataPtr = NNsiMacroOpTbl;
    while (dataPtr->opCode != 0xffff)
    {
        if (dataPtr->opCode == opCode)
        {
            MemSet(dataRec, sizeof(NNshMacroRecord), 0x00);
            dataRec->opCode = opCode;
            ControlOpSetDataItem(frm, dataPtr, dataRec);
            return;
        }
        dataPtr++;
    }
    return;
}


/*=========================================================================*/
/*   Function : OpCodeInputDialog                                          */
/*                                                sf[^̓_CAO */
/*=========================================================================*/
Boolean OpCodeInputDialog(UInt16 lineNum, NNshMacroRecord *dataRec)
{
    Boolean       ret = false;
    UInt16        btnId;
    FormType     *prevFrm, *diagFrm;
    Char         *lineData, title[MINIBUF + MARGIN];

    // \s̃f[^H
    MemSet(title, sizeof(title), 0x00);
    lineData = MemPtrNew(BUFSIZE + MARGIN);
    if (lineData == NULL)
    {
        return (false);
    }
    MemSet(lineData, (BUFSIZE + MARGIN), 0x00);
    PrintMacroLine(lineData, BUFSIZE, lineNum, dataRec);

    // ^Cg̐ݒ
    StrCat(title, "Edit line No.");
    NUMCATI(title, lineNum);

    // ҏWΏۃf[^O[öɒu
    NNshGlobal->dataRec = dataRec;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // PalmOS v3.5ȉȂAÕtH[B
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        FrmEraseForm(prevFrm);
    }

    // _CAOtH[ANeBuɂ
    diagFrm  = FrmInitForm(FRMID_OPCODEINPUT);
    if (diagFrm == NULL)
    {
        return (false);
    }
    FrmSetActiveForm(diagFrm);

    // C̏\
    NNshWinSetFieldText(diagFrm, FLDID_OPECODE, false, lineData, BUFSIZE);

    // ߂|bvAbvgK[ACeɔf
    NNshWinSetPopItems(diagFrm, POPTRID_OP_CODE, LSTID_OP_CODE, dataRec->opCode);

    // f[^̉ʕ\ݒ
    prepareOpCodeDialog(diagFrm, dataRec, dataRec->opCode);

    // VN\ő剻
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        VgaFormModify(diagFrm, vgaFormModify160To240);
        SilkMaximizeWindow();
    }
    else
#endif // #ifdef USE_HANDERA
    {
        NNshSilkMaximize(diagFrm);
    }
    HandEraMoveDialog(diagFrm);

    // ^CgRs[
    FrmCopyTitle(diagFrm, title);

    FrmSetEventHandler(diagFrm, Handler_opCodeAction);

    btnId = FrmDoDialog(diagFrm);
    if (btnId == BTNID_VIEW_OK)
    {
        // OK{^ꂽƂɂ́Af[^𔽉f
        effectOpCodeData(diagFrm, dataRec);
        ret = true;
    }
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(diagFrm);

    // VN\ŏ
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        SilkMinimizeWindow();
    }
    else
#endif // #ifdef USE_HANDERA
    {
        NNshSilkMinimize(prevFrm);
    }

    MemPtrFree(lineData);
    return (ret);
}
