/*============================================================================*
 *  FILE: 
 *     modifylog.c
 *
 *  Description: 
 *     QƃÕO擾H
 *===========================================================================*/
#define MODIFYLOG_C
#include "local.h"

#ifdef USE_LOGCHARGE

/*--------------------------------------------------------------------------*/
/*   launch_viewJPEG() : JPEGt@C̉{(DAN̗\...)            */
/*                                      fileLoc  : t@Ĉ肩         */
/*                                          FILEMGR_STATE_OPENED_STREAM     */
/*                                          FILEMGR_STATE_OPENED_VFS        */
/*                                      fileName : t@C(full-path)    */
/*--------------------------------------------------------------------------*/
static void launch_viewJPEG(UInt16 fileLoc, Char *fileName)
{
    Char   fileType, *cmdMsg;

    NNsh_DebugMessage(ALTID_INFO, "OPEN JPEG : ", fileName, fileLoc);

    // nnDACXg[Ă邩mF
    if (CheckInstalledResource_NNsh('DAcc','nnDA') == false)
    {
        // nnDACXg[AI
        return;
    }

    if (fileLoc == FILEMGR_STATE_OPENED_VFS)
    {
        // "VFS̓RpNgtbVgp"ݒ̏ꍇAAA
        switch ((NNshGlobal->NNsiParam)->vfsUseCompactFlash)
        {
          case NNSH_VFS_USEMEDIA_CF:             
            fileType = 'c';
            break;

          case NNSH_VFS_USEMEDIA_MS: 
            fileType = 'm';
            break;

          case NNSH_VFS_USEMEDIA_SD:
            fileType = 's';             
            break;

          case NNSH_VFS_USEMEDIA_SM:
            fileType = 't';
            break;
                
          case NNSH_VFS_USEMEDIA_RD:             
            fileType = 'r';
            break;

          case NNSH_VFS_USEMEDIA_DoC:
            fileType = 'd';
            break;

          default:
            // w肵Ȃ
            fileType = 'v';
            break;
        }
    }
    else
    {
        fileType = 'f';
    }

    // Nbv{[hp̗̈mۂ
    cmdMsg = MEMALLOC_PTR(BIGBUF + MARGIN);
    if (cmdMsg == NULL)
    {
        return;
    }
    MemSet(cmdMsg, BIGBUF + MARGIN, 0x00);

    StrCopy(cmdMsg, nnDA_NNSIEXT_VIEWSTART);
    StrCat (cmdMsg, nnDA_NNSIEXT_INFONAME);
    StrCat (cmdMsg, nnDA_NNSIEXT_SHOWJPEG);
    cmdMsg[StrLen(cmdMsg)] = fileType;
    StrCat (cmdMsg, "NNsi:");
    StrCat (cmdMsg, fileName);
    StrCat (cmdMsg, nnDA_NNSIEXT_ENDINFONAME);
    StrCat (cmdMsg, nnDA_NNSIEXT_ENDVIEW);
    ClipboardAddItem(clipboardText, cmdMsg, StrLen(cmdMsg) + 1); 

    MEMFREE_PTR(cmdMsg);

    // nnDAN
    (void) LaunchResource_NNsh('DAcc','nnDA','code',1000);
    return;
}

/*--------------------------------------------------------------------------*/
/*  ReadOnlyLogDataPickup() : QƃÕO擾                      */
/*                                                                          */
/*                                                                          */
/*                    ̊֐̈ŁAXVf[^ : url, fileName  */
/*--------------------------------------------------------------------------*/
Err ReadOnlyLogDataPickup(Boolean isImage, NNshGetLogDatabase *dbData,
                          Char *url, Char *fileName, UInt16 recNum,
                          UInt32 recId, UInt16 depth, UInt16 number, 
                          Char *dateTime)
{
    Err                       ret;
    Boolean                   workAround, updateRecord;
    UInt16                    index, bufSize, kanjiCode, redirectCnt, titleSize, subIndex;
    UInt32                    readSize, offset, dummy, offsetW, currentTime;
    DmOpenRef                 subjRef;
    Char                      *ptr, *file, *realBuf, *chk, *dateBuf, *titlePrefix;
    NNshSubjectDatabase       *subjDb;
    NNshFileRef                fileRefR, fileRefW;
    NNshGetLogSubFileDatabase *subDbData;

    // X^Cg(Ăяo)Ŏw肳Ă邩H
    if ((depth != 0)&&(dateTime != NULL))
    {
        // X^CǵAQKwȉŎw肳Ă
        // (Kwł̕ϐdateTiméAIf-Modified-Since ̈ŗpĂ)
        // ȕϐ̗pȂ̂Œӂ邱ƁAAB
        titlePrefix = dateTime;
    }
    else
    {
        titlePrefix = NULL;
    }

    // ̈mۂ
    subIndex = NNSH_DATABASE_BLANK;
    bufSize = sizeof(NNshSubjectDatabase) + MARGIN;
    subjDb = MEMALLOC_PTR(bufSize);
    if (subjDb == NULL)
    {
        // ꎞ̈̊mۂɎs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", bufSize);
        return (~errNone);
    }
    MemSet(subjDb, sizeof(NNshSubjectDatabase) + MARGIN, 0x00);
  
    dateBuf = MEMALLOC_PTR(sizeof("If-Modified-Since: ") + MAX_GETLOG_DATETIME + MARGIN);
    if (dateBuf == NULL)
    {
        // ꎞ̈̊mۂɎs...
        MEMFREE_PTR(subjDb);
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", (sizeof("If-Modified-Since: ") + MAX_GETLOG_DATETIME + MARGIN));
        return (~errNone);
    } 
    MemSet(dateBuf, (sizeof("If-Modified-Since: ") + MAX_GETLOG_DATETIME + MARGIN), 0x00);
  
    subDbData = MEMALLOC_PTR(sizeof(NNshGetLogSubFileDatabase) + MARGIN);
    if (subDbData == NULL)
    {
        NNsh_DebugMessage(ALTID_ERROR, "MEMALLOC_PTR (subDbData) ", "", 0);
        MEMFREE_PTR(subjDb);
        MEMFREE_PTR(dateBuf);
        return (~errNone);
    }
    MemSet(subDbData, (sizeof(NNshGetLogSubFileDatabase) + MARGIN), 0x00);
  
    // w肳ꂽURL\
    NNsh_DebugMessage(ALTID_INFO, "url:", url, 0);

    // R[h
    kanjiCode = dbData->kanjiCode;

    // ꎞobt@̈m
    bufSize = (NNshGlobal->NNsiParam)->bufferSize + MARGIN;
    realBuf = MEMALLOC_PTR(bufSize);
    if (realBuf == NULL)
    {
        // ꎞ̈̊mۂɎs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", bufSize);
        MEMFREE_PTR(dateBuf);
        MEMFREE_PTR(subDbData);
        MEMFREE_PTR(subjDb);
        return (~errNone);
    }
    MemSet(realBuf, bufSize, 0x00);
    bufSize = bufSize - MARGIN;

    // Xf[^x[X̃I[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &subjRef);
    if (subjRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", " ", 0);
        MEMFREE_PTR(subjDb);
        MEMFREE_PTR(subDbData);
        MEMFREE_PTR(dateBuf);
        MEMFREE_PTR(realBuf);
        return (~errNone);
    }

    // ot@C̓ƁAXcaɏރf[^
    if (StrLen(fileName) != 0)
    {
        // Ƀt@Cw肳Ăꍇɂ́Ãt@Cgp
        //                                      (t@CXDBɊi[)
        StrNCopy(subjDb->threadFileName, fileName, MAX_THREADFILENAME);
    }
    MemSet(fileName, sizeof(fileName), 0x00);

    // OFFLINEXVFSɊi[ꍇɂ́AfBNgtB
    workAround = false;
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_USEOFFLINE) != 0)
    {
        // Ox[XfBNgt
        if ((NNshGlobal->logPrefixH == 0)||
            ((ptr = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
        {
            StrCopy(fileName, LOGDATAFILE_PREFIX);
        }
        else
        {
            StrCopy(fileName, ptr);
            MemHandleUnlock(NNshGlobal->logPrefixH);
        }
        subjDb->msgState = FILEMGR_STATE_OPENED_VFS; 

        // CLIE4pstOĂ邩`FbN
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND) != 0)
        {
            workAround = true;
        }       
    }
    else
    {
        subjDb->msgState = FILEMGR_STATE_OPENED_STREAM;        
    }
    if (StrStr(dbData->dataTitlePrefix, "%t") == NULL)
    {
        StrCopy(subjDb->threadTitle, dbData->dataTitlePrefix);
    }
    else
    {
        //  Ƃ肠APł͂ȂꍇA"%t"X^Cwb_
        // ܂܂ĂƂ́ȂO܂ł̕wb_ɓ
        chk = dbData->dataTitlePrefix;
        ptr = subjDb->threadTitle;
        while ((*chk != '\0')&&
                ((*chk != '%')||(*(chk + 1) != 't')))
        {
            *ptr = *chk;
            ptr++;
            chk++;
        }
        *ptr = '\0';
    }
    StrCopy(subjDb->boardNick, OFFLINE_THREAD_NICK);
    subjDb->state = NNSH_SUBJSTATUS_UNKNOWN;

    // ݎ擾
    currentTime = TimGetSeconds();

    // Ot@C̍\z
    file = &fileName[StrLen(fileName)];
    if (StrLen(subjDb->threadFileName) != 0)
    {
        // Ƀt@Cw肳Ăꍇ(̃t@C𗘗p)
        StrCat(fileName, subjDb->threadFileName);
    }
    else
    {
        // Ƀt@Cw肳ĂȂꍇ(IɃt@C𐶐)
        StrCat (fileName, FILE_LOGCHARGE_PREFIX);
        NUMCATI(fileName, recNum);
        StrCat (fileName, "-");
        NUMCATI(fileName, depth);
        StrCat (fileName, "-");
        NUMCATI(fileName, number);
        if ((depth != 0)&&(dbData->getAfterHours != 0))
        {
            //  depthw肳ĂꍇłAnԌĎ擾̎w肪Ă
            // ꍇAt@Cɓ16iŕt
            // (2005N11̌oߕbt)
            StrCat (fileName, "-");
            NUMCATH(fileName, (currentTime 
                           - TIME_CONVERT_1904_1970 - TIME_CONVERT_1970_2005));
        }
        StrCat (fileName, FILE_LOGCHARGE_SUFFIX);    
        StrNCopy(subjDb->threadFileName, file, MAX_THREADFILENAME);
    }

    redirectCnt = 0;

    // 擾ς݃O݂邩ǂ̃`FbN
    // (Xf[^̂cáAt@Cł̃\[gĂȂ̂œȂAAA)
    if (IsExistRecordRR_NNsh(subjRef, subjDb->threadFileName, NNSH_KEYTYPE_CHAR, 0, &index) == errNone)
    {
        // f[^ɂAf[^̍XV`FbNɐ؂ւ
        if (dbData->getDateTime[0] != '\0')
        {
            StrCopy(dateBuf, "If-Modified-Since: ");
            StrCat (dateBuf, dbData->getDateTime);
        }
        updateRecord = true;   // 擾ς݃O݂
    }
    else
    {
        // 擾ς݃O݂Ȃ
        updateRecord = false;

        // Kwł͂ȂAXVĂꍇ...
        if ((depth == 0)&&(dbData->lastUpdate != 0))
        {
            // ݎ擾
            currentTime = TimGetSeconds();
            currentTime = currentTime - dbData->lastUpdate;
            dummy       = ((UInt32) dbData->getAfterHours) * 60 * 60;
            if ((dbData->getAfterHours == MAX_GETLOG_REGETHOUR)||
                 (currentTime < dummy))
            {
                // Ď擾ԂɓBĂȂ̂ŁAXV`FbNɐ؂ւ
                if (dbData->getDateTime[0] != '\0')
                {
                    StrCopy(dateBuf, "If-Modified-Since: ");
                    StrCat (dateBuf, dbData->getDateTime);
                }
            }
        }
    }

    // uP擾vŁAuԍXVmFvw肳ĂƂ...
    if ((depth != 0)&&(dbData->getAfterHours != 0))
    {
        // w肳ꂽtqk擾ς݂ǂmF
        subIndex = GetSubFileDatabase(NNSH_GETLOGDB_CHECKURL, 0, url, subDbData);
        if (subIndex != NNSH_DATABASE_BLANK)
        {
            // w肳ꂽURL͎擾ς...
            if (subDbData->lastUpdate != 0)
            {
                currentTime = TimGetSeconds();
                currentTime = currentTime - dbData->lastUpdate;
                dummy       = ((UInt32) dbData->getAfterHours) * 60 * 60;
                if ((dbData->getAfterHours == MAX_GETLOG_REGETHOUR)||
                     (currentTime < dummy))
                {
                    // Ď擾ԂɓBĂȂAAAO擾͍sȂ
                    ret = NNSH_DATABASE_PENDING;
                    goto FUNC_END;
                }
            }
            // (Â)Ot@C...
            if (subDbData->logDbId != 0)
            {
                DeleteThreadMessage_RecordID(subDbData->logDbId);
            }
            subDbData->logDbId = 0;
        }
    }

////////  _CNgwꍇɂ́Aɖ߂ĂƂȂ  ////////
GET_URL_DATA:

    // f[^̎擾
    // zXgXꗗf[^擾
    if (dbData->wwwcMode == 1)
    {
        // ꕔ(wb_̂)擾
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET_NOTMONA, url, NULL, dateBuf,
                            HTTP_GETLOG_START, HTTP_GETLOG_LEN, NULL);
    }
    else
    {
        // ʏ擾[h
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET_NOTMONA, url, NULL, dateBuf,
                            HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
    }

    if (ret != errNone)
    {
        // (^CAEgȊO)ʐMG[
        if (ret != netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR,MSG_ERROR_HTTP_COMM, "[logCharge]", ret);
            goto FUNC_END;
        }

        // ʐM^CAEg
        NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "[logCharge]", ret);
        goto FUNC_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "logGET URL:%s [DONE]", url);
#endif // #ifdef USE_REPORTER

    // ǂݏot@C̃I[v
    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRefR);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", FILE_RECVMSG, ret);
        goto FUNC_END;
    }

    // BUSYEBhE\
    Show_BusyForm(MSG_MESSAGE_ENTRY);

    // f[^̓ǂݏo
    readSize = 0;
    MemSet(realBuf, bufSize, 0x00);
    ret  = ReadFile_NNsh(&fileRefR, 0, bufSize, realBuf, &readSize);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read Failure :", FILE_RECVMSG, ret);
        goto CLOSE_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "++++++++++HTTP MESSAGE++++++++++");
    HostTraceOutputTL(appErrorClass, "%s", realBuf);
    HostTraceOutputTL(appErrorClass, "++++++++++++++++++++++++++++++++");
#endif // #ifdef USE_REPORTER
    
    // if ((StrNCompare(realBuf,"HTTP/1.1 3", 10) == 0)||
    //     (StrNCompare(realBuf,  "HTTP/1.0 3", 10) == 0))
    if ((redirectCnt < MAX_REDIRECT_COUNT)&&(((realBuf[0] == 'H')&&
        (realBuf[1] == 'T')&&(realBuf[2] == 'T')&&
        (realBuf[3] == 'P')&&(realBuf[9] == '3'))))
    {
        // R[h(304, Not Modified)̂Ƃ...
        if ((realBuf[10] == '0')&&(realBuf[11] == '4'))
        {
            // f[^̍XV͍s킸IB
            NNsh_DebugMessage(ALTID_INFO, "HTTP/1.x 304 Not Modified :", url, 0);
            goto CLOSE_END;
        }

        // {ȂA"Location:" TׂA
        ptr = StrStr(realBuf, "http://");
        if (ptr != NULL)
        {
            // _CNgĂAAAʂURLēxf[^蒼
            Hide_BusyForm(false);
            CloseFile_NNsh(&fileRefR);
        
            chk = ptr;
            // f[^̖T
            while ((*chk != 0x0d)&&(chk < ptr + (MAX_GETLOG_URL - 1)))
            {
                chk++;
            }
            *chk = 0x00;

            // VURLRs[
            MemSet(url, MAX_GETLOG_URL, 0x00);
            StrNCopy(url, ptr, MAX_GETLOG_URL);

            redirectCnt++;

#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, "REDIRECT(%d) TO URL:%s ", redirectCnt, url);
#endif // #ifdef USE_REPORTER

            // f[^̍ēx蒼
            goto GET_URL_DATA;
        }
        
        // "Location:" TAAA
        ptr = StrStr(realBuf, "Location");
        if (ptr != NULL)
        {
            // _CNgĂAAAʂURLēxf[^蒼
            Hide_BusyForm(false);
            CloseFile_NNsh(&fileRefR);
            
            // f[^ǂݔ΂...
            ptr = ptr + sizeof("Location") - 1;
            while ((*ptr == ':')||(*ptr == ' '))
            {
                ptr++;   
            }

            chk = ptr;
            // f[^̖T
            while ((*chk != 0x0d)&&(chk < ptr + (MAX_GETLOG_URL - 1)))
            {
                chk++;
            }
            *chk = 0x00;

            // VURLRs[...AURLΎw肳ĂBB
            //   (؂ ( http://host.name/ )c悤ɂ)
            chk = StrStr(url, "://");
            if (chk != NULL)
            {
                chk = chk + sizeof("://") - 1;
                while ((*chk != '/')&&(*chk != '\0'))
                {
                    chk++;
                }
                *chk = 0x00;
                dummy = MAX_GETLOG_URL - StrLen(url);
            }
            else
            {
                chk = url;
                dummy = MAX_GETLOG_URL;
            }
            StrNCopy(chk, ptr, dummy);

            redirectCnt++;

#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, "REDIRECT(%d) TO URL:%s ", redirectCnt, url);
#endif // #ifdef USE_REPORTER

            // f[^̍ēx蒼
            goto GET_URL_DATA;        
        } 
    }

    // T[o̍XV擾i[
    chk = "Last-modified";
    ptr = StrStr(realBuf, chk);
    if (ptr == NULL)
    {
        chk = "Last-Modified";
        ptr = StrStr(realBuf, chk);
        if (ptr == NULL)
        {
            // T[ȏM擾i[
            chk = "Date";
            ptr = StrStr(realBuf, chk);
        }
    }
    if ((depth == 0)&&((dateTime != NULL)&&(ptr != NULL)))
    {
        ptr = ptr + StrLen(chk);
        while ((*ptr != '\x0d')&&((*ptr == ':')||(*ptr <= ' ')))
        {
            ptr++;
        }
        dummy = 0;
        while ((dummy < MAX_GETLOG_DATETIME)&&
                (*(ptr + dummy) != '\x0d')&&
                (*(ptr + dummy) != '\x0a')&&
                (*(ptr + dummy) != '\0'))
        {
            dummy++;
        }
        MemSet(dateTime, MAX_GETLOG_DATETIME, 0x00);
        StrNCopy(dateTime, ptr, dummy);

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "DateTime>>>%s", dateTime);
#endif // #ifdef USE_REPORTER
    }

    if (dbData->wwwcMode == 1)
    {
        // XV`FbNIAŐ܂Ԃ...
        // (subjDBȂ...̂AŁH)
        NNsh_DebugMessage(ALTID_INFO, "SITE UPDATE :", url, 0);
        if (updateRecord == true)
        {
            // ɃOꍇAxbZ[Woɂ
            NNsh_DebugMessage(ALTID_WARN, "LOG DATA EXIST, but... ", "", 0);
        }
        goto CLOSE_END;
    }

    // GR[h̃`FbN(JPEGM\ɂ邩H)
    // ptr = StrStr(realBuf, "image/jpeg");
    ptr = StrStr(realBuf, "image/");
    if (ptr != NULL)
    {
        file = StrStr(realBuf, NNSH_HTTP_HEADER_ENDTOKEN);
        if ((file != NULL)&&(ptr < file))
        {
            // JPEGt@CMI
            file       = file + 4;  // g[Nǂݔ΂...
            offset     = (UInt32) (file - realBuf);
            kanjiCode  = NNSH_KANJICODE_NOT_TEXT;

            // t@CH ("/Palm/Images"fBNgɕۑ)
            ptr = fileName + StrLen(fileName);
            while ((ptr > fileName)&&(*ptr != '/'))
            {
                ptr--;
            }
            dummy = StrLen(ptr) + 1;  // +1 ́A'\0'킹Ĉړ邽

            // C[Wۑp̃fBNg(ꉞARs[ł悤)쐬
            if (subjDb->msgState == FILEMGR_STATE_OPENED_VFS)
            {
                // VFSɃRs[Ƃ̃fBNgw...
                MemMove(&fileName[12], ptr, dummy); // 12"/Palm/Images"̒
                StrCopy(fileName, "/Palm/Image");
                fileName[11] = 's';   // StrCopy̎dlYꂽ̂ŁAAAS
                CreateDir_NNsh("/Palm/Images");
            }
            else
            {
                // file streamɎMƂ́At@CɂĂ܂
                MemMove(fileName, ptr, dummy);

                // t@C̃TCYꍇɂ͐؂B
                fileName[MAX_DBNAMELEN - 1] = '\0';
            }
            redirectCnt = subjDb->msgState;

            // t@Co̓WbN...
            goto OUTPUT_DATAFILE;
        }
    }

    // zipt@CMA܂͋IɃC[WMw...
    ptr = StrStr(realBuf, "application/zip");
    if ((ptr != NULL)||(isImage == true))
    {
        file = StrStr(realBuf, NNSH_HTTP_HEADER_ENDTOKEN);
        if ((file != NULL)&&(ptr < file))
        {
            file        = file + 4;  // g[Nǂݔ΂...
            offset      = (UInt32) (file - realBuf);
            redirectCnt = FILEMGR_STATE_DISABLED;
            kanjiCode   = NNSH_KANJICODE_NOT_TEXT;

            // t@Co̓WbN...
            goto OUTPUT_DATAFILE;
        }
    }

    // R[h̃`FbN
    ptr = StrStr(realBuf, "charset=");
    dummy = StrLen("charset=");
    if (ptr == NULL)
    {
        // charsetȂꍇɂ́Aencodinggp
        ptr   = StrStr(realBuf, "encoding=");
        dummy = StrLen("encoding=");
    }
    if (ptr != NULL)
    {
        // ǂݔ΂
        ptr = ptr + dummy;
        
        // 󔒕ǂݔ΂
        while ((*ptr == ' ')||(*ptr == '\t')||(*ptr == '"'))
        {
            ptr++;
        }

        if (StrNCaselessCompare(ptr, "iso-2022-jp", StrLen("iso-2022-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_JIS;
        }
        else if (StrNCaselessCompare(ptr, "euc-jp", StrLen("euc-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_EUC;
        }
        else if (StrNCaselessCompare(ptr, "x-euc-jp", StrLen("x-euc-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_EUC;
        }
        else if (StrNCaselessCompare(ptr, "shift_jis", StrLen("shift_jis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "x-sjis", StrLen("x-sjis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "shift-jis", StrLen("shift-jis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "utf-8", StrLen("utf-8")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_UTF8;
        }
    }

    // RSSɃ`FbNĂꍇɂ́A(I)UTF-8Ƃ
    // (Aŏʂ̊Kw...)
    if ((dbData->rssData != 0)&&(depth == 0))
    {
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "kanji :%d, utf-8:%d", 
                                               kanjiCode, NNSH_KANJICODE_UTF8);
#endif // #ifdef USE_REPORTER
        kanjiCode = NNSH_KANJICODE_UTF8;
    }

    // f[^̐擪T
    ptr = StrStr(realBuf, NNSH_HTTP_HEADER_ENDTOKEN);
    if (ptr == NULL)
    {
        // 擪Ȃ΁Af[^ubN̍ŏ͂
        NNsh_DebugMessage(ALTID_ERROR, "Data Failure :", FILE_RECVMSG, ret);
        ptr = realBuf;
    }

    // Rs[f[^̕␳
    //     ptrf[^{fB̐擪ɎĂB
    //     offsetǂݏot@C̐擪̃ItZbgĂB
    //     (offset́At@C̏o̐擪߂Ƃɗp)
    ptr = ptr + 4;   // 4́AStrLen(NNSH_HTTP_HEADER_ENDTOKEN) ƓB
    offset = (UInt32) (ptr - realBuf);

    // ʂ^Cgw肳Ă邩H
    if (titlePrefix != NULL)
    {
        // ^Cĝw肳Ăꍇɂ́A𗘗p
        file = titlePrefix;
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "##### Title : %s", file);
#endif // #ifdef USE_REPORTER
        goto SET_TITLE_STRING;
    }

    // ^Cg̎擾
    file = StrStr(ptr, "<title");
    if (file == NULL)
    {
        // ^Cg^OłȂꍇ...
        file = StrStr(ptr, "<TITLE");
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "<TITLE(kanji:%d)>", kanjiCode);
#endif // #ifdef USE_REPORTER

    if (file != NULL)
    {
        // ^O̖T...
        file = file + StrLen("<TITLE");
        while (*file != '>')
        {
            file++;
        }
        file++;

        // ^Cgf[^̖T
        chk = StrStr(file, "</TITLE");
        if (chk == NULL)
        {
            chk = StrStr(file, "</title");
        }
        if (chk == NULL)
        {
            chk = file;
            *chk = ' ';
            chk++;
        }
        *chk = '\0';

SET_TITLE_STRING:
        // X^Ci[̈Ƀf[^i[(R[h̕ϊYȂI)
        dummy = StrLen(subjDb->threadTitle);
        titleSize = StrLen(file);

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "</TITLE(len:%lu, size:%d)>", dummy, titleSize);
#endif // #ifdef USE_REPORTER

        switch (kanjiCode)
        {
          case NNSH_KANJICODE_EUC:
            // EUC -> SJϊĊi[
            chk = MEMALLOC_PTR((titleSize * 2) + MARGIN);
            if (chk != NULL)
            {
                StrCopySJ(chk, file);
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MEMFREE_PTR(chk);
            }
            break;

          case NNSH_KANJICODE_JIS:
            // JIS -> SJϊĊi[(JIS...)
            chk = MEMALLOC_PTR((titleSize * 2) + MARGIN);
            if (chk != NULL)
            {
                StrCopyJIStoSJ(chk, file);
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MEMFREE_PTR(chk);
            }
             break;

          case NNSH_KANJICODE_UTF8:
            chk = MEMALLOC_PTR((titleSize * 2) + MARGIN);
            if (chk != NULL)
            {
                StrNCopyUTF8toSJ(chk, file, (titleSize * 2));
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MEMFREE_PTR(chk);
            }
            else
            {
                // UTF8̕ϊłȂꍇ...
                StrNCopy(&subjDb->threadTitle[dummy], file, MAX_THREADNAME - dummy - 1);
            }
            break;                

          case NNSH_KANJICODE_SHIFTJIS:
          default:
            // ̂܂܊i[
            StrNCopy(&subjDb->threadTitle[dummy], file, MAX_THREADNAME - dummy - 1);
            break;
        }
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "TITLE : %s ", subjDb->threadTitle);
#endif // #ifdef USE_REPORTER

OUTPUT_DATAFILE:
    // ݃t@C̃I[v
    ret = OpenFile_NNsh(fileName, NNSH_FILEMODE_CREATE, &fileRefW);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Write File Open :", fileName, ret);
        goto CLOSE_END;
    }

    // ɓǂݍ߂Ƃ́Af[^̃{fBt@CɃRs[
    ret = errNone;
    offsetW = 0;
    while (ret == errNone)
    {
        readSize = 0;
        MemSet(realBuf, bufSize, 0x00);
        ret  = ReadFile_NNsh(&fileRefR, offset, bufSize, realBuf, &readSize);

        offset  = offset + readSize;
        if ((readSize % 2) != 0)
        {
            // ݃TCYɕ␳(CLIE4p̕ی)
            if (workAround == true)
            {
                realBuf[readSize] = ' ';
                readSize++;
            }
        }
        (void) WriteFile_NNsh(&fileRefW, offsetW, readSize, realBuf, &dummy);
        offsetW = offsetW + readSize;
    }

    // urlL^(eLXgt@ĈƂ̂)
    if (kanjiCode != NNSH_KANJICODE_NOT_TEXT)
    {
        MemSet (realBuf, bufSize, 0x00);
        StrCopy(realBuf, "<br><hr><a href=\"");
        StrCat (realBuf, url);
        StrCat (realBuf, "\">");
        StrCat (realBuf, url);
        StrCat (realBuf, "</a>");
    }

    readSize = StrLen(realBuf);
    if ((readSize % 2) != 0)
    {
        // ݃TCYɕ␳(CLIE4p̕ی)
        if (workAround == true)
        {
            realBuf[readSize] = ' ';
            readSize++;
        }
    }
    (void) WriteFile_NNsh(&fileRefW, offsetW, readSize, realBuf, &dummy);
    offsetW = offsetW + readSize;

    CloseFile_NNsh(&fileRefW);

    ////////// 擾ネOH o  //////////
    if (dbData->wwwcMode == 2)
    {
        // 擾ネO̊Kw`FbN
        if (depth != 0)
        {
            // P̃ÔƂ...
            (void) TrimGetDataLog(fileName, url, dbData->subTokenId, realBuf, bufSize);
        }
        else
        {
            // ʏ̃ÔƂ...
            (void) TrimGetDataLog(fileName, url, dbData->tokenId, realBuf, bufSize);
        }
    }
    ////////// p 擾ネOH  //////////

    // C[Wt@CMɂ́At@CN[Y
    // (DB̍XV{Ȃ...)
    if (kanjiCode == NNSH_KANJICODE_NOT_TEXT)
    {
        goto CLOSE_END;
    }

    // Ot@CTCYL^
    subjDb->fileSize = offsetW;
    
    // BBS^CvɊR[hǉ
    subjDb->bbsType = NNSH_BBSTYPE_HTML | (kanjiCode << NNSH_BBSTYPE_CHAR_SHIFT);

    // VXƂčXV
    subjDb->state = NNSH_SUBJSTATUS_NEW;

    // Xf[^o^ς݂̏ꍇAxf[^폜
    // (Xf[^̂cáAt@Cł̃\[gĂȂ̂œȂAAA)
    if (updateRecord == true)
    {
        // f[^ɂAf[^XV
        ret = UpdateRecord_NNsh(subjRef, index, sizeof(NNshSubjectDatabase), subjDb);
    }
    else
    {
        // f[^ȂAf[^o^
        ret = EntryRecord_NNsh(subjRef, sizeof(NNshSubjectDatabase), subjDb);
        index = 0;
    }

    // uP擾vŁAuԍXVmFvw肳ĂƂ...
    if ((depth != 0)&&(dbData->getAfterHours != 0))
    {
        // TuDBo^
        // URLLqĂ邩H (f[^o^ς݂ǂmF)
        if (subIndex == NNSH_DATABASE_BLANK)
        {
            // VKo^Kv...
            StrNCopy(subDbData->dataURL, url, MAX_GETLOG_URL);
            StrNCopy(subDbData->dataFileName, subjDb->threadFileName, MAX_THREADFILENAME);
            subDbData->lastUpdate = TimGetSeconds();
            subDbData->parentDbId = recId;

            // Of[^̃R[hID擾
            if (GetRecordID_NNsh(subjRef, index, &(subDbData->logDbId)) != errNone)
            {
                subDbData->logDbId = 0;
                NNsh_DebugMessage(ALTID_ERROR, "Cannot get record id ", " ", 0);
            }
            EntryLogSubFileDatabase(subDbData);
        }
        else
        {
            // (Â)Ot@C...
            if (subDbData->logDbId != 0)
            {
                DeleteThreadMessage_RecordID(subDbData->logDbId);
            }
            // Of[^̃R[hID擾
            if (GetRecordID_NNsh(subjRef, index, &(subDbData->logDbId)) != errNone)
            {
                subDbData->logDbId = 0;
                NNsh_DebugMessage(ALTID_ERROR, "cannot get record id ", " ", 0);
            }

            // R[hXVKv(XV)
            subDbData->lastUpdate = TimGetSeconds();
            subDbData->parentDbId = recId;
            UpdateSubFileDatabase(subIndex, subDbData);
            
        }
    }

CLOSE_END:
    // t@C̃N[Y
    Hide_BusyForm(false);
    CloseFile_NNsh(&fileRefR);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "CLOSE END>>ReadOnlyLogDataPickup()");
#endif // #ifdef USE_REPORTER

FUNC_END:
    // f[^x[X̃N[Y
    CloseDatabase_NNsh(subjRef);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "FUNC END>>ReadOnlyLogDataPickup"
                      "(subjDB:%x, dateBuf:%x, realBuf:%x)",
                      &subjDb, &dateBuf, &realBuf);
#endif // #ifdef USE_REPORTER

    // J...
    MEMFREE_PTR(realBuf);
    MEMFREE_PTR(subDbData);
    MEMFREE_PTR(dateBuf);
    MEMFREE_PTR(subjDb);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "GET URL:%s DONE.", url);
#endif // #ifdef USE_REPORTER

    // C[Wt@CMɂ́ADANs...
    if (kanjiCode == NNSH_KANJICODE_NOT_TEXT)
    {
        if (redirectCnt != FILEMGR_STATE_DISABLED)
        {
            // JPEGt@CMꍇADANsB
            launch_viewJPEG(redirectCnt, fileName);
        }
        else
        {
            // t@CM񍐂s
            NNsh_WarningMessage(ALTID_WARN, fileName, MSG_RECEIVE_IMAGEFILE, 0);
        }
    }
    return (ret);
}


/*==========================================================================*/
/*  TrimGetDataLog() : QƃÕOf[^H                       */
/*                                                                          */
/*==========================================================================*/
Err TrimGetDataLog(Char *fileName, Char *url, UInt32 tokenId, Char *realBuf, UInt16 bufSize)
{
    Err                   ret;
    NNshFileRef           fileRefR, fileRefW;
    NNshLogTokenDatabase *tokenData;
    UInt32                offsetW, offsetR, readSize, dummy;
    Char                 *ptr, status;

    // ݂̃OUPalmփRs[
    ret = CopyFile_NNsh(FILE_SENDMSG, fileName, NNSH_COPY_VFS_TO_PALM);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "CopyFile_NNsh()", " :", ret);
        return (ret);
    }

    // ؂f[^x[X̃f[^̈m
    tokenData = MEMALLOC_PTR(sizeof(NNshLogTokenDatabase) + MARGIN);
    if (tokenData == NULL)
    {
        // ؂f[^x[Ẍ̗mۂɎs...
        NNsh_DebugMessage(ALTID_ERROR, "MEMALLOC_PTR(sizeof(NNshLogTokenDatabase) + MARGIN)", " :", ret);
        return (~errNone);
    }

    // ؂f[^x[X̃f[^擾
    ret = GetLogToken(tokenId, tokenData);
    if (ret != errNone)
    {
        // ؂f[^x[X̎擾Ɏs...
        NNsh_DebugMessage(ALTID_ERROR, "GetLogToken(tokenId, tokenData)", " :", ret);
        MEMFREE_PTR(tokenData);
        return (ret);
    }
    NNsh_DebugMessage(ALTID_INFO, "tokenData :", tokenData->startToken, 0);

    // ݃t@C̃I[v
    ret = OpenFile_NNsh(fileName, NNSH_FILEMODE_CREATE, &fileRefW);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Write File Open :", fileName, ret);
        MEMFREE_PTR(tokenData);
        (void) CopyFile_NNsh(fileName, FILE_SENDMSG, NNSH_COPY_PALM_TO_VFS);
        return (ret);
    }

    // ǂݍ݃t@CI[v
    ret = OpenFile_NNsh(FILE_SENDMSG, (NNSH_FILEMODE_READONLY | NNSH_FILEMODE_TEMPFILE), &fileRefR);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", FILE_SENDMSG, ret);
        MEMFREE_PTR(tokenData);
        (void) CopyFile_NNsh(fileName, FILE_SENDMSG, NNSH_COPY_PALM_TO_VFS);
        return (ret);
    }

    // ɓǂݍ߂Ƃ́At@CRs[
    status  = NNSH_COPYSTATUS_SEARCHTOP;
    offsetW = 0;
    offsetR = 0;
    while (ret == errNone)
    {
        readSize = 0;
        MemSet(realBuf, bufSize, 0x00);
        ret  = ReadFile_NNsh (&fileRefR, offsetR, bufSize, realBuf, &readSize);
        switch (status)
        {        
          case NNSH_COPYSTATUS_SEARCHTOP:
            ptr = StrStr(realBuf, tokenData->startToken);
            if (ptr != NULL)
            {
                status = NNSH_COPYSTATUS_COPYING;
                offsetR = offsetR + (ptr - realBuf);

                NNsh_DebugMessage(ALTID_INFO, "tokenData :", tokenData->startToken, (offsetR));
                ret = errNone;
            }
            else
            {
                // ̓ǂݏoʒu𒲐
                offsetR = offsetR + readSize;
                dummy = StrLen(tokenData->startToken);
                if ((dummy % 2) != 0)
                {
                    dummy = dummy + 1;
                }
                if (readSize > dummy)
                {
                    offsetR = offsetR - dummy;
                }
            }
            break;

          case NNSH_COPYSTATUS_COPYING:
            // HORs[...
            ptr = StrStr(realBuf, tokenData->endToken);
            if (ptr != NULL)
            {
                status = NNSH_COPYSTATUS_COPYDONE;
                readSize = (ptr - realBuf) + StrLen(tokenData->endToken) + 1;
            }
            if ((readSize % 2) != 0)
            {
                // ݃TCYɕ␳(CLIEp̕ی)
                if ((((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) != 0)&&
                    (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND) != 0))
                {
                    realBuf[readSize] = ' ';
                    readSize++;
                }
            }
            (void) WriteFile_NNsh(&fileRefW, offsetW, readSize, realBuf, &dummy);
            offsetW = offsetW + readSize;
            break;

          case NNSH_COPYSTATUS_COPYDONE:
          default:
            // Ȃ... (Rs[IȂ̂)
            ret = fileErrEOF;
            break;
        }
    }

    // I[vt@C...
    CloseFile_NNsh(&fileRefW);
    CloseFile_NNsh(&fileRefR);

    MEMFREE_PTR(tokenData);

    // t@C̍Ō܂ŃRs[errNoneŉ
    if ((ret == vfsErrFileEOF)||(ret == fileErrEOF))
    {
        ret = errNone;
    }
    return (ret);
}

#endif    // #ifdef USE_LOGCHARGE
